-- Global declarations
MissionPlayer = Player.GetPlayers(function(p) return p.IsLocalPlayer end)[1]
NeutralPlayer = Player.GetPlayers(function(p) return p.IsNonCombatant end)[1]
HouseGroups = { }
Houses = { }


ActorNoTrigger = { }
-------- MAIN FUNCTION TO ATTACH TO WorldLoaded()
function InitialisePlayers ()
  if bdebug then UserInterface.SetMissionText("InitialisePlayers() called at tick "..missiontick, MissionPlayer.Color) end  

  SetupPlayerSettings()
  SetupPlayerGroups()
  SetupPlayers()   
  ApplyPlayerSettings()
  
end

------------------------------------------------------------------------------------------------------------------
function SetupPlayerSettings ()
  if bdebug then UserInterface.SetMissionText("SetupPlayerSettings() called at tick "..missiontick, MissionPlayer.Color) end  
  -- Player settings declarations, if not present in ScripterOverride file
  DefaultInitialCash = DefaultInitialCash or 0
  SovietBotInitialCash = SovietBotInitialCash or 0
  SovietBotBuildTimeMultiplier = SovietBotBuildTimeMultiplier or { default = 1 }
  SovietBotCostMultiplier = SovietBotCostMultiplier or { default = 1 }
  AlliedBotInitialCash = AlliedBotInitialCash or 0
  AlliedBotBuildTimeMultiplier = AlliedBotBuildTimeMultiplier or { default = 1 }
  AlliedBotCostMultiplier = AlliedBotCostMultiplier or { default = 1 }
  AIStructureHPRepair = AIStructureHPRepair or 1
end

function SetupPlayerGroups ()
  if bdebug then UserInterface.SetMissionText("SetupPlayerGroups() called at tick "..missiontick, MissionPlayer.Color) end  
  -- Groups
  HouseGroups.All = Player.GetPlayers(function(p) return true end)
  HouseGroups.Active = Player.GetPlayers(function(p) return not p.IsNonCombatant end)
  HouseGroups.Humans = Player.GetPlayers(function(p) return (p.IsLocalPlayer and not p.IsNonCombatant) end) 
  HouseGroups.Bots = Player.GetPlayers(function(p) return (not p.IsLocalPlayer and not p.IsNonCombatant) end) 
	HouseGroups.AlliedBots = Player.GetPlayers(function(p) return (p.Faction == "allies" and not p.IsLocalPlayer and not p.IsNonCombatant) end)
	HouseGroups.SovietBots = Player.GetPlayers(function(p) return (p.Faction == "soviet" and not p.IsLocalPlayer and not p.IsNonCombatant) end)
  
  ------ Debug to check 
  --local str = "All: "
  --Utils.Do(HouseGroups.All, function(h)
  --  str = str .. "  " .. h.Name
  --end)
  --str = "\n" .. str .. "\nActive: "
  --Utils.Do(HouseGroups.Active, function(h)
  --  str = str .. "  " .. h.Name
  --end)
  --str = "\n" .. str .. "\nHumans: "
  --Utils.Do(HouseGroups.Humans, function(h)
  --  str = str .. "  " .. h.Name
  --end)
  --str = "\n" .. str .. "\nBots: "
  --Utils.Do(HouseGroups.Bots, function(h)
  --  str = str .. "  " .. h.Name
  --end)
  --str = "\n" .. str .. "\nAlliedBots: "
  --Utils.Do(HouseGroups.AlliedBots, function(h)
  --  str = str .. "  " .. h.Name
  --end)
  --str = "\n" .. str .. "\nSovietBots: "
  --Utils.Do(HouseGroups.SovietBots, function(h)
  --  str = str .. "  " .. h.Name
  --end)
  --str = "\n" .. str .. "\n"
  --UserInterface.SetMissionText(str, HSLColor.Salmon)

end
  
function SetupPlayers ()
  if bdebug then UserInterface.SetMissionText("SetupPlayers() called at tick "..missiontick, MissionPlayer.Color) end  
  
  -- Fill the House table
  ------ Houses[Player.Name]
  ----------- Player = the Player
  ----------- InitialCash = Player's initial cash
  ----------- BuildTimeMultipliers = (AI) Multiplier to BuildTime (default, Structures, Defences, Infantry, Units, Aircraft, Ships)
  ----------- CostMultipliers = (AI) Multiplier to Cost (default, Structures, Defences, Infantry, Units, Aircraft, Ships)
  ----------- StructurePriority = (AI) AI-assigned priority for structure production
  
  
  Utils.Do( HouseGroups.Active, function(player) 
      Houses[player.Name] = { Player = player, InitialCash = DefaultInitialCash, BuildTimeMultipliers = { }, CostMultipliers = { } } 
    end
  )
  -- Allied Bot override
  Utils.Do( HouseGroups.AlliedBots, function(bot) 
      Houses[bot.Name] = { Player = bot, InitialCash = AlliedBotInitialCash, BuildTimeMultipliers = AlliedBotBuildTimeMultiplier, CostMultipliers = AlliedBotCostMultiplier }
    end
  )
  -- Soviet Bot override
  Utils.Do( HouseGroups.SovietBots, function(bot) 
      Houses[bot.Name] = { Player = bot, InitialCash = SovietBotInitialCash, BuildTimeMultipliers = SovietBotBuildTimeMultiplier, CostMultipliers = SovietBotCostMultiplier } 
    end
  )
  -- Create table for ActorRegistry[player.name]
  Utils.Do( HouseGroups.All, function(player) 
      ActorRegistry[player.Name] = { } 
    end
  )
  -- Populate ActorRegistry[player.Name]
  PopulateActorRegistry()
end

function GetPlayerSettings (player, firstsettingtype)
  if bdebug then UserInterface.SetMissionText("GetPlayerSettings() called at tick "..missiontick, MissionPlayer.Color) end  

  if Houses == nil then 
    Media.Debug("WARNING: Function GetPlayerSettings() invoked with empty Houses array!")
    return nil
  end
  
  if player == nil then 
    Media.Debug("WARNING: Function GetPlayerSettings() invoked with empty parameter player!")
    return nil
  end  
  
  if firstsettingtype == nil then 
    Media.Debug("WARNING: Function GetPlayerSettings() invoked with empty parameter firstsettingtype!")
    return nil
  end 
  
  if Houses[player.Name] ~= nil then
    if Houses[player.Name][firstsettingtype] ~= nil then
      return Houses[player.Name][firstsettingtype]
    end
  end
  return nil
end

function GetBuildTimeMultiplier (player, category)
  if bdebug then UserInterface.SetMissionText("GetBuildTimeMultiplier() called at tick "..missiontick, MissionPlayer.Color) end  
  
  local tbl = GetPlayerSettings(player, "BuildTimeMultipliers")
  if type(tbl) == "table" then 
    if tbl[category] ~= nil then return tbl[category] end
    if tbl.default ~= nil then return tbl.default end
    return 1
  else 
    return 1 
  end
end  
  
function GetCostMultiplier (player, category) 
  if bdebug then UserInterface.SetMissionText("GetBuildTimeMultiplier() called at tick "..missiontick, MissionPlayer.Color) end  
  
  local tbl = GetPlayerSettings(player, "CostMultipliers")
  if type(tbl) == "table" then 
    if tbl[category] ~= nil then return tbl[category] end
    if tbl.default ~= nil then return tbl.default end
    return 1
  else 
    return 1 
  end
end

function ApplyPlayerSettings ()
  if bdebug then UserInterface.SetMissionText("ApplyPlayerSettings() called at tick "..missiontick, MissionPlayer.Color) end  
  
  -- Apply Cash
  Utils.Do(HouseGroups["Active"], function(house) house.Cash = GetPlayerSettings(house, "InitialCash") end)
  
end

function PopulateActorRegistry ()
  if bdebug then UserInterface.SetMissionText("PopulateActorRegistry() called at tick "..missiontick, MissionPlayer.Color) end  

  Utils.Do(Map.NamedActors, function(actor)
    if actor.IsDead then return end
    AddActorToRegistry(actor)
  end)
end
      
function AddActorToRegistry (actor) -- actor
  if bdebug then UserInterface.SetMissionText("AddActorToRegistry() called at tick "..missiontick, MissionPlayer.Color) end  

  -- Add to list
  local ownername = actor.Owner.Name
  local actortype = actor.Type
  
  ActorRegistry[ownername][actortype] = ActorRegistry[ownername][actortype] or { }
  table.insert(ActorRegistry[ownername][actortype], actor)
  
  -- Add Triggers to handle removal 
  xpcall( 
    function() 
      Trigger.OnKilled(actor, function(a,_)
        RemoveFromList(ActorRegistry[ownername][actortype], a)
      end)
      Trigger.AfterDelay(DateTime.Seconds(10), function()  ---- LAG!
        CheckActorInRegistry({Actor = actor, OwnerName = ownername, Actortype = actortype})
      end)
    end
    ,
    function()
      -- Add to ActorNoTrigger for periodic checking(?)
      table.insert(ActorNoTrigger, {Actor = actor, OwnerName = ownername, Actortype = actortype})
    end
  )
  
end

function CheckActorInRegistry (set) -- actor
  if bdebug then UserInterface.SetMissionText("CheckActorInRegistry() called at tick "..missiontick, MissionPlayer.Color) end  

  if set.Actor.IsDead then 
    RemoveFromList(ActorRegistry[set.OwnerName][set.Actortype], set.Actor) 
    RemoveFromList(ActorNoTrigger, set)     
  end
  if set.Actor.Owner.Name ~= set.OwnerName or set.Actor.Type ~= set.Actortype then 
    RemoveFromList(ActorRegistry[set.OwnerName][set.Actortype], set.Actor)
    -- re-add to the correct slot
    AddActorToRegistry(set.Actor)
  end
end


