
SovietMCVNavyReinforcementPath = { SouthEastNavalReinforcementAccess1.Location, SouthEastNavalWaypoint1.Location, SouthEastBeachHead1.Location }
SovietMCVMovePath = { UkraineBaseWP.Location }


UnitReinforcements = {}
UnitReinforcements["Germany"] = {
  --{ Units = { }, Spawn = { } , Path = { } },
  { Units = { "jeep", "1tnk.german" }, Spawn = { NorthAlliedTownRoad.Location } , Path = { GermanNorthWestEntrance.Location, GermanSouthWestEntrance.Location, GermanBaseSouth.Location, GermanSouthEntrance.Location } },
  { Units = { "e1", "e1", "e1" }, Spawn = { NorthAlliedTownRoad.Location } , Path = { GermanSouthWestEntrance.Location, GermanNorthWestEntrance.Location, GermanSouthEntrance.Location } },
  { Units = { "jeep" }, Spawn = { NorthAlliedTownRoad.Location } , Path = { EasternCorridorNorth.Location, EasternCorridorSouth.Location } },
  { Units = { "e3", "e3", "e3" }, Spawn = { NorthAlliedTownRoad.Location } , Path = { WesternCorridorNorth.Location, WesternCorridorSouth.Location } },
}
Civilians = {"c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "c10"}
CivNorthEvacRoute = { NorthernTownAPC.Location, CivEvacCell.Location }
CivSouthEvacRoute = { SouthernTownAPC.Location, GermanBaseSouth.Location, GermanNorthWestEntrance.Location, CivEvacCell.Location }
CivEastEvacRoute = { GermanBaseEast.Location, GermanBaseWest.Location, GermanNorthWestEntrance.Location, CivEvacCell.Location }
NorthTown = { NorthTownHospital, NorthTownChurch, NorthTown1, NorthTown2, NorthTown3, NorthTown4 }
SouthTown = { SouthTownChurch, SouthTown1, SouthTown2, SouthTown3, SouthTown4, SouthTown5 }
EastTown = { EastTown1, EastTown2, EastTown3 }

UnitReinforcements["Allied Town"] = {
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { NorthernChurch.Location } , Path = CivNorthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { NorthernTown1.Location } , Path = CivNorthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { NorthernTown2.Location } , Path = CivNorthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { NorthernTown3.Location } , Path = CivNorthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { NorthernTown4.Location } , Path = CivNorthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { SouthernChurch.Location } , Path = CivSouthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { SouthernTown1.Location } , Path = CivSouthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { SouthernTown2.Location } , Path = CivSouthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { SouthernTown3.Location } , Path = CivSouthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { SouthernTown4.Location } , Path = CivSouthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { SouthernTown5.Location } , Path = CivSouthEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { EasternTown1.Location } , Path = CivEastEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { EasternTown2.Location } , Path = CivEastEvacRoute },
  { Units = { Utils.Random(Civilians), Utils.Random(Civilians) }, Spawn = { EasternTown3.Location } , Path = CivEastEvacRoute },
  { Units = { "jeep" }, Spawn = { NorthAlliedTownRoad.Location }, Path = { NorthernTownAPC.Location } },
  { Units = { "jeep", "e1", "e1", "e3", "e3" }, Spawn = { NorthAlliedTownRoad.Location } , Path = { GermanNorthWestEntrance.Location, SouthernTownAPC.Location } },
}
UnitReinforcements["USSR"] = {
  { Units = { "3tnk", "3tnk", "3tnk", "3tnk", "v2rl", "v2rl" }, Spawn = { SouthRoad.Location } , Path = SovietSouthRoute },
}
UnitReinforcements["Soviet Armour"] = {
  { Units = { "4tnk", "4tnk" }, Spawn = { SouthEastRoad.Location } , Path = SovietSouthRoute },
}

TransportReinforcements = { }
TransportReinforcements["Germany"] = {
  --{ Transport = , Units = { }, Spawn = { }, Path = { } },
  { Transport = "lst", Units = { "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german" }, Spawn = { NouthEastNavalReinforcementAccess1.Location, NorthWestBeachHead1.Location }, Path = AlliedSouthRoute },
  { Transport = "tran", Units = { "e1", "e1", "e1", "e1", "e3", "e3", "e3" }, Spawn = { CivEvacCell.Location, GermanBaseEast.Location }, Path = AlliedSouthRoute },
}
TransportReinforcements["Ukraine"] = {
  -- 1 to 5 are bomb trucks
  { Transport = "lst", Units = { "dtrk" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastBeachHead1.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "dtrk" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastBeachHead2.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "dtrk" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastBeachHead3.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "dtrk" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthEastBeachHead4.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "dtrk" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthWestBeachHead1.Location }, Path = UkraineNorthWestRoute },
  
  -- 6 to 17 are South East reinforcements
  { Transport = "lst", Units = { "ftrk", "ftrk", "3tnk", "3tnk", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess1.Location, SouthEastNavalWaypoint1.Location, SouthEastBeachHead1.Location }, Path = UkraineSouthRoute },
  { Transport = "lst", Units = { "ftrk", "ftrk", "3tnk", "3tnk", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess2.Location, SouthEastNavalWaypoint2.Location, SouthEastBeachHead1.Location }, Path = UkraineSouthRoute },
  { Transport = "lst", Units = { "ftrk", "ftrk", "3tnk", "3tnk", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess1.Location, SouthEastNavalWaypoint1.Location, SouthEastBeachHead1.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "ftrk", "ftrk", "3tnk", "3tnk", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess2.Location, SouthEastNavalWaypoint2.Location, SouthEastBeachHead1.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e2", "e2", "e4", "e4", "4tnk" }, Spawn = { SouthEastNavalReinforcementAccess1.Location, SouthEastNavalWaypoint1.Location, SouthEastBeachHead1.Location }, Path = UkraineSouthRoute },
  { Transport = "lst", Units = { "e2", "e2", "e4", "e4", "4tnk" }, Spawn = { SouthEastNavalReinforcementAccess2.Location, SouthEastNavalWaypoint2.Location, SouthEastBeachHead1.Location }, Path = UkraineSouthRoute },
  { Transport = "lst", Units = { "e2", "e2", "e4", "e4", "4tnk" }, Spawn = { SouthEastNavalReinforcementAccess1.Location, SouthEastNavalWaypoint1.Location, SouthEastBeachHead1.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e2", "e2", "e4", "e4", "4tnk" }, Spawn = { SouthEastNavalReinforcementAccess2.Location, SouthEastNavalWaypoint2.Location, SouthEastBeachHead1.Location }, Path = UkraineEastCorridorRoute },  
  { Transport = "lst", Units = { "e3", "e3", "e3", "v2rl", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess1.Location, SouthEastNavalWaypoint1.Location, SouthEastBeachHead1.Location }, Path = UkraineSouthRoute },
  { Transport = "lst", Units = { "e3", "e3", "e3", "v2rl", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess2.Location, SouthEastNavalWaypoint2.Location, SouthEastBeachHead1.Location }, Path = UkraineSouthRoute },
  { Transport = "lst", Units = { "e3", "e3", "e3", "v2rl", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess1.Location, SouthEastNavalWaypoint1.Location, SouthEastBeachHead1.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e3", "e3", "e3", "v2rl", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess2.Location, SouthEastNavalWaypoint2.Location, SouthEastBeachHead1.Location }, Path = UkraineEastCorridorRoute },
  
  -- 18 to 32 are North East / West routes
  { Transport = "lst", Units = { "ftrk", "ftrk", "3tnk", "3tnk", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastBeachHead1.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "ftrk", "ftrk", "3tnk", "3tnk", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastBeachHead2.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "ftrk", "ftrk", "3tnk", "3tnk", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthEastBeachHead3.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "ftrk", "ftrk", "3tnk", "3tnk", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthEastBeachHead4.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "ftrk", "ftrk", "3tnk", "3tnk", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthWestBeachHead1.Location }, Path = UkraineNorthWestRoute },

  { Transport = "lst", Units = { "e2", "e2", "e4", "e4", "4tnk" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastBeachHead1.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e2", "e2", "e4", "e4", "4tnk" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastBeachHead2.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e2", "e2", "e4", "e4", "4tnk" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthEastBeachHead3.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e2", "e2", "e4", "e4", "4tnk" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthEastBeachHead4.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e2", "e2", "e4", "e4", "4tnk" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthWestBeachHead1.Location }, Path = UkraineNorthWestRoute },
  
  { Transport = "lst", Units = { "e3", "e3", "e3", "v2rl", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastBeachHead1.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e3", "e3", "e3", "v2rl", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastBeachHead2.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e3", "e3", "e3", "v2rl", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthEastBeachHead3.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e3", "e3", "e3", "v2rl", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthEastBeachHead4.Location }, Path = UkraineEastCorridorRoute },
  { Transport = "lst", Units = { "e3", "e3", "e3", "v2rl", "v2rl" }, Spawn = { SouthEastNavalReinforcementAccess3.Location, SouthEastNavalWaypoint3.Location, SouthEastNavalCorridor.Location, NorthEastNavalCorridor.Location, NorthEastNavalWaypoint1.Location, NorthWestBeachHead1.Location }, Path = UkraineNorthWestRoute },
}

function PrepareReinforcements()
  
  PrepareCivEvacuations()
  
  if Map.LobbyOption("difficulty") == "Mental" then
    Trigger.AfterDelay(DateTime.Seconds(120), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(1,5), 3, 102, true) end)
    Trigger.AfterDelay(DateTime.Seconds(260), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(1,5), 3, 102, true) end)
    Trigger.AfterDelay(DateTime.Seconds(180), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(1,5), 3, 102, true) end)
  end
  
  if Map.LobbyOption("difficulty") ~= "Easy" then
    Trigger.AfterDelay(DateTime.Seconds(90), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(6,32), 3, 102, true) end)
    Trigger.AfterDelay(DateTime.Seconds(172), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(6,32), 3, 102, true) end)
    Trigger.AfterDelay(DateTime.Seconds(244), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(6,32), 3, 102, true) end)
    Trigger.AfterDelay(DateTime.Seconds(130), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(6, 17), 3, 102, true) end)
 
    Trigger.AfterDelay(DateTime.Seconds(240), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 1, 1, 151, true) end)
    Trigger.AfterDelay(DateTime.Seconds(750), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 1, 1, 151, true) end)
    Trigger.AfterDelay(DateTime.Seconds(462), function() CreateUnitReinforcements(Player.GetPlayer("Soviet Armour"), 1, 1, 151, true) end)
  end
  
  Trigger.AfterDelay(DateTime.Seconds(96), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(6,32), 3, 102, true) end)
  Trigger.AfterDelay(DateTime.Seconds(178), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(6,32), 3, 102, true) end)
  Trigger.AfterDelay(DateTime.Seconds(240), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(6,32), 3, 102, true) end)
  
  Trigger.AfterDelay(DateTime.Seconds(140), function() CreateTransportReinforcements(Player.GetPlayer("Ukraine"), Utils.RandomInteger(6, 17), 3, 102, true) end)
  Trigger.AfterDelay(DateTime.Seconds(150), SendUkraineMCVReinforcement)
  
  Trigger.AfterDelay(DateTime.Seconds(32), function() CreateUnitReinforcements(Player.GetPlayer("Germany"), 1, 3, 202, true) end)
  Trigger.AfterDelay(DateTime.Seconds(60), function() CreateUnitReinforcements(Player.GetPlayer("Germany"), 2, 3, 202, true) end)
  Trigger.AfterDelay(DateTime.Seconds(20), function() CreateUnitReinforcements(Player.GetPlayer("Germany"), 3, 3, 202, true) end)
  Trigger.AfterDelay(DateTime.Seconds(45), function() CreateUnitReinforcements(Player.GetPlayer("Germany"), 4, 3, 202, true) end)
  Trigger.AfterDelay(DateTime.Seconds(224), function() CreateTransportReinforcements(Player.GetPlayer("Germany"), 1, 3, 102, true) end)
  Trigger.AfterDelay(DateTime.Seconds(250), function() CreateTransportReinforcements(Player.GetPlayer("Germany"), 2, 3, 102, true) end)
  Trigger.AfterDelay(DateTime.Seconds(410), function() CreateTransportReinforcements(Player.GetPlayer("Germany"), 1, 3, 102, true) end)
  Trigger.AfterDelay(DateTime.Seconds(655), function() CreateTransportReinforcements(Player.GetPlayer("Germany"), 2, 3, 102, true) end)

  Trigger.AfterDelay(DateTime.Seconds(500), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 1, 1, 151, true) end)
  Trigger.AfterDelay(DateTime.Seconds(212), function() CreateUnitReinforcements(Player.GetPlayer("Soviet Armour"), 1, 1, 151, true) end)
  Trigger.AfterDelay(DateTime.Seconds(712), function() CreateUnitReinforcements(Player.GetPlayer("Soviet Armour"), 1, 1, 151, true) end)

  Trigger.AfterDelay(DateTime.Seconds(15), function() CreateUnitReinforcements(Player.GetPlayer("Allied Town"), 15) end)
  Trigger.AfterDelay(DateTime.Seconds(5), function() CreateUnitReinforcements(Player.GetPlayer("Allied Town"), 16) end)

end

townevacuationnorth = false
townevacuationsouth = false
townevacuationeast = false
function PrepareCivEvacuations()
  --Trigger.AfterDelay(DateTime.Seconds(1),SendUkraineMCVReinforcement)
  Utils.Do(NorthTown, function(town)
    Trigger.OnDamaged(town, function(a,attacker) CheckCivUnderAttack(a, attacker, 1) end)
  end)
  Utils.Do(SouthTown, function(town)
    Trigger.OnDamaged(town, function(a,attacker) CheckCivUnderAttack(a, attacker, 2) end)
  end)
  Utils.Do(EastTown, function(town)
    Trigger.OnDamaged(town, function(a,attacker) CheckCivUnderAttack(a, attacker, 3) end)
  end)
end

function CheckCivUnderAttack(town, attacker, num)
  if attacker.Owner.Faction ~= "allies" then 
    SendCivEvacuation(num) 
  end
end

function SendCivEvacuation(num)
  if (num == 1 and not townevacuationnorth) or (num == 2 and not townevacuationsouth) or (num == 3 and not townevacuationeast) then
    local civilianhouse = Player.GetPlayer("Allied Town")
    if num == 1 then
      townevacuationnorth = true
      CreateCivEvacuations(civilianhouse, 1)
      CreateCivEvacuations(civilianhouse, 2)
      CreateCivEvacuations(civilianhouse, 3)
      CreateCivEvacuations(civilianhouse, 4)
      CreateCivEvacuations(civilianhouse, 5)
    elseif num == 2 then
      townevacuationsouth = true
      CreateCivEvacuations(civilianhouse, 6)
      CreateCivEvacuations(civilianhouse, 7)
      CreateCivEvacuations(civilianhouse, 8)
      CreateCivEvacuations(civilianhouse, 9)
      CreateCivEvacuations(civilianhouse, 10)     
      CreateCivEvacuations(civilianhouse, 11)
    elseif num == 3 then
      townevacuationeast = true
      CreateCivEvacuations(civilianhouse, 12)
      CreateCivEvacuations(civilianhouse, 13)
      CreateCivEvacuations(civilianhouse, 14)
    end
  
  end
end


function SendUkraineMCVReinforcement ()
	Media.Debug("Creating Ukraine MCV transport reinforcements")
  local alreadyordered = false
	local units = Reinforcements.ReinforceWithTransport ( Player.GetPlayer("Ukraine"), 
                                                        "lst", 
                                                        { "mcv", "4tnk", "ftrk", "ftrk", "v2rl" }, 
                                                        SovietMCVNavyReinforcementPath,
                                                        { SovietMCVNavyReinforcementPath[1] })[2]
                                                      
  Utils.Do(units, function(unit)
    if unit.IsDead then return end
    Trigger.OnIdle(unit, function()
      if unit.Type == "mcv" then 
        unit.Wait(50)
        unit.Move(SovietMCVMovePath[1])
        unit.Deploy()
        if not alreadyordered then 
          alreadyordered = true
          Trigger.OnRemovedFromWorld(unit, SetupConYards)
        end
      else
        Trigger.AfterDelay(DateTime.Seconds(25), function() 
          if not unit.IsDead then
            if unit.Type == "4tnk" then 
              unit.Move(SovietMCVMovePath[1] + CVec.New(1,-2), 2)
              unit.Stance = "Defend"
            elseif unit.Type == "ftrk" then 
              unit.Move(SovietMCVMovePath[1] + CVec.New(1,2), 2)
              unit.Stance = "Defend"
            else 
              unit.Hunt() 
            end
          end
        end)
      end
    end)
  end)
end



function CreateUnitReinforcements (player, i, closeenough, delay, cyclic, waitforgroup) -- waitforgroup 

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

	Media.Debug("Creating "..player.Name.." Reinforcements #" .. i)
  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end

	local units = Reinforcements.Reinforce( player, 
                                          UnitReinforcements[player.Name][i].Units, 
                                          UnitReinforcements[player.Name][i].Spawn)
   
	Utils.Do(units, function(unit)
    if waitforgroup then
      GroundAttack(unit, UnitReinforcements[player.Name][i].Path, closeenough, delay, cyclic, units)
    else
      GroundAttack(unit, UnitReinforcements[player.Name][i].Path, closeenough, delay, cyclic)
    end
  end)
end


function CreateTransportReinforcements (player, i, closeenough, delay, cyclic, waitforgroup)
  if bdebug then UserInterface.SetMissionText("User CreateTransportReinforcements( player = ".. player.Name ..", i = " ..i..") at "..missiontick, MissionPlayer.Color) end

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

	Media.Debug("Creating "..player.Name.." Transport Reinforcements #" .. i)
  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end
  
	local units = Reinforcements.ReinforceWithTransport(player, 
                                                      TransportReinforcements[player.Name][i].Transport, 
                                                      TransportReinforcements[player.Name][i].Units, 
                                                      TransportReinforcements[player.Name][i].Spawn,
                                                      { TransportReinforcements[player.Name][i].Spawn[1] })[2]
  
	Utils.Do(units, function(unit)
    if waitforgroup then
      GroundAttack(unit, TransportReinforcements[player.Name][i].Path, closeenough, delay, cyclic, units)
    else
      GroundAttack(unit, TransportReinforcements[player.Name][i].Path, closeenough, delay, cyclic)
    end
  end)
end


function CreateCivEvacuations (player, i, closeenough, delay, cyclic)

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

	Media.Debug("Creating "..player.Name.." Civilian Evacuation #" .. i)
	local units = Reinforcements.Reinforce( player, 
                                          UnitReinforcements[player.Name][i].Units, 
                                          UnitReinforcements[player.Name][i].Spawn)
     
	Utils.Do(units, function(unit)
    GroundAttack(unit, UnitReinforcements[player.Name][i].Path, closeenough, delay, cyclic, false, true)
	
    Trigger.OnKilled(unit, function() civiliansDead = civiliansDead + 1 end)
  
		Trigger.OnIdle(unit, function(a)				
      if a.Location == UnitReinforcements[player.Name][i].Path[#UnitReinforcements[player.Name][i].Path] then
        a.Destroy()
      end
		end)
	end)
end


ChronoReinforcements = { }
ChronoReinforcements["Germany"] = {

  { UnitTypes = { "mcv", "arty", "arty", "arty", "arty", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german" }, Facings = {96, 96, 96, 96, 96}, TargetCells = Utils.ExpandFootprint(Utils.ExpandFootprint({ BattlegroundCenter.Location }, false), false) , Path = { SovietBaseNorth.Location } },
  { UnitTypes = { "mgg", "arty", "arty", "arty", "arty", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german" }, Facings = {96, 96, 96, 96, 96}, TargetCells = Utils.ExpandFootprint(Utils.ExpandFootprint({ SovietNorthEntrance.Location }, false), false) , Path = { SovietBaseNorth.Location } },
  { UnitTypes = { "mgg", "arty", "arty", "arty", "arty", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german" }, Facings = {96, 96, 96, 96, 96}, TargetCells = Utils.ExpandFootprint(Utils.ExpandFootprint({ SovietEastEntrance.Location }, false), false) , Path = { SovietBaseNorth.Location } },
}

function CreateChronoReinforcements (player, i, closeenough, delay, cyclic, waitforgroup)
  
  -- Define:
  --ChronoReinforcements[player.Name][i].UnitTypes : type[]
  --ChronoReinforcements[player.Name][i].Facings : int[]
  --ChronoReinforcements[player.Name][i].TargetCells : CPos[]
  --ChronoReinforcements[player.Name][i].Path : CPos[]  
  
  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

	Media.Debug("Creating "..player.Name.." Chrono Reinforcements #" .. i)
  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end

  local units = { }
	for k = 1, #ChronoReinforcements[player.Name][i].TargetCells do
		local unit = Actor.Create(ChronoReinforcements[player.Name][i].UnitTypes[k], true, { Owner = player, Facing = ChronoReinforcements[player.Name][i].Facings[k] })
		units[unit] = ChronoReinforcements[player.Name][i].TargetCells[k]
	end
	Chronosphere.Chronoshift(units)                                          
   
	--Utils.Do(units, function(unit)
  --  if waitforgroup then
  --    GroundAttack(unit, UnitReinforcements[player.Name][i].Path, closeenough, delay, cyclic, units)
  --  else
  --    GroundAttack(unit, UnitReinforcements[player.Name][i].Path, closeenough, delay, cyclic)
  --  end
  --end)
end