-- Global declarations
BaseNodes = { } 
ExistingBuildings = { } -- Actor[]
BaseNodePlayerSuffix = "_BaseNodes"

-------- MAIN FUNCTION TO ATTACH TO WorldLoaded()
function InitialiseBases ()
  if bdebug then UserInterface.SetMissionText("InitialiseBases() called at tick "..missiontick, MissionPlayer.Color) end  

  SetupBaseSettings()
  SetupInitialNodes()
  SetupBaseNodes() 
  DeleteBaseNodes()
  SetupBaseCenters() 
  ArrangeBaseNodes()

end

------------------------------------------------------------------------------------------------------------------
function SetupBaseSettings ()
  if bdebug then UserInterface.SetMissionText("SetupBaseSettings() called at tick "..missiontick, MissionPlayer.Color) end  

  -- Base setting declarations, if not present in ScripterOverride file
  if IncludeExistingBuildingsInBaseNodes ~= nil then IncludeExistingBuildingsInBaseNodes = true end  
  InitialBaseNodes = InitialBaseNodes or { }
  BaseCenters = BaseCenters or { }
end

function SetupInitialNodes ()
  if bdebug then UserInterface.SetMissionText("SetupInitialNodes() called at tick "..missiontick, MissionPlayer.Color) end  

  BaseNodes = BaseNodes or { }
  Utils.Do(InitialBaseNodes, function(bn) ImportBaseNode(bn) end)
end

-- Remove all BaseNode spawns and units
function DeleteBaseNodes ()
  if bdebug then UserInterface.SetMissionText("DeleteBaseNodes() called at tick "..missiontick, MissionPlayer.Color) end  

  Trigger.AfterDelay(0, function()
    Utils.Do(Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(a) return true end), function(a)
      if a.IsDead then return end
      local oldctyname = a.Owner.Name
      if string.sub(oldctyname, #oldctyname - #BaseNodePlayerSuffix + 1, -1) == BaseNodePlayerSuffix then  
        local newctyname = string.sub(oldctyname, 1, #oldctyname - #BaseNodePlayerSuffix)
        
        if Player.GetPlayer(newctyname) ~= nil then 
          --a.Owner = Player.GetPlayer(newctyname)
          if a.HasProperty("Destroy") then 
            a.Stop()
            a.Destroy() 
          end
        end
      end
    end)
  end)
end

function SetupBaseNodes ()
  if bdebug then UserInterface.SetMissionText("SetupBaseNodes() called at tick "..missiontick, MissionPlayer.Color) end  

	local enumbb = #BaseNodes
	Utils.Do(Map.NamedActors, function(actor)
    if actor.IsDead then return end
		local cty = actor.Owner
    local actortype = actor.Type
    local importactor = actor
    -- Check if it is player_(BaseNode)
    local oldctyname = cty.Name
    if string.sub(oldctyname, #oldctyname - #BaseNodePlayerSuffix + 1, -1) == BaseNodePlayerSuffix then
      local newctyname = string.sub(oldctyname, 1, #oldctyname - #BaseNodePlayerSuffix)
      actor.Destroy() -- Remove actor
      importactor = nil

      if Player.GetPlayer(newctyname) ~= nil then 
        cty = Player.GetPlayer(newctyname)
      end
    end
    
		local mb = GetBuildingfromMasterList(actortype, cty)
		if mb ~= nil then		
			ExistingBuildings[#ExistingBuildings + 1] = actor
			
      if IncludeExistingBuildingsInBaseNodes then
        --if ExcludeExistingBuildingWithStringOverride ~= nil then
        --  if string.find(actor.Name, ExcludeExistingBuildingWithStringOverride) == nil then (no way of finding out names of NamedActors?)
            
            ImportBaseNode( 
              { 
                id = "E".. (#BaseNodes - enumbb + 1), --id is not used, for debug reference only
                type = actortype, 
                owner = cty, 
                mapactor = importactor, 
                pos = { x = actor.Location.X , y = actor.Location.Y } 
              } 
            )
        --  end
        --end
      end
		end
	end)

  if bdebug then
    local str = "Building list: ".. #BaseNodes .."\n"
    Utils.Do(BaseNodes, function(b)
      str = "\n".. str .." ".. b.id .." ".. b.owner.Name .." ".. b.type .." ".. b.pos.x .." ".. b.pos.y .."\n"
    end)
    UserInterface.SetMissionText(str, MissionPlayer.Color)
    
  end
end

function SetupBaseCenters ()
  if bdebug then UserInterface.SetMissionText("SetupBaseCenters() called at tick "..missiontick, MissionPlayer.Color) end  

  --Utils.Do(HouseGroups.Active, function(h) if BaseCenters[h.Name] == nil then SetupBaseCenter(h) end end)
--end

--SetupBaseCenter = function(player)
  --if bdebug then UserInterface.SetMissionText("SetupBaseCenter() called at tick "..missiontick, MissionPlayer.Color) end  

  -- More efficient, cycle through BaseNode only once
  local basenodetype = { }
  -- precedence: fact, weap, proc, atek, stek, dome, fix, afld, hpad, barr, tent
  local basenodeprecedence = {
    fact = 1,
    weap = 2,
    proc = 3,
    atek = 4,
    stek = 5,
    dome = 6,
    fix = 7,
    afld = 8,
    hpad = 9,
    barr = 10,
    tent = 11
  }
  
  
  Utils.Do(BaseNodes, function(b)
    if b.type == nil then return end
		if basenodeprecedence[b.type] == nil then return end
    if basenodeprecedence[b.type] >= (basenodetype[b.owner.Name] or 100) then return end
    
    basenodetype[b.owner.Name] = basenodeprecedence[b.type]
    BaseCenters[b.owner.Name] = b.pos
	end)  

end

function ArrangeBaseNodes ()
  if bdebug then UserInterface.SetMissionText("ArrangeBaseNodes() called at tick "..missiontick, MissionPlayer.Color) end  

	local BaseHoldingList = { }
	local i = 0
	local x_dist
  local y_dist
  
	for j = 1,#BaseNodes do 	
		--table.insert(BaseHoldingList, BaseNodes[j])	
    
    local cty = BaseNodes[j].owner
    if BaseCenters[cty.Name] ~= nil then
      x_dist = BaseNodes[j].pos.x - BaseCenters[cty.Name].x
      y_dist = BaseNodes[j].pos.y - BaseCenters[cty.Name].y
    else
      x_dist = BaseNodes[j].pos.x
      y_dist = BaseNodes[j].pos.y
    end
    
    BaseNodes[j].x_dist = x_dist
    BaseNodes[j].y_dist = y_dist
		BaseNodes[j].dist = x_dist * x_dist + y_dist * y_dist
		BaseNodes[j].initrank = j
	end
	        --UserInterface.SetMissionText(i.."  "..mb.dist.."  "..mb2.dist.. " "..#BaseHoldingList, HSLColor.White)

  for k,v in pairs(BaseNodes) do
      v.name = k --Store the key in an entry called "name"
      table.insert(BaseHoldingList, v)
  end
  table.sort(BaseHoldingList, function(a,b) return a.dist < b.dist end)
  BaseNodes = BaseHoldingList

	Utils.Do(BaseNodes, function(mb)
		if mb.mapactor ~= nil then 
			--t = t + 1
			--Trigger.AfterDelay(250 + 5 * t, function() UserInterface.SetMissionText(mb.id, player.Color) end)
			
			Trigger.OnKilled(mb.mapactor, function(a, _) 
				mb.mapactor = nil
        RemoveFromList (ExistingBuildings, a)
				if bdebug then UserInterface.SetMissionText(mb.id .." killed", MissionPlayer.Color) end
			end) 
		end
	end)
	
	--Debug Message only
  Media.Debug("Building information for "..#BaseNodes.." entries created.")
	if bdebug then
		local str = "Building rank: ".. #BaseHoldingList .."\n"
		local str2 = "Arranged building list: ".. #BaseNodes .."\n"
		Utils.Do(BaseHoldingList, function(b)
			str = "\n".. str .." ".. b.id .." ".. b.owner.Name .." ".. GetName(b.type) .." ".. b.initrank .." ".. b.x_dist ..",".. b.y_dist .." ".. b.dist .."\n"
		end)
		Utils.Do(BaseNodes, function(mb)
			str2 = str2 .." ".. mb.id
		end)
		Trigger.AfterDelay(DateTime.Seconds(3), function() 
			UserInterface.SetMissionText(str .."\n", MissionPlayer.Color)
		end)
	end
end

 
function ImportBaseNode (basenode)
  if bdebug then UserInterface.SetMissionText("ImportBaseNode() called at tick "..missiontick, MissionPlayer.Color) end  

  if basenode.owner == nil then return end
  local mb = GetBuildingfromMasterList(basenode.type, basenode.owner)
  if mb ~= nil then
    table.insert(BaseNodes, 
    {
      id = basenode.id,
      owner = basenode.owner,
      side = basenode.owner.Faction,
      type = basenode.type,
      pos = basenode.pos,
      mapactor = basenode.mapactor, -- for initial base nodes it is nil
      
      priority = mb.priority,
      power = mb.power,
      prereq = mb.prereq,
      cost = mb.cost or Actor.Cost(basenode.type),
      buildtime = mb.buildtime or Actor.BuildTime(basenode.type),
    })
  end
end
  
function FindBaseNode (cty, t) -- cty = player, t = type (building only), returns basenode table entry
  if bdebug then UserInterface.SetMissionText("FindBaseNode(cty = "..cty.Name..", t = "..t..") called at tick "..missiontick, MissionPlayer.Color) end  

	local result = nil
  Utils.Do(BaseNodes, function(b)
		if b.owner == cty and b.type == t then
			result = b
      return
		end
	end)
	return result
end
  



