bdebug = false -- for debug only

MissionAnnouncementDelaySeconds = 3
MissionAIDelaySeconds = 20

missionstring = ""
missiontick = 0
missionAIcontroltick = 600
missionAIreservedcontroltick = 800
missionAIcontroldelay = { low = 150, high = 350 }

missionDisplayPlayer = MissionPlayer
missionObjectiveIDs = { }
missionObjectiveFlavourText = { }

CameraSets = 
{ 
	{ PlayerCamera }
}

function Tick ()
  --if bdebug then UserInterface.SetMissionText("Tick() called at tick "..missiontick, MissionPlayer.Color) end  

  if missiontick > missionAIcontroltick then 	
    AITeamControl()
    missionAIcontroltick = missionAIcontroltick + Utils.RandomInteger(missionAIcontroldelay.low, missionAIcontroldelay.high)
  end
  
  if missiontick > missionAIreservedcontroltick then 	
    AIReservedTeamControl()
    missionAIreservedcontroltick = missionAIreservedcontroltick + Utils.RandomInteger(missionAIcontroldelay.low, missionAIcontroldelay.high)
  end
  
  if missiontick > 1 then 	
    TickShowInfo(missionDisplayPlayer)
  end
  
  -- User Entry
  if TickManualOverride then TickManualOverride() end
    
  -- Update Tick
  missiontick = missiontick + 1
end


function WorldLoaded ()
  --if bdebug then UserInterface.SetMissionText("WorldLoaded() called at tick "..missiontick, MissionPlayer.Color) end  

  GenerateMasterTable()
  InitialisePlayers()
  InitialiseBases()
  
  Trigger.AfterDelay(DateTime.Seconds(MissionAIDelaySeconds), function() 
    InitialiseAI()
	end)



	Trigger.OnObjectiveAdded(MissionPlayer, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
    --if p.GetObjectiveType(id) == "Primary" then 
    table.insert(missionObjectiveIDs, id) 
    --end
	end)
	Trigger.OnObjectiveCompleted(MissionPlayer, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
    RemoveFromList(missionObjectiveIDs, id)
	end)
	Trigger.OnObjectiveFailed(MissionPlayer, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
    if p.GetObjectiveType(id) ~= "Primary" then 
      RemoveFromList(missionObjectiveIDs, id)
    end
    missionObjectiveFlavourText[id] = "FAILED"
	end)
	Trigger.OnPlayerLost(MissionPlayer, function()
		Media.PlaySpeechNotification(MissionPlayer, "MissionFailed")
	end)
	Trigger.OnPlayerWon(MissionPlayer, function()
		Media.PlaySpeechNotification(MissionPlayer, "MissionAccomplished")
	end)
  
	Camera.Position = PlayerCamera.CenterPosition
  
  -- User Entry
  if PrepareReinforcements then PrepareReinforcements() end
  if PostSetupManualOverride then PostSetupManualOverride() end
	--Debug stuff here
end

ToggleReveal = function(n, bl)
	Utils.Do(CameraSets[n], function(a)
		if bl then
			a.Owner = MissionPlayer
		else
			a.Owner = NeutralPlayer
		end
	end)
end

