-- Collection of functions for governing AI base production --

ConstructionYards = { } -- Active Construction Yards
validstructureList = { }


-------- MAIN FUNCTION TO ATTACH TO SetupAI ActivateAI()
function SetupConYards ()
  if bdebug then UserInterface.SetMissionText("SetupConYards() called at tick "..missiontick, MissionPlayer.Color) end  
  
  Utils.Do(HouseGroups.Active, function(bot) 
    local yardlist = bot.GetActorsByType("fact")
    Utils.Do(yardlist, function(yard)
      if bdebug then UserInterface.SetMissionText(yard.Owner.Name .." ConYard found ".. #ConstructionYards.. " "..missiontick, HSLColor.Aqua) end
    
      for i = 1,#ConstructionYards do
        if ConstructionYards[i] == yard then 
          return
        end
      end
      ActivateConYard(yard)
    end)
  end)
end


------------------------------------------------------------------------------------
------ Base production activation by ConYard
function ActivateConYard (yard)
  if bdebug then UserInterface.SetMissionText("ActivateConYard() called at tick "..missiontick, MissionPlayer.Color) end  

  table.insert(ConstructionYards, yard)
  
  if TabQueue then
    BaseProduction(yard, "Structures")
    BaseProduction(yard, "Defenses")
  else
    BaseProduction(yard, "ConstructionYard")
  end
end

------------------------------------------------------------------------------------
------ Cyclic base production
function BaseProduction (yard, tab) -- yard
  if bdebug then UserInterface.SetMissionText("BaseProduction() called at tick "..missiontick, MissionPlayer.Color) end  
  
	if yard.IsDead then 
    if bdebug then  Media.Debug("Detected dead ConYard for "..yard.Owner.Name..", removing from Active ConYards") end
    RemoveFromList (ConstructionYards, yard)
    
    local i = 1
    while i <= #ActiveProductionTable do
      if ActiveProductionTable[i].factory == yard then
        table.remove(ActiveProductionTable, i)
      else
        i = i + 1
      end
    end
		return
	end

  local productiontable = nil
  Utils.Do(ActiveProductionTable, function(apt)
    if apt.factory == yard and apt.tab == tab then productiontable = apt end
  end)
  if productiontable == nil then 
    productiontable = {factory = yard, tab = tab, curr_production = "", progress = 0} 
    table.insert(ActiveProductionTable, productiontable)
  end
  
  local h = yard.Owner
	EvaluateAIBaseBehaviour(h)
	local h_priority = GetStructurePriority(h)
	
	-- Check prereqs
  validstructureList[yard] = { }
  Utils.Do(BaseNodes, function(tt)
    if tt.mapactor ~= nil then return end
    if CheckPrerequisites(tt.owner, tt.prereq) then
      validstructureList[yard][#validstructureList[yard] + 1] = tt
    end
  end)
	
	Media.Debug("Considering building construction for ".. h.Name .." with priority: ".. (h_priority or "none"))
	for i,v in ipairs(validstructureList[yard]) do
		if v.mapactor == nil and v.owner == h and (h_priority == nil or v.priority == h_priority) then
			Media.Debug(h.Name .." decided to build: [".. v.id .."] ".. GetName(v.type))
			
			-- apply multipliers
			local buildtime = v.buildtime * GetBuildTimeMultiplier(h, v.tab)
			local cost = v.cost * GetCostMultiplier(h, v.tab)
      
      BuildActor(v, h, yard, productiontable, tab, buildtime, cost)
			return
		end
	end

	-- periodic recheck
	Trigger.AfterDelay(Utils.RandomInteger(200, 1250), function() BaseProduction(yard, tab) end)
end



------------------------------------------------------------------------------------

------------------------------------------------------------------------------------
------ AI Base evaluation to set building priority
function EvaluateAIBaseBehaviour (cty, tab)
  if bdebug then UserInterface.SetMissionText("EvaluateAIBaseBehaviour() called at tick "..missiontick, MissionPlayer.Color) end  
  
	local baselist = { }
	local prioritylist = { }
  
	-- populate lists (Figure out a more efficient way to handle this)
	Utils.Do(ExistingBuildings, function(actor)
    if actor.Owner == cty then
      table.insert(baselist, actor)
      local mb = GetBuildingfromMasterList(actor.Type, cty)
      if mb ~= nil then		
        if mb.priority ~= nil then
          if prioritylist[mb.priority] == nil then prioritylist[mb.priority] = { } end
          table.insert(prioritylist[mb.priority], actor)
        end
      end
    end  
	end)

	-- check for power	
	local excesspower = AIMaintainExcessPower or 101 
	excesspower = -excesspower
  Utils.Do(baselist, function(actor)
    if actor.HasProperty("Power") then
      excesspower = excesspower + actor.Power
    end
	end)
	
	if excesspower < 0 or cty.PowerState ~= "Normal" then
		if CheckandSetStructurePriority(cty, tab, "power") then return end
	end
	
	-- check for economy
	if prioritylist["economy"] == nil or #prioritylist["economy"] < 0.1 * #baselist then 
		if CheckandSetStructurePriority(cty, tab, "economy") then return end
	end	
  
  if cty.Cash + cty.Resources < AIEmergencyCashThreshold then
    SetStructurePriority(cty, "economy")
    return
  end

	-- check for production	
	if prioritylist["production"] == nil or #prioritylist["production"] < 0.2 * #baselist then 
		if CheckandSetStructurePriority(cty, tab, "production") then return end
	end	
	
	-- check for tech
	if prioritylist["tech"] == nil or #prioritylist["tech"] < 0.1 * #baselist then 
		if CheckandSetStructurePriority(cty, tab, "tech") then return end
	end	
	
  -- check for defence
  if prioritylist["defence"] == nil or #prioritylist["defence"] < 0.25 * #baselist then 
		if CheckandSetStructurePriority(cty, tab, "defence") then return end
	end	
  
	SetStructurePriority(cty, nil)	
end

CheckandSetStructurePriority = function(cty, tab, priority) --returns true if priority has been set
  if bdebug then UserInterface.SetMissionText("CheckandSetStructurePriority() called at tick "..missiontick, MissionPlayer.Color) end  

	local priorityset = false
	Utils.Do(BaseNodes, function(mb)
      
    -- TO DO: CHECK FOR PREREQUISITES    
		if mb.owner == cty and mb.priority == priority and mb.tab == tab and mb.mapactor == nil then
      if CheckPrerequisites(mb.owner, mb.prereq) then
        SetStructurePriority(cty, priority)
        priorityset = true
        return
      end
		end
	end)
	return priorityset
end

function GetStructurePriority (player)
  if bdebug then UserInterface.SetMissionText("GetStructurePriority() called at tick "..missiontick, MissionPlayer.Color) end  

  if Houses == nil then 
    Media.Debug("WARNING: Function GetStructurePriority() invoked with empty Houses array!")
    return nil
  end
  
  if player == nil then 
    Media.Debug("WARNING: Function GetStructurePriority() invoked with empty parameter player!")
    return nil
  end  
  
 	local str = nil
  if Houses[player.Name] ~= nil then str = Houses[player.Name].StructurePriority end
	
  return str
end

function SetStructurePriority (player, newstrvalue)
  if bdebug then UserInterface.SetMissionText("SetStructurePriority() called at tick "..missiontick, MissionPlayer.Color) end  

  if Houses == nil then 
    Media.Debug("WARNING: Function SetStructurePriority() invoked with empty Houses array!")
    return 
  end
  
  if player == nil then 
    Media.Debug("WARNING: Function SetStructurePriority() invoked with empty parameter player!")
    return nil
  end  
  
  if Houses[player.Name] == nil then Houses[player.Name] = { } end
    
  Houses[player.Name].StructurePriority = newstrvalue
end




------------------------------------------------------------------------------------

