-- Collection of functions for governing AI teams --

AITeams = { }
AIFunctions = { }
------ AIGroupToFillStatus[player.Name][groupname] = actortype[]
---------- actortype indicates actortypes needed to fill the group. 
---------- Initialised from AITeams[player.Name][groupname]
---------- Depopulated by transfer of an actor with actortype into the group.
---------- Populated with actor is killed or removed from map.
---------- Always blank for reserved groups (Pool, Defender, DefenderEscort, Hunt)
AIGroupToFillStatus = { }

------ AIGroupStatus[player.Name][groupname] = actor[] 
---------- list of actors in the group
AIActorGroups = { }

------ AIGroupStatus[player.Name][groupname] = value
---------- 0: Inactive / default for empty group. If last unit of AIActorGroups is killed, value will be set to 0.
---------- Any integer above 0: Units of AIActorGroups shall commit the functions in AI[player.Name][groupname][value]
---------- Any integer + 0.5: Units of AIActorGroups are busy executing the functions in 
---------- -1: Acquiring actors from Pool. 
---------- -2: Frozen, team on standby, not acquiring actors from Pool
---------- -3: Disband, move actors back to Pool. Set to 0 when done.
AIGroupStatus = { }

------ Cloned sets so that using TickManualOverride will not affect the process.
AITeamClone = { }
AIFunctionClone = { }


------------------------------------------------------------------------------------
------ Main assignment control ATTACHED TO Tick()
function AITeamControl ()
  if bdebug then UserInterface.SetMissionText("AITeamControl() called at tick "..missiontick, MissionPlayer.Color) end
  
  for playername,aiteamgroup in pairs(AITeams) do 
    
    AITeams[playername] = AITeams[playername] or { Pool = {},Hunt = {},Defense = {}, DefenseEscort = {} }
    AITeamClone[playername] = AITeamClone[playername] or AITeams[playername]
    
    AIFunctions[playername] = AIFunctions[playername] or { Pool = {},Hunt = {},Defense = {}, DefenseEscort = {}}
    AIFunctionClone[playername] = AIFunctionClone[playername] or AIFunctions[playername]
    
    AIActorGroups[playername] = AIActorGroups[playername] or { Pool = {},Hunt = {},Defense = {}, DefenseEscort = {} }
    AIGroupStatus[playername] = AIGroupStatus[playername] or { Pool = 0,Hunt = 0,Defense = 0, DefenseEscort = 0 }
    AIGroupToFillStatus[playername] = AIGroupToFillStatus[playername] or { Pool = {},Hunt = {},Defense = {}, DefenseEscort = {}}
    
    Utils.Shuffle(aiteamgroup)
    for actorgroupname,actors in pairs(aiteamgroup) do 
      if actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defense" or actorgroupname == "DefenseEscort" then 
      else
      --pcall( 
      --function() 
        AITeams[playername][actorgroupname] = AITeams[playername][actorgroupname] or { }
        AITeamClone[playername][actorgroupname] = AITeamClone[playername][actorgroupname] or AITeams[playername][actorgroupname]
        
        AIFunctions[playername][actorgroupname] = AIFunctions[playername][actorgroupname] or { }
        AIFunctionClone[playername][actorgroupname] = AIFunctionClone[playername][actorgroupname] or AIFunctions[playername][actorgroupname]
        
        AIActorGroups[playername][actorgroupname] = AIActorGroups[playername][actorgroupname] or { }
        AIGroupToFillStatus[playername][actorgroupname] = AIGroupToFillStatus[playername][actorgroupname] or { }

        
        local status = AIGroupStatus[playername][actorgroupname]
        if status == nil then status = -99 end
        
        if status == -99 then -- test
          AIGroupStatus[playername][actorgroupname] = -1
          status = -1
          AIGroupToFillStatus[playername][actorgroupname] = clone(AITeamClone[playername][actorgroupname]) 
        end 
      
        if status == 0 then -- placeholder
          AIGroupStatus[playername][actorgroupname] = -1
          status = -1
          AIGroupToFillStatus[playername][actorgroupname] = clone(AITeamClone[playername][actorgroupname]) 
        end 
      
        if status == -1 then -- Summon from pool
          local i = 1
          while i <= tablelength(AIGroupToFillStatus[playername][actorgroupname]) do

            if GrabActorFromPool(AIGroupToFillStatus[playername][actorgroupname][i], playername, AIActorGroups[playername][actorgroupname]) then
              table.remove(AIGroupToFillStatus[playername][actorgroupname], i)
            else
              i = i + 1
            end
          end
          -- Filled
          if #AIGroupToFillStatus[playername][actorgroupname] == 0 then 
            AIGroupStatus[playername][actorgroupname] = 1
            status = 1
          end 
          
        elseif status == -3 then -- Disband, return all to Pool
          Utils.Do(AIActorGroups[playername][actorgroupname], function(actor) 
            if not actor.IsDead then 
              actor.Stop()
              table.insert (AIActorGroups[playername]["Pool"], actor) 
            end 
          end)
          AIActorGroups[playername][actorgroupname] = { }
          AIGroupToFillStatus[playername][actorgroupname] = clone(AITeamClone[playername][actorgroupname])
          AIGroupStatus[playername][actorgroupname] = 0 -- Use 0 in the final version and use another function to control it
          status = 0 -- Use 0 in the final version and use another function to control it
          -- Perform update of teams and functions if status is changed to 0
          AITeamClone[playername][actorgroupname] = clone(AITeams[playername][actorgroupname]) 
          AIFunctionClone[playername][actorgroupname] = clone(AIFunctions[playername][actorgroupname]) 
        
        elseif status == math.modf(status) and status > 0 then -- execute function[x]
          if AIFunctionClone[playername][actorgroupname] ~= nil then
            local functionset = AIFunctions[playername][actorgroupname][status]
            AIGroupStatus[playername][actorgroupname] = AIGroupStatus[playername][actorgroupname] + 0.5
            status = status + 0.5
            if functionset ~= nil then 
              functionset.ArgumentTable = functionset.ArgumentTable or { }
              if type(functionset.ArgumentTable) == "table" and type(functionset.Function) == "function" then
                functionset.ArgumentTable.Actors = AIActorGroups[playername][actorgroupname]
                functionset.ArgumentTable.PlayerName = playername
                functionset.ArgumentTable.ActorGroupName = actorgroupname
                functionset.ArgumentTable.StatusOnSuccess = math.modf(status) + 1
                functionset.Function(functionset.ArgumentTable) -- execute function
              else
                AIGroupStatus[playername][actorgroupname] = -3
                status = -3
              end
            else -- Nothing to do: disband
              AIGroupStatus[playername][actorgroupname] = -3
              status = -3
            end
          else -- Nothing to do: disband
            AIGroupStatus[playername][actorgroupname] = -3
            status = -3
          end
          
        elseif status > 0 then -- in process, but revert to status 0 if units are wiped out
          local AllDead = true
          Utils.Do(AIActorGroups[playername][actorgroupname], function(actor) if not actor.IsDead then AllDead = false end end)
          if AllDead then
            AIActorGroups[playername][actorgroupname] = { }
            AIGroupStatus[playername][actorgroupname] = 0 -- Use 0 in the final version and use another function to control it
            status = 0 -- Use 0 in the final version and use another function to control it
            -- Perform update of teams and functions if status is changed to 0 
            AITeamClone[playername][actorgroupname] = clone(AITeams[playername][actorgroupname])
            AIFunctionClone[playername][actorgroupname] = clone(AIFunctions[playername][actorgroupname]) 
          end          
        end
      end
    end
  end
end

function AIReservedTeamControl ()
  if bdebug then UserInterface.SetMissionText("AIReservedTeamControl() called at tick "..missiontick, MissionPlayer.Color) end
  
  ------ Reserved Logic: Hunt if Pool exceeds PooltoHuntThreshold
  for playername,actorgroup in pairs(AIActorGroups) do 
    PooltoHuntThreshold[playername] = PooltoHuntThreshold[playername] or 10
    if #AIActorGroups[playername]["Pool"] > PooltoHuntThreshold[playername] then
      
      HuntingPath(AIActorGroups[playername]["Pool"], playername)
      AIActorGroups[playername]["Hunt"] = AIActorGroups[playername]["Hunt"] or { }
      Utils.Do(AIActorGroups[playername]["Pool"], function(actor) table.insert (AIActorGroups[playername]["Hunt"], actor) end)
      AIActorGroups[playername]["Pool"] = { }
    end
  end
end

function AIReservedDefense ()
  if bdebug then UserInterface.SetMissionText("AIReservedTeamControl() called at tick "..missiontick, MissionPlayer.Color) end

  ------ Reserved Logic: Send Pool to Defense and DefenseEscort if a Protect unit or Structure gets attacked.

  -- Not yet implemented (to define how to give certain units Protected status)

end


function GrabActorFromPool (actortype, playername, targettable) -- return true if successful
  if bdebug then UserInterface.SetMissionText("GrabActorFromPool() called at tick "..missiontick, MissionPlayer.Color) end
  
  for k,v in pairs(AIActorGroups[playername]["Pool"]) do
    if v.Type == actortype then 
      targettable = targettable or { }
      local actor = AIActorGroups[playername]["Pool"][k]
      targettable[#targettable + 1] = actor
      AIActorGroups[playername]["Pool"][k] = nil 
      --TransferActorToActorGroup(v, AIActorGroups[playername]["Pool"], targettable) 
      return true
    end
  end 
  return false
end

function TransferActorToActorGroup (actor, sourcetable, targettable)
  if bdebug then UserInterface.SetMissionText("TransferActorToActorGroup() called at tick "..missiontick, MissionPlayer.Color) end

  for k,v in pairs(sourcetable) do
    if v == actor then 
      targettable = targetable or { }
      table.insert (targettable, actor)
      sourcetable[k] = nil 
      return
    end
  end 
end


function HuntingPath (units, playername)
  if bdebug then UserInterface.SetMissionText("HuntingPath(units, player = "..playername..") called at tick "..missiontick, MissionPlayer.Color) end
  
  local currentwaypoint = Utils.Random(AIHuntInitialWaypoints[playername])
  if currentwaypoint == nil then currentwaypoint = Utils.Random(Waypoints) end
  local path = { } 
  table.insert(path, currentwaypoint.Location)
  local str = ""
  for i = 1, 20 do
    
    str = str.. "  ("..currentwaypoint.Location.X..","..currentwaypoint.Location.Y..") "
    local nextwaypointset = GetNextWaypointSet(currentwaypoint)
    if #nextwaypointset == 1 then currentwaypoint = nextwaypointset[1]
    elseif #nextwaypointset > 1 then
      
      --RemoveFromList(nextwaypointset, currentwaypoint)
      for k,v in pairs(nextwaypointset) do
        if v.Location.X == currentwaypoint.Location.X and v.Location.Y == currentwaypoint.Location.Y then 
          nextwaypointset[k] = nil 
        end
      end    
      --Media.Debug("nextwaypointset "..#nextwaypointset) 
      currentwaypoint = Utils.Random(nextwaypointset)
    else currentwaypoint = Utils.Random(Waypoints)
    end
    table.insert(path, currentwaypoint.Location)
  end
  Media.Debug(#units.." units belonging to "..playername.." set to hunt for "..#path.." waypoints:  "..str)
  --GroupPatrol(units, path, 600, 5)
  
  Utils.Do(units, function(unit)
    if unit.IsDead then return end
    if not unit.IsInWorld then return end
    if unit.Type == "yak" or unit.Type == "mig" or unit.Type == "hind" or unit.Type == "heli" or unit.Type == "tran" then 
      AircraftAttack(unit, path, 8, 100, true)
    else    
      GroundAttack(unit, path, 4, 50, true)
    end
  end)
end

function AircraftAttack (a, path, closeenough, checkdelay, cyclic)
  if bdebug then UserInterface.SetMissionText("AircraftAttack() called at tick "..missiontick, MissionPlayer.Color) end
  
	if a.IsDead then return end
  if not a.IsInWorld then return end
 
  local i = 1
  local exwaypoints = { } -- for expanded waypoints
  
  for j = 1,#path do
    if closeenough > 1 then
      for cl = 1, closeenough do
        if cl > 1 then	-- ignore first expansion
          exwaypoints[j] = Utils.ExpandFootprint({path[j]}, false)
        end
      end
    else
      exwaypoints[j] = { path[j] }		
    end
  end
 
  if a.AmmoCount() == 0 then
    a.Stop()
    a.ReturnToBase()
    AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  else
    a.Stop()
    a.AttackMove(path[i], closeenough)
    AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  end
end

function AircraftMove (a, path, closeenough, checkdelay, cyclic)
  if bdebug then UserInterface.SetMissionText("AircraftAttack() called at tick "..missiontick, MissionPlayer.Color) end
  
	if a.IsDead then return end
  --if not a.IsInWorld then return end
 
  local i = 1
  local exwaypoints = { } -- for expanded waypoints
  
  for j = 1,#path do
    if closeenough > 1 then
      for cl = 1, closeenough do
        if cl > 1 then	-- ignore first expansion
          exwaypoints[j] = Utils.ExpandFootprint({path[j]}, false)
        end
      end
    else
      exwaypoints[j] = { path[j] }		
    end
  end
 
    a.Stop()
    a.Move(path[i], closeenough)
    AircraftMove(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
end

function AircraftReloadRefresh (a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  Trigger.AfterDelay(checkdelay * 20, function()
    if a.IsDead then return end
    --if not a.IsInWorld then return end
    if a.AmmoCount() == 0 then    
      -- why are you not loading?
      a.Stop()
      a.AttackMove(path[i], closeenough)    
      --AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
      --I give up on you, just don't jam the airfield / helipad
      AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    elseif a.AmmoCount() ~= a.MaximumAmmoCount() then
      AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    else
      a.Stop()
      a.AttackMove(path[i], closeenough)
      AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    end 
  end)
end

function AircraftAttackRefresh (a, path, closeenough, checkdelay, exwaypoints, i, cyclic)  
  Trigger.AfterDelay(checkdelay, function()
    if a.IsDead then return end
    local reachdest = false
    --Utils.Do(exwaypoints[i], function(wp)
    --  if a.Location == wp then reachdest = true end
    --end)
    
    --if reachdest then 
      i = i + 1
      if i > #path then
        if cyclic then 
          i = 1
        else
          return
        end
      end
    --end
    
    if a.AmmoCount() == 0 then
      a.Stop()
      a.ReturnToBase()
      AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    else
      a.Stop()
      a.AttackMove(path[i], closeenough)
      AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    end
  end)
end

function GroundAttack (a, path, closeenough, delay, cyclic, waitforgroup, noattack) -- waitforgroup: Actor[] or false, noattack: use move instead of attack
  if bdebug then UserInterface.SetMissionText("GroundAttack() called at tick "..missiontick, MissionPlayer.Color) end

	if a.IsDead then return end
  
  local i = 1
  local stop = false
  local exwaypoints = { } -- for expanded waypoints
  
  for j = 1,#path do
    if closeenough > 1 then
      for cl = 1, closeenough do
        if cl > 1 then	-- ignore first expansion
          exwaypoints[j] = Utils.ExpandFootprint({path[j]}, false)
        end
      end
    else
      exwaypoints[j] = { path[j] }		
    end
  end
  
  if not a.IsDead then
    a.Scatter()
    Trigger.OnIdle(a, function()
      if stop then
        return
      end

      local reachdest = false
      Utils.Do(exwaypoints[i], function(wp)
        if a.Location == wp then reachdest = true end
      end)
      
      if reachdest then 
        local bool = false
        if waitforgroup then
          bool = Utils.All(waitforgroup, function(actor)
            if actor.IsDead then return true end
            return actor.IsIdle
          end)
        else
          bool = a.IsDead or a.IsIdle
        end
        if bool then
          stop = true
          i = i + 1
          if i > #path then
            if cyclic then 
              i = 1
            else
              return
            end
          end

          Trigger.AfterDelay(delay, function() stop = false end)
        end
      else
        if noattack or not a.HasProperty("AttackMove") then
          a.Move(path[i], closeenough)
        else
          a.AttackMove(path[i], closeenough)
        end
        Trigger.AfterDelay(delay, function() if not a.IsDead then a.Stop() end end)
      end
    end)
  end
end


-- Simple hunts. WARNING: Aircraft cannot use Hunt()!
function ForceHunt (a) 
	if a.HasProperty("Hunt") and a.HasProperty("IsMobile") then
		if not a.IsDead then 
      if a.IsInWorld then
        a.Stop()
        a.Hunt()
      end
		end
	end
end

function IdleHunt (a) 
	if a.HasProperty("Hunt") and a.HasProperty("IsMobile") then
		if not a.IsDead then 
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					a.Hunt()
				end
			end)
		end
	end
end

-- Closed loop patrol
function GroupPatrol (units, waypoints, delay, closeenough)
  if bdebug then UserInterface.SetMissionText("GroupPatrol() called at tick "..missiontick, MissionPlayer.Color) end

	local i = 1
	local stop = false

	local exwaypoints = { } -- for expanded waypoints
  
	for j = 1,#waypoints do
		if closeenough > 1 then
			for cl = 1, closeenough do
				if cl > 1 then	-- ignore first expansion
					exwaypoints[j] = Utils.ExpandFootprint({waypoints[j]}, false)
				end
			end
		else
			exwaypoints[j] = { waypoints[j] }		
		end
	end
	
	Utils.Do(units, function(unit)
		if not unit.IsDead then
			unit.Scatter()
			Trigger.OnIdle(unit, function()
				if stop then
					return
				end

				--Trigger.OnEnteredProximityTrigger(Map.CenterOfCell(waypoints[i]), WDist.New(closeenough * 1024), function(a, id)
				local reachdest = false
				Utils.Do(exwaypoints[i], function(wp)
					if unit.Location == wp then reachdest = true end
				end)
				
				if reachdest then 
					--if a == unit then
					local bool = Utils.All(units, function(actor)
						if actor.IsDead then return true end
						return actor.IsIdle 
					end)

					if bool then
						stop = true

						i = i + 1
						if i > #waypoints then
							i = 1
						end

						Trigger.AfterDelay(delay, function() stop = false end)
					end
				--end)
				
				--Trigger.OnExitedProximityTrigger(Map.CenterOfCell(waypoints[i]), WDist.New(closeenough * 1024), function(a, id)
				--	if a == unit and not a.IsDead then
				else
					unit.AttackMove(waypoints[i], closeenough)
				end
				--end)				
			end)
		end
	end)
end



	

