if Map.LobbyOption("difficulty") == "Easy" then

	PlayerReinforcement1 = { "e7", "medi", "spy", "spy", "stnk" }
	PlayerReinforcement2 = { "1tnk", "1tnk", "1tnk", "mech", "mech" }
	PlayerReinforcement3 = { "jeep", "jeep", "2tnk", "2tnk", "mcv" }

	USSRReinforcement1 = { "e1", "e1", "e1", "e2", "e2", "e3", "e3"  }
	USSRReinforcement2 = { "e4", "e4", "e4", "e4" }
	USSRReinforcement3 = { "shok", "shok", "e4", "e4" }
	USSRReinforcement4 = { "3tnk", "3tnk", "3tnk" }


	USSRAIReinfDelay = DateTime.Minutes(5) + DateTime.Seconds(10)

	ENGLANDAIReinfDelay = DateTime.Minutes(2) + DateTime.Seconds(50)

elseif Map.LobbyOption("difficulty") == "Mental" then

	PlayerReinforcement1 = { "e7", "medi", "stnk" }
	PlayerReinforcement2 = { "spy", "spy" }
	PlayerReinforcement3 = { }

	USSRReinforcement1 = { "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e3", "e3" }
	USSRReinforcement2 = { "e4", "e4", "e4", "e4", "e4", "e4", "e3", "e3" }
	USSRReinforcement3 = { "v2rl", "v2rl", "shok", "shok", "shok", "shok" }
	USSRReinforcement4 = { "4tnk", "4tnk" }


	USSRAIReinfDelay = DateTime.Minutes(4) + DateTime.Seconds(10)

	ENGLANDAIReinfDelay = DateTime.Minutes(4) + DateTime.Seconds(10)

else

	PlayerReinforcement1 = { "e7", "medi", "spy", "spy", "stnk" }
	PlayerReinforcement2 = { "1tnk", "1tnk", "1tnk", "e3", "e3" }
	PlayerReinforcement3 = { "jeep", "jeep", "e3" , "e3" , "mcv" }

	USSRReinforcement1 = { "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e3", "e3" }
	USSRReinforcement2 = { "e4", "e4", "e4", "e4", "e3" }
	USSRReinforcement3 = { "v2rl", "shok", "shok" }
	USSRReinforcement4 = { "4tnk" }


	USSRAIReinfDelay = DateTime.Minutes(4) + DateTime.Seconds(40)

	ENGLANDAIReinfDelay = DateTime.Minutes(3) + DateTime.Seconds(10)

end

PlayerReinforcementSet = { PlayerReinforcement1, PlayerReinforcement2, PlayerReinforcement3 }

USSRBIOOut = USSRBIO1.Location + CVec.New(0, 1)
PlScientistType = "chan"

USSRReinforcementSet = { USSRReinforcement1, USSRReinforcement2, USSRReinforcement3, USSRReinforcement4 }
USSRReinforcementPath =
{
	{ spawn = { USSRReinforcementSpawn1.Location }, path = { USSRAdv1C.Location, USSRAdv2C.Location, EngBase.Location } }
}

USSRAdvanceLv1 = { USSRAdv1A.Location, USSRAdv1B.Location, USSRAdv1C.Location }
USSRAdvanceLv2 = { USSRAdv2A.Location, USSRAdv2B.Location, USSRAdv2C.Location }
USSRAdvanceLv3 = { EngBase.Location }

USSRAdvanceA = {USSRAdv1A.Location, USSRAdv2A.Location, EngBase.Location}
USSRAdvanceB = {USSRAdv1B.Location, USSRAdv2B.Location, EngBase.Location}
USSRAdvanceC = {USSRAdv1C.Location, USSRAdv2C.Location, EngBase.Location}

USSRAdvanceRand = 		
{ 
	Utils.Random(USSRAdvanceLv1), 
	Utils.Random(USSRAdvanceLv2), 
	Utils.Random(USSRAdvanceLv3)
}

USSRPatrolGroup = 
{ 
	{ "e1", "e1", "dog" },
	{ "e1", "dog", "dog" },
	{ "e2", "e2", "e1", "dog" },
	{ "e4", "e4", "dog" },
	{ "e1", "shok", "dog" }
}

USSRPatrolPaths = 
{ 
	{ spawn = { USSRPatrol1A.Location }, path = { USSRPatrol1A.Location, USSRPatrol1B.Location } },
	{ spawn = { USSRPatrol2A.Location }, path = { USSRPatrol2A.Location, USSRPatrol2B.Location } },
	{ spawn = { USSRPatrol3A.Location }, path = { USSRPatrol3A.Location, USSRPatrol3B.Location } },
	{ spawn = { USSRPatrol4A.Location }, path = { USSRPatrol4A.Location, USSRPatrol4B.Location } },
	{ spawn = { USSRPatrol5A.Location }, path = { USSRPatrol5A.Location, USSRPatrol5B.Location, USSRPatrol5C.Location, USSRPatrol5D.Location } },
	{ spawn = { USSRPatrol6A.Location }, path = { USSRPatrol6A.Location, USSRPatrol6B.Location, USSRPatrol6C.Location, USSRPatrol6D.Location } }
}

USSRAircraftAttackPos = { USSRAdv1B, USSRAdv1C, USSRAdv2A, USSRAdv2C, EngBase }

SovParadropLocations = {  }
SovParadropUnits = 
{ 
	{ "e1", "e1", "e1", "e1", "e1", "e1"},
	{ "e2", "e2", "e2", "e2", "e2" },
	{ "e3", "e3", "e1", "e1", "e1" },
	{ "e4", "e4", "e4", "e2", "e2" },
	{ "shok", "shok", "e1", "e1", "e1"}
}

ENGLANDReinforcement1 = { "1tnk", "1tnk", "1tnk", "2tnk", "2tnk" }
ENGLANDReinforcement2 = { "e3", "e3", "e3", "e3", "e3" }
ENGLANDReinforcement3 = { "jeep", "jeep", "jeep", "e1", "e1" }
ENGLANDReinforcement4 = { "e1", "e1", "e3", "e3", "e3" }
ENGLANDReinforcement5 = { "mrj", "e1", "e3", "e3", "e3" }
ENGLANDReinforcement6 = { "mcv" }

ENGLANDReinforcementSet = { ENGLANDReinforcement1, ENGLANDReinforcement2, ENGLANDReinforcement3, ENGLANDReinforcement4, ENGLANDReinforcement5, ENGLANDReinforcement6 }
ENGLANDReinforcementPath = { ENGLANDAdvanceA, ENGLANDAdvanceA, ENGLANDAdvanceB, {EngDefend.Location}, {EngDefend.Location}, {EngBase.Location} }

ENGLANDAdvanceLv1 = { USSRAdv2B.Location, USSRAdv2C.Location }
ENGLANDAdvanceLv2 = { USSRAdv1B.Location, USSRAdv1C.Location }
ENGLANDAdvanceLv3 = { USSRBase.Location }

ENGLANDAdvanceA = {USSRAdv2B.Location, USSRAdv1B.Location, USSRBase.Location}
ENGLANDAdvanceB = {USSRAdv2C.Location, USSRAdv1C.Location, USSRBase.Location}

ENGLANDAdvanceRand = 		
{ 
	Utils.Random(ENGLANDAdvanceLv1), 
	Utils.Random(ENGLANDAdvanceLv2), 
	Utils.Random(ENGLANDAdvanceLv3)
}

AllyReinfPointSet = { AllyReinfPoint1.Location, AllyReinfPoint2.Location, AllyReinfPoint3.Location, AllyReinfPoint1.Location, AllyReinfPoint2.Location, AllyReinfPoint3.Location }
HeliEscorts = { }

 -- Player Reinforcements

PreparePlayerReinforcements = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function() SendPlayerReinforcements(1) end)
end

PreparePlayerReinforcements2 = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function() SendPlayerReinforcements(2) end)
	if Map.LobbyOption("difficulty") ~= "Mental" then 
		Trigger.AfterDelay(DateTime.Seconds(15), function() SendPlayerReinforcements(3) end)
	end
end

SendPlayerReinforcements = function(i)
	Media.Debug("Creating Player Reinforcements #" .. i)
	Media.PlaySpeechNotification(player, "ReinforcementsArrived")
	
	local units = Reinforcements.ReinforceWithTransport(player, "lst", PlayerReinforcementSet[i], { PlayerEntryPoint.Location, PlayerReinfPoint.Location }, { PlayerEntryPoint.Location })[2]
	
	Utils.Do(units, function(unit)
		Trigger.OnAddedToWorld(unit, function()
			Trigger.OnDamaged(unit, PlayerDamaged)
			if unit.Type == "e7" then
				Tanyas[#Tanyas + 1] = unit
				Trigger.OnAnyKilled(Tanyas, function()
					player.MarkFailedObjective(TanyaSurviveObjective)
				end)

			elseif unit.Type == "stnk" then
				STNKs[#STNKs + 1] = unit
				Trigger.OnAnyKilled(STNKs, function()
					player.MarkFailedObjective(PhaseSurviveObjective)
				end)

			end
		end)
	end)	
end

SendPlayerScientist = function()
	Media.Debug("Creating Player Scientist")
	PlScientist = Actor.Create(PlScientistType, true, { Location = USSRBIOOut, Owner = player })
	PlScientist.Scatter()
	Trigger.OnDamaged(PlScientist, PlayerDamaged) 
	Trigger.OnKilled(PlScientist, RescueFailed)
	Trigger.AfterDelay(DateTime.Seconds(1), function() Media.PlaySpeechNotification(player, "TargetFreed") end)	
end

SendHeliEscorts = function()

	Media.Debug("Creating Hinds")
	local Escorts = { "hind" }
	local x = Utils.RandomInteger(3, 6)
	local y = Utils.Random({-1,1})
	local z = Utils.Random({-1,1})
	local EscortPath = { ExtractionEntryPoint.Location + CVec.New(0,2), ExtractionLZ.Location + CVec.New(z*x,y*(6-x)) }
	local heliescort = Reinforcements.Reinforce( pl_england , Escorts, EscortPath )
	
	HeliEscorts[#HeliEscorts + 1] = heliescort[1]
	
	heliescort.Stance = "Defend"
end

RetreatHeliEscorts = function()

	Media.Debug("Retreating Player Hinds")
	local i = 0
	Utils.Do(HeliEscorts, function(a)
		if not a.IsDead then
			a.Move(ExtractionEntryPoint.Location + CVec.New(0,2 + i))
			Trigger.OnIdle(a, a.Destroy)
			i = i + 2
		end
	end)
end

 -- USSR Reinforcements

 PrepareUSSRPatrols = function()

	Trigger.AfterDelay(DateTime.Seconds(2), function() CreatUSSRPatrols(1) end) 
	Trigger.AfterDelay(DateTime.Seconds(3), function() CreatUSSRPatrols(2) end) 
	Trigger.AfterDelay(DateTime.Seconds(4), function() CreatUSSRPatrols(3) end) 
	Trigger.AfterDelay(DateTime.Seconds(5), function() CreatUSSRPatrols(4) end) 
	Trigger.AfterDelay(DateTime.Seconds(6), function() CreatUSSRPatrols(5) end) 
	Trigger.AfterDelay(DateTime.Seconds(7), function() CreatUSSRPatrols(6) end) 

end
 
PrepareUSSRReinforcements = function()

	Trigger.AfterDelay(DateTime.Seconds(1), function() SendUSSRReinforcements(1) end) 
	
	--Trigger.AfterDelay(DateTime.Seconds(25), ParadropSovietUnits)
end

SendUSSRReinforcements = function(i)

	Media.Debug("Creating Soviet Reinforcements #" .. i)
	local Invaders = Utils.Random(USSRReinforcementSet)
	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(60))
	local units = Reinforcements.Reinforce( pl_ussr , Invaders, USSRReinforcementPath[i].spawn , DateTime.Seconds(1))
	
	Utils.Do(units, function(unit)
		unit.Patrol(USSRReinforcementPath[i].path, false, 60)
		IdleHunt(unit) 
	end)


	Trigger.AfterDelay(USSRAIReinfDelay + delay, function() SendUSSRReinforcements(i) end) 
	
end

CreatUSSRPatrols = function(i)

	Media.Debug("Creating Soviet Patrol #" .. i)
	local Patrols = Utils.Random(USSRPatrolGroup)
	local units = Reinforcements.Reinforce( pl_ussr , Patrols, USSRPatrolPaths[i].spawn , DateTime.Seconds(1))
	
	GroupPatrol(units, USSRPatrolPaths[i].path, 180)
	
end

ParadropSovietUnits = function()

	if deadaircraft then
		Media.Debug("Soviet Airfields destroyed. Cancelling paradrops.")
		return 		
	end
	
	Media.Debug("Creating Soviet Paradrop team.")
	local lz = Utils.Random(SovParadropLocations).Location
    local start = Map.CenterOfCell(Map.RandomEdgeCell()) + WVec.New(0, 0, Actor.CruiseAltitude("badr"))
    local transport = Actor.Create("badr", true, { CenterPosition = start, Owner = pl_ussr, Facing = (Map.CenterOfCell(lz) - start).Facing })
	local units = Utils.Random(SovParadropUnits)
	
    Utils.Do(units, function(type)
        local a = Actor.Create(type, false, { Owner = pl_ussr })
        IdleHunt(a)
		transport.LoadPassenger(a)
	end)

    transport.Paradrop(lz)
	
	-- 2nd time
	Trigger.AfterDelay(DateTime.Seconds(3), function()
		local transport2 = Actor.Create("badr", true, { CenterPosition = start, Owner = pl_ussr, Facing = (Map.CenterOfCell(lz) - start).Facing })
		local units2 = Utils.Random(SovParadropUnits)
		
		Utils.Do(units2, function(type)
			local a = Actor.Create(type, false, { Owner = pl_ussr })
			IdleHunt(a)
			transport2.LoadPassenger(a)
		end)
	
		transport2.Paradrop(lz)	
	end)
	
	Trigger.AfterDelay(DateTime.Minutes(2), ParadropSovietUnits)
	
end

PrepareENGLANDReinforcements = function()

	Media.PlaySpeechNotification(player, "AlliedReinforcementsEast")
	
	Trigger.AfterDelay(DateTime.Seconds(1), function() SendENGLANDReinforcements(1) end) 
	Trigger.AfterDelay(DateTime.Seconds(5), function() SendENGLANDReinforcements(2) end) 
	Trigger.AfterDelay(DateTime.Seconds(9), function() SendENGLANDReinforcements(3) end) 
	Trigger.AfterDelay(DateTime.Seconds(40), function() SendENGLANDReinforcements(4) end) 
	Trigger.AfterDelay(DateTime.Seconds(44), function() SendENGLANDReinforcements(5) end) 
	Trigger.AfterDelay(DateTime.Seconds(48), function() SendENGLANDReinforcements(6) end) 

	
	
	--Trigger.AfterDelay(DateTime.Minutes(2), function() SendENGLANDChinookReinforcements(HeliEntry1, HeliTrans1, 0) end)  

end

SendENGLANDReinforcements = function(i)

	Media.Debug("Creating Allied Reinforcements #" .. i)
	local Defenders = Utils.Random(ENGLANDReinforcementSet)
	
	local units = Reinforcements.ReinforceWithTransport(pl_england, "lst", ENGLANDReinforcementSet[i], { AllyEntryPoint.Location, AllyReinfPointSet[i] }, { AllyEntryPoint.Location })[2]
	
	
	Utils.Do(units, function(unit)
		Trigger.OnIdle(unit, function(a)
			if i == 6 then -- MCV
				a.Move(ENGLANDReinforcementPath[i][1])
				a.Deploy()
				Trigger.AfterDelay(DateTime.Seconds(7), BuildBase)
			elseif i == 4 or i == 5 then -- MRJ defence perimeter
				a.Move(ENGLANDReinforcementPath[i][1])
			else
				a.AttackMove(Utils.Random(ENGLANDAdvanceLv1), 1)
				a.AttackMove(Utils.Random(ENGLANDAdvanceLv2), 1)
				a.AttackMove(Utils.Random(ENGLANDAdvanceLv3), 1)
			end
		end)
	end)

end



SendENGLANDChinookReinforcements = function(entry, hpad, IsWest)

	Media.Debug("Creating Allied Chinook Drop")
	local units = Reinforcements.ReinforceWithTransport(pl_england, "lst", ENGLANDReinforcementSet[i], { AllyEntryPoint.Location, AllyReinfPointSet[i].Location }, { AllyEntryPoint.Location })[2]

	Utils.Do(units, function(unit)
		a.AttackMove(Utils.Random(ENGLANDAdvanceLv1), 1)
		a.AttackMove(Utils.Random(ENGLANDAdvanceLv2), 1)
		a.AttackMove(Utils.Random(ENGLANDAdvanceLv3), 1)
	end)

	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(60))
	Trigger.AfterDelay(DateTime.Minutes(4) + delay, function() SendENGLANDChinookReinforcements(entry, hpad, IsWest) end)
end
