-- Collection of functions for governing unit and AI behaviour --

if Map.LobbyOption("difficulty") == "Easy" then
	SovietBuildTimeMultiplier = 3
	AlliedBuildTimeMultiplier = 1.5
	AircraftTimeMultiplier = 10
	DogTimeMultiplier = 5

	SovietInfantryTypes = { "e1", "e1", "e1", "e1", "e1", "e2", "e2", "e4", "e4" }
	SovietVehicleTypes = { "3tnk", "3tnk", "3tnk", "3tnk", "3tnk", "v2rl", "v2rl", "v2rl", "apc", "ftrk", "ftrk", "ftrk", "ftrk", "ttnk" }
	SovietAircraftType = { "yak" }

	AlliedInfantryTypes = { "e1", "e1", "e1", "e3", "e3", "e3" }
	AlliedVehicleTypes = { "jeep", "jeep", "1tnk", "arty", "arty", "arty", "2tnk", "2tnk", "apc" }

	SovietAttackGroupSize = 5
	AlliedAttackGroupSize = 20
	
elseif Map.LobbyOption("difficulty") == "Mental" then
	
	SovietBuildTimeMultiplier = 1.5
	AlliedBuildTimeMultiplier = 2.5
	AircraftTimeMultiplier = 1.75
	DogTimeMultiplier = 3.5

	SovietInfantryTypes = { "e1", "e1", "e2", "e2", "e2", "e4", "e4", "shok", "shok" }
	SovietVehicleTypes = { "3tnk", "3tnk", "3tnk", "v2rl", "v2rl", "v2rl", "apc", "ftrk", "ftrk", "4tnk", "4tnk", "ttnk", "ttnk", "ttnk" }
	SovietAircraftType = { "yak", "mig" }

	AlliedInfantryTypes = { "e1", "e1", "e1", "e1", "e1", "e3" }
	AlliedVehicleTypes = { "jeep", "jeep", "jeep", "1tnk", "1tnk", "1tnk", "arty", "2tnk", "apc" }

	SovietAttackGroupSize = 30
	AlliedAttackGroupSize = 6
else

	SovietBuildTimeMultiplier = 2
	AlliedBuildTimeMultiplier = 2
	AircraftTimeMultiplier = 3
	DogTimeMultiplier = 4

	SovietInfantryTypes = { "e1", "e1", "e1", "e1", "e2", "e2", "e4", "e4", "shok" }
	SovietVehicleTypes = { "3tnk", "3tnk", "3tnk", "3tnk", "3tnk", "v2rl", "v2rl", "v2rl", "apc", "ftrk", "ftrk", "ftrk", "4tnk", "ttnk" }
	SovietAircraftType = { "yak" }

	AlliedInfantryTypes = { "e1", "e1", "e1", "e1", "e3", "e3" }
	AlliedVehicleTypes = { "jeep", "jeep", "1tnk", "1tnk", "1tnk", "arty", "arty", "2tnk", "apc" }

	SovietAttackGroupSize = 20
	AlliedAttackGroupSize = 12	
end 

SovietWest = { USSR1BARR1, USSR1BARR2, USSR1BARR3, USSR1KENN, USSR1WEAP, USSR1AFLD1, USSR1AFLD2 }
SovietWestB = { USSR3BARR1, USSR3BARR2, USSR3WEAP1, USSR3WEAP2, USSR3AFLD1, USSR3AFLD2, USSR3AFLD3, USSR3AFLD4 }
SovietEast = { USSR2BARR1, USSR2BARR2, USSR2KENN, USSR2WEAP, USSR2AFLD1 }
AlliedWest = { ENGLANDTENT1, ENGLANDTENT2, ENGLANDWEAP }
AlliedEast = { ENGLANDTENT3, ENGLANDTENT4 }

SovietWestHoldingList = { }
SovietWestBHoldingList = { }
SovietEastHoldingList = { }
AlliedWestHoldingList = { }
AlliedEastHoldingList = { }

ProducedUnitTypes =
{
	-- USSR Production
	{ factory = USSR1BARR1, types = SovietInfantryTypes },
	{ factory = USSR1BARR2, types = SovietInfantryTypes },
	{ factory = USSR1BARR3, types = SovietInfantryTypes },
	{ factory = USSR1KENN, types = { "dog" } },
	{ factory = USSR1WEAP, types = SovietVehicleTypes },
	{ factory = USSR1AFLD1, types = SovietAircraftType },
	{ factory = USSR1AFLD2, types = SovietAircraftType },
	
	-- USSR2 Production

	{ factory = USSR2BARR1, types = SovietInfantryTypes },
	{ factory = USSR2BARR2, types = SovietInfantryTypes },
	{ factory = USSR2KENN, types = { "dog" } },
	{ factory = USSR2WEAP, types = SovietVehicleTypes },
	{ factory = USSR2AFLD1, types = SovietAircraftType },

	-- USSR3 Production
	{ factory = USSR3BARR1, types = SovietInfantryTypes },
	{ factory = USSR3BARR2, types = SovietInfantryTypes },
	{ factory = USSR3WEAP1, types = SovietVehicleTypes },
	{ factory = USSR3WEAP2, types = SovietVehicleTypes },
	{ factory = USSR3AFLD1, types = SovietAircraftType },
	{ factory = USSR3AFLD2, types = SovietAircraftType },
	{ factory = USSR3AFLD3, types = SovietAircraftType },
	{ factory = USSR3AFLD4, types = SovietAircraftType },
	
	-- ENGLAND Production

	{ factory = ENGLANDTENT1, types = AlliedInfantryTypes },
	{ factory = ENGLANDTENT2, types = AlliedInfantryTypes },
	{ factory = ENGLANDTENT3, types = AlliedInfantryTypes },
	{ factory = ENGLANDTENT4, types = AlliedInfantryTypes },
	{ factory = ENGLANDWEAP, types = AlliedVehicleTypes }
	
}


-- Simple hunt
IdleHunt = function(a) 
	if a.HasProperty("Hunt") then
		if not a.IsDead then 
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					a.Hunt()
				end
			end)
		end
	end
end

-- Closed loop patrol - Not used
GroupPatrol = function(units, waypoints, delay)
	local i = 1
	local stop = false

	Utils.Do(units, function(unit)
		Trigger.OnIdle(unit, function()
			if stop then
				return
			end

			if unit.Location == waypoints[i] then
				local bool = Utils.All(units, function(actor) return actor.IsIdle end)

				if bool then
					stop = true

					i = i + 1
					if i > #waypoints then
						i = 1
					end

					Trigger.AfterDelay(delay, function() stop = false end)
				end
			else
				unit.AttackMove(waypoints[i], 1)
			end
		end)
	end)
end

-- Initial unit setup
SetupMapUnits = function(n)
	Utils.Do(Map.NamedActors, function(a)
		a.Stance = "Defend"
		
		-- attack persistent attackers
		if a.HasProperty("Health") then
			Trigger.OnDamaged(a, function(b)
				if b.Health < n * b.MaxHealth then
					b.Stance = "AttackAnything"
				end
			end)
		end
		
		-- convert all walls to neutral
		if a.Type == "brik" or a.Type == "cycl" or a.Type == "fenc" or a.Type == "sbag" then
			a.Owner = neutral
		end
	end)
end

-- Production of units from factory
ProduceUnits = function(t)
	local factory = t.factory
	if (not factory.IsDead) and #t.types > 0 then
		local unitType = t.types[Utils.RandomInteger(1, #t.types + 1)]
		
		-- too many doge.
		if unitType == "dog" then
			factory.Wait(Actor.BuildTime(unitType) * DogTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02}))
		elseif unitType == "yak" or unitType == "mig" then
			factory.Wait(Actor.BuildTime(unitType) * AircraftTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02}))
		else
			-- Soviet vs Allied adjustment for difficulty
			if factory.Owner == pl_england then
				factory.Wait(Actor.BuildTime(unitType) * AlliedBuildTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02}))
			else
				factory.Wait(Actor.BuildTime(unitType) * SovietBuildTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02}))
			end
		end
		factory.Produce(unitType)
		factory.CallFunc(function() ProduceUnits(t) end)
	end
end

-- Factory setup to produce
SetupFactories = function()
	Utils.Do(ProducedUnitTypes, function(production)
		local fty = production.factory
		Trigger.OnProduction(fty, function(_, a) DecisionMaker(fty, a) end)
	end)
end

AircraftDecisionMaker = function(a)
	if a.IsDead then return end
	a.AttackMove(Utils.Random(USSRAircraftAttackPos).Location, 5)
	
	Trigger.AfterDelay(DateTime.Seconds(3), function() AircraftDecisionMaker(a) end)
end

-- What to do with the units?
DecisionMaker = function(factory, a)

	local isaircraft = false
	for i = 1, #SovietAirfields do
		if SovietAirfields[i] == factory then isaircraft = true end
	end

	if isaircraft then -- Unit is a Soviet aircraft
	
		Media.Debug("Sending Soviet Aircraft to attack.")
		AircraftDecisionMaker(a)
		return
	
	else -- Unit is a ground vehicle, Allied or Soviet
		-- What factory is this?
		for i = 1, #SovietWest do -- Factory belongs to Soviet, on the western front
			if SovietWest[i] == factory then
			
				SovietWestHoldingList[#SovietWestHoldingList + 1] = a
				if #SovietWestHoldingList >= SovietAttackGroupSize then

					local units = { }

					for i = 1, #SovietWestHoldingList do
						units[i] = SovietWestHoldingList[1]
						table.remove(SovietWestHoldingList, 1)
					end
					
					Media.Debug("Sending Soviet West Holding List to attack.")
					Utils.Do(units, function(unit)
						if not unit.IsDead then
							unit.AttackMove(Utils.Random(USSRAdvanceLv1).Location, 1)
							unit.AttackMove(Utils.Random(USSRAdvanceLv2).Location, 1)
							unit.AttackMove(Utils.Random(USSRAdvanceLv3).Location, 1)
							IdleHunt(unit)
						end
					end)
				end
				return
			end
		end

		for i = 1, #SovietWestB do -- Factory belongs to Soviet, on the western front
			if SovietWestB[i] == factory then
			
				SovietWestBHoldingList[#SovietWestBHoldingList + 1] = a
				if #SovietWestBHoldingList >= SovietAttackGroupSize then

					local units = { }

					for i = 1, #SovietWestBHoldingList do
						units[i] = SovietWestBHoldingList[1]
						table.remove(SovietWestBHoldingList, 1)
					end
					
					Media.Debug("Sending Soviet West B Holding List to attack.")
					Utils.Do(units, function(unit)
						if not unit.IsDead then
							unit.AttackMove(Utils.Random(USSRAdvanceLv1).Location, 1)
							unit.AttackMove(Utils.Random(USSRAdvanceLv2).Location, 1)
							unit.AttackMove(Utils.Random(USSRAdvanceLv3).Location, 1)
							IdleHunt(unit)
						end
					end)
				end
				return
			end
		end
		
		for i = 1, #SovietEast do -- Factory belongs to Soviet, on the eastern front
			if SovietEast[i] == factory then
			
				SovietEastHoldingList[#SovietEastHoldingList + 1] = a
				if #SovietEastHoldingList >= SovietAttackGroupSize then

					local units = { }

					for i = 1, #SovietEastHoldingList do
						units[i] = SovietEastHoldingList[1]
						table.remove(SovietEastHoldingList, 1)
					end
					
					Media.Debug("Sending Soviet East Holding List to attack.")
					Utils.Do(units, function(unit)
						if not unit.IsDead then
							unit.AttackMove(Utils.Random(USSR2AdvanceLv1).Location, 1)
							unit.AttackMove(Utils.Random(USSR2AdvanceLv2).Location, 1)
							unit.AttackMove(Utils.Random(USSR2AdvanceLv3).Location, 1)
							IdleHunt(unit)
						end
					end)
				end
				return			
			end
		end

		for i = 1, #AlliedWest do -- Factory belongs to Allies, on the western front
			if AlliedWest[i] == factory then
			
				AlliedWestHoldingList[#AlliedWestHoldingList + 1] = a
				if #AlliedWestHoldingList >= AlliedAttackGroupSize then

					local units = { }

					for i = 1, #AlliedWestHoldingList do
						units[i] = AlliedWestHoldingList[1]
						table.remove(AlliedWestHoldingList, 1)
					end
					
					Media.Debug("Sending Allied West Holding List to attack.")
					Utils.Do(units, function(unit)
						if not unit.IsDead then
							unit.AttackMove(Utils.Random(USSRAdvanceLv2).Location, 1)
							unit.AttackMove(Utils.Random(USSRAdvanceLv1).Location, 1)
							IdleHunt(unit)
						end
					end)
				end
				return
			end
		end

		for i = 1, #AlliedEast do -- Factory belongs to Allies, on the eastern front
			if AlliedEast[i] == factory then

				AlliedEastHoldingList[#AlliedEastHoldingList + 1] = a
				if #AlliedEastHoldingList >= AlliedAttackGroupSize then

					local units = { }

					for i = 1, #AlliedEastHoldingList do
						units[i] = AlliedEastHoldingList[1]
						table.remove(AlliedEastHoldingList, 1)
					end
					
					Media.Debug("Sending Allied East Holding List to attack.")
					Utils.Do(units, function(unit)
						if not unit.IsDead then
							unit.AttackMove(Utils.Random(USSR2AdvanceLv1).Location, 1)
							IdleHunt(unit)
						end
					end)
				end
				return
			end
		end	

		-- IdleHunt(a)
		
	end
end

-- All houses to repair structures
StructureRepair = function(cty,n) -- cty is house, n is the fraction of health to start repairing

	Utils.Do(Map.NamedActors, function(actor)
		if actor.Owner == cty and actor.HasProperty("StartBuildingRepairs") then
			Trigger.OnDamaged(actor, function(building)
				if building.Owner == cty and building.Health < n * building.MaxHealth then
					building.StartBuildingRepairs()
				end
			end)
		end
	end)
end