Domes = { ENGLANDDOME1, ENGLANDDOME2 }
Town = { ENGLANDChurch1, ENGLANDHOSP }
ForwardCommand = { USSR1FCOM }
SovietAirfields = { USSR1AFLD1, USSR1AFLD2, USSR2AFLD1, USSR3AFLD1, USSR3AFLD2, USSR3AFLD3, USSR3AFLD4 }
SovietProduction = 
{ 
	USSR1FCOM,  
	USSR1BARR1, USSR1BARR2, USSR1BARR3, USSR1KENN, USSR1WEAP, USSR1AFLD1, USSR1AFLD2,
	USSR3BARR1, USSR3BARR2, USSR3WEAP1, USSR3WEAP2, USSR3AFLD1, USSR3AFLD2, USSR3AFLD3, USSR3AFLD4,
	USSR2BARR1, USSR2BARR2, USSR2KENN, USSR2WEAP, USSR2AFLD1
}

deadaircraft = false

Tick = function()

	if pl_england.Resources >= pl_england.ResourceCapacity * 0.75 then
		pl_england.Cash = pl_england.Cash + pl_england.Resources - pl_england.ResourceCapacity * 0.25
		pl_england.Resources = pl_england.ResourceCapacity * 0.25
	end
	
	if pl_ussr.Resources >= pl_ussr.ResourceCapacity * 0.75 then
		pl_ussr.Cash = pl_ussr.Cash + pl_ussr.Resources - pl_ussr.ResourceCapacity * 0.25
		pl_ussr.Resources = pl_ussr.ResourceCapacity * 0.25
	end	

	if pl_ussr2.Resources >= pl_ussr2.ResourceCapacity * 0.75 then
		pl_ussr2.Cash = pl_ussr2.Cash + pl_ussr2.Resources - pl_ussr2.ResourceCapacity * 0.25
		pl_ussr2.Resources = pl_ussr2.ResourceCapacity * 0.25
	end	

	if pl_ussr3.Resources >= pl_ussr3.ResourceCapacity * 0.75 then
		pl_ussr3.Cash = pl_ussr3.Cash + pl_ussr3.Resources - pl_ussr3.ResourceCapacity * 0.25
		pl_ussr3.Resources = pl_ussr3.ResourceCapacity * 0.25
	end	
end

Trigger.OnAnyKilled(Domes, function()
	player.MarkFailedObjective(DefendObjective)
end)

Trigger.OnAnyKilled(ForwardCommand, function()
	player.MarkCompletedObjective(DestroyFCOMObjective)
	Media.PlaySpeechNotification(player, "ObjectiveMet")
end)

Trigger.OnAllKilledOrCaptured(Town, function()
	player.MarkFailedObjective(DefendTownObjective)
end)

Trigger.OnAllKilledOrCaptured(SovietAirfields, function()
	deadaircraft = true
	player.MarkCompletedObjective(DestroyAirfieldObjective)
end)

Trigger.OnAllKilledOrCaptured(SovietProduction, function()
	player.MarkCompletedObjective(ConquestObjective)
	player.MarkCompletedObjective(DefendObjective)
  
	Trigger.AfterDelay(DateTime.Seconds(1), function() 
		if not player.IsObjectiveFailed(DefendTownObjective) then
			player.MarkCompletedObjective(DefendTownObjective)
		end
	end)
end)

WorldLoaded = function()
	player = Player.GetPlayer("Greece")
	pl_england = Player.GetPlayer("England")
	pl_ussr = Player.GetPlayer("USSR")
	pl_ussr2 = Player.GetPlayer("USSR2")
	pl_ussr3 = Player.GetPlayer("USSR3")
	neutral = Player.GetPlayer("Neutral")
	
	Trigger.OnObjectiveAdded(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)
	Trigger.OnObjectiveCompleted(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)
	Trigger.OnPlayerLost(player, function()
		Media.PlaySpeechNotification(player, "MissionFailed")
	end)
	Trigger.OnPlayerWon(player, function()
		Media.PlaySpeechNotification(player, "MissionAccomplished")
	end)

	ussrObj = pl_ussr.AddPrimaryObjective("Destroy the Allied radar domes.")
	ussr2Obj = pl_ussr2.AddPrimaryObjective("Destroy the Allied radar domes.")
	ussr3Obj = pl_ussr2.AddPrimaryObjective("Destroy the Allied radar domes.")
	
	DefendObjective = player.AddPrimaryObjective("Defend both Allied radar domes.")
	ConquestObjective = player.AddPrimaryObjective("Eliminate all Soviet production facilities in this area.")
	DestroyFCOMObjective = player.AddSecondaryObjective("Destroy the Soviet Forward Command Post \nto reduce enemy reinforcements")
	DestroyAirfieldObjective = player.AddSecondaryObjective("Destroy all Soviet Airfields to reduce enemy \naerial attacks")
	DefendTownObjective = player.AddSecondaryObjective("Hold the western town.")
	
	-- Trigger.AfterDelay(DateTime.Seconds(1), function() Media.PlaySpeechNotification(allies, "MissionTimerInitialised") end)

	SetupMapUnits(0.5)

	Trigger.AfterDelay(DateTime.Seconds(1), PreparePlayerReinforcements)
	Trigger.AfterDelay(DateTime.Minutes(1), PrepareUSSRReinforcements)
	Trigger.AfterDelay(DateTime.Seconds(20), PrepareENGLANDReinforcements)
	
	Trigger.AfterDelay(DateTime.Seconds(10), ActivateAI)
	
	Camera.Position = PlayerStartPoint.CenterPosition
end

ActivateAI = function()

	SetupFactories()
	StructureRepair(pl_ussr, 0.9)
	StructureRepair(pl_ussr2, 0.9)
	StructureRepair(pl_england, 0.8)
	Utils.Do(ProducedUnitTypes, ProduceUnits)
	
end

