if Map.LobbyOption("difficulty") == "Easy" then

	PlayerReinforcement1 = { "e1", "e1", "e3", "e3" }
	PlayerReinforcement2 = { "jeep", "jeep", "1tnk", "1tnk" }
	PlayerReinforcement3 = { "arty", "arty", "2tnk", "2tnk" }

	USSRReinforcement1 = { "e1", "e1", "e1", "e2", "e2", "e3", "e3", "e1", "e1", "e1", "e2", "e2", "e3", "e3"  }
	USSRReinforcement2 = { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" }
	USSRReinforcement3 = { "shok", "shok", "e4", "e4", "e4", "e4", "e4", "e4" }
	USSRReinforcement4 = { "ftrk", "ftrk", "ftrk" }
	USSRReinforcement5 = { "v2rl", "e2", "e2", "e2", "e2" }
	USSRReinforcement6 = { "3tnk", "3tnk", "3tnk" }
	USSRReinforcement7 = { "ttnk", "ttnk" }
	USSRReinforcement8 = { "4tnk" }

	USSRBarracksSpawn1 = { "e1", "e1", "e1", "e1", "e2", "e2"}
	USSRBarracksSpawn2 = { "e3", "e3", "e3", "e3" }
	USSRBarracksSpawn3 = { "e4", "e4", "e4", "e4" }
	USSRBarracksSpawn4 = { "shok", "shok" }

	USSRAIBarracksDelay = DateTime.Minutes(3) + DateTime.Seconds(30)
	USSRAIReinfDelay = DateTime.Minutes(5) + DateTime.Seconds(10)
	USSRAINoFCOMDelay = DateTime.Minutes(5)

	ENGLANDReinforcement1 = { "e1", "e1", "e1", "e1", "e1" }
	ENGLANDReinforcement2 = { "e3", "e3", "e3", "e3", "e3" }
	ENGLANDReinforcement3 = { "jeep", "jeep", "jeep", "e3", "e3" }
	ENGLANDReinforcement4 = { "arty", "arty", "e3", "e3", "e3" }
	ENGLANDReinforcement5 = { "1tnk", "1tnk", "1tnk", "2tnk", "2tnk" }

	ENGLANDTentSpawn1 = { "e1", "e1", "e1", "e1", "e1", "e1"}
	ENGLANDTentSpawn2 = { "e3", "e3", "e3", "e3" }
	ENGLANDTentSpawn3 = { "e1", "e1", "e1", "e3", "e3" }

	ENGLANDAIBarracksDelay = DateTime.Minutes(1) + DateTime.Seconds(45)
	ENGLANDAIReinfDelay = DateTime.Minutes(2) + DateTime.Seconds(50)
	HelicopterUnitTypes = { "e1", "e1", "e1", "e3", "e3", "e3" }

elseif Map.LobbyOption("difficulty") == "Mental" then

	PlayerReinforcement1 = { "e1", "e1" }
	PlayerReinforcement2 = { "jeep" }
	PlayerReinforcement3 = { "1tnk" }

	USSRReinforcement1 = { "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e3", "e3", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e3"  }
	USSRReinforcement2 = { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" }
	USSRReinforcement3 = { "shok", "shok", "shok", "shok", "shok", "shok", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" }
	USSRReinforcement4 = { "ftrk", "ftrk", "ftrk", "ftrk", "ftrk", "ftrk", "ftrk" }
	USSRReinforcement5 = { "v2rl", "v2rl", "v2rl", "v2rl", "e2", "e2" , "e2", "e2", "e2", "e2", "e2", "e2" }
	USSRReinforcement6 = { "3tnk", "3tnk", "3tnk", "3tnk", "3tnk", "3tnk", "3tnk", "3tnk" }
	USSRReinforcement7 = { "ttnk", "ttnk", "ttnk", "shok", "shok", "shok", "shok" , "ttnk", "ttnk", "shok", "shok" }
	USSRReinforcement8 = { "4tnk", "4tnk", "4tnk", "4tnk" }

	USSRBarracksSpawn1 = { "e1", "e1", "e1", "e1", "e2", "e2", "e4", "e4" }
	USSRBarracksSpawn2 = { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" }
	USSRBarracksSpawn3 = { "e4", "e4", "e4", "e4", "e4", "e4" }
	USSRBarracksSpawn4 = { "shok", "shok", "shok", "shok" }

	USSRAIBarracksDelay = DateTime.Minutes(1) + DateTime.Seconds(55)
	USSRAIReinfDelay = DateTime.Minutes(4) + DateTime.Seconds(10)
	USSRAINoFCOMDelay = DateTime.Minutes(2)

	ENGLANDReinforcement1 = { "e1", "e1", "e1", "e1", "e1" }
	ENGLANDReinforcement2 = { "e1", "e1", "e3", "e3", "e3" }
	ENGLANDReinforcement3 = { "jeep", "jeep", "e1", "e3", "e3" }
	ENGLANDReinforcement4 = { "arty", "e1", "e1", "e3", "e3" }
	ENGLANDReinforcement5 = { "1tnk", "1tnk", "2tnk" }

	ENGLANDTentSpawn1 = { "e1", "e1", "e1", "e1"}
	ENGLANDTentSpawn2 = { "e3", "e3", "e3" }
	ENGLANDTentSpawn3 = { "e1", "e1", "e3", "e3" }

	ENGLANDAIBarracksDelay = DateTime.Minutes(2) + DateTime.Seconds(45)
	ENGLANDAIReinfDelay = DateTime.Minutes(4) + DateTime.Seconds(10)
	HelicopterUnitTypes = { "e1", "e1", "e1", "e1", "e1", "e1" }

else

	PlayerReinforcement1 = { "e1", "e1", "e3" }
	PlayerReinforcement2 = { "jeep", "jeep" }
	PlayerReinforcement3 = { "1tnk", "1tnk", "2tnk" }

	USSRReinforcement1 = { "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e3", "e3", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e3"  }
	USSRReinforcement2 = { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" }
	USSRReinforcement3 = { "shok", "shok", "shok", "shok", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" }
	USSRReinforcement4 = { "ftrk", "ftrk", "ftrk", "ftrk", "ftrk", "ftrk" }
	USSRReinforcement5 = { "v2rl", "v2rl", "v2rl", "e2", "e2", "e2", "e2", "e2", "e2" }
	USSRReinforcement6 = { "3tnk", "3tnk", "3tnk", "3tnk", "3tnk", "3tnk" }
	USSRReinforcement7 = { "ttnk", "ttnk", "ttnk", "shok", "shok", "shok", "shok" }
	USSRReinforcement8 = { "4tnk", "4tnk", "3tnk", "3tnk" }

	USSRBarracksSpawn1 = { "e1", "e1", "e1", "e1", "e2", "e2"}
	USSRBarracksSpawn2 = { "e3", "e3", "e3", "e3" }
	USSRBarracksSpawn3 = { "e4", "e4", "e4", "e4" }
	USSRBarracksSpawn4 = { "shok", "shok" }

	USSRAIBarracksDelay = DateTime.Minutes(2) + DateTime.Seconds(20)
	USSRAIReinfDelay = DateTime.Minutes(4) + DateTime.Seconds(40)
	USSRAINoFCOMDelay = DateTime.Minutes(3) + DateTime.Seconds(30)

	ENGLANDReinforcement1 = { "e1", "e1", "e1", "e1", "e1" }
	ENGLANDReinforcement2 = { "e3", "e3", "e3", "e3", "e3" }
	ENGLANDReinforcement3 = { "jeep", "jeep", "jeep", "e3", "e3" }
	ENGLANDReinforcement4 = { "arty", "arty", "e3", "e3", "e3" }
	ENGLANDReinforcement5 = { "1tnk", "1tnk", "1tnk", "2tnk", "2tnk" }

	ENGLANDTentSpawn1 = { "e1", "e1", "e1", "e1", "e1", "e1"}
	ENGLANDTentSpawn2 = { "e3", "e3", "e3", "e3" }
	ENGLANDTentSpawn3 = { "e1", "e1", "e1", "e3", "e3" }

	ENGLANDAIBarracksDelay = DateTime.Minutes(2) + DateTime.Seconds(5)
	ENGLANDAIReinfDelay = DateTime.Minutes(3) + DateTime.Seconds(10)
	HelicopterUnitTypes = { "e1", "e1", "e1", "e1", "e3", "e3" }

end

PlayerReinforcementSet = { PlayerReinforcement1, PlayerReinforcement2, PlayerReinforcement3 }

PlayerReinforcementAPath = { ReinforcementsEntryPoint1.Location, ReinforcementsRallyPoint1.Location }
PlayerReinforcementBPath = { ReinforcementsEntryPoint2.Location, ReinforcementsRallyPoint2.Location }

USSRReinforcementSet = { USSRReinforcement1, USSRReinforcement2, USSRReinforcement3, USSRReinforcement4, USSRReinforcement5, USSRReinforcement6, USSRReinforcement7, USSRReinforcement8 }
USSRBarracksSpawnSet = { USSRBarracksSpawn1, USSRBarracksSpawn2, USSRBarracksSpawn3, USSRBarracksSpawn4 }

USSRAdvanceLv1 = { USSRAdv1A, USSRAdv1B, USSRAdv1C }
USSRAdvanceLv2 = { USSRAdv2A, USSRAdv2B, USSRAdv2C }
USSRAdvanceLv3 = { Dome1Loc }

USSR2AdvanceLv1 = { USSR2Adv1A, USSR2Adv1B }
USSR2AdvanceLv2 = { USSR2Adv2A, USSR2Adv2B }
USSR2AdvanceLv3 = { Dome2Loc }

USSRWestAdvanceA = {USSRAdv1A.Location, USSRAdv2A.Location, Dome1Loc.Location}
USSRWestAdvanceB = {USSRAdv1B.Location, USSRAdv2B.Location, Dome1Loc.Location}
USSRWestAdvanceC = {USSRAdv1C.Location, USSRAdv2C.Location, Dome1Loc.Location}
USSREastAdvanceA = {USSR2Adv1A.Location, USSR2Adv2A.Location, Dome2Loc.Location}
USSREastAdvanceB = {USSR2Adv1B.Location, USSR2Adv2B.Location, Dome2Loc.Location}

USSRWestAdvanceRand = 		
{ 
	Utils.Random(USSRAdvanceLv1).Location, 
	Utils.Random(USSRAdvanceLv2).Location, 
	Utils.Random(USSRAdvanceLv3).Location 
}

USSREastAdvanceRand = 
{ 
	Utils.Random(USSR2AdvanceLv1).Location, 
	Utils.Random(USSR2AdvanceLv2).Location, 
	Utils.Random(USSR2AdvanceLv3).Location 
}

USSRReinforcementPath =
{ 
	{owner = 1, spawn = { USSREntryPoint1.Location }, path = USSRWestAdvanceA}, 
	{owner = 1, spawn = { USSREntryPoint2.Location }, path = USSRWestAdvanceB}, 
	{owner = 3, spawn = { USSREntryPoint3.Location }, path = USSRWestAdvanceC}, 
	{owner = 2, spawn = { USSR2EntryPoint1.Location }, path = USSREastAdvanceA}, 
	{owner = 2, spawn = { USSR2EntryPoint2.Location }, path = USSREastAdvanceB} 
}

USSRBarrackSpawnPath = 
{ 
	{source = USSR1BARR1, owner = 1, spawn = { USSR1BARR1.Location + CVec.New(0, 1)}, path = USSRWestAdvanceRand}, 
	{source = USSR1BARR2, owner = 1, spawn = { USSR1BARR2.Location + CVec.New(0, 1)}, path = USSRWestAdvanceRand}, 
	{source = USSR1BARR3, owner = 1, spawn = { USSR1BARR3.Location + CVec.New(0, 1)}, path = USSRWestAdvanceRand}, 
	{source = USSR2BARR1, owner = 2, spawn = { USSR2BARR1.Location + CVec.New(0, 1)}, path = USSREastAdvanceRand}, 
	{source = USSR2BARR2, owner = 2, spawn = { USSR2BARR2.Location + CVec.New(0, 1)}, path = USSREastAdvanceRand}, 
	{source = USSR3BARR1, owner = 3, spawn = { USSR3BARR1.Location + CVec.New(0, 1)}, path = USSRWestAdvanceRand}, 
	{source = USSR3BARR2, owner = 3, spawn = { USSR3BARR2.Location + CVec.New(0, 1)}, path = USSRWestAdvanceRand}
}

USSRAircraftAttackPos = { USSRAdv2A, USSRAdv2B, USSRAdv2C, USSR2Adv2A, USSR2Adv2B, Dome1Loc, Dome2Loc }

SovParadropLocations = { SovParadropLoc1, SovParadropLoc2, SovParadropLoc3, SovParadropLoc4, SovParadropLoc5, SovParadropLoc6, SovParadropLoc7, SovParadropLoc8, SovParadropLoc9, SovParadropLoc10, SovParadropLoc11, SovParadropLoc12 }
SovParadropUnits = 
{ 
	{ "e1", "e1", "e1", "e1", "e1", "e1"},
	{ "e2", "e2", "e2", "e2", "e2" },
	{ "e3", "e3", "e1", "e1", "e1" },
	{ "e4", "e4", "e4", "e2", "e2" },
	{ "shok", "shok", "e1", "e1", "e1"}
}

ENGLANDReinforcementSet = { ENGLANDReinforcement1, ENGLANDReinforcement2, ENGLANDReinforcement3, ENGLANDReinforcement4, ENGLANDReinforcement5 }
ENGLANDTentSpawnSet = { ENGLANDTentSpawn1, ENGLANDTentSpawn2, ENGLANDTentSpawn3 }

ENGLANDWestAdvanceA = {USSRAdv2A.Location, USSRAdv1A.Location}
ENGLANDWestAdvanceB = {USSRAdv2B.Location, USSRAdv1B.Location}
ENGLANDWestAdvanceC = {USSRAdv2C.Location, USSRAdv1C.Location}
ENGLANDEastAdvanceA = {USSR2Adv2A.Location, USSR2Adv1A.Location}
ENGLANDEastAdvanceB = {USSR2Adv2B.Location, USSR2Adv1B.Location}

ENGLANDWestAdvanceRand = 		
{ 
	Utils.Random(USSRAdvanceLv2).Location, 
	Utils.Random(USSRAdvanceLv1).Location
}

ENGLANDEastAdvanceRand = 
{ 
	Utils.Random(USSR2AdvanceLv2).Location, 
	Utils.Random(USSR2AdvanceLv1).Location
}

ENGLANDReinforcementPath =
{ 
	{owner = 1, spawn = { ENGLANDEntryPoint1.Location }, path = ENGLANDWestAdvanceRand}
}

ENGLANDBarrackSpawnPath = 
{ 
	{source = ENGLANDTENT1, owner = 1, spawn = { ENGLANDTENT1.Location + CVec.New(0, 1)}, path = ENGLANDWestAdvanceRand}, 
	{source = ENGLANDTENT2, owner = 1, spawn = { ENGLANDTENT2.Location + CVec.New(0, 1)}, path = ENGLANDWestAdvanceRand}, 
	{source = ENGLANDTENT3, owner = 1, spawn = { ENGLANDTENT3.Location + CVec.New(0, 1)}, path = ENGLANDEastAdvanceRand}, 
	{source = ENGLANDTENT4, owner = 1, spawn = { ENGLANDTENT4.Location + CVec.New(0, 1)}, path = ENGLANDEastAdvanceRand} 
}


 -- Player Reinforcements

PreparePlayerReinforcements = function()
	Trigger.AfterDelay(DateTime.Seconds(20), function() SendPlayerReinforcements(1) end)
	Trigger.AfterDelay(DateTime.Seconds(45), function() SendPlayerReinforcements(2) end)
	Trigger.AfterDelay(DateTime.Minutes(4), function() SendPlayerReinforcements(3) end)
end

SendPlayerReinforcements = function(i)
	Media.Debug("Creating Player Reinforcements #" .. i)
	Media.PlaySpeechNotification(player, "ReinforcementsArrived")
	Reinforcements.Reinforce(player, PlayerReinforcementSet[i], PlayerReinforcementAPath, DateTime.Seconds(1))
	Reinforcements.Reinforce(player, PlayerReinforcementSet[i], PlayerReinforcementBPath, DateTime.Seconds(1))
end

 -- USSR Reinforcements

PrepareUSSRReinforcements = function()

	Media.PlaySpeechNotification(player, "EnemyUnitsApproaching")
	Trigger.AfterDelay(DateTime.Seconds(1), function() SendUSSRReinforcements(1) end) 
	Trigger.AfterDelay(DateTime.Seconds(2), function() SendUSSRReinforcements(2) end) 
	Trigger.AfterDelay(DateTime.Seconds(3), function() SendUSSRReinforcements(3) end) 
	Trigger.AfterDelay(DateTime.Seconds(5), function() SendUSSRReinforcements(4) end) 
	Trigger.AfterDelay(DateTime.Seconds(7), function() SendUSSRReinforcements(5) end) 

	Trigger.AfterDelay(DateTime.Seconds(10), function() SendUSSRBarracksSpawn(1) end)
	Trigger.AfterDelay(DateTime.Seconds(20), function() SendUSSRBarracksSpawn(2) end) 
	Trigger.AfterDelay(DateTime.Seconds(30), function() SendUSSRBarracksSpawn(3) end) 
	Trigger.AfterDelay(DateTime.Seconds(15), function() SendUSSRBarracksSpawn(4) end)
	Trigger.AfterDelay(DateTime.Seconds(25), function() SendUSSRBarracksSpawn(5) end) 	
	Trigger.AfterDelay(DateTime.Seconds(45), function() SendUSSRBarracksSpawn(6) end)
	Trigger.AfterDelay(DateTime.Seconds(55), function() SendUSSRBarracksSpawn(7) end) 
	
	Trigger.AfterDelay(DateTime.Seconds(25), ParadropSovietUnits)
end

SendUSSRReinforcements = function(i)

	Media.Debug("Creating Soviet Reinforcements #" .. i)
	local Invaders = Utils.Random(USSRReinforcementSet)
	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(60))
	local sovHouses = { pl_ussr, pl_ussr2, pl_ussr3 }
	
	local units = Reinforcements.Reinforce( sovHouses[USSRReinforcementPath[i].owner] , Invaders, USSRReinforcementPath[i].spawn , DateTime.Seconds(1))
	
	Utils.Do(units, function(unit)
		unit.Patrol(USSRReinforcementPath[i].path, false, 60)
		IdleHunt(unit) 
	end)

	if not USSR1FCOM.IsDead then 
		Trigger.AfterDelay(USSRAIReinfDelay + delay, function() SendUSSRReinforcements(i) end) 
	else
		Trigger.AfterDelay(USSRAIReinfDelay + USSRAINoFCOMDelay + delay, function() SendUSSRReinforcements(i) end) 
	end

end

SendUSSRBarracksSpawn = function(i)
	
	if USSRBarrackSpawnPath[i].source.IsDead then
		Media.Debug("Creating Soviet Barracks Spawn #" .. i .. " but barracks is dead.")
		return
	end

	Media.Debug("Creating Soviet Barracks Spawn #" .. i)	
	local Invaders = Utils.Random(USSRBarracksSpawnSet)
	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(30))
	local sovHouses = { pl_ussr, pl_ussr2, pl_ussr3 }
	
	local units = Reinforcements.Reinforce( sovHouses[USSRBarrackSpawnPath[i].owner], Invaders, USSRBarrackSpawnPath[i].spawn, DateTime.Seconds(0))
	
	Utils.Do(units, function(unit)
		unit.Patrol(USSRBarrackSpawnPath[i].path, false, 28)
		IdleHunt(unit) 
	end)

	if not USSR1FCOM.IsDead then 
		Trigger.AfterDelay(USSRAIBarracksDelay + delay, function() SendUSSRBarracksSpawn(i) end) 
	else
		Trigger.AfterDelay(USSRAIBarracksDelay + USSRAINoFCOMDelay + delay, function() SendUSSRBarracksSpawn(i) end) 
	end

end

ParadropSovietUnits = function()

	if deadaircraft then
		Media.Debug("Soviet Airfields destroyed. Cancelling paradrops.")
		return 		
	end
	
	Media.Debug("Creating Soviet Paradrop team.")
	local lz = Utils.Random(SovParadropLocations).Location
    local start = Map.CenterOfCell(Map.RandomEdgeCell()) + WVec.New(0, 0, Actor.CruiseAltitude("badr"))
    local transport = Actor.Create("badr", true, { CenterPosition = start, Owner = pl_ussr, Facing = (Map.CenterOfCell(lz) - start).Facing })
	local units = Utils.Random(SovParadropUnits)
	
    Utils.Do(units, function(type)
        local a = Actor.Create(type, false, { Owner = pl_ussr })
        IdleHunt(a)
		transport.LoadPassenger(a)
	end)

    transport.Paradrop(lz)
	
	-- 2nd time
	Trigger.AfterDelay(DateTime.Seconds(3), function()
		local transport2 = Actor.Create("badr", true, { CenterPosition = start, Owner = pl_ussr, Facing = (Map.CenterOfCell(lz) - start).Facing })
		local units2 = Utils.Random(SovParadropUnits)
		
		Utils.Do(units2, function(type)
			local a = Actor.Create(type, false, { Owner = pl_ussr })
			IdleHunt(a)
			transport2.LoadPassenger(a)
		end)
	
		transport2.Paradrop(lz)	
	end)
	
	Trigger.AfterDelay(DateTime.Minutes(2), ParadropSovietUnits)
	
end

PrepareENGLANDReinforcements = function()

	Trigger.AfterDelay(DateTime.Minutes(1), function() SendENGLANDReinforcements(1) end) 
	Trigger.AfterDelay(DateTime.Seconds(28), function() SendENGLANDTentSpawn(1) end)
	Trigger.AfterDelay(DateTime.Seconds(30), function() SendENGLANDTentSpawn(2) end) 
	Trigger.AfterDelay(DateTime.Seconds(46), function() SendENGLANDTentSpawn(3) end) 	
	Trigger.AfterDelay(DateTime.Seconds(56), function() SendENGLANDTentSpawn(4) end) 	
	
	Trigger.AfterDelay(DateTime.Minutes(2), function() SendENGLANDChinookReinforcements(HeliEntry1, HeliTrans1, 0) end) 
	Trigger.AfterDelay(DateTime.Minutes(2), function() SendENGLANDChinookReinforcements(HeliEntry2, HeliTrans2, 1) end) 
	Trigger.AfterDelay(DateTime.Minutes(2), function() SendENGLANDChinookReinforcements(HeliEntry3, HeliTrans3, 1) end) 

end

SendENGLANDReinforcements = function(i)

	Media.Debug("Creating Allied Reinforcements #" .. i)
	local Defenders = Utils.Random(ENGLANDReinforcementSet)
	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(60))
	local allHouses = { pl_england }
	
	local units = Reinforcements.Reinforce( allHouses[ENGLANDReinforcementPath[i].owner] , Defenders, ENGLANDReinforcementPath[i].spawn , DateTime.Seconds(1))
	
	Utils.Do(units, function(unit)
		unit.Patrol(ENGLANDReinforcementPath[i].path, false, 60)
		IdleHunt(unit) 
	end)

	Trigger.AfterDelay(ENGLANDAIReinfDelay + delay, function() SendENGLANDReinforcements(i) end) 

end

SendENGLANDTentSpawn = function(i)
	
	if ENGLANDBarrackSpawnPath[i].source.IsDead then
		Media.Debug("Creating Allied Barracks Spawn #" .. i .. " but barracks is dead.")
		return
	end

	Media.Debug("Creating Allied Barracks Spawn #" .. i)		
	local Defenders = Utils.Random(ENGLANDTentSpawnSet)
	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(30))
	local allHouses = { pl_england }

	local units = Reinforcements.Reinforce( allHouses[ENGLANDBarrackSpawnPath[i].owner] , Defenders, ENGLANDBarrackSpawnPath[i].spawn , DateTime.Seconds(1))
	
	Utils.Do(units, function(unit)
		unit.Patrol(ENGLANDBarrackSpawnPath[i].path, false, 28)
		IdleHunt(unit) 
	end)
	
 	Trigger.AfterDelay(ENGLANDAIBarracksDelay + delay, function() SendENGLANDTentSpawn(i) end) 

end

SendENGLANDTent2Spawn = function()
	
	if ENGLANDTENT2.IsDead then
		return
	end
	
	local Defenders = Utils.Random(ENGLANDTentSpawnSet)
	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(30))

	local units = Reinforcements.Reinforce(pl_england, Defenders, ENGLANDTent2Path, DateTime.Seconds(0))
	
	Utils.Do(units, function(unit)
		unit.AttackMove(Utils.Random(USSRAdvanceLv2).Location, 1)
		unit.AttackMove(Utils.Random(USSRAdvanceLv1).Location, 1)
		IdleHunt(unit) 
	end)
 
	Trigger.AfterDelay(ENGLANDAIBarracksDelay + delay, SendENGLANDTent2Spawn) 


end

SendENGLANDTent3Spawn = function()
	
	if ENGLANDTENT3.IsDead then
		return
	end
	
	local Defenders = Utils.Random(ENGLANDTentSpawnSet)
	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(30))

	local units = Reinforcements.Reinforce(pl_england, Defenders, ENGLANDTent3Path, DateTime.Seconds(0))
	
	Utils.Do(units, function(unit)
		unit.AttackMove(Utils.Random(USSR2AdvanceLv2).Location, 1)
		unit.AttackMove(Utils.Random(USSR2AdvanceLv1).Location, 1)
		IdleHunt(unit) 
	end)
 
	Trigger.AfterDelay(ENGLANDAIBarracksDelay + delay, SendENGLANDTent3Spawn) 


end

SendENGLANDTent4Spawn = function()
	
	if ENGLANDTENT4.IsDead then
		return
	end
	
	local Defenders = Utils.Random(ENGLANDTentSpawnSet)
	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(30))

	local units = Reinforcements.Reinforce(pl_england, Defenders, ENGLANDTent4Path, DateTime.Seconds(0))
	
	Utils.Do(units, function(unit)
		unit.AttackMove(Utils.Random(USSR2AdvanceLv2).Location, 1)
		unit.AttackMove(Utils.Random(USSR2AdvanceLv1).Location, 1)
		IdleHunt(unit) 
	end)
 
	Trigger.AfterDelay(ENGLANDAIBarracksDelay + delay, SendENGLANDTent4Spawn) 


end

SendENGLANDChinookReinforcements = function(entry, hpad, IsWest)

	Media.Debug("Creating Allied Chinook Drop")
	local units = Reinforcements.ReinforceWithTransport(pl_england, "tran", HelicopterUnitTypes, { entry.Location, hpad.Location }, { entry.Location })[2]

	Utils.Do(units, function(unit)
		if IsWest then
			unit.AttackMove(Utils.Random(USSRAdvanceLv2).Location, 1)
			unit.AttackMove(Utils.Random(USSRAdvanceLv1).Location, 1)		
		else 
			unit.AttackMove(Utils.Random(USSR2AdvanceLv2).Location, 1)
			unit.AttackMove(Utils.Random(USSR2AdvanceLv1).Location, 1)	
		end
		IdleHunt(unit)
	end)

	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(60))
	Trigger.AfterDelay(DateTime.Minutes(4) + delay, function() SendENGLANDChinookReinforcements(entry, hpad, IsWest) end)
end
