if Map.LobbyOption("difficulty") == "Easy" then

	USSRReinforcement1 = { "3tnk", "3tnk", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2" }
	USSRReinforcement2 = { "3tnk", "3tnk", "e4", "e4", "e4", "e4", "e3", "e3" }
	USSRReinforcement3 = { "3tnk", "3tnk", "shok", "shok", "shok", "shok" }
	USSRReinforcement4 = { "4tnk", "3tnk", "3tnk", "3tnk" }

	USSRPatrolGroup = 
	{ 
		{ owner = 1, units = { "e1", "e1", "e2", "e2" } },
		{ owner = 1, units = { "ftrk", "ftrk" } },
		{ owner = 1, units = { "ftrk" } },
		{ owner = 3, units = { "3tnk", "3tnk" } }
	}

	USSRAIReinfDelay = DateTime.Minutes(4) + DateTime.Seconds(25)

	FRANCEAIReinfDelay = DateTime.Minutes(4) + DateTime.Seconds(50)

elseif Map.LobbyOption("difficulty") == "Mental" then

	USSRReinforcement1 = { "4tnk", "4tnk", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2" }
	USSRReinforcement2 = { "4tnk", "4tnk", "e4", "e4", "e4", "e4", "e3", "e3" }
	USSRReinforcement3 = { "4tnk", "4tnk", "shok", "shok", "shok", "shok" }
	USSRReinforcement4 = { "4tnk", "4tnk", "4tnk", "4tnk" }

	USSRPatrolGroup = 
	{ 
		{ owner = 1, units = { "e1", "e1", "e2", "shok", "dog" } },
		{ owner = 1, units = { "ftrk", "ftrk", "3tnk" } },
		{ owner = 1, units = { "ftrk", "e2", "e2", "dog", "dog" } },
		{ owner = 3, units = { "4tnk", "4tnk" } }
	}

	USSRAIReinfDelay = DateTime.Minutes(3) + DateTime.Seconds(5)

	FRANCEAIReinfDelay = DateTime.Minutes(6) + DateTime.Seconds(10)

else

	USSRReinforcement1 = { "4tnk", "3tnk", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2" }
	USSRReinforcement2 = { "4tnk", "3tnk", "e4", "e4", "e4", "e4", "e3", "e3" }
	USSRReinforcement3 = { "4tnk", "3tnk", "shok", "shok", "shok", "shok" }
	USSRReinforcement4 = { "4tnk", "4tnk", "3tnk", "3tnk" }

	USSRPatrolGroup = 
	{ 
		{ owner = 1, units = { "e1", "e1", "e2", "e2", "dog" } },
		{ owner = 1, units = { "ftrk", "ftrk" } },
		{ owner = 1, units = { "ftrk", "e2", "e2" } },
		{ owner = 3, units = { "4tnk", "3tnk" } }
	}
	
	USSRAIReinfDelay = DateTime.Minutes(3) + DateTime.Seconds(50)

	FRANCEAIReinfDelay = DateTime.Minutes(5) + DateTime.Seconds(10)

end

PlayerReinforcement1 = { "e7", "stnk" }
PlayerReinforcementSet = { PlayerReinforcement1 }

USSRAdvanceLv1 = { USSRAdv1A.Location, USSRAdv1B.Location }
USSRAdvanceLv2 = { USSRAdv2A.Location, USSRAdv2B.Location }
USSRAdvanceLv3 = { USSRAdv3A.Location, USSRAdv3B.Location, USSRAdv3C.Location }
USSRAdvanceLv4 = { ATech.Location }

USSRAdvanceA = {USSRAdv1A.Location, USSRAdv2A.Location, USSRAdv3A.Location, ATech.Location}
USSRAdvanceB = {USSRAdv1B.Location, USSRAdv2B.Location, USSRAdv3B.Location, ATech.Location}
USSRAdvanceC = {USSRAdv1B.Location, USSRAdv2B.Location, USSRAdv3C.Location, ATech.Location}

USSRReinforcementSet = { USSRReinforcement1, USSRReinforcement2, USSRReinforcement3, USSRReinforcement4 }
USSRReinforcementPath =
{
	{ spawn = { USSRReinforcementSpawn1.Location }, path = USSRAdvanceA },
	{ spawn = { USSRReinforcementSpawn2.Location }, path = USSRAdvanceA }
}

USSRAdvanceRand = 		
{ 
	Utils.Random(USSRAdvanceLv1), 
	Utils.Random(USSRAdvanceLv2), 
	Utils.Random(USSRAdvanceLv3),
	Utils.Random(USSRAdvanceLv4)

}

USSRPatrolPaths = 
{ 
	{ spawn = { USSRPatrol1A.Location }, path = { USSRPatrol1A.Location, USSRPatrol1B.Location } },
	{ spawn = { USSRPatrol2A.Location }, path = { USSRPatrol2A.Location, USSRPatrol2B.Location } },
	{ spawn = { USSRPatrol3A.Location }, path = { USSRPatrol3A.Location, USSRPatrol3B.Location } },
	{ spawn = { USSRPatrol4A.Location }, path = { USSRPatrol4A.Location, USSRPatrol4B.Location } },
}

USSRAircraftAttackTransport = { PlayerReinfPoint }
USSRAircraftAttackPos = { USSRAdv2A, USSRAdv2B, USSRAdv3C, ATech }

SovParadropLocations = { SovParadrop1, SovParadrop2, SovParadrop3, SovParadrop4 }
SovParadropUnits = 
{ 
	{ "e1", "e1", "e1", "e1", "e1", "e1" },
	{ "e2", "e2", "e2", "e1", "e1", "e1" },
	{ "e2", "e2", "e2", "e2", "e2" },
	{ "e4", "e4", "e1", "e1", "e1" }
}

SovietReinforcement1 = { "e4", "e4", "e2", "e2", "e2" }
SovietReinforcement2 = { "3tnk", "ftrk", "ftrk", "e2", "e2" }
SovietReinforcement3 = { "4tnk", "ttnk", "3tnk", "e2", "e2" }
SovietReinforcement4 = { "shok", "shok", "shok", "shok", "dog" }
SovietReinforcement5 = { "shok", "shok", "shok", "shok", "dog" }
SovietReinforcement6 = { "e4", "e4", "e4", "dog", "mcv" }
SovietReinforcement7 = { "e1", "e1", "e1", "ftrk", "ftrk" }
SovietReinforcement8 = { "3tnk", "shok", "e2", "e2", "dog" }
SovietReinforcement9 = { "v2rl", "v2rl", "e1", "e1", "dog" }
SovietReinforcement10 = { "dtrk", "4tnk", "e1", "e1", "dog" }



SovietReinforcementSet = { SovietReinforcement1, SovietReinforcement2, SovietReinforcement3, SovietReinforcement4, SovietReinforcement5, SovietReinforcement6, SovietReinforcement7, SovietReinforcement8, SovietReinforcement9, SovietReinforcement10 }
SovietReinforcementPath = 
{ 
	{USSRAdv2B.Location, USSRAdv3B.Location, ATech.Location}, 
	{USSRAdv2B.Location, USSRAdv3B.Location, ATech.Location}, 
	{USSRAdv2B.Location, USSRAdv3C.Location, ATech.Location}, 
	{USSRAdv1A.Location, USSRAdv2A.Location, USSRAdv3A.Location, ATech.Location}, 
	{USSRAdv2B.Location, USSRAdv3B.Location, ATech.Location}, 
	{USSRBase.Location, USSRAdv2A.Location, USSRAdv3B.Location, ATech.Location},
	{USSRAdv2B.Location, USSRAdv3B.Location, ATech.Location}, 
	{USSRAdv2B.Location, USSRAdv3B.Location, ATech.Location}, 
	{USSRAdv2B.Location, USSRAdv3C.Location, ATech.Location}, 
	{USSRAdv1A.Location, USSRAdv2A.Location, USSRAdv3A.Location, ATech.Location}, 
}

SovietReinfPointSet = 
{ 
	SovietReinfPoint1.Location, 
	SovietReinfPoint2.Location, 
	SovietReinfPoint3.Location, 
	SovietReinfPoint1.Location, 
	SovietReinfPoint4.Location, 
	SovietReinfPoint3.Location,
	SovietReinfPoint1.Location, 
	SovietReinfPoint2.Location, 
	SovietReinfPoint3.Location, 
	SovietReinfPoint4.Location 	
}


FranceReinforcement1 = { "jeep", "jeep", "1tnk", "e3", "e3" }
FranceReinforcement2 = { "2tnk", "2tnk", "e1", "e1", "arty" }
FranceReinforcement3 = { "e3", "e3", "e3", "e3", "e3" }
FranceReinforcement4 = { "1tnk", "1tnk", "1tnk", "2tnk", "2tnk" }
FranceReinforcement5 = { "e3", "e3", "e3", "e3", "jeep" }
FranceReinforcement6 = { "mcv" }

FranceReinforcementSet = { FranceReinforcement1, FranceReinforcement2, FranceReinforcement3, FranceReinforcement4, FranceReinforcement5, FranceReinforcement6 }
FranceReinforcementPath = 
{ 
	{USSRAdv1B.Location}, 
	{USSRAdv3B.Location}, 
	{USSRAdv3C.Location}, 
	{USSRAdv1B.Location}, 
	{USSRAdv2B.Location}, 
	{FranceBase.Location, USSRAdv2A.Location} 
}

FranceReinfPointSet = { FranceReinfPoint1.Location, FranceReinfPoint2.Location, FranceReinfPoint3.Location, FranceReinfPoint1.Location, FranceReinfPoint2.Location, FranceReinfPoint3.Location }


FRANCEAdvanceLv1 = { USSRAdv2A.Location, USSRAdv3B.Location }
FRANCEAdvanceLv2 = { USSRAdv1A.Location, USSRAdv1B.Location }
FRANCEAdvanceLv3 = { USSRBase.Location }

FRANCEAdvanceA = {USSRAdv2B.Location, USSRAdv1B.Location, USSRBase.Location}
FRANCEAdvanceB = {USSRAdv2A.Location, USSRAdv1A.Location, USSRBase.Location}

FRANCEAdvanceRand = 		
{ 
	Utils.Random(FRANCEAdvanceLv1), 
	Utils.Random(FRANCEAdvanceLv2), 
	Utils.Random(FRANCEAdvanceLv3)
}

GermanReinforcementSet = 
{ 
	{"1tnk.german", "1tnk.german", "1tnk.german", "1tnk.german", "1tnk.german"}, 
	{"1tnk.german", "1tnk.german", "1tnk.german", "1tnk.german", "1tnk.german"},
	{"e3", "e3", "e3", "e3", "e3"}, 
	{"e3", "e3", "e3", "e3", "e3"},
	{"2tnk.german", "2tnk.german", "2tnk.german", "e3", "e3"}, 
	{"2tnk.german", "2tnk.german", "2tnk.german", "e3", "e3"}, 
	{"2tnk.german", "arty", "arty", "arty", "arty"}, 
	{"2tnk.german", "arty", "arty", "arty", "arty"}
}

GermanReinforcementPath =
{
	{ spawn = { GermanEntryPoint1.Location }, path = {USSRAdv1A.Location, USSRBase.Location} },
	{ spawn = { GermanEntryPoint2.Location }, path = {USSRAdv1B.Location, USSRBase.Location} },
	{ spawn = { GermanEntryPoint1.Location + CVec.New(2,0) }, path = {USSRAdv1A.Location, USSRBase.Location} },
	{ spawn = { GermanEntryPoint2.Location + CVec.New(2,0) }, path = {USSRAdv1B.Location, USSRBase.Location} },
	{ spawn = { GermanEntryPoint1.Location + CVec.New(-2,0) }, path = {USSRAdv1A.Location, USSRBase.Location} },
	{ spawn = { GermanEntryPoint2.Location + CVec.New(-2,0) }, path = {USSRAdv1B.Location, USSRBase.Location} },
	{ spawn = { GermanEntryPoint1.Location }, path = {USSRAdv1A.Location, USSRBase.Location} },
	{ spawn = { GermanEntryPoint2.Location }, path = {USSRAdv1B.Location, USSRBase.Location} }
}


 -- Player Reinforcements

PreparePlayerReinforcements = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function() SendPlayerReinforcements(1) end)
end

SendPlayerReinforcements = function(i)
	Media.Debug("Creating Player Reinforcements #" .. i)
	Media.PlaySpeechNotification(player, "ReinforcementsArrived")
	
	local units = Reinforcements.ReinforceWithTransport(player, "lst", PlayerReinforcementSet[i], { PlayerEntryPoint.Location, PlayerReinfPoint.Location }, { PlayerEntryPoint.Location })[2]
	
	Utils.Do(units, function(unit)
		Trigger.OnAddedToWorld(unit, function()
			Trigger.OnDamaged(unit, PlayerDamaged)
			if unit.Type == "e7" then
				Tanyas[#Tanyas + 1] = unit
				Trigger.OnAnyKilled(Tanyas, function()
					player.MarkFailedObjective(TanyaSurviveObjective)
				end)

				Trigger.OnIdle(unit, function(a)
					TanyaReady = true
					TanyaEnterPhase()
				end)
				
			elseif unit.Type == "stnk" then
				STNKs[#STNKs + 1] = unit
				Trigger.OnAnyKilled(STNKs, function()
					player.MarkFailedObjective(PhaseSurviveObjective)
				end)
				
				Trigger.OnIdle(unit, function(a)
					STNKReady = true
					TanyaEnterPhase()
				end)
			end
		end)
	end)	
end

TanyaReady = false
STNKReady = false
TanyaIn = true

TanyaEnterPhase = function()
	if TanyaReady and STNKReady and TanyaIn then
		TanyaIn = false
		Media.Debug("Tanya move into Phase.")
		if not Tanyas[1].IsDead and not STNKs[1].IsDead then
			Trigger.AfterDelay(5, function()
				STNKs[1].Move(STNKs[1].Location + CVec.New(-1,0))
				Tanyas[1].Move(STNKs[1].Location + CVec.New(-1,1))
				Tanyas[1].EnterTransport(STNKs[1]) 
			end)			
		end
	end
end


 -- USSR Reinforcements

 PrepareUSSRPatrols = function()

	Trigger.AfterDelay(DateTime.Seconds(1), function() CreatUSSRPatrols(1) end) 
	Trigger.AfterDelay(DateTime.Seconds(2), function() CreatUSSRPatrols(2) end) 
	Trigger.AfterDelay(DateTime.Seconds(3), function() CreatUSSRPatrols(3) end) 
	Trigger.AfterDelay(DateTime.Seconds(4), function() CreatUSSRPatrols(4) end) 

end
 
PrepareUSSRReinforcements = function()

	Trigger.AfterDelay(DateTime.Seconds(1), function() SendUSSRReinforcements(1) end) 
	Trigger.AfterDelay(DateTime.Seconds(10), function() SendUSSRReinforcements(2) end) 
	
	Trigger.AfterDelay(DateTime.Minutes(3), function() ParadropSovietUnits(1) end)
end

SendUSSRMIGs = function()

	Media.Debug("Creating Soviet MIGs")
	local MIGs = { "mig", "mig", "mig", "mig" }
	local units = Reinforcements.Reinforce( pl_ussr , MIGs, { PlayerEntryPoint.Location } , 9)
	
	Utils.Do(units, function(unit)
		unit.Stop()
		unit.AttackMove(Utils.Random(USSRAircraftAttackTransport).Location, 5)
		Trigger.AfterDelay(120, function()
			unit.Stop()
			unit.Move(SovietEntryPoint.Location)
			Trigger.AfterDelay(110, function()
				unit.Stop()
				unit.Destroy()
			end)
		end)
	end)
	
end

SendUSSRReinforcements = function(i)

	Media.Debug("Creating Soviet Reinforcements #" .. i)
	local Invaders = Utils.Random(USSRReinforcementSet)
	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(60))
	local units = Reinforcements.Reinforce( pl_ussr , Invaders, USSRReinforcementPath[i].spawn , DateTime.Seconds(1))
	
	Utils.Do(units, function(unit)
	
		SovietReinfList[#SovietReinfList + 1] = unit
		ManDown(SovietReinfList, unit)
	
		unit.Patrol(USSRReinforcementPath[i].path, false, 60)
		IdleHunt(unit) 
	end)


	Trigger.AfterDelay(USSRAIReinfDelay + delay, function() SendUSSRReinforcements(i) end) 
	
end

CreatUSSRPatrols = function(i)

	Media.Debug("Creating Soviet Patrol #" .. i)
	local units = Reinforcements.Reinforce( SovietHouses[USSRPatrolGroup[i].owner] , USSRPatrolGroup[i].units, USSRPatrolPaths[i].spawn , DateTime.Seconds(1))
	
	GroupPatrol(units, USSRPatrolPaths[i].path, 180, 2)
	
end

ParadropSovietUnits = function(i)

	Media.Debug("Creating Soviet Paradrop team on location ".. i)
	
	if i == 0 then
		i = Utils.RandomInteger(1, #SovParadropLocations)
	end
	
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		local lz = SovParadropLocations[i].Location
		local start = Map.CenterOfCell(SovParadropEntry.Location) + WVec.New(0, 0, Actor.CruiseAltitude("badr"))
		local transport = Actor.Create("badr", true, { CenterPosition = start, Owner = pl_ussr, Facing = (Map.CenterOfCell(lz) - start).Facing })
		local units = Utils.Random(SovParadropUnits)
		
		Utils.Do(units, function(type)
			local a = Actor.Create(type, false, { Owner = pl_ussr })
			IdleHunt(a)
			transport.LoadPassenger(a)
		end)

		transport.Paradrop(lz)
		
		Trigger.AfterDelay(DateTime.Minutes(4), function() ParadropSovietUnits(0) end)
	end)

end

PrepareSovietReinforcements = function()

	Trigger.AfterDelay(DateTime.Seconds(1), function() SendSovietReinforcements(1) end) 
	Trigger.AfterDelay(DateTime.Seconds(5), function() SendSovietReinforcements(2) end) 
	Trigger.AfterDelay(DateTime.Seconds(9), function() SendSovietReinforcements(3) end) 
	Trigger.AfterDelay(DateTime.Seconds(30), function() SendSovietReinforcements(4) end) 
	Trigger.AfterDelay(DateTime.Seconds(34), function() SendSovietReinforcements(5) end) 
	Trigger.AfterDelay(DateTime.Seconds(38), function() SendSovietReinforcements(6) end) 

	Trigger.AfterDelay(DateTime.Seconds(50), function() SendSovietReinforcements(7) end) 
	Trigger.AfterDelay(DateTime.Seconds(54), function() SendSovietReinforcements(8) end) 
	Trigger.AfterDelay(DateTime.Seconds(58), function() SendSovietReinforcements(9) end)
	Trigger.AfterDelay(DateTime.Seconds(60), function() SendSovietReinforcements(10) end) 

	Trigger.AfterDelay(USSRAIReinfDelay, function() PrepareSovietReinforcementsR() end) 
	
end

PrepareSovietReinforcementsR = function()

	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(60))
	Trigger.AfterDelay(DateTime.Seconds(1), function() SendSovietReinforcements(4) end) 
	Trigger.AfterDelay(DateTime.Seconds(5), function() SendSovietReinforcements(8) end) 
	Trigger.AfterDelay(DateTime.Seconds(9), function() SendSovietReinforcements(3) end) 
	Trigger.AfterDelay(DateTime.Seconds(11), function() SendSovietReinforcements(5) end) 

	if Map.LobbyOption("difficulty") == "Mental" then 
		Trigger.AfterDelay(DateTime.Seconds(50), function() SendSovietReinforcements(Utils.Random({1,2,3,4,5,7,8,9,10})) end) 
	end
	
	Trigger.AfterDelay(USSRAIReinfDelay + delay, function() PrepareSovietReinforcementsR() end) 
	
end

SendSovietReinforcements = function(i)

	Media.Debug("Creating Soviet transport Reinforcements #" .. i)
	local units = Reinforcements.ReinforceWithTransport(pl_ussr, "lst", SovietReinforcementSet[i], { SovietEntryPoint.Location, SovietReinfPointSet[i] }, { SovietEntryPoint.Location })[2]
	local alreadyordered = false
	
	Utils.Do(units, function(unit)
	
		if unit.Type ~= "mcv" then
			SovietReinfList[#SovietReinfList + 1] = unit
			ManDown(SovietReinfList, unit)
		end
		Trigger.OnIdle(unit, function(a)
			if unit.Type == "mcv" then --  MCV
				a.Wait(75)
				a.Move(SovietReinforcementPath[i][1])
				a.Deploy()
				if not alreadyordered then 
					alreadyordered = true
					Trigger.AfterDelay(50, function() BuildNewBase(pl_ussr) end)
				end
			else		
				for j = 1, #SovietReinforcementPath[i] do
					if a.HasProperty("AttackMove") then 
						a.AttackMove(SovietReinforcementPath[i][j], 1)
					else
						a.Move(SovietReinforcementPath[i][j], 1)
					end
				end
			end
		end)
	end)

end

PrepareFranceReinforcements = function()

	Trigger.AfterDelay(DateTime.Seconds(50), function() SendFranceReinforcements(1) end) 
	Trigger.AfterDelay(DateTime.Seconds(54), function() SendFranceReinforcements(2) end) 
	Trigger.AfterDelay(DateTime.Seconds(58), function() SendFranceReinforcements(3) end) 
	Trigger.AfterDelay(DateTime.Seconds(74), function() SendFranceReinforcements(4) end) 
	Trigger.AfterDelay(DateTime.Seconds(78), function() SendFranceReinforcements(5) end) 
	Trigger.AfterDelay(DateTime.Seconds(82), function() SendFranceReinforcements(6) end) 

	Trigger.AfterDelay(FRANCEAIReinfDelay, function() PrepareFranceReinforcementsR() end) 
	
end

PrepareFranceReinforcementsR = function()

	local delay = Utils.RandomInteger(DateTime.Seconds(0), DateTime.Seconds(60))
	Trigger.AfterDelay(DateTime.Seconds(1), function() SendFranceReinforcements(1) end) 
	Trigger.AfterDelay(DateTime.Seconds(5), function() SendFranceReinforcements(3) end) 
	Trigger.AfterDelay(DateTime.Seconds(9), function() SendFranceReinforcements(5) end) 

	Trigger.AfterDelay(FRANCEAIReinfDelay + delay, function() PrepareFranceReinforcementsR() end) 
	
end

SendFranceReinforcements = function(i)

	Media.Debug("Creating France transport Reinforcements #" .. i)
	local units = Reinforcements.ReinforceWithTransport(pl_france, "lst", FranceReinforcementSet[i], { FranceEntryPoint.Location, FranceReinfPointSet[i] }, { FranceEntryPoint.Location })[2]
	local alreadyordered = false
	
	Utils.Do(units, function(unit)
		local alreadyinholdinglist = false

		if unit.Type ~= "mcv" then
			AlliedReinfList[#AlliedReinfList + 1] = unit
			ManDown(AlliedReinfList, unit)
		end
		Trigger.OnIdle(unit, function(a)
			if unit.Type == "mcv" then --  MCV
				a.Wait(50)
				a.Move(FranceReinforcementPath[i][1])
				a.Deploy()
				if not alreadyordered then 
					alreadyordered = true
					Trigger.AfterDelay(75, function() BuildNewBase(pl_france) end)
				end
			else
			
				for j = 1, #FranceReinforcementPath[i] do
					if a.HasProperty("AttackMove") then 
						a.AttackMove(FranceReinforcementPath[i][j], 1)
					else
						a.Move(FranceReinforcementPath[i][j], 1)
					end
					if not alreadyinholdinglist then 
						alreadyinholdinglist = true
						Trigger.AfterDelay(2500, function() 
							if not a.IsDead then
								RemoveFromList(AlliedReinfList, a)
								AlliedHoldingList[#AlliedHoldingList + 1] = a
								ManDown(AlliedHoldingList, a)
							end
						end)
					end
				end
			end
		end)
	end)

end


PrepareGermanReinforcements = function()

	Trigger.AfterDelay(DateTime.Seconds(1), function() SendGermanReinforcements(1) end) 
	Trigger.AfterDelay(DateTime.Seconds(2), function() SendGermanReinforcements(2) end) 
	Trigger.AfterDelay(DateTime.Seconds(11), function() SendGermanReinforcements(3) end) 
	Trigger.AfterDelay(DateTime.Seconds(12), function() SendGermanReinforcements(4) end) 
	Trigger.AfterDelay(DateTime.Seconds(21), function() SendGermanReinforcements(5) end) 
	Trigger.AfterDelay(DateTime.Seconds(22), function() SendGermanReinforcements(6) end) 
	Trigger.AfterDelay(DateTime.Seconds(31), function() SendGermanReinforcements(7) end) 
	Trigger.AfterDelay(DateTime.Seconds(32), function() SendGermanReinforcements(8) end) 

	Trigger.AfterDelay(DateTime.Seconds(62), function() SendGermanReinforcements(2) end) 
	Trigger.AfterDelay(DateTime.Seconds(82), function() SendGermanReinforcements(4) end)
	
	if Map.LobbyOption("difficulty") == "Easy" then
		Trigger.AfterDelay(DateTime.Seconds(51), function() SendGermanReinforcements(3) end) 
		Trigger.AfterDelay(DateTime.Seconds(61), function() SendGermanReinforcements(5) end) 
		Trigger.AfterDelay(DateTime.Seconds(71), function() SendGermanReinforcements(6) end) 
		Trigger.AfterDelay(DateTime.Seconds(92), function() SendGermanReinforcements(8) end)
	end

	if Map.LobbyOption("difficulty") == "Mental" then 
		Trigger.AfterDelay(DateTime.Seconds(15), function() SendSovietReinforcements(Utils.Random({1,2,3,4,5,7,8,9,10})) end) 
		Trigger.AfterDelay(DateTime.Seconds(35), function() SendSovietReinforcements(Utils.Random({1,2,3,4,5,7,8,9,10})) end) 
		Trigger.AfterDelay(DateTime.Seconds(45), function() SendSovietReinforcements(10) end) 
	end
	
end


SendGermanReinforcements = function(i)

	Media.Debug("Creating German Reinforcements #" .. i)
	local Defenders = GermanReinforcementSet[i]
	local units = Reinforcements.Reinforce( pl_germany , Defenders, GermanReinforcementPath[i].spawn , DateTime.Seconds(2))
	
	Utils.Do(units, function(unit)
		
		AlliedReinfList[#AlliedReinfList + 1] = unit
		ManDown(AlliedReinfList, unit)
	
		unit.Patrol(GermanReinforcementPath[i].path, false, 30)
		IdleHunt(unit) 
	end)
	
end
