-- wacky messages goes here
-- for best effect, 120 characters max. Captains and higher only. Only one player character allowed.

randommsgallowed = false
randommsgcodelist = {4,4,4,4,1,0,0,0,0,0,0,0} -- 8 elements

MasterofRandomMessages = 
{
	-- Code 1, the pure random
	-- From the Allied with love and irony... for all difficulties
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "This message is brought to you by Brigadier General NoName, who has risen to the height of obscurity." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "Why do the Soviets still find me so easily? Didn't my green camouflage work?" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "This base contains fake blueprints for a fake project. It contains a fake commander as well." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "Please refrain from selling the Allied Tech Center." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "Did you notice that the Soviets are always in the West? What are we, Japan?" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "The Allied High Command are too cheap to build real Tech Centers. They claim launching satellites are expensive." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "Where are our cruisers?" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "Welcome to the town of Whiskers. Well, if you can liberate it." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "Iterating call for reinforcements... but nobody came." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "Taking a small loan of a million dollars will be really handy here. Imagine the number of Pillboxes I can build!" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "I heard the French High Command has invented Fake Power Plants. Is that supposed to be an anti-spy measure?" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "General Announcement: General NoName is generally in a defensive mood today. Blame is generally on the Soviets." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "General NoName is having difficulties selling his Construction Yard, or any of his structure." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "Our Operations Officer is as formidable as his name sounds. Somehow, he prefers us to call him by his first name, Mark." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "Colonel Question is not too happy about the casualty rates incurred in the last operation." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "I feel weird that we are paid by the number of goons we shoot. We are not on that kind of commission." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "Wait, kid. Are you still a Newbie?" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 1, message = "The V2s and Mammoth Tanks... Are you sure the Germans are on our side?" },

	{ difficulty = {"Mental"}, side = {"allies"}, code = 1, message = "I heard the Soviets are building SAM sites, so the General sold the Helipad. I can't believe he managed to sell something!" },
	{ difficulty = {"Mental"}, side = {"allies"}, code = 1, message = "No rest for the wicked!" },

	
	-- From the Soviets with love and irony... for all difficulties
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "This message is brought to you by Major General Vladimir, whose name has risen to the height of major normalcy" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "This message is brought to you by Agent John Smith, who is now in charge of the Soviet Alcohol Center." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "This message is brought to you by Agent John Smith, who swears he is still on your side." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "WHO. JUST. STOLE. MY. VODKA?!" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "Please refrain from infiltrating our installations, laboratories, tank husks and toilets." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "This Spy is having difficulties selling the Soviet Construction Yard. Must be bugged." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "General Vladimir has just sent a complaint about the MIGs. He wants them to destroy the Allied base, not a transport." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "General Announcement: Beware of the invisible squishing thing. Bring your dog out today." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "General Vladimir is in a sour mood again. He wants the Ukraine forces out of his base." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "Why am I here?" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "Did you notice that the Allies are always in the East? What are we, China?" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "A Mammoth a day keeps Agent Tanya away." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "This uphill battle is going nowhere." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 1, message = "The Ukraine base is complaining about the Russian reinforcements trampling across their grounds." },

	{ difficulty = {"Mental"}, side = {"soviet"}, code = 1, message = "Curses! I am making SAM sites, and they sold their airforce?! Are they mocking me?" },
	
	
	-- Love from both sides may be a bit too much...
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 1, message = "SILOS NEEDED" },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 1, message = "You must acquire more minerals." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 1, message = "Attempting to perform illegal transfer of funds... Standby." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 1, message = "Rated R18 for Reason." },
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 1, message = "Rate 5 stars to win this game instantly! Seriously, who would fall for that?" },

	
	-- Code 2, pure random after German reinforcements
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 2, message = "The Germans called, Comrade General. They want their tanks back." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"soviet"}, code = 2, message = "The Germans threaten to send in their Mechanics." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 2, message = "The Germans have arrived rather... enthusiastically." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 2, message = "The Germans have modified their tank guns to be more effective against enemy armor. They remain vulnerable to infantry." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 2, message = "The Germans have modified their tanks to take much more punishment than most other tanks." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 2, message = "If the Germans fail to breach this front... I will make sure to laugh at them in the next staff meeting." },	
	
	
	-- Code 3, Real announcements, in sequence order
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 3, message = "I am the Commanding Officer of this base. It is my honor to fight alongside you." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 3, message = "This is a major Allied facility, containing plans for top secret Allied projects, or so we want them to think." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 3, message = "As you can see, every technological building is a fake." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 3, message = "The real facility is up ahead, Allied High Command has indicated you to be posted there in good time." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 3, message = "But you are needed here." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 3, message = "To keep Soviet hands away from the real project, we must defend this facility." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies", "soviet"}, code = 3, message = "That is our mission." },	

	-- Code 4, Random Tips, in no particular order of calling
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 4, message = "Our bases are linked. If one of us has more than $".. GiverThreshold .." and the other less than $".. TakerThreshold ..", resources will be transferred." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 4, message = "My Base information above this statement lists several important attributes in my base. It can help you consider your options." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 4, message = "Be sure to support my troops in their counter-attacks against the enemy." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 4, message = "Your Phase Transport seems to have very advanced radar equipped. It will make an excellent artillery spotter." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 4, message = "I hope you have been defending your Harvester well." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 4, message = "Remember that dogs can detect your Phase Transport." },	
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 4, message = "Agent Tanya can deal with masses of Soviet infantry, but beware that Shock Troopers can kill her in one zap." },		
	
	-- Code 5, 
	{ difficulty = {"Easy", "Normal", "Mental"}, side = {"allies"}, code = 5, message = "Warning: The base is under attack." }		
	
}

AlliedMessageList = { }

SovietMessageList = { }

str_message = ""

TrueName = 
{
	-- Tanks
	["1tnk"] = "Light Tank",
	["2tnk"] = "Medium Tank",
	["3tnk"] = "Heavy Tank",
	["4tnk"] = "Badass Tank",
	["apc"]  = "APC",
	["v2rl"] = "V2 Rocket Launcher",
	["arty"] = "Artillery",
	["jeep"] = "Ranger",
	["harv"] = "Ore Truck",
	["mcv"] = "Mobile Construction Vehicle",
	["mnly.ap"] = "Minelayer",
	["mnly.at"] = "Minelayer",
	["truk"] = "Supply Truck",
	["dtrk"] = "Demolition Truck",
	["mgg"] = "Mobile GG",
	["mrj"] = "Mobile Radar Jammer",
	["ttnk"] = "Tesla Tank",
	["ftrk"] = "Mobile Flak",
	["ctnk"] = "Chrono Tank",
	["qtnk"] = "MAD Tank",
	["stnk"] = "Phase Transport",

	-- Infantry
	["e1"] = "Rifle Infantry",
	["e2"] = "Grenadier",
	["e3"] = "Rocket Soldier",
	["e4"] = "Flamethrower",
	["e5"] = "",
	["e6"] = "",
	["e7"] = "Agent Tanya",
	["shok"] = "Shock Trooper",
	["dog"] = "Dog",

	-- Ships
	["pt"] = "Gunboat",
	["dd"] = "Destroyer",
	["sub"] = "Submarine",
	["ca"] = "Not a Carrier",
	["lst"] = "Low Sanity Transport",
	
	-- Aircraft
	["yak"] = "Yak Attack Plane",
	["mig"] = "MIG Fighter",
	["tran"] = "MIG Fighter",
	["hind"] = "Hind",
	["heli"] = "Longbow",
	
	-- Structures
	["fact"] = "More than an opinion",
	["powr"] = "Power Plant",
	["apwr"] = "Advanced Power Plant",
	["proc"] = "Ore Refinery",
	["barr"] = "Soviet Barracks",
	["tent"] = "Allied Barracks",
	["weap"] = "War Factory",
	["fix"] = "Service Depot",
	["dome"] = "Radar Dome",
	["atek"] = "Allied Tech Center",
	["stek"] = "Soviet Tech Center",
	["ftur"] = "Flame Tower",
	["tsla"] = "Tesla Coil",
	["sam"] = "SAM Site",
	["pbox"] = "Pillbox",
	["hbox"] = "Camo Pillbox",
	["gun"] = "Gun Turret",
	["asam"] = "AA Gun",
	["hpad"] = "Helipad",
	["afld"] = "Airfield",
	["kenn"] = "Kennel"

}

-- Gets true name from type
GetName = function(stype)
	
	local str = TrueName[stype]
	if TrueName[stype] ~= nil then
		return str
	else
		return stype
	end
	
end

--do i need to sort?
MessageSort = function()
	
	table.insert(AlliedMessageList, MessageSortNum("allies",1))
	table.insert(AlliedMessageList, MessageSortNum("allies",2))
	table.insert(AlliedMessageList, MessageSortNum("allies",3))
	table.insert(AlliedMessageList, MessageSortNum("allies",4))
	table.insert(SovietMessageList, MessageSortNum("soviet",1))
	table.insert(SovietMessageList, MessageSortNum("soviet",2))
	table.insert(SovietMessageList, MessageSortNum("soviet",3))
	table.insert(SovietMessageList, MessageSortNum("soviet",4))
	
end

MessageSortNum = function(side, code)

	local enumlist = { }
	
	Utils.Do(MasterofRandomMessages, function(rngmsg)
	
		local meetsdifficulty = false
		Utils.Do(rngmsg.difficulty, function(rndiff)
			if rndiff == Map.LobbyOption("difficulty") then meetsdifficulty = true end
		end)
				
		local meetsside = false
		Utils.Do(rngmsg.side, function(rnside)
			if rnside == side then meetsside = true end
		end)

		local meetscode = false
		if rngmsg.code == code then meetscode = true end
		
		if meetsdifficulty and meetsside and meetscode then
			table.insert(enumlist, rngmsg.message)
		end

	end)

	return enumlist
	
end

MessageCall = function(side, code, id)
	
	-- code = 0 is special case to clear the message.
	if code == 0  then
		str_message = ""
		return
	end

	-- id = 0 is special case to randomize order
	local sublist = SovietMessageList[code]
	if side == "allies" then
		sublist = AlliedMessageList[code]
	end
	
	if id == 0 then
		id = Utils.RandomInteger(1,#sublist)		
	end
	
	-- if id is still 0, return with empty string
	if id == 0 or #sublist == 0 then
		str_message = ""
		return
	end

	str_message = sublist[id]

end