-- Collection of functions for governing AI teams --

if Map.LobbyOption("difficulty") == "Easy" then
	SovietAttackGroupSize = 20
	AlliedAttackGroupSize = 30
	
elseif Map.LobbyOption("difficulty") == "Mental" then
	SovietAttackGroupSize = 40
	AlliedAttackGroupSize = 15
else
	SovietAttackGroupSize = 30
	AlliedAttackGroupSize = 25	
end 

SovietHoldingList = { }
SovietDefenderList = { }
SovietAttackingList = { }
SovietReinfList = { }

AlliedHoldingList = { }
AlliedDefenderList = { }
AlliedAttackingList = { }
AlliedReinfList = { }

-- Simple hunt
IdleHunt = function(a) 
	if a.HasProperty("Hunt") then
		if not a.IsDead then 
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					a.Hunt()
				end
			end)
		end
	end
end

-- Closed loop patrol
GroupPatrol = function(units, waypoints, delay, closeenough)
	local i = 1
	local stop = false

	local exwaypoints = { } -- for expanded waypoints
	
	for j = 1,#waypoints do
		if closeenough > 1 then
			for cl = 1, closeenough do
				if cl > 1 then	-- ignore first expansion
					exwaypoints[j] = Utils.ExpandFootprint({waypoints[j]}, false)
				end
			end
		else
			exwaypoints[j] = { waypoints[j] }		
		end
	end
	
	Utils.Do(units, function(unit)
		if not unit.IsDead then
			unit.Scatter()
			Trigger.OnIdle(unit, function()
				if stop then
					return
				end

				--Trigger.OnEnteredProximityTrigger(Map.CenterOfCell(waypoints[i]), WDist.New(closeenough * 1024), function(a, id)
				local reachdest = false
				Utils.Do(exwaypoints[i], function(wp)
					if unit.Location == wp then reachdest = true end
				end)
				
				if reachdest then 
					--if a == unit then
					local bool = Utils.All(units, function(actor)
						if actor.IsDead then return true end
						return actor.IsIdle 
					end)

					if bool then
						stop = true

						i = i + 1
						if i > #waypoints then
							i = 1
						end

						Trigger.AfterDelay(delay, function() stop = false end)
					end
				--end)
				
				--Trigger.OnExitedProximityTrigger(Map.CenterOfCell(waypoints[i]), WDist.New(closeenough * 1024), function(a, id)
				--	if a == unit and not a.IsDead then
				else
					unit.AttackMove(waypoints[i], closeenough)
				end
				--end)				
			end)
		end
	end)
end

-- Initial unit setup
SetupMapUnits = function(n)
	Utils.Do(Map.NamedActors, function(a)
		if a.Type == "dog" then
			a.Stance = "AttackAnything"
		elseif a.Type ~= "camera" then
			a.Stance = "Defend"
			
			-- attack persistent attackers
			if a.HasProperty("Health") then
				Trigger.OnDamaged(a, function(b)
					if b.Health < n * b.MaxHealth then
						b.Stance = "AttackAnything"
					end
				end)
			end
			
			-- convert all walls to neutral
			if (a.Type == "brik" or a.Type == "cycl" or a.Type == "fenc" or a.Type == "sbag") and a.Owner ~= neutral then
				a.Owner = neutral
			end
		end
	end)
	
	if Map.LobbyOption("difficulty") ~= "Easy" then Helipad.Destroy() end
end

AircraftDecisionMaker = function(a)
	if a.IsDead then return end
	a.Stop()
	a.AttackMove(Utils.Random(USSRAircraftAttackPos).Location, 5)
	
	Trigger.AfterDelay(DateTime.Seconds(7), function() AircraftDecisionMaker(a) end)
end

-- What to do with the units?
DecisionMaker = function(factory, a)

	local isaircraft = false -- special handling for Soviet aircraft
	if factory.Type == "afld" then isaircraft = true end

	if isaircraft then -- Unit is a Soviet aircraft
	
		Media.Debug("Sending Soviet Aircraft to attack.")
		AircraftDecisionMaker(a)
		return
	
	else -- Unit is a ground vehicle, Allied or Soviet
		-- Harvester
		if a.Type == "harv" then
			a.FindResources()
			return
		end
	
		local unit = a
		local id = 0
		
		-- What factory is this?
		if CheckOwnerSide(factory.Owner) == "soviet" then  -- Factory belongs to Soviet
		
			id = #SovietHoldingList + 1
			SovietHoldingList[id] = a
			ManDown(SovietHoldingList, a)
			
			if #SovietHoldingList >= SovietAttackGroupSize then

				for i = 1, #SovietHoldingList do
					table.insert(SovietAttackingList, SovietHoldingList[1])
					table.remove(SovietHoldingList, 1)
					ManDown(SovietAttackingList, SovietAttackingList[#SovietAttackingList])
				end
				
				Media.Debug("Sending Soviet Holding List to attack.")
				
				i = 1
				while i <= #SovietAttackingList do
					unit = SovietAttackingList[i]
				    if unit.IsDead then
						table.remove(SovietAttackingList, i)
					else
						unit.Patrol(USSRAdvanceRand, false, 60)
						IdleHunt(unit)
						i = i + 1
					end
				end
			end
			return
		end

		
		if CheckOwnerSide(factory.Owner) == "allies" then  -- Factory belongs to Allies	

			id = #AlliedHoldingList + 1
			AlliedHoldingList[id] = a
			ManDown(AlliedHoldingList, a)

			if #AlliedHoldingList >= AlliedAttackGroupSize then

				for i = 1, #AlliedHoldingList do
					table.insert(AlliedAttackingList, AlliedHoldingList[1])
					table.remove(AlliedHoldingList, 1)
					ManDown(AlliedAttackingList, AlliedAttackingList[#AlliedAttackingList])
				end
				
				Media.Debug("Sending Allied Holding List to attack.")
				
				i = 1
				while i <= #AlliedAttackingList do
					unit = AlliedAttackingList[i]
				    if unit.IsDead then
						table.remove(AlliedAttackingList, i)
					else
						unit.Patrol(FRANCEAdvanceRand, false, 60)
						IdleHunt(unit)
						i = i + 1
					end
				end
			end
			return
		end
		
		-- IdleHunt(a)
		
	end
end

ManDown = function(list, unit)	
	Trigger.OnKilled(unit, function() 
		RemoveFromList(list, unit) 
	end)
--	Trigger.OnAnyKilled(list, function(unit) 
--		RemoveFromList(list, unit) 
--		ManDown(list)
--	end)
end
	
RemoveFromList = function(list, element)	
	local i = 1
	while i <= #list do
		if list[i] == element then
			table.remove(list, i)
		else
			i = i + 1
		end
	end
end
