-- Collection of functions for governing AI unit production --

if Map.Difficulty == "Easy" then
	SovietBuildTimeMultiplier = 1
	AlliedBuildTimeMultiplier = 0.75
	AircraftTimeMultiplier = 7
	DogTimeMultiplier = 5

elseif Map.Difficulty == "Mental" then
	
	SovietBuildTimeMultiplier = 0.6
	AlliedBuildTimeMultiplier = 1.5
	AircraftTimeMultiplier = 2
	DogTimeMultiplier = 3.5

else

	SovietBuildTimeMultiplier = 0.8
	AlliedBuildTimeMultiplier = 1
	AircraftTimeMultiplier = 4
	DogTimeMultiplier = 4

end 


UnitsMasterTable =
{
	-- Harvester
	--{ type = "harv", factory = "weap", prereq = {}, side = "allies", weight = 0, cost = 1400 }, 
	--{ type = "harv", factory = "weap", prereq = {}, side = "soviet", weight = 0, cost = 1400 }, 
	-- Allied units
	{ type = "e1", factory = "tent", prereq = {}, side = "allies", weight = 4, cost = 100 }, 
	{ type = "e3", factory = "tent", prereq = {}, side = "allies", weight = 2, cost = 300 }, 
	
	{ type = "jeep", factory = "weap", prereq = {}, side = "allies", weight = 3, cost = 300 }, 
	{ type = "1tnk", factory = "weap", prereq = {}, side = "allies", weight = 3, cost = 400 }, 
	{ type = "2tnk", factory = "weap", prereq = {"fix"}, side = "allies", weight = 2, cost = 800 }, 
	
	{ type = "hind", factory = "hpad", prereq = {}, side = "allies", weight = 1, cost = 800 }, 
	-- Soviet units
	{ type = "e1", factory = "barr", prereq = {}, side = "soviet", weight = 6, cost = 100 }, 
	{ type = "e2", factory = "barr", prereq = {}, side = "soviet", weight = 3, cost = 200 }, 
	{ type = "e4", factory = "barr", prereq = {"dome"}, side = "soviet", weight = 2, cost = 200 }, 
	{ type = "shok", factory = "barr", prereq = {"tsla"}, side = "soviet", weight = 1, cost = 300 }, 
	
	{ type = "dog", factory = "kenn", prereq = {}, side = "soviet", weight = 1, cost = 100 }, 
	
	{ type = "ftrk", factory = "weap", prereq = {}, side = "soviet", weight = 2, cost = 500 }, 
	{ type = "3tnk", factory = "weap", prereq = {}, side = "soviet", weight = 2, cost = 400 },  --removed "fix" prereq
	{ type = "v2rl", factory = "weap", prereq = {"dome"}, side = "soviet", weight = 2, cost = 600 },
	{ type = "ttnk", factory = "weap", prereq = {"stek"}, side = "soviet", weight = 1, cost = 1200 },
	{ type = "4tnk", factory = "weap", prereq = {"stek"}, side = "soviet", weight = 1, cost = 1500 },
	
 	{ type = "yak", factory = "afld", prereq = {}, side = "soviet", weight = 2, cost = 900 },  
	{ type = "mig", factory = "afld", prereq = {"stek"}, side = "soviet", weight = 1, cost = 1400 }  

}

BuildingsMasterTable = 
{
	-- Allied structures
	{ type = "powr", priority = "power", power = 100, prereq = {}, side = "allies", cost = 300 },
	{ type = "tent", priority = "production", power = -30, prereq = {}, side = "allies", cost = 400 },
	{ type = "proc", priority = "economy", power = -40, prereq = {"powr"}, side = "allies", cost = 1400 },
	{ type = "weap", priority = "production", power = -40, prereq = {"proc"}, side = "allies", cost = 2000 },
	{ type = "pbox", priority = "defence", power = -15, prereq = {"tent"}, side = "allies", cost = 300 },
	{ type = "gun", priority = "defence", power = -40, prereq = {"tent"}, side = "allies", cost = 600 },
	{ type = "hbox", priority = "defence", power = -15, prereq = {"tent"}, side = "allies", cost = 600 },
	{ type = "fix", priority = "tech", power = -40, prereq = {"weap"}, side = "allies", cost = 1000 },
	{ type = "hpad", priority = "production", power = -10, prereq = {"tent"}, side = "allies", cost = 500 },

	-- Soviet structures
	{ type = "powr", priority = "power", power = 100, prereq = {}, side = "soviet", cost = 300 },
	{ type = "barr", priority = "production", power = -30, prereq = {}, side = "soviet", cost = 400 },
	{ type = "kenn", priority = "production", power = 0, prereq = {}, side = "soviet", cost = 300 },
	{ type = "proc", priority = "economy", power = -40, prereq = {"powr"}, side = "soviet", cost = 1400 },
	{ type = "weap", priority = "production", power = -40, prereq = {"proc"}, side = "soviet", cost = 2000 },
	{ type = "ftur", priority = "defence", power = -30, prereq = {"barr"}, side = "soviet", cost = 300 },
	{ type = "tsla", priority = "defence", power = -100, prereq = {"weap"}, side = "soviet", cost = 1400 },
	{ type = "sam", priority = "defence", power = -100, prereq = {"weap"}, side = "soviet", cost = 700 },
	{ type = "dome", priority = "tech", power = -40, prereq = {"proc"}, side = "soviet", cost = 1000 },
	{ type = "fix", priority = "tech", power = -40, prereq = {"weap"}, side = "soviet", cost = 1000 },
	{ type = "apwr", priority = "power", power = 200, prereq = {"dome"}, side = "soviet", cost = 700 },
	{ type = "afld", priority = "production", power = -30, prereq = {"dome"}, side = "soviet", cost = 900 },
	{ type = "stek", priority = "tech", power = -40, prereq = {"dome"}, side = "soviet", cost = 2000 }
}

OwnerPriorities = { } --{ owner = nil, priority = nil }

ProducedUnitTypes = { }	--{ factory = nil, types = nil, curr_production = nil, curr_progress = 0 }

BaseCenters = { }

ConstructionYards = { }

ExistingBuildings = { }

BaseBuildings = { }

DeclareBaseBuildings = function()
	BaseBuildings = {
		-- Allied buildings
		{ id = "A01", owner = pl_france, type = "powr", pos = { x = 3, y = -2}, exists = false },
		{ id = "A02", owner = pl_france, type = "tent", pos = { x = 3, y = 2}, exists = false },
		{ id = "A03", owner = pl_france, type = "proc", pos = { x = 3, y = 5}, exists = false },
		{ id = "A04", owner = pl_france, type = "powr", pos = { x = 5, y = -2}, exists = false },
		{ id = "A05", owner = pl_france, type = "weap", pos = { x = 7, y = 6}, exists = false },
		{ id = "A06", owner = pl_france, type = "tent", pos = { x = 7, y = 2}, exists = false },

		--Soviet buildings
		{ id = "S01", owner = pl_ussr, type = "powr", pos = { x = 3, y = -3}, exists = false }, 
		{ id = "S02", owner = pl_ussr, type = "barr", pos = { x = 5, y = -1}, exists = false }, 
		{ id = "S03", owner = pl_ussr, type = "barr", pos = { x = 8, y = -1}, exists = false }, 
		{ id = "S04", owner = pl_ussr, type = "proc", pos = { x = 0, y = -5}, exists = false }, 
		{ id = "S05", owner = pl_ussr, type = "proc", pos = { x = 8, y = -6}, exists = false }, 
		{ id = "S06", owner = pl_ussr, type = "powr", pos = { x = 3, y = 0}, exists = false }, 
		{ id = "S07", owner = pl_ussr, type = "apwr", pos = { x = -3, y = 0}, exists = false }, 
		{ id = "S08", owner = pl_ussr, type = "apwr", pos = { x = -4, y = 3}, exists = false }, 
		{ id = "S09", owner = pl_ussr, type = "weap", pos = { x = 3, y = 3}, exists = false }, 
		{ id = "S10", owner = pl_ussr, type = "weap", pos = { x = 7, y = 3}, exists = false }, 
		{ id = "S11", owner = pl_ussr, type = "dome", pos = { x = -3, y = -6}, exists = false }, 
		{ id = "S12", owner = pl_ussr, type = "fix", pos = { x = 11, y = -1}, exists = false },
		{ id = "S13", owner = pl_ussr, type = "powr", pos = { x = 12, y = -4}, exists = false }, 		
		{ id = "S14", owner = pl_ussr, type = "ftur", pos = { x = 4, y = -4}, exists = false }, 
		{ id = "S15", owner = pl_ussr, type = "ftur", pos = { x = 5, y = -3}, exists = false }, 
		{ id = "S16", owner = pl_ussr, type = "ftur", pos = { x = 10, y = -9}, exists = false }, 
		{ id = "S17", owner = pl_ussr, type = "tsla", pos = { x = 8, y = -8}, exists = false },
		{ id = "S18", owner = pl_ussr, type = "tsla", pos = { x = 0, y = -2}, exists = false }, 
		{ id = "S19", owner = pl_ussr, type = "sam", pos = { x = 1, y = -1}, exists = false }, 
		{ id = "S20", owner = pl_ussr, type = "sam", pos = { x = 10, y = -2}, exists = false }, 
		{ id = "S21", owner = pl_ussr, type = "powr", pos = { x = 11, y = 3}, exists = false }, 
		{ id = "S22", owner = pl_ussr, type = "afld", pos = { x = -1, y = 4}, exists = false },
		{ id = "S23", owner = pl_ussr, type = "kenn", pos = { x = 6, y = -3}, exists = false }, 	
		{ id = "S24", owner = pl_ussr, type = "kenn", pos = { x = 10, y = 1}, exists = false } 	

	}
	
	BaseCenters = 
	{
		{ owner = pl_france, pos = FranceBase.Location + CVec.New(-1, -1) },
		{ owner = pl_ussr, pos = USSRBase.Location + CVec.New(-1, -1) }
	}

	-- Add existing actors

	enumbb = #BaseBuildings
	Utils.Do(Map.NamedActors, function(actor)
		local cty = actor.Owner
		local basecen = CPos.New(1, 1)
		Utils.Do(BaseCenters, function(bc)
			if bc.owner == cty then basecen = bc.pos end
		end)
		
		if basecen == CPos.New(1, 1) then return end
		
		local s = CheckOwnerSide(cty)
		local mb = GetBuildingfromMasterList(actor.Type, s)
		if mb ~= nil then
		
			ExistingBuildings[#ExistingBuildings + 1] = actor
			
			table.insert(BaseBuildings, 
			{
				id = "E".. (#BaseBuildings - enumbb + 1),
				exists = true,
				owner = cty,
				mapactor = actor,
				type = actor.Type,
				pos = { x = actor.Location.X - basecen.X, y = actor.Location.Y - basecen.Y }
			} )
			
		end
	end)
end

BaseBuildingsExt = { } -- Populate from information from BaseBuildings and BuildingsMasterTable

AIBaseBehavior = function(cty)

	local str = ""
	local priorityset = false
	
	local poweruserlist = { }
	local economiclist = { }
	local factorylist = { }
	local techlist = { }
	
	-- populate lists
	Utils.Do(ExistingBuildings, function(actor)
		if actor.HasProperty("Power") and actor.Owner == cty then
			poweruserlist[#poweruserlist + 1] = actor
		end
		
		if actor.Type == "proc" and actor.Owner == cty then
			economiclist[#economiclist + 1] = actor
		end
		
		if (actor.Type == "barr" or actor.Type == "tent" or actor.Type == "weap") and actor.Owner == cty then -- don't count aircraft, naval and dogs
			factorylist[#factorylist + 1] = actor
		end
		
		if (actor.Type == "dome" or actor.Type == "fix" or actor.Type == "atek" or actor.Type == "stek") and actor.Owner == cty then
			techlist[#techlist + 1] = actor
		end
	end)

	-- check for power	
	local excesspower = -101 -- negative power for bias to build more power
	Utils.Do(poweruserlist, function(actor)
		excesspower = excesspower + actor.Power
	end)
	
	if excesspower < 0 then
		if CheckandSetOwnerPriority(cty, "power") then return end
	end
	
	-- check for economy
	if #economiclist == 0 then 
		if CheckandSetOwnerPriority(cty, "economy") then return end
	end	

	-- check for production	
	if #factorylist == 0 then 
		if CheckandSetOwnerPriority(cty, "production") then return end
	end	
	
	-- check for tech
	if #techlist == 0 then 
		if CheckandSetOwnerPriority(cty, "tech") then return end
	end	
	
	SetOwnerPriority(cty, "anything")	
end

CheckandSetOwnerPriority = function(cty, str) --returns true if priority has been set
	
	local priorityset = false
	
	Utils.Do(BaseBuildingsExt, function(mb)
		if mb.owner == cty and mb.priority == str and not mb.exists then
			SetOwnerPriority(cty, str)
			priorityset = true
			return
		end
	end)
	return priorityset
end

FindACYard = function(cty) -- cty = country, returns an 'ID' from the enumerated list ConstructionYards. Use ConstructionYards[returned value] to call the conyard
	
	local value = 0
	local alreadyexists = false
	local actorlist = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
		return actor.Type == "fact" and actor.Owner == cty
	end)
	Media.Debug("Checking for conyard among ".. #actorlist .." actors")
	
	Utils.Do(actorlist, function(actor)
		Utils.Do(ConstructionYards, function(cy)
			if cy == actor then alreadyexists = true end
		end)
		if not alreadyexists then 
			ConstructionYards[#ConstructionYards + 1] = actor
			Media.Debug("Add one ConstructionYard to list. Now populated with ".. #ConstructionYards)
			value = #ConstructionYards
		end
		alreadyexists = false
	end)
	
	return value
end


CheckForCYard = function(yard) -- yard = construction yard
	
	return not yard.IsDead
	
end

GetOwnerPriority = function(cty) -- cty = player
	local str = "anything"
	
	for i,v in ipairs(OwnerPriorities) do
		if v.owner == cty then
			str = v.priority
		end
	end	
	
	return str
end

SetOwnerPriority = function(cty, newstrvalue) -- cty = player
	for i,v in ipairs(OwnerPriorities) do
		if v.owner == cty then
			v.priority = newstrvalue
			return
		end
	end	
	
	table.insert(OwnerPriorities, {owner = cty, priority = newstrvalue} )
end

CheckOwnerType = function(cty, t) -- cty = player, t = type (building only), returns boolean
	local bool = false
	
	--Utils.Do(Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor) return actor.Owner == cty end), function(a)
	Utils.Do(ExistingBuildings, function(a)
		if a.Owner == cty and a.Type == t then
			bool = true
		end
	end)
	return bool
end

CheckOwnerSide = function(cty) -- cty = player, returns "allies" or "soviet"
	
	return cty.Faction
	
end

GetBuildingfromMasterList = function(t, s) -- t = building type, s = side
		
	for i,v in ipairs(BuildingsMasterTable) do
		if v.type == t and v.side == s then
			return v
		end
	end
end

PopulateBaseBuildingsExt = function()

	Utils.Do(BaseBuildings, function(b)
		local cty = b.owner
		local s = CheckOwnerSide(cty)
		local mb = GetBuildingfromMasterList(b.type, s)
		if mb ~= nil then
			table.insert(BaseBuildingsExt, 
			{
				id = b.id,
				exists = b.exists,
				owner = cty,
				side = s,
				type = b.type,
				priority = mb.priority,
				power = mb.power,
				prereq = mb.prereq,
				cost = mb.cost,
				pos = b.pos,
				mapactor = b.mapactor
			})
		end
	end)
		
	if bdebug then
		local str = "Building list: ".. #BaseBuildingsExt .."\n"
		Utils.Do(BaseBuildingsExt, function(b)
			str = "\n".. str .." ".. b.id .." ".. b.side .." ".. b.type .." ".. b.pos.x .." ".. b.pos.y .."\n"
		end)
		Trigger.AfterDelay(1, function() 
			UserInterface.SetMissionText(str, player.Color)
		end)
	end
	
	ArrangeBaseBuildingsExt()
end

ArrangeBaseBuildingsExt = function()

	local BaseHoldingList = { }
	local i = 0
	
	--Utils.Do(BaseHoldingList, function(mb)
	for j = 1,#BaseBuildingsExt do 	
		table.insert(BaseHoldingList, BaseBuildingsExt[j])		
		BaseHoldingList[j].dist = BaseHoldingList[j].pos.x * BaseHoldingList[j].pos.x + BaseHoldingList[j].pos.y * BaseHoldingList[j].pos.y
		BaseHoldingList[j].initrank = j
	end
	
	Utils.Do(BaseHoldingList, function(mb)
		i = 1
		Utils.Do(BaseHoldingList, function(mb2)
			if mb ~= mb2 then
				if mb.dist > mb2.dist then
					i = i + 1
				elseif mb.dist == mb2.dist then
					if mb.initrank > mb2.initrank then
						i = i + 1
					end
				end
			end
		end)
		mb.rank = i
	end)
	
	for j = 1,#BaseBuildingsExt do 
		Utils.Do(BaseHoldingList, function(mb)
			if mb.rank == j then BaseBuildingsExt[mb.rank] = mb end
		end)
	end
	
	--local t = 0
	Utils.Do(BaseBuildingsExt, function(mb)
		if mb.mapactor ~= nil then 
			--t = t + 1
			--Trigger.AfterDelay(250 + 5 * t, function() UserInterface.SetMissionText(mb.id, player.Color) end)
			
			Trigger.OnKilled(mb.mapactor, function(a, _) 
				mb.exists = false
				for j = 1,#ExistingBuildings do
					if ExistingBuildings[j] == a then table.remove(ExistingBuildings, i) end
					if bdebug then UserInterface.SetMissionText(mb.id .." killed", player.Color) end
				end
			end) 
		end
	end)
	
	--Debug Message only
	if bdebug then
		local str = "Building rank: ".. #BaseHoldingList .."\n"
		local str2 = "Arranged building list: ".. #BaseBuildingsExt .."\n"
		Media.Debug("Building information created.")
		Utils.Do(BaseHoldingList, function(b)
			str = "\n".. str .." ".. b.rank .." ".. b.id .." ".. b.side .." ".. b.type .." ".. b.initrank .." ".. b.dist .."\n"
		end)
		Utils.Do(BaseBuildingsExt, function(mb)
			str2 = str2 .." ".. mb.id
		end)
		Trigger.AfterDelay(200, function() 
			UserInterface.SetMissionText(str .."\n".. str2, player.Color)
		end)
	end
end



BuildNewBase = function(cty) -- yard
	Media.Debug("Finding ConYard for ".. CheckOwnerSide(cty))
	local newyardid = FindACYard(cty)
	if newyardid ~= 0 then
		Media.Debug("ConYard [".. newyardid .."] found for ".. CheckOwnerSide(cty))

		Trigger.OnDamaged(ConstructionYards[newyardid], function(building)
			if building.Health < building.MaxHealth * 0.9 then
				building.StartBuildingRepairs()
			end
		end)
		
		if cty == pl_ussr then 
			Trigger.OnInfiltrated(ConstructionYards[newyardid], ConyardInfiltrated)
		end
		
		BuildBase(ConstructionYards[newyardid])
	else
		-- periodic recheck
		Trigger.AfterDelay(1000, function() BuildNewBase(cty) end)
	end
end


BuildBase = function(yard) -- yard
	if not CheckForCYard(yard) then
		return
	end

	local newfty = #ProducedUnitTypes + 1
	table.insert(ProducedUnitTypes, {factory = yard, types = "", curr_production = "", progress = 0} )
	local newfact = ProducedUnitTypes[newfty]
	
	local h = yard.Owner
	AIBaseBehavior(h)
	h_priority = GetOwnerPriority(h)
	
	-- Check prereqs
	local validstructureList = { }
	Utils.Do(BaseBuildingsExt, function(tt)
		local meetsprereq = true
		if #tt.prereq > 0 then
			Utils.Do(tt.prereq, function(ttp)
				if meetsprereq then meetsprereq = CheckOwnerType(tt.owner, ttp) end
			end)
		end
		
		if meetsprereq then
			validstructureList[#validstructureList + 1] = tt
		end
	end)
	
	Media.Debug("Considering building construction for ".. CheckOwnerSide(h) .." with priority: ".. h_priority)
	for i,v in ipairs(validstructureList) do
		if not v.exists and v.owner == h and (h_priority == "anything" or v.priority == h_priority) then
			Media.Debug(CheckOwnerSide(h) .." decided to build: [".. v.id .."] ".. v.type)
			
			-- apply speedhax
			local buildtime = Actor.BuildTime(v.type)
			-- Soviet vs Allied adjustment for difficulty
			if CheckOwnerSide(h) == "allies" then
				buildtime = buildtime * AlliedBuildTimeMultiplier
			else
				buildtime = buildtime * SovietBuildTimeMultiplier
			end

			BuildBuilding(v, h, yard, newfact, buildtime)
			return
		end
	end

	-- periodic recheck
	Trigger.AfterDelay(500, function() BuildBase(yard) end)
end


BuildBuilding = function(building, h, yard, newfact, buildtime)
	
	local delay = 5
	newfact.curr_production = building.type
	
	-- refund
	if not CheckForCYard(yard) then
		AddMoney(yard.Owner, building.cost * newfact.progress / 100000)
		newfact.curr_production = ""
		newfact.progress = 0
		return
	end
	
	local expense = building.cost * delay / buildtime
	if AddMoney(yard.Owner, -expense) then
		newfact.progress = newfact.progress + 100000 * delay / buildtime
	end
	
	if newfact.progress >= 100000 then
		FinalizeBuilding(building, h, yard, newfact)
		newfact.curr_production = ""
		newfact.progress = 0
	else
		Trigger.AfterDelay(delay, function() BuildBuilding(building, h, yard, newfact, buildtime) end)
	end
	
end
	
FinalizeBuilding = function(building, h, yard, newfact)
	--Finished construction
	--Trigger.AfterDelay(Actor.BuildTime(building.type) / 10, function()
		--if not CheckForCYard(yard) then
		--	return
		--end
		local actor = Actor.Create(building.type, true, { Owner = h, Location = yard.Location + CVec.New(building.pos.x, building.pos.y) })
		
		--h.Cash = h.Cash - building.cost
		
		Media.Debug("Structure completed for ".. building.side ..": [".. building.id .."] ".. building.type .." at (".. building.pos.x ..",".. building.pos.y ..")")
		building.exists = true
		ExistingBuildings[#ExistingBuildings + 1] = actor
		
		if building.priority == "production" then
			local newfty = #ProducedUnitTypes + 1
			local productiontypes = MakeProductionTypes(building.type, building.side)
			local str = actor.Type .." of ".. building.side ..":"
			Utils.Do(productiontypes, function(s)
				str = str .." ".. s.type
			end)
			Media.Debug(str)
			
			table.insert(ProducedUnitTypes, {factory = actor, types = productiontypes, curr_production = "", progress = 0} )
			SetupFactories(newfty)
			ProduceUnits(ProducedUnitTypes[newfty])
		end
		
		Trigger.OnKilled(actor, function(a, _) 
			building.exists = false 
			for i = 1,#ExistingBuildings do
				if ExistingBuildings[i] == a then table.remove(ExistingBuildings, i) end
			end
		end)
		Trigger.OnDamaged(actor, function(building)
			if building.Health < building.MaxHealth * 0.9 then
				building.StartBuildingRepairs()
			end
		end)

		Trigger.AfterDelay(5, function() BuildBase(yard) end)
	--end)
end

SetExistingProductionBuilding = function(actor)
	
	local newfty = #ProducedUnitTypes + 1
	local productiontypes = MakeProductionTypes(actor.Type, CheckOwnerSide(actor.Owner))
	local str = actor.Type .." of ".. CheckOwnerSide(actor.Owner) ..":"
	Utils.Do(productiontypes, function(s)
		str = str .." ".. s.type
	end)
	Media.Debug(str)
	
	table.insert(ProducedUnitTypes, {factory = actor, types = productiontypes, curr_production = "", progress = 0} )
	SetupFactories(newfty)
	ProduceUnits(ProducedUnitTypes[newfty])
	
	Trigger.OnDamaged(actor, function(building)
		if building.Health < building.MaxHealth * 0.9 then
			building.StartBuildingRepairs()
		end
	end)
end


MakeProductionTypes = function(t, s) -- t = building type, s = side
	local ProduceList = { }

	Utils.Do(UnitsMasterTable, function(mu)
		if mu.factory == t and mu.side == s then
			for i = 1, mu.weight do
				table.insert(ProduceList, mu)
			end
		end
	end)
	
	return ProduceList
end


-- Production of units from factory
BuildUnit = function(chosenone, factory, newfact, buildtime)
	
	local delay = 5
	newfact.curr_production = chosenone.type
	
	-- refund
	if factory.IsDead then
		AddMoney(factory.Owner, chosenone.cost * newfact.progress / 100000)
		newfact.curr_production = ""
		newfact.progress = 0
		return
	end
	
	local expense = chosenone.cost * delay / buildtime
	if AddMoney(factory.Owner, -expense) then
		newfact.progress = newfact.progress + 100000 * delay / buildtime
	end
	
	if newfact.progress >= 100000 then
		FinalizeUnit(chosenone.type, factory, newfact)
		newfact.curr_production = ""
		newfact.progress = 0
	else
		Trigger.AfterDelay(delay, function() BuildUnit(chosenone, factory, newfact, buildtime) end)
	end
	
end

ProduceUnits = function(t)
	local factory = t.factory
	
	if factory.Type == "fact" then return end --different handling for Construction Yards
	if (not factory.IsDead) and #t.types > 0 then
		
		local numproc = 0
		local harvlist = { }
		-- Check for harvesters
		--if CheckOwnerType(factory.Owner, "proc") and factory.Type == "weap" then
		Utils.Do(ExistingBuildings, function(a)
			if a.Owner == factory.Owner and a.Type == "proc" then numproc = numproc + 1 end
		end)
		if numproc > 0 then
			harvlist = factory.Owner.GetActorsByType("harv") --Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor) return actor.Type == "harv" and actor.Owner == factory.Owner end)
		end
		
		local validunitList = { }
		if #harvlist < numproc and factory.Type == "weap" then
			validunitList = { { type = "harv", factory = "weap", prereq = {}, side = CheckOwnerSide(factory.Owner), weight = 0, cost = 1400 } } 
		else
			-- Check prereqs
			Utils.Do(t.types, function(tt)
				local meetsprereq = true
				if #tt.prereq > 0 then
					Utils.Do(tt.prereq, function(ttp)
						if meetsprereq then meetsprereq = CheckOwnerType(factory.Owner, ttp) end
					end)
				end
				
				if meetsprereq then
					validunitList[#validunitList + 1] = tt
				end
			end)
		end
		
		local chosenone = validunitList[Utils.RandomInteger(1, #validunitList + 1)]
		local unitType = chosenone.type
		Media.Debug(factory.Type.. " decided to build: ".. unitType)

		-- too many doge.
		local buildtime = Actor.BuildTime(unitType)
		if unitType == "dog" then
			buildtime = buildtime * DogTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02})
		elseif unitType == "yak" or unitType == "mig" or unitType == "hind" then
			buildtime = buildtime * AircraftTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02})
		else
			-- Soviet vs Allied adjustment for difficulty
			if CheckOwnerSide(factory.Owner) == "allies" then
				buildtime = buildtime * AlliedBuildTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02})
			else
				buildtime = buildtime * SovietBuildTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02})
			end
		end
		
		BuildUnit(chosenone, factory, t, buildtime)
	end
end		
		
FinalizeUnit = function(unitType, factory, t)
	factory.Produce(unitType)
	factory.CallFunc(function() ProduceUnits(t) end)
end

-- Factory setup to produce
SetupFactories = function(i)
	if i == 0 then
		Utils.Do(ProducedUnitTypes, function(production)
			local fty = production.factory
			if fty.Type == "fact" then return end --different handling for Construction Yards
			if not fty.IsDead then
				Trigger.OnProduction(fty, function(_, a) DecisionMaker(fty, a) end)
			end
		end)
	else
		local fty = ProducedUnitTypes[i].factory
		if not fty.IsDead then
			Trigger.OnProduction(fty, function(_, a) DecisionMaker(fty, a) end)		
		end
	end
end


-- All houses to repair structures
StructureRepair = function(cty,n) -- cty is house, n is the fraction of health to start repairing

	Utils.Do(Map.NamedActors, function(actor)
		if actor.Owner == cty and actor.HasProperty("StartBuildingRepairs") then
			Trigger.OnDamaged(actor, function(building)
				if building.Owner == cty and building.Health < n * building.MaxHealth then
					building.StartBuildingRepairs()
				end
			end)
		end
	end)
end


--PlayerPowerSituation = function(cty, newstrvalue)
	

