shapeTypes		=	{
					"o",
					"i",
					"s",
					"z",
					"l",
					"j",
					"t"
					}

shapeTemplates	=	{
					o = {{false, false, false, false}, {false, true, true, false}, {false, true, true, false}, {false, false, false, false}},
					i = {{false, true, false, false}, {false, true, false, false}, {false, true, false, false}, {false, true, false, false}},
					s = {{true, false, false}, {true, true, false}, {false, true, false}},
					z = {{false, true, false}, {true, true, false}, {true, false, false}},
					l = {{true, true, false}, {false, true, false}, {false, true, false}},
					j = {{false, true, true}, {false, true, false}, {false, true, false}},
					t = {{false, true, false}, {true, true, true}, {false, false, false}}
					}

style = {spawnX = 4, spawnY = 0, areaX = 1, areaY = 4}

Game = {}

Game.new = function(player)
	return function(xPos)
		return function(yPos)
			local game = {x = xPos, y = yPos, player = player, score = 0, level = 1, playing = false, counter = 21}
			game.area = TetrisArea.new(10)(20)
			game.shape = false
			game.control = Actor.Create("control", true, {Owner = player, Location = CPos.New(xPos, yPos)})
			game.newShape = function()
				local shapeType = Utils.Random(shapeTypes)
				local template = Utility.dCopy(shapeTemplates[shapeType])
				game.shape = TetrisShape.new(shapeType)(template)(game.x + style.spawnX)(game.y + style.spawnY)
			end
			game.updateLevel = function()
				while (game.score >= math.pow(game.level, 2) * 200) do
					game.level = game.level + 1
					if (game.counter > 5) then
						game.counter = game.counter - 1
					end
				end
			end
			game.freezeShape = function()
				local xPos = game.shape.x - game.x - style.areaX
				local yPos = game.shape.y - game.y - style.areaY
				for y = 1, #game.shape.shape do
					for x = 1, #game.shape.shape do
						if (game.shape.shape[y][x]) then
							if (yPos + y < 1) then
								game.playing = false
								Media.DisplayMessage(game.player.Name .. " has failed!", "")
							else
								game.area.setGrid(xPos + x)(yPos + y)(game.shape.shape[y][x])
							end
						end
					end
				end
				game.shape = false
				local lines = game.area.removeFullRows(game.x + style.areaX)(game.y + style.areaY)
				local points = game.level + 1
				if (lines == 1) then
					points = points * 40
				elseif (lines == 2) then
					points = points * 100
				elseif (lines == 3) then
					points = points * 300
				elseif (lines == 4) then
					points = points * 1200
				else
					points = 0
				end
				game.score = game.score + points
				game.updateLevel()
			end
			game.validShapePosition = function()
				local xPos = game.shape.x - game.x - style.areaX
				local yPos = game.shape.y - game.y - style.areaY
				for y = 1, #game.shape.shape do
					for x = 1, #game.shape.shape do
						if (game.shape.shape[y][x]) then
							if (yPos + y > 20 or game.area.occupied(xPos + x)(yPos + y) or not Utility.between(xPos + x)(1)(10)) then			
								return false
							end
						end
					end
				end
				return true
			end
			game.moveShapeLeft = function()
				game.shape.moveX(-1)
				if (not game.validShapePosition()) then
					game.shape.moveX(1)
				end
				game.shape.render(game.y + style.areaY)
			end
			game.rotateShape = function()
				game.shape.rotateRight()
				if (not game.validShapePosition()) then
					game.shape.rotateLeft()
				end
				game.shape.render(game.y + style.areaY)
			end
			game.moveShapeRight = function()
				game.shape.moveX(1)
				if (not game.validShapePosition()) then
					game.shape.moveX(-1)
				end
				game.shape.render(game.y + style.areaY)
			end
			game.moveShapeDown = function()
				game.shape.moveY(1)
				if (not game.validShapePosition()) then
					game.shape.moveY(-1)
					game.freezeShape()
				else
					game.shape.render(game.y + style.areaY)
				end
			end
			game.hardDropShape = function()
				while (game.validShapePosition()) do
					game.shape.moveY(1)
				end
				game.shape.moveY(-1)
				game.shape.render(game.y + style.areaY)
				game.freezeShape()
			end
			Trigger.OnProduction(game.control,
				function(producer, produced)
					local pType = produced.Type
					produced.Destroy()
					if (game.shape and game.playing) then
						if (pType == "move_left") then
							game.moveShapeLeft()
						elseif (pType == "rotate") then
							game.rotateShape()
						elseif (pType == "move_right") then
							game.moveShapeRight()
						elseif (pType == "move_down") then
							game.moveShapeDown()
						elseif (pType == "hard_drop") then
							game.hardDropShape()
						end
					end
				end)
			game.tick = function(count)
				if (game.playing) then
					if (count % game.counter == 0) then
						if (game.shape) then
							game.shape.render(game.y + style.areaY)
							game.moveShapeDown()
						else
							game.newShape()
						end
					end
				end
			end
			return game
		end
	end
end
