Area = {}

Area.new = function(width)
	return function(height)
		local area = {width = width, height = height, grid = {}}
		for y = 1, height do
			area.grid[y] = {}
			for x = 1, width do
				area.grid[y][x] = false
			end
		end
		area.occupied = function(xPos)
			return function(yPos)
				if (Utility.between(xPos)(1)(10) and Utility.between(yPos)(1)(20) and area.grid[yPos][xPos]) then
					return true
				end
				return false
			end
		end
		area.setGrid = function(xPos)
			return function(yPos)
				return function(value)
					area.grid[yPos][xPos] = value
				end
			end
		end
		return area
	end
end
