Block = {}

Block.new = function(blockType)
	local block = {type = blockType, actor = false}
	block.render = function (owner)
		return function(xPos)
			return function(yPos)
				if (block.actor) then
					block.actor.Teleport(CPos.New(xPos, yPos))
				else
					block.actor = Actor.Create(block.type .. "_block", true, {Owner = owner, Location = CPos.New(xPos, yPos)})
				end
			end
		end
	end
	block.derender = function()
		if (block.actor) then
			block.actor.Destroy()
			block.actor = false
		end
	end
	return block
end
