Reinforcements = {
	{"light_inf","light_inf","light_inf","trooper","trooper"},
	{"quad","trike","light_inf", "light_inf"},
	{"trooper","trooper","trooper","trooper"},
	}
ReinforcementLocations={}

Tick = function()
--needed for harkonnen airdrop powers
	local tmp = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, 
			function(act)
				if act.Type=="waypoint_dummy" and noDuplicate(act,ReinforcementLocations)then
					if act.Owner==atreides then
						dropAirReinforcements(act.Location,1)
					elseif act.Owner==harkonnen then
						dropAirReinforcements(act.Location,2)
					elseif act.Owner==ordos then
						dropAirReinforcements(act.Location,3)
					end
					table.insert(ReinforcementLocations, act)
				end
			end
		)
end

function noDuplicate(actor, actorlist)
  for _, value in pairs(actorlist) do
    if value == actor then
      return false
    end
  end
  return true
end

function dropAirReinforcements(location,squad)
	--Carryall reinforcements
	local path = {ReinforcementBase[squad],location}
	local units = Reinforcements.ReinforceWithTransport(harkonnen, "carryall", HarkonnenReinforcements[squad], path, {path[2], path[1]})
	--reset spectator candy timer
	--T_reset[squad] = DateTime.GameTime
end

WorldLoaded = function()
Media.DisplayMessage("World loaded", "debug")

--players
atreides = Player.GetPlayer("Multi0")
harkonnen= Player.GetPlayer("Multi1")
ordos    = Player.GetPlayer("Multi2")

--focusing camera on starting position
if atreides and atreides.IsLocalPlayer then
	Camera.Position = Actor150.CenterPosition
elseif harkonnen and harkonnen.IsLocalPlayer then
	Camera.Position = Actor177.CenterPosition	
elseif ordos and ordos.IsLocalPlayer then 
	Camera.Position = Actor112.CenterPosition
end

ReinforcementBase={Actor210.Location, Actor211.Location, Actor212.Location}

Media.DisplayMessage("success", "debug")
end