OrdosReinforcements = { }
OrdosReinforcements["easy"] =
{
	{ "light_inf", "light_inf", "light_inf" },
	{ "light_inf", "light_inf", "trike" },
	{ "light_inf", "light_inf", "light_inf", "light_inf", "trike" }
}

OrdosReinforcements["normal"] =
{
	{ "light_inf", "light_inf", "trike" },
	{ "light_inf", "light_inf", "light_inf", "light_inf" },
	{ "light_inf", "light_inf", "light_inf", "trike", "trike" }
}

OrdosReinforcements["hard"] =
{
	{ "trike", "trike" },
	{ "light_inf", "light_inf", "light_inf", "trike", "trike" },
	{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "trike", "trike" },
}

OrdosPaths =
{
	{ OrdosEntry1.Location, OrdosRally1.Location },
	{ OrdosEntry2.Location, OrdosRally2.Location }
}

HarkonnenReinforcements = { }
HarkonnenReinforcements["easy"] =
{
	{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
	{ "light_inf", "trike", "light_inf", "trike" },
	{ "light_inf", "light_inf", "trike", "trike", "trike" }
}

HarkonnenReinforcements["normal"] =
{
	{ "light_inf", "trike" },
	{ "light_inf", "trike" },
	{ "light_inf", "light_inf", "light_inf", "trike", "trike" },
	{ "light_inf", "light_inf" },
	{ "light_inf", "light_inf", "light_inf" },
	{ "light_inf", "trike" },
}

HarkonnenReinforcements["hard"] =
{
	{ "trike", "trike" },
	{ "light_inf", "trike", "trike" },
	{ "light_inf", "light_inf", "trike", "trike" },
	{ "light_inf", "light_inf", "light_inf", "trike", "trike" },
	{ "light_inf", "light_inf", "light_inf", "light_inf" },
	{ "light_inf", "light_inf", "light_inf", "light_inf", "trike", "trike" },
	{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
	{ "light_inf", "trike", "trike" },
	{ "trike", "trike" }
}

HarkonnenAttackPaths =
{
	{ HarkonnenEntry1.Location, HarkonnenRally1.Location },
	{ HarkonnenEntry1.Location, HarkonnenRally3.Location },
	{ HarkonnenEntry2.Location, HarkonnenRally2.Location },
	{ HarkonnenEntry2.Location, HarkonnenRally4.Location }
}

HarkonnenAttackDelay = { }
HarkonnenAttackDelay["easy"] =DateTime.Seconds(20)
HarkonnenAttackDelay["normal"] = DateTime.Minutes(1) + DateTime.Seconds(40)
HarkonnenAttackDelay["hard"] = DateTime.Minutes(1) + DateTime.Seconds(30)

HarkonnenAttackWaves = { }
HarkonnenAttackWaves["easy"] = 3
HarkonnenAttackWaves["normal"] = 6
HarkonnenAttackWaves["hard"] = 9

OrdosDelay = { }
OrdosDelay["easy"] = DateTime.Seconds(10)
OrdosDelay["normal"] = DateTime.Minutes(1) + DateTime.Seconds(10)
OrdosDelay["hard"] = DateTime.Minutes(1) + DateTime.Seconds(10)

OrdosWaves = { }
OrdosWaves["easy"] = 2
OrdosWaves["normal"] = 4
OrdosWaves["hard"] = 6

ToHarvest = { }
ToHarvest["easy"] = 3500
ToHarvest["normal"] = 4000
ToHarvest["hard"] = 6000


Messages =
{
	"Build a concrete foundation before placing your buildings.",
	"Build a Wind Trap for power.",
	"Build a Refinery to collect Spice.",
	"Build a Silo to store additional Spice."
}

wave = 0
SendHarkonnen = function()
	Trigger.AfterDelay(HarkonnenAttackDelay[Map.LobbyOption("difficulty")], function()
		wave = wave + 1
		if wave > HarkonnenAttackWaves[Map.LobbyOption("difficulty")] then
			Trigger.AfterDelay(DateTime.Seconds(1), function() HarkonnenArrived = true end)
			return
		end

		local path = Utils.Random(HarkonnenAttackPaths)
		local units = Reinforcements.ReinforceWithTransport(harkonnen, "carryall.reinforce", HarkonnenReinforcements[Map.LobbyOption("difficulty")][wave], path, { path[1] })[2]
		Utils.Do(units, IdleHunt)
		--Utils.Do(units, function(unit) Trigger.OnAddedToWorld(unit, IdleHunt) end)
		SendHarkonnen()
	end)
end

ordosWave = 0
SendOrdos = function()
	Trigger.AfterDelay(OrdosDelay[Map.LobbyOption("difficulty")], function()
		Media.PlaySpeechNotification(player, "Reinforce")
		ordosWave = ordosWave + 1
		if ordosWave > OrdosWaves[Map.LobbyOption("difficulty")] then
			return
		end

		local path = Utils.Random(OrdosPaths)
		local units = Reinforcements.ReinforceWithTransport(player, "carryall.reinforce", OrdosReinforcements[Map.LobbyOption("difficulty")][ordosWave], path, { path[1] })[2]
		SendOrdos()
	end)
end

IdleHunt = function(unit)
	Trigger.OnIdle(unit, unit.Hunt)
end

Tick = function()
	if HarkonnenArrived and harkonnen.HasNoRequiredUnits() and not player.IsObjectiveCompleted(KillHarkonnen) then
		Media.DisplayMessage("The Harkonnen have been annihilated!", "Mentat")
		player.MarkCompletedObjective(KillHarkonnen)
	end
	
	if player.HasNoRequiredUnits() then
		harkonnen.MarkCompletedObjective(KillOrdos)
	end

	--if harkonnen.HasNoRequiredUnits() and not player.IsObjectiveCompleted(KillHarkonnen) then
		--Media.DisplayMessage("The Harkonnen have been annihilated!", "Mentat")
		--player.MarkCompletedObjective(KillHarkonnen)
	--end
	
	if player.Resources > ToHarvest[Map.LobbyOption("difficulty")] - 1 then
		player.MarkCompletedObjective(GatherSpice)
	end

	-- player has no Wind Trap
	if (player.PowerProvided <= 20 or player.PowerState ~= "Normal") and DateTime.GameTime % DateTime.Seconds(32) == 0 then
		HasPower = false
		Media.DisplayMessage(Messages[2], "Mentat")
	else
		HasPower = true
	end

	-- player has no Refinery and no Silos
	if HasPower and player.ResourceCapacity == 0 and DateTime.GameTime % DateTime.Seconds(32) == 0 then
		Media.DisplayMessage(Messages[3], "Mentat")
	end

	if HasPower and player.Resources > player.ResourceCapacity * 0.8 and DateTime.GameTime % DateTime.Seconds(32) == 0 then
		Media.DisplayMessage(Messages[4], "Mentat")
	end

	UserInterface.SetMissionText("Harvested resources: " .. player.Resources .. "/" .. ToHarvest[Map.LobbyOption("difficulty")], player.Color)
end

WorldLoaded = function()
	harkonnen = Player.GetPlayer("Harkonnen")
	player = Player.GetPlayer("Ordos")

	InitObjectives()

	Camera.Position = OrdosConyard.CenterPosition
	Trigger.OnRemovedFromWorld(OrdosConyard, function()
		local refs = Utils.Where(Map.ActorsInWorld, function(actor) return actor.Type == "refinery" end)

		if #refs == 0 then
			harkonnen.MarkCompletedObjective(KillOrdos)
		else
			Trigger.OnAllRemovedFromWorld(refs, function()
				harkonnen.MarkCompletedObjective(KillOrdos)
			end)
		end
	end)

	WavesLeft = HarkonnenAttackWaves[Map.LobbyOption("difficulty")]
	WavesLeft = WavesLeft - 1
		if WavesLeft == 0 then
			Trigger.AfterDelay(DateTime.Seconds(1), function() HarkonnenArrived = true end)
		else
			SendHarkonnen()
		end
	SendOrdos()
end

InitObjectives = function()
	Trigger.OnObjectiveAdded(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)

	KillOrdos = harkonnen.AddPrimaryObjective("Kill all Ordos units.")
	GatherSpice = player.AddPrimaryObjective("Harvest " .. tostring(ToHarvest[Map.LobbyOption("difficulty")]) .. " Solaris worth of Spice.")
	KillHarkonnen = player.AddSecondaryObjective("Eliminate all Harkonnen units and reinforcements\nin the area.")

	Trigger.OnObjectiveCompleted(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)

	Trigger.OnPlayerLost(player, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(player, "Lose")
		end)
	end)
	Trigger.OnPlayerWon(player, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(player, "Win")
		end)
	end)
end
