MutantTeam1 = { "c12" }
MutantTeam2 = { "c11" }
MutantTeam3 = { "c9" }
MutantTeam4 = { "c8" }
MutantTeam5 = { "c7" }
MutantTeam6 = { "c6" }
MutantTeam7 = { "c5" }
MutantTeam8 = { "c4" }
MutantTeam9 = { "c3" }
MutantTeam10 = { "c2" }
MutantTeam11 = { "c1" }
MutantTeam12 = { "c10" }

Wave = 0
Waves =
{
	{ delay = 500, units = { MutantTeam1 } },
	{ delay = 500, units = { MutantTeam2 } },
	{ delay = 500, units = { MutantTeam3 } },
	{ delay = 500, units = { MutantTeam4 } },
	{ delay = 500, units = { MutantTeam5 } },
	{ delay = 500, units = { MutantTeam6 } },
	{ delay = 500, units = { MutantTeam7 } },
	{ delay = 500, units = { MutantTeam8 } },
	{ delay = 500, units = { MutantTeam9 } },
	{ delay = 500, units = { MutantTeam10 } },
	{ delay = 500, units = { MutantTeam11 } },
	{ delay = 500, units = { MutantTeam12 } },
	{ delay = 500, units = { MutantTeam2 } },
	{ delay = 500, units = { MutantTeam3 } },
	{ delay = 500, units = { MutantTeam4 } },
	{ delay = 500, units = { MutantTeam5 } },
	{ delay = 500, units = { MutantTeam6 } },
	{ delay = 500, units = { MutantTeam7 } },
	{ delay = 500, units = { MutantTeam8 } },
	{ delay = 500, units = { MutantTeam9 } },
	{ delay = 500, units = { MutantTeam10 } },
	{ delay = 500, units = { MutantTeam11 } },
	{ delay = 500, units = { MutantTeam12 } }
}
EntryPoints = { EntryPoint, EntryPoint1, EntryPoint2, EntryPoint3, EntryPoint4, EntryPoint5, EntryPoint6, EntryPoint7 }
MiddlePoints = { MiddlePoint, MiddlePoint1, MiddlePoint2, MiddlePoint3 }

SendWave = function()
	Wave = Wave + 1
	local wave = Waves[Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(EntryPoints).Location
			local target = Utils.Random(MiddlePoints).Location
			SendUnits(entry, units, target)
		end)
		if (Wave < #Waves) then
			local delay = Utils.RandomInteger(DateTime.Seconds(10), DateTime.Seconds(20))
			Trigger.AfterDelay(delay, SendWave)
		end
	end)

end

SendUnits = function(entryCell, unitTypes, targetCell)
	local units = Reinforcements.Reinforce(Mutants, unitTypes, { entryCell }, 40, function(a)
		if not a.HasProperty("AttackMove") then
			Trigger.OnIdle(a, function(a)
				a.Move(targetCell)
			end)
			return
		end

		Trigger.OnIdle(a, function(a)
			if a.Location ~= targetCell then
				a.Move(targetCell)
			else
				a.Hunt()
			end
		end)
	end)
end

MAXPLAYERCOUNT = 8

Teams =
{
	{ units = { "c1" },			entryCell = Actor147.Location, building = Actor110 },
	{ units = { "c2" }, 		entryCell = Actor148.Location, building = Actor104 },
	{ units = { "c3" }, 		entryCell = Actor149.Location, building = Actor112 },
	{ units = { "c4" }, 		entryCell = Actor154.Location, building = Actor106 },
	{ units = { "c5" }, 		entryCell = Actor166.Location, building = Actor82 },
	{ units = { "c6" }, 		entryCell = Actor198.Location, building = Actor136 },
	{ units = { "c7" },			entryCell = Actor199.Location, building = Actor81 },
	{ units = { "c8" }, 		entryCell = Actor200.Location, building = Actor111 },
	{ units = { "c9" },			entryCell = Actor201.Location, building = Actor126 },
	{ units = { "c11" }, 		entryCell = Actor202.Location, building = Actor87 },
	{ units = { "c12" }, 		entryCell = Actor203.Location, building = Actor85 },
	{ units = { "c10" }, 		entryCell = Actor203.Location, building = Actor110 }
}

CreateTeam = function(Team)
	if Team.building.IsDead then
		return
	end
	local units = Reinforcements.Reinforce(Mutants, Team.units, { Team.entryCell }, 25)
	SendTeam(units)
	Utils.Do(units, function(actor)
		if not actor.IsDead then
			Trigger.OnIdle(actor, actor.Hunt)
		end
	end)
	Trigger.AfterDelay(DateTime.Seconds(delayRepeatTeam), function()
		CreateTeam(Team)
	end)
end

SendTeam = function(units)
	local player = Utils.Random(players)
	local waypoint = Map.NamedActor("SPMulti"..tostring(player.Spawn - 1))	
	Utils.Do(units, function(unit)
		if not unit.IsDead then
			unit.AttackMove(waypoint.Location)
			unit.Hunt()
		end
	end)
end

WorldLoaded = function()
	Mutants = Player.GetPlayer("Mutants")
	players = { }
	for i = 1, MAXPLAYERCOUNT, 1 do
		local player = Player.GetPlayer("Multi" ..i-1)
		if player ~= nil then
			table.insert(players, player)
		end
	end
	if Map.Difficulty == "Mutants On" then
		Media.PlaySound("thunder3.aud")
		SendWave()
		delayRepeatTeam = 110 * (MAXPLAYERCOUNT + 2 - #players)
		Trigger.AfterDelay(DateTime.Seconds(30), function()
			CreateTeam(Teams[1])
		end)
		Trigger.AfterDelay(DateTime.Seconds(60), function()
			CreateTeam(Teams[2])
		end)
		Trigger.AfterDelay(DateTime.Minutes(3), function()
			CreateTeam(Teams[3])
		end)
		Trigger.AfterDelay(DateTime.Minutes(6), function()
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Media.PlaySound("thunder5.aud")
			Media.PlaySound("Rumble.aud")
			Media.PlaySound("Rumble.aud")
			CreateTeam(Teams[12])
			CreateTeam(Teams[8])
			CreateTeam(Teams[4])
		end)
		Trigger.AfterDelay(DateTime.Minutes(8), function()
			CreateTeam(Teams[5])
		end)
		Trigger.AfterDelay(DateTime.Minutes(12), function()
			CreateTeam(Teams[6])
		end)
		Trigger.AfterDelay(DateTime.Minutes(15), function()
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Media.PlaySound("thunder5.aud")
			Media.PlaySound("Rumble.aud")
			Media.PlaySound("Rumble.aud")
			CreateTeam(Teams[7])
			CreateTeam(Teams[8])
			CreateTeam(Teams[9])
		end)
		Trigger.AfterDelay(DateTime.Minutes(18), function()
			CreateTeam(Teams[10])
		end)
		Trigger.AfterDelay(DateTime.Minutes(26), function()
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Media.PlaySound("thunder5.aud")
			Media.PlaySound("Rumble.aud")
			Media.PlaySound("Rumble.aud")
			CreateTeam(Teams[5])
			CreateTeam(Teams[12])
			CreateTeam(Teams[7])
			CreateTeam(Teams[4])
		end)
		Trigger.AfterDelay(DateTime.Minutes(35), function()
			CreateTeam(Teams[11])
		end)
		Trigger.AfterDelay(DateTime.Minutes(41), function()
			CreateTeam(Teams[12])
		end)
		Trigger.AfterDelay(DateTime.Minutes(50), function()
			Lighting.Flash("LightningStrike", delay)
			Media.PlaySound("thunder5.aud")
			Media.PlaySound("Rumble.aud")
			Media.PlaySound("Rumble.aud")
			CreateTeam(Teams[5])
			CreateTeam(Teams[12])
			CreateTeam(Teams[7])
			CreateTeam(Teams[4])
			CreateTeam(Teams[11])
		end)
		Trigger.AfterDelay(DateTime.Minutes(70), function()
			Lighting.Flash("LightningStrike", delay)
			Media.PlaySound("thunder5.aud")
			Media.PlaySound("Rumble.aud")
			Media.PlaySound("Rumble.aud")
			CreateTeam(Teams[5])
			CreateTeam(Teams[12])
			CreateTeam(Teams[7])
			CreateTeam(Teams[4])
			CreateTeam(Teams[3])
			CreateTeam(Teams[6])
			CreateTeam(Teams[8])
		end)
	elseif Map.Difficulty == "Mutants Off" then
		return
	end
end

Tick = function()
	if (Utils.RandomInteger(1, 200) == 10) then
		local delay = Utils.RandomInteger(1, 10)
		Lighting.Flash("LightningStrike", delay)
		Trigger.AfterDelay(delay, function()
			Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
		end)
	end
	if (Utils.RandomInteger(1, 200) == 10) then
		Media.PlaySound("thunder-ambient.aud")
	end
end