ParadropWaypoints = { Paradrop1, Paradrop2, Paradrop3, Paradrop4 }
ParadropUnitTypes = { "RIFLE", "RIFLE", "RIFLE", "RIFLE", "RIFLE", "SARDAUKAR", "SARDAUKAR" }

ParadropAWaypoints = { ParadropA1, ParadropA2, ParadropA3, ParadropA4 }
ParadropAUnitTypes = { "RIFLE", "RIFLE", "GRENADIER", "GRENADIER", "FREMEN" }


SetupAtreidesUnits = function()
	Utils.Do(Map.NamedActors, function(a)
		if a.Owner == atreides and a.HasProperty("AcceptsUpgrade") and a.AcceptsUpgrade("unkillable") then
			a.GrantUpgrade("unkillable")
			a.Stance = "Defend"
		end
	end)
end

ParadropHarkonnenUnits = function()
	local lz = Utils.Random(ParadropWaypoints).Location
	local start = Map.CenterOfCell(Map.RandomEdgeCell()) + WVec.New(0, 0, Actor.CruiseAltitude("badr"))
	local transport = Actor.Create("badr", true, { CenterPosition = start, Owner = harkonnen, Facing = (Map.CenterOfCell(lz) - start).Facing })

	Utils.Do(ParadropUnitTypes, function(type)
		local a = Actor.Create(type, false, { Owner = harkonnen })
		BindActorTriggers(a)
		transport.LoadPassenger(a)
	end)

	transport.Paradrop(lz)
	Trigger.AfterDelay(DateTime.Seconds(5), ParadropHarkonnenUnits)
end

ParadropAtreidesUnits = function()
	local lz = Utils.Random(ParadropAWaypoints).Location
	local start = Map.CenterOfCell(Map.RandomEdgeCell()) + WVec.New(0, 0, Actor.CruiseAltitude("badr"))
	local transport = Actor.Create("badr", true, { CenterPosition = start, Owner = atreides, Facing = (Map.CenterOfCell(lz) - start).Facing })

	Utils.Do(ParadropAUnitTypes, function(type)
		local a = Actor.Create(type, false, { Owner = atreides })
		BindActorTriggers(a)
		transport.LoadPassenger(a)
	end)

	transport.Paradrop(lz)
	Trigger.AfterDelay(DateTime.Seconds(5), ParadropAtreidesUnits)
end

BindActorTriggers = function(a)
	--if a.HasProperty("Hunt") then
	--	if a.Owner == harkonnen then
			Trigger.OnIdle(a, a.Hunt)		
	--	end
	--end
end

WorldLoaded = function()
	atreides = Player.GetPlayer("Atreides")
	harkonnen = Player.GetPlayer("Harkonnen")

	SetupAtreidesUnits()
	ParadropHarkonnenUnits()
	ParadropAtreidesUnits()
	--SendUnits(Entry1.Location, UnitTypes, 50)
end