ToHarvest = 3500
HarkonnenReinforcements = {
	{"light_inf","light_inf","light_inf","light_inf"},
	{"quad","trooper", "trooper"},
	{"combat_tank_h"},
	{"engineer"}
	}
wave=0
harvesterDropped = false
SupportLocations={}

Tick = function()
	--spice-meter:
	UserInterface.SetMissionText("Stored resources: " .. atreides.Resources .. "/" .. ToHarvest, atreides.Color)
	
	--atreides victory?
	if atreides.Resources >= ToHarvest
		then atreides.MarkCompletedObjective(GatherSpice)
	end
	
	--harkonnen victory?
	--harvester killed check (add Trigger after harv arrives):
	if not harvesterDropped
		then
			local tmp = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, 
				function(actor)
					if actor.Type=="harvester"
						then 
							harvesterDropped = true
							Trigger.OnAllRemovedFromWorld({actor}, 
								function()
									harkonnen.MarkCompletedObjective(StopHarvestOperations)
								end
							)
							return actor
					else return actor
					end
				end
			)		
	end
	--needed for harkonnen airdrop powers
	for iter, act in pairs(harkonnen.GetActors()) 
	do 
		if act.Type=="waypoint_dummy_1" and noDuplicate(act) 
		then 
			dropHarkonnen(act.Location,1)
			table.insert(SupportLocations, act)
		elseif act.Type=="waypoint_dummy_2" and noDuplicate(act) 
		then 
			dropHarkonnen(act.Location,2)
			table.insert(SupportLocations, act)
		elseif act.Type=="waypoint_dummy_3" and noDuplicate(act)
		then 
			dropHarkonnen(act.Location,3)
			table.insert(SupportLocations, act)		
		end
	end
	
	--silo storage insufficient check:
	if atreides.ResourceCapacity < ToHarvest and atreides.ResourceCapacity ~= 0
		then harkonnen.MarkCompletedObjective(StopHarvestOperations)
	end	
end

function noDuplicate(location)
  for _, value in pairs(SupportLocations) do
    if value == location then
      return false
    end
  end
  return true
end

function dropHarkonnen(location,squad)
	--Carryall reinforcements
	local path = {EntryPoint.Location,location}
	local units = Reinforcements.ReinforceWithTransport(harkonnen, "carryall.reinforce", HarkonnenReinforcements[squad], path, {path[2], path[1]})
end

WorldLoaded = function()
	--players:
	harkonnen = Player.GetPlayer("Multi1")
	atreides = Player.GetPlayer("Multi0")

	
	--buildings:
	refinery = Actor29
	barracks = Actor26
	silos = {Actor24, Actor25, Actor27}
	damageBuildings()
	
	--units
	dropHarkonnen(ReinforceLeft.Location,4) 
	
	--obectives:
	if atreides.IsLocalPlayer 
	then
		Media.DisplayMessage("Harvest SPICE in this area.\nWe send you one HARVESTER to complete your mission, DO NOT LOSE it!\nAlso keep an eye on your SILOS, harkonnen forces are in the area.\n--Good luck! ","Your Mission",HSLColor.Blue)
	elseif harkonnen.IsLocalPlayer 
	then
		Media.DisplayMessage("Keep the atreides scum from harvesting enough spice.\nDESTROY their HARVESTER, REFIENRY or SILOS to stop them!\nThe Duke will send you reinforcements, but you should NOT make him regret his aid!","Your Mission",HSLColor.Red)
	end

	GatherSpice = atreides.AddPrimaryObjective("Harvest " .. tostring(ToHarvest) .. " Solaris worth of Spice.")
	StopHarvestOperations = harkonnen.AddPrimaryObjective("Stop the Atreides from storing enough Spice.")
	Trigger.OnObjectiveCompleted(atreides, 
		function(p, id)
			Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed") 
		end
	)
	Trigger.OnPlayerWon(atreides, 
		function() 
			Trigger.AfterDelay(DateTime.Seconds(1), 
				function() 
					Media.PlaySpeechNotification(atreides, "Win") 
				end
			)
		end
	)
	--harkonnen victory (refinery killed):
	Trigger.OnAllRemovedFromWorld({refinery}, 
		function()
			harkonnen.MarkCompletedObjective(StopHarvestOperations)
		end
	)


end

damageBuildings = function()
	refinery.Health = 0.49*refinery.MaxHealth 
	barracks.Health = 0.7*barracks.MaxHealth 
	for iter,silo in pairs(silos) 
		do silo.Health = 1.*silo.MaxHealth 
	end
end