--[ GLOBAL VARIABLES ]--

team1actors = {}
team2actors = {}

team1template = {}
team2template = {}

team1 = Player.GetPlayer( "Left" )
team2 = Player.GetPlayer( "Right" )
neutral = Player.GetPlayer( "Neutral" )
human = Player.GetPlayer( "Multi0" )
makeActors = {}
currentTeam = 1
simCounter = 0
simulating = true
simQueue = {}

--[ OPENRA FUNCTIONS ]--

function WorldLoaded()
	createMakeActors()
	attachMakeTriggers()
	updateSimCounter()
end

function createMakeActors()
	makeActors[ 1 ] = Actor.Create( "make_control",	 true,	 { Owner = human, Location = CPos.New( 1, 1 ) } )
	makeActors[ 2 ] = Actor.Create( "make_infantry",	 true,	 { Owner = human, Location = CPos.New( 1, 1 ) } )
	makeActors[ 3 ] = Actor.Create( "make_vehicle",	 true,	 { Owner = human, Location = CPos.New( 1, 1 ) } )
	makeActors[ 4 ] = Actor.Create( "make_air",			 true,	 { Owner = human, Location = CPos.New( 1, 1 ) } )
end

function attachMakeTriggers()
	for i, v in ipairs( makeActors ) do
		Trigger.OnProduction( v, function( producer, produced )
			produced.Destroy()
			if ( produced.Type == "switch_team" ) then
				switchTeam()
			elseif ( produced.Type == "run_sim" ) then
				if ( #simQueue > 0 ) then
					startSim()
				elseif ( #simQueue == 0 ) then
					Media.DisplayMessage( "To start a simulation you must queue at least 1 simulation!", "Warning" )
				end
			elseif ( produced.Type == "1sim" ) then
				addSims( 1 )
			elseif ( produced.Type == "10sim" ) then
				addSims( 10 )
			elseif ( produced.Type == "clear" ) then
				killEverythingNoExceptions()
			else
				local spawn = nil
				if ( currentTeam == 1 ) then
					spawn = team1spawn.Location
				else
					spawn = team2spawn.Location
				end
				spawnActor( string.sub( produced.Type, 7 ), human, spawn )
			end
		end)
	end
end

function switchTeam()
		if ( currentTeam == 1 ) then
		currentTeam = 2
		switchActorOwners( team2actors, human )
		switchActorOwners( team1actors, neutral )
	else
		currentTeam = 1
		switchActorOwners( team1actors, human )
		switchActorOwners( team2actors, neutral )
	end
end

function spawnActor( actorType, owner, spawn )
		local actor = Actor.Create( actorType, true,  { Owner = owner, Location = spawn } )
		if ( currentTeam == 1 ) then
			table.insert( team1actors, actor )
		else
			table.insert( team2actors, actor )
		end
end

function switchActorOwners( actors, owner )
	if ( not ( #actors == 0 ) ) then
		for i, v in ipairs( actors ) do
			v.Owner = owner
		end
	end
end

function startSim()
	killEverythingNoExceptions()
	sim()
end

function sim()
	team1actors = createActorsFromTemplates( simQueue[ 1 ].team1template )
	team2actors = createActorsFromTemplates( simQueue[ 1 ].team2template )
	convertTeams()
	addTriggers()
end

function addSims( number )
	if ( ( #team1actors > 0 ) and ( #team2actors > 0 ) ) then
		for i = 1, number do
			local simulation = { team1template = createTemplate( team1actors ), team2template = createTemplate( team2actors ) }
			table.insert( simQueue, simulation )
		end
		updateSimCounter()
	else
		Media.DisplayMessage( "To queue a simulation you must have units on both teams!", "Warning" )
	end
end

function destroyMakeActors()
	for i, v in ipairs( makeActors ) do
		v.Destroy()
	end
	makeActors = {}
end

function createTemplate( actors )
	local template = {}
	for i, v in ipairs( actors ) do
		template[ i ] = { Owner = v.Owner, Type = v.Type, Location = CPos.New( v.Location.X, v.Location.Y ) }
	end
	return template
end

function convertTeams()
	switchActorOwners( team1actors, team1 )
	switchActorOwners( team2actors, team2 )
end

function addTriggers()
	addOnAllKilledTrigger( team1actors, team2actors )
	addOnAllKilledTrigger( team2actors, team1actors )
	addIdleTriggers( team1actors, team2actors )
	addIdleTriggers( team2actors, team1actors )
end

function addOnAllKilledTrigger( actors, enemies )
	local filteredActors = filterOutTable( actors, onKilledExceptions )
	Trigger.OnAllKilled( filteredActors, function()
		if ( simulating ) then
			table.remove( simQueue, 1 )
			updateSimCounter()
			simulating = false
			killEverything()
			if ( #simQueue > 0 ) then
				sim()
			else
				endSim()
			end
		else
			simulating = true
		end
	end)
end

function endSim()
	team1actors =createActorsFromTemplates( team1template )
	team2actors =createActorsFromTemplates( team2template )
	createMakeActors()
	attachMakeTriggers()
	switchActorOwners( team2actors, neutral )
	switchActorOwners( team1actors, human )
	currentTeam = 1
end

function filterOutTable( t, crap )
	local aTable = {}
	for i, v in ipairs( t ) do
		if ( not ( Utils.Any(crap, function( element ) return ( v.Type == element )  end) ) ) then
			table.insert( aTable, v )
		end
	end
	return aTable
end

function addIdleTriggers( actors, enemyActors )
	for i, v in ipairs( actors ) do
		Trigger.OnIdle( v, function( v )
			if ( v.HasProperty( "Hunt" ) ) then
				if ( #enemyActors > 0 ) then
					local closestEnemy = findClosestActorPos( enemyActors, v )
					v.AttackMove( closestEnemy )
				end
			else
				local allyPos = randomActorPosition( actors, v )
				v.Move( allyPos )
				Trigger.AfterDelay( 100, v.Stop )
			end
		end)
	end
end

function findClosestActorPos( actors, actor )
	local closestEnemy = nil
	local distance = nil
	for i, v in ipairs( actors ) do
		if ( ( not  ( v.IsDead ) ) and ( not ( v == actor ) ) ) then
			if ( closestEnemy == nil ) then
				closestEnemy = v
				distance = getDistanceBetween( actor.Location, v.Location )
			elseif ( distance > getDistanceBetween( actor.Location, v.Location ) ) then
				closestEnemy = v
				distance = getDistanceBetween( actor.Location, v.Location )
			end
		end
	end
	if ( closestEnemy == nil ) then
		return CPos.New( 1, 1 )
	else
		return closestEnemy.Location
	end
end

function getDistanceBetween( pos1, pos2 )
	local distance = math.sqrt( math.pow( ( pos1.X - pos2.X ), 2) + math.pow( ( pos1.Y - pos2.Y ), 2 ) )
	return distance
end

function destroyActors( actors )
	for i, v in ipairs( actors ) do
		if ( not ( v.IsDead ) ) then
			v.Kill()
		end
	end
	actors = {}
end

function createActorsFromTemplates( template )
	local actors = {}
	for i, v in ipairs( template ) do
		local actor = Actor.Create( v.Type, true, { Owner = v.Owner, Location = v.Location } )
		table.insert( actors, actor)
	end
	return actors
end

function updateSimCounter()
	UserInterface.SetMissionText( "Queued Simulations: " .. #simQueue )
end

function randomActorPosition( actors, actor )
	local validActors = {}
	for i, v in ipairs( actors ) do
		if ( ( not ( v.IsDead ) ) and ( not ( v == actor ) ) ) then
			table.insert( validActors, v )
		end
	end
	if ( #validActors == 0 ) then
		return actor.Location
	else
		return Utils.Random( validActors ).Location
	end
end

function killEverything()
	local actors = Map.ActorsInBox( WPos.New( Map.TopLeft.X, Map.TopLeft.Y, 4000 ), Map.BottomRight, function( actor ) return ( not ( ( actor.Owner == human ) or ( actor.Owner == neutral ) ) ) end )
	destroyActors( actors )
end

function clear()
	killEverythingNoExceptions()
end

function killEverythingNoExceptions()
	local actors = Map.ActorsInBox( WPos.New( Map.TopLeft.X, Map.TopLeft.Y, 4000 ), Map.BottomRight )
	actors = filterOutTable( actors, killEverythingExceptions )
	destroyActors( actors )
end