--[ GLOBAL VARIABLES ]--

team1actors = {}
team2actors = {}

team1template = {}
team2template = {}

team1 = Player.GetPlayer( "Left" )
team2 = Player.GetPlayer( "Right" )
neutral = Player.GetPlayer( "Neutral" )
human = Player.GetPlayer( "Multi0" )
makeActors = {}
currentTeam = 1
simCounter = 0

--[ OPENRA FUNCTIONS ]--

function WorldLoaded()
	createMakeActors()
	attachMakeTriggers()
end

function createMakeActors()
	makeActors[ 1 ] = Actor.Create( "make_control",	 true,	 { Owner = human, Location = CPos.New( 1, 1 ) } )
	makeActors[ 2 ] = Actor.Create( "make_infantry",	 true,	 { Owner = human, Location = CPos.New( 1, 1 ) } )
	makeActors[ 3 ] = Actor.Create( "make_vehicle",	 true,	 { Owner = human, Location = CPos.New( 1, 1 ) } )
	makeActors[ 4 ] = Actor.Create( "make_air",			 true,	 { Owner = human, Location = CPos.New( 1, 1 ) } )
end

function attachMakeTriggers()
	for i, v in ipairs( makeActors ) do
		Trigger.OnProduction( v, function( producer, produced )
			produced.Destroy()
			if ( produced.Type == "switch_team" ) then
				switchTeam()
			elseif ( produced.Type == "run_sim" ) then
				if ( ( #team1actors > 0 ) and ( #team2actors > 0 ) ) then
					simCounter = 1
					startSim()
				else
					Media.DisplayMessage( "To start a simulation you must have units on both teams!" )
				end
			else
				local spawn = nil
				if ( currentTeam == 1 ) then
					spawn = team1spawn.Location
				else
					spawn = team2spawn.Location
				end
				spawnActor( string.sub( produced.Type, 7 ), human, spawn )
			end
		end)
	end
end

function switchTeam()
		if ( currentTeam == 1 ) then
		currentTeam = 2
		switchActorOwners( team2actors, human )
		switchActorOwners( team1actors, neutral )
	else
		currentTeam = 1
		switchActorOwners( team1actors, human )
		switchActorOwners( team2actors, neutral )
	end
end

function spawnActor( actorType, owner, spawn )
		local actor = Actor.Create( actorType, true,  { Owner = owner, Location = spawn } )
		if ( currentTeam == 1 ) then
			table.insert( team1actors, actor )
		else
			table.insert( team2actors, actor )
		end
end

function switchActorOwners( actors, owner )
	if ( not ( #actors == 0 ) ) then
		for i, v in ipairs( actors ) do
			v.Owner = owner
		end
	end
end

function startSim()
	destroyMakeActors()
	team1template = createTemplate( team1actors )
	team2template = createTemplate( team2actors )
	convertTeams()
	addTriggers()
end

function sim()
	createActorsFromTemplates()
	addTriggers()
end

function destroyMakeActors()
	for i, v in ipairs( makeActors ) do
		v.Destroy()
	end
	makeActors = {}
end

function createTemplate( actors )
	local template = {}
	for i, v in ipairs( actors ) do
		template[ i ] = { Owner = team2, Type = v.Type, Location = v.Location }
	end
	return template
end

function convertTeams()
	switchActorOwners( team1actors, team1 )
	switchActorOwners( team2actors, team2 )
end

function addTriggers()
	addOnAllKilledTrigger( team1actors )
	addOnAllKilledTrigger( team2actors )
	addIdleTriggers( team1actors, team2actors )
	addIdleTriggers( team2actors, team1actors )
end

function addOnAllKilledTrigger( actors )
	local filteredActors = filterOutTable( actors, onKilledExceptions )
	Trigger.OnAllKilled( filteredActors, function()
		simCounter = simCounter - 1
		destroyActors( team1actors )
		destroyActors( team2actors )
		if ( simCounter > 0 ) then
			simCounter = 0
			sim()
		else
			endSim()
		end
	end)
end

function endSim()
	team1actors =createActorsFromTemplates( team1template )
	team2actors =createActorsFromTemplates( team2template )
	createMakeActors()
	attachMakeTriggers()
	switchActorOwners( team2actors, neutral )
	switchActorOwners( team1actors, human )
	currentTeam = 1
end

function filterOutTable( t, crap )
	local aTable = {}
	for i, v in ipairs( t ) do
		if ( not ( Utils.Any(crap, function( element ) return ( v.Type == element )  end) ) ) then
			table.insert( aTable, v )
		end
	end
	return aTable
end

function addIdleTriggers( actors, enemyActors )
	for i, v in ipairs( actors ) do
		Trigger.OnIdle( v, function( v )
			if ( v.HasProperty( "Hunt" ) ) then
				if ( #enemyActors > 0 ) then
					local closestEnemy = findClosestActorPos( enemyActors, v )
					v.AttackMove( closestEnemy )
				end
			else
				local closestAlly = findClosestActorPos( actors, v )
				v.Move( closestAlly )
				Trigger.AfterDelay( 100, v.Stop )
			end
		end)
	end
end

function findClosestActorPos( actors, actor )
	local closestEnemy = nil
	local distance = nil
	for i, v in ipairs( actors ) do
		if ( ( not  ( v.IsDead ) ) and ( not ( v == actor ) ) ) then
			if ( closestEnemy == nil ) then
				closestEnemy = v
				distance = getDistanceBetween( actor.Location, v.Location )
			elseif ( distance > getDistanceBetween( actor.Location, v.Location ) ) then
				closestEnemy = v
				distance = getDistanceBetween( actor.Location, v.Location )
			end
		end
	end
	if ( closestEnemy == nil ) then
		return CPos.New( 1, 1 )
	else
		return closestEnemy.Location
	end
end

function getDistanceBetween( pos1, pos2 )
	local distance = math.sqrt( math.pow( ( pos1.X - pos2.X ), 2) + math.pow( ( pos1.Y - pos2.Y ), 2 ) )
	return distance
end

function destroyActors( actors )
	for i, v in ipairs( actors ) do
		if ( not ( v.IsDead ) ) then
			v.Destroy()
		end
	end
	actors = {}
end

function createActorsFromTemplates( template )
	local actors = {}
	for i, v in ipairs( template ) do
		local actor = Actor.Create( v.Type, true, { Owner = team1, Location = v.Location } )
		table.insert( actors, actor)
	end
	return actors
end


