Targetyard = { TARGETYARD }
AIHouses = { }

Tick = function()

	Utils.Do(AIHouses, function(h)
		if h.Resources >= h.ResourceCapacity * 0.75 then
			h.Cash = h.Cash + h.Resources - h.ResourceCapacity * 0.25
			h.Resources = h.ResourceCapacity * 0.25
		end
	end)

end

Trigger.OnAnyKilled(Targetyard, function()
	player.MarkCompletedObjective(KillTarget)
end)


WorldLoaded = function()
	
	player = Player.GetPlayer("Greece")
	pl_ussr = Player.GetPlayer("USSR")
	neutral = Player.GetPlayer("Neutral")

	AIHouses = { pl_ussr }
	
	Trigger.OnObjectiveAdded(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)
	Trigger.OnObjectiveCompleted(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)
	Trigger.OnPlayerLost(player, function()
		Media.PlaySpeechNotification(player, "MissionFailed")
	end)
	Trigger.OnPlayerWon(player, function()
		Media.PlaySpeechNotification(player, "MissionAccomplished")
	end)

	ussrObj = pl_ussr.AddPrimaryObjective("Destroy the Allies.")
	
	SetupMapUnits(0.5)
	ActivateAI()
	
	KillTarget = player.AddPrimaryObjective("Destroy the Soviet Construction Yard.") 
	
	Camera.Position = PlayerCamera.CenterPosition
	
	--Debug stuff here
	
end

ActivateAI = function()

	Utils.Do(AIHouses, function(h)
		StructureRepair(h, 0.9)
	end)
	
end

-- Initial unit setup
SetupMapUnits = function(n)
	Utils.Do(Map.NamedActors, function(a)
		if a.Type == "dog" then
			a.Stance = "AttackAnything"
		elseif a.Type ~= "camera" and a.Type ~= "minv" then
			a.Stance = "Defend"
			
			-- attack persistent attackers
			if a.HasProperty("Health") then
				Trigger.OnDamaged(a, function(b)
					if b.Health < n * b.MaxHealth then
						b.Stance = "AttackAnything"
					end
				end)
			end
			
			-- convert all walls to neutral
			if (a.Type == "brik" or a.Type == "cycl" or a.Type == "fenc" or a.Type == "sbag") and a.Owner ~= neutral then
				a.Owner = neutral
			end
		end
	end)
end

-- All houses to repair structures
StructureRepair = function(cty,n) -- cty is house, n is the fraction of health to start repairing

	Utils.Do(Map.NamedActors, function(actor)
		if actor.Owner == cty and actor.HasProperty("StartBuildingRepairs") then
			Trigger.OnDamaged(actor, function(building)
				if building.Owner == cty and building.Health < n * building.MaxHealth then
					building.StartBuildingRepairs()
				end
			end)
		end
	end)
end
