--[ PLAYER CONFIG ]--
startingCash = 1000				--Cash that the player starts with
playerLives = 10				--The number of lives the player gets

--[ MAP CONFIG ]--
mapWidth 			= 32		--The width of the map
mapHeight 			= 32		--The height of the map

--[ ACTOR CONFIG ]--
spawnAppearance		= "kenn"	--The spawn appearance (Currently broken)
objectiveAppearance	= "silo"	--The objective appearance (Currently broken)

--[ WAVE ALLOWANCE EXPRESSION CONFIG ]--

function getWaveAllowance()
	waveAllowance = math.floor(math.pow(waveNumber, 2)) + 1	--Change this to a suitable wave allowance curve for your map. This determines how many units and which units can be afforded during a wave.
	return waveAllowance
end

--[ WAVE REWARD EXPRESSION CONFIG ]--

function getWaveReward()
	local waveReward = math.floor(math.pow((waveNumber * 200), 0.6)) + 50	--Change this to a suitable earnings expression for your map
	return waveReward
end

--[ WAVE CONFIG ]--
initialSendDelay 	= 100		--The delay before the first units of a wave are sent
sendDelay 			= 40		--The delay between units being sent during the wave
parallelUnitSending = true		--When true enemies will spawn at every spawn, when false they will be sent one at a time from a random spawn
cashPerWave 		= true		--When true the player is given a cash reward at the end of the wave, when false the player gets bounty cash instead
endless 			= true		--When true the player plays until they are defeated, when false the number of waves is finite
wavesToSurvive 		= 10		--The number of waves to survive when endless is set to false
customWaves 		= {			--Add your custom waves here

					  }

--[ ENEMY CONFIG ]--
enemies = {					--Add the enemies you want included in the waves here.

		  }