--[ PLAYER CONFIG ]--
startingCash = 1000				--Cash that the player starts with
playerLives = 15				--The number of lives the player gets

--[ MAP CONFIG ]--
mapWidth 			= 32		--The width of the map
mapHeight 			= 32		--The height of the map

--[ ACTOR CONFIG ]--
spawnAppearance		= "kenn"	--The spawn appearance (Currently broken)
objectiveAppearance	= "silo"	--The objective appearance (Currently broken)

--[ WAVE ALLOWANCE EXPRESSION CONFIG ]--

function getWaveAllowance()
	waveAllowance = math.floor(math.pow(waveNumber, 2)) + 1	--Change this to a suitable wave allowance curve for your map. This determines how many units and which units can be afforded during a wave.
	return waveAllowance
end

--[ WAVE REWARD EXPRESSION CONFIG ]--

function getWaveReward()
	local waveReward = math.floor(math.pow((waveNumber * 300), 0.6)) + 50	--Change this to a suitable earnings expression for your map
	return waveReward
end

--[ WAVE CONFIG ]--
wave = {}
waveNumber = 0
initialSendDelay 	= 60	--SETTING: Initial Send Delay
sendDelay 			= 40	--SETTING: Send Delay
parallelUnitSending = true	--SETTING: Parallel Unit Sending
cashPerWave 		= true	--SETTING: Cash Per Wave
waveReward			= nil
playerCash			= nil
endless 			= true	--SETTING: Endless
wavesToSurvive 		= 10	--SETTING: Waves to Survive
customWaves 		= {		--SETTING: Custom Waves
						{Number = 1,	WaveReward = 100,		Enemies = {
																			{NumberOf = 3,	Type = "e1"}
																			}
						},
						{Number = 2,	WaveReward = 120,		Enemies = {
																			{NumberOf = 1,	Type = "dog"},
																			{NumberOf = 4,	Type = "e1"}
																			}
						},
						{Number = 3,	WaveReward = 150,		Enemies = {
																			{NumberOf = 2,	Type = "dog"},
																			{NumberOf = 6,	Type = "e1"},
																			{NumberOf = 1,	Type = "medi"}
																			}
						},
						{Number = 8,	Text = "Ranger Swarm Incoming!",	WaveReward = 600,	Enemies = {
																												{NumberOf = 8,	Type = "jeep"}
																												}
						},
						{Number = 10,	Text = "Zombie Invasion Incoming!",	WaveReward = 800,	Enemies = {
																												{NumberOf = 22,	Type = "zombie"}
																												}
						},
						{Number = 15,	Text = "Stealth Force Detected!",	WaveReward = 1000,	Enemies = {
																												{NumberOf = 15,	Type = "hjckr"},
																												{NumberOf = 10,	Type = "stnk2"},
																												{NumberOf = 2,	Type = "phase"}
																												}
						},
						{Number = 20,	Text = "BLITZKRIEG!!",				WaveReward = 1200,	Enemies = {
																												{NumberOf = 10,	Type = "jeep"},
																												{NumberOf = 8,	Type = "1tnk"},
																												{NumberOf = 7,	Type = "2tnk"},
																												{NumberOf = 5,	Type = "3tnk"}
																												}
						},
						{Number = 25,	Text = "Enemy air armada detected!", 		WaveReward = 1400,	Enemies = {
																												{NumberOf = 10, Type = "gyro"},
																												{NumberOf = 8, Type = "hind2"},
																												{NumberOf = 6,	Type = "lbow"}
																												}
						},
						{Number = 30,	Text = "Enemy armored forced detected!",	WaveReward = 1600,	Enemies = {
																												{NumberOf = 13, Type = "4tnk"},
																												{NumberOf = 6,	Type = "3tnk"},
																												{NumberOf = 4,	Type = "mech2"},
																												{NumberOf = 3,	Type = "qtnk"}
																												}
						}
					}

--[ ENEMY CONFIG ]--
enemies = {					--SETTING: Custom Enemies
			{Cost = 1, 		Type = "e1",		MinWave = 1,	Shares = 15	},
			{Cost = 2, 		Type = "dog",		MinWave = 2,	Shares = 5	},
			{Cost = 2, 		Type = "medi2",		MinWave = 3,	Shares = 5	},
			{Cost = 5,		Type = "jeep",		MinWave = 6,	Shares = 3	},
			{Cost = 2, 		Type = "hjckr",		MinWave = 8,	Shares = 5	},
			{Cost = 3, 		Type = "zombie",	MinWave = 10,	Shares = 8	},
			{Cost = 7, 		Type = "1tnk",		MinWave = 10,	Shares = 4	},
			{Cost = 3, 		Type = "gyro",		MinWave = 12,	Shares = 6	},
			{Cost = 8, 		Type = "2tnk",		MinWave = 13,	Shares = 3	},
			{Cost = 4, 		Type = "mech2",		MinWave = 14,	Shares = 3	},
			{Cost = 11, 	Type = "stnk2",		MinWave = 15,	Shares = 3	},
			{Cost = 9, 		Type = "3tnk",		MinWave = 17,	Shares = 5	},
			{Cost = 13, 	Type = "hind2",		MinWave = 20,	Shares = 4	},
			{Cost = 10, 	Type = "ictank",	MinWave = 20,	Shares = 2	},
			{Cost = 20, 	Type = "4tnk",		MinWave = 22,	Shares = 3	},
			{Cost = 13, 	Type = "phase",		MinWave = 25,	Shares = 3	},
			{Cost = 20, 	Type = "lbow",		MinWave = 27,	Shares = 4	},
			{Cost = 20, 	Type = "qtnk",		MinWave = 30,	Shares = 5	}
		  }
