--[ PLAYER CONFIG ]--
startingCash = 1000				--Cash that the player starts with
playerLives = 15				--The number of lives the player gets

--[ MAP CONFIG ]--
mapWidth 			= 32		--The width of the map
mapHeight 			= 32		--The height of the map

--[ ACTOR CONFIG ]--
spawnAppearance		= "kenn"	--The spawn appearance (Currently broken)
objectiveAppearance	= "silo"	--The objective appearance (Currently broken)

--[ WAVE ALLOWANCE EXPRESSION CONFIG ]--

function getWaveAllowance()
	waveAllowance = math.floor(math.pow(waveNumber, 2)) + 1	--Change this to a suitable wave allowance curve for your map. This determines how many units and which units can be afforded during a wave.
	return waveAllowance
end

--[ WAVE REWARD EXPRESSION CONFIG ]--

function getWaveReward()
	local waveReward = math.floor(math.pow((waveNumber * 200), 0.6)) + 50	--Change this to a suitable earnings expression for your map
	return waveReward
end

--[ WAVE CONFIG ]--
wave = {}
waveNumber = 0
initialSendDelay 	= 100	--SETTING: Initial Send Delay
sendDelay 			= 40	--SETTING: Send Delay
parallelUnitSending = true	--SETTING: Parallel Unit Sending
cashPerWave 		= false	--SETTING: Cash Per Wave
waveReward			= nil
playerCash			= nil
endless 			= true	--SETTING: Endless
wavesToSurvive 		= 10	--SETTING: Waves to Survive
customWaves 		= {		--SETTING: Custom Waves
						{Number = 8,	Text = "Ranger Swarm Incoming!",	WaveReward = 1000,		Enemies = {
																												{NumberOf = 8,	Type = "jeep"}
																												}
						},
						{Number = 10,	Text = "Zombie Invasion Incoming!",	Enemies = {
																						{NumberOf = 22, Type = "zombie"}
																						}
						},
						{Number = 20,	Text = "BLITZKRIEG!!",				Enemies = {
																						{NumberOf = 6, Type = "jeep"},
																						{NumberOf = 4, Type = "1tnk"},
																						{NumberOf = 4, Type = "2tnk"},
																						{NumberOf = 2, Type = "3tnk"},
																						{NumberOf = 1, Type = "4tnk"}
																						}
						}
					}

--[ ENEMY CONFIG ]--
enemies = {					--SETTING: Custom Enemies
			{Cost = 1, 		Type = "e1",		Shares = 3},
			{Cost = 1, 		Type = "dog",		MinWave = 2},
			{Cost = 2, 		Type = "zombie",	MinWave = 10},
			{Cost = 6, 		Type = "hjckr",		MinWave = 7},
			{Cost = 10,		Type = "jeep",		MinWave = 6},
			{Cost = 10, 	Type = "1tnk",		MinWave = 10},
			{Cost = 20, 	Type = "2tnk",		MinWave = 15},
			{Cost = 25, 	Type = "3tnk",		MinWave = 15},
			{Cost = 30, 	Type = "stnk2",		MinWave = 17},
			{Cost = 40, 	Type = "4tnk",		MinWave = 20},
			{Cost = 40, 	Type = "phase",		MinWave = 22},
			{Cost = 40, 	Type = "qtnk",		MinWave = 25}
		  }
