function centraliseCamera()
	local centerPosition = WPos.New(1024 * mapWidth/2, 1024 * mapHeight/2, 0)
	Camera.Position = centerPosition
end

function getWinLossConditionID()
	local missionDescription
	if (endless) then
		missionDescription = "Do not allow " .. playerLives .. " enemies to the exit!"
	else
		missionDescription = "Do not allow " .. playerLives .. " enemies to the exit and survive " .. wavesToSurvive .. " waves!"
	end
	return humanPlayer.AddPrimaryObjective(missionDescription)
end

function inTable(value, t)
	return Utils.Any(t, function(element)
			if (element == value) then
				return true
			end
			return false
		end)
end

function filterTable(t, filter)
	local filteredTable = {}
	for i, v in ipairs(t) do
		if inTable(v.Type, filter) then
			filteredTable[#filteredTable + 1] = v
		end
	end
	if (#filteredTable == 0) then
		error("filterTable Error: Filtered table empty")
	end
	return filteredTable
end

function getSpawns()
	local spawns = filterTable(Map.NamedActors, {"enemy_spawn"})
	if (#spawns == 0) then
		error("getSpawns Error: No spawns on map")
	end
	return spawns
end

function getObjectives()
	local objectives = filterTable(Map.NamedActors, {"enemy_objective"})
	if (#objectives == 0) then
		error("getObjectives Error: No objectives on map")
	end
	return objectives
end

function displayGameStateText()
	local gameState
	if (endless == nil) then
		error("displayGameStateText Error: Boolean endless is nil")
	end
	if (endless) then
		gameState = "WAVE: " .. waveNumber .. "\n\n"
	else
		if (wavesToSurvive == nil) then
			error("displayGameStateText Error: Variable wavesToSurvive is nil")
		elseif (wavesToSurvive < 1) then
			error("displayGameStateText Error: Variable wavesToSurvive is out of bounds")
		end
		gameState = "WAVE: " .. waveNumber .. "/" .. wavesToSurvive .. "\n\n"
	end
	gameState = gameState .. "LIVES: ["
	for i = 1, initialPlayerLives do
		if (playerLives >= i) then
			gameState = gameState .. "|"
		else
			gameState = gameState .. " "
		end
	end
	gameState = gameState .. "]"
	UserInterface.SetMissionText(gameState)
end

function disguiseActorsAs(actors, appearance)
	for i, v in ipairs(actors) do
		v.DisguiseAsType(appearance, humanPlayer)
	end
	return actors
end

function initialiseSpawns()
	enemySpawns = makeOwnerOfActors(enemyPlayer, enemySpawns)
	if (spawnAppearance ~= nil) then
		enemySpawns = disguiseActorsAs(enemySpawns, spawnAppearance)
	end
end

function addObjectiveTrigger(objective)
	Trigger.OnPassengerEntered(objective, function(objective, actor)
			if (objective.HasPassengers) then
				removeEnemy(actor)
				objective.UnloadPassenger()
				actor.Destroy()
				playerLives = playerLives - 1
				if (playerLives == 0) then
					endGame(false)
				end
				displayGameStateText()
			else
				print("addObjectiveTrigger ERROR CATCH: OnPassengerEntered triggered without passengers")
			end
		end)
end

function addObjectiveTriggers()
	for i, v in ipairs(enemyObjectives) do
		addObjectiveTrigger(v)
	end
end

function makeOwnerOfActors(player, actors)
	for i, v in ipairs(actors) do
		v.Owner = player
	end
	return actors
end

function initialiseObjectives()
	enemyObjectives = makeOwnerOfActors(enemyPlayer, enemyObjectives)
	if (objectiveAppearance ~= nil) then
		enemyObjectives = disguiseActorsAs(enemyObjectives, objectiveAppearance)
	end
	addObjectiveTriggers()
end

function getPathTiles()
	local tiles = filterTable(Map.NamedActors, {"path_tile"})
	if (#tiles == 0) then
		error("getPathTiles Error: No tiles on map")
	end
	return tiles
end

function getPathBorderTiles()
	local tiles = filterTable(Map.NamedActors, {"path_border_tile"})
	if (#tiles == 0) then
		error("getPathBorderTiles Error: No tile borders on map")
	end
	return tiles
end

function setPlayerCash(player, cash)
	player.Cash = cash
end

function actualiseActors(actors)
	for i, v in ipairs(actors) do
		v.IsInWorld = true
	end
end

function deactualiseActors(actors)
	for i, v in ipairs(actors) do
		v.IsInWorld = false
	end
end

function actualisePath()
	actualiseActors(pathTiles)
end

function actualisePathBorders()
	actualiseActors(pathBorderTiles)
end

function deactualisePath()
	deactualiseActors(pathTiles)
end

function deactualisePathBorders()
	deactualiseActors(pathBorderTiles)
end

function attachReadyTrigger(actor)
	Trigger.OnProduction(actor, function(producer, produced)
			if (produced.Type == "ready") then
				produced.Destroy()
				exitBuildMode()
				playing = true
				enterPlayMode()
			end
		end)
end

function createBuildingActor()
	local actorPosition = enemyObjectives[1].Location
	local actor = Actor.Create("build_control", true, {Location = actorPosition, Owner = humanPlayer})
	attachReadyTrigger(actor)
	return actor
end

function enterBuildMode()
	if (playing) then
		error("enterBuildMode Error: Cannot enter build mode whilst playing")
	end
	deactualisePathBorders()
	buildingActor = createBuildingActor()
	building = true
	displayGameStateText()
end

function exitBuildMode()
	building = false
	buildingActor.Destroy()
	actualisePathBorders()
end

function getWaveAllowance()
	waveAllowance = math.floor(math.pow(waveNumber, 2)) + 1	--SETTING: Wave Allowance Expression
	return waveAllowance
end

function getPossibleEnemies(allowance)
	--TODO: Clean this up
	local possibleEnemies = {}
	for i, v in ipairs(enemies) do
		if (v.Cost <= allowance) then
			if ((v.MinWave ~= nil) and (v.MaxWave ~= nil)) then
				if ((v.MinWave <= waveNumber) and (waveNumber <= v.MaxWave)) then
					if (v.Shares == nil) then
						table.insert(possibleEnemies, 1, v)
					elseif (v.Shares <= 0) then
						error("getPossibleEnemies Error: Enemy shares is out of bounds")
					else
						for i = 1, v.Shares do
							table.insert(possibleEnemies, 1, v)
						end
					end
				end
			elseif (v.MinWave ~= nil) then
				if (v.MinWave <= waveNumber) then
					if (v.Shares == nil) then
						table.insert(possibleEnemies, 1, v)
					elseif (v.Shares <= 0) then
						error("getPossibleEnemies Error: Enemy shares is out of bounds")
					else
						for i = 1, v.Shares do
							table.insert(possibleEnemies, 1, v)
						end
					end
				end
			elseif (v.MaxWave ~= nil) then
				if (waveNumber <= v.MaxWave) then
					if (v.Shares == nil) then
						table.insert(possibleEnemies, 1, v)
					else
						if (v.Shares <= 0) then
							error("getPossibleEnemies Error: Enemy shares is out of bounds")
						end
						for i = 1, v.Shares do
							table.insert(possibleEnemies, 1, v)
						end
					end
				end
			else
				if (v.Shares == nil) then
					table.insert(possibleEnemies, 1, v)
				elseif (v.Shares <= 0) then
					error("getPossibleEnemies Error: Enemy shares is out of bounds")
				else
					for i = 1, v.Shares do
						table.insert(possibleEnemies, 1, v)
					end
				end
			end
		end
	end
	return possibleEnemies
end

function getMaxCostUnit(units)
	local maxCost = -1
	for i, v in ipairs(units) do
		if (v.Cost > maxCost) then
			maxCost = v.Cost
		end
	end
	return maxCost
end

function isCustomWave()
	for i, v in ipairs(customWaves) do
		if (v.Number == waveNumber) then
			return true
		end
	end
	return false
end

function getCustomWave()
	--TODO: Clean this up
	for i, v in ipairs(customWaves) do
		if (v.Number == waveNumber) then
			for j, a in ipairs(v.Enemies) do
				for i = 1, a.NumberOf do
					table.insert(wave, #wave + 1, a.Type)
				end
			end
			if (v.Text ~= nil) then
				Media.DisplayMessage(v.Text,"")
			end
			if (v.WaveReward ~= nil) then
				waveReward = v.WaveReward
			else
				waveReward = getWaveReward()
			end
			return
		end
	end
end

function populateWave()
	--TODO: Clean this up
	waveNumber = waveNumber + 1
	if (isCustomWave()) then
		getCustomWave()
	else
		local allowance = getWaveAllowance()
		local possibleEnemies = getPossibleEnemies(allowance)
		if (#possibleEnemies == 0) then
			return
		end
		while (allowance ~= 0) do
			if (getMaxCostUnit(possibleEnemies) > allowance) then
				possibleEnemies = getPossibleEnemies(allowance)
			end
			local enemy = Utils.Random(possibleEnemies)
			table.insert(wave, 1, enemy.Type)
			allowance = allowance - enemy.Cost
		end
		waveReward = getWaveReward()
	end
end

function enterPlayMode()
	if (building) then
		error("enterPlayMode Error: Cannot enter play mode whilst building")
	end
	deactualisePath()
	populateWave()
	tickCounter = 0
	if (cashPerWave) then
		playerCash = humanPlayer.Cash
	end
	playing = true
	displayGameStateText()
end

function getWaveReward()
	local waveReward = math.floor(math.pow((waveNumber * 200), 0.6)) + 50		--SETTING: Wave Reward Expression
	return waveReward
end

function getNewPlayerCash()
	local cash = playerCash + waveReward
	return cash
end

function exitPlayMode()
	playing = false
	actualisePath()
	if (cashPerWave) then
		humanPlayer.Cash = getNewPlayerCash()
	end
end

function waveEmpty()
	if (#wave == 0) then
		return true
	end
	return false
end

function createUnit(unitType, unitLocation)
	local unit = Actor.Create(unitType, true, {Owner = enemyPlayer, Location = unitLocation})
	return unit
end

function getRandomObjective()
	local objective = Utils.Random(enemyObjectives)
	return objective
end

function findInTable(value, t)
	for i, v in ipairs(t) do
		if (v == value) then
			return i
		end
	end
	error("findInTable Error: Value not in table")
end

function removeEnemy(enemy)
	local key = findInTable(enemy, aliveEnemies)
	table.remove(aliveEnemies, key)
	table.remove(aliveEnemyObjectives, key)
end

function addOnIdleTrigger(unit, objective)
	Trigger.OnIdle(unit, function(unit)
			unit.Stop()
			unit.EnterTransport(objective)
		end)
end

function addOnKilledTrigger(unit)
	Trigger.OnKilled(unit, function(unit)
			removeEnemy(unit)
		end)
end

function addEnemyTriggers(unit, objective)
	addOnIdleTrigger(unit, objective)
	addOnKilledTrigger(unit)
end

function sendUnit(spawn)
	local unitType = table.remove(wave, 1)
	local unit = createUnit(unitType, spawn.Location)
	table.insert(aliveEnemies, 1, unit)
	local objective = getRandomObjective()
	table.insert(aliveEnemyObjectives, 1, objective)
	addEnemyTriggers(unit, objective)
end

function getRandomSpawn()
	local spawn = Utils.Random(enemySpawns)
	return spawn
end

function sendUnits()
	if (parallelUnitSending) then
		for i = 1, #enemySpawns do
			if (not waveEmpty()) then
				local spawn = enemySpawns[i]
				sendUnit(spawn)
			end
		end
	else
		local spawn = getRandomSpawn()
		sendUnit(spawn)
	end
end

function enemiesAlive()
	if (#aliveEnemies == 0) then
		return false
	end
	return true
end

function finalWave()
	if (wavesToSurvive <= waveNumber) then
		return true
	end
	return false
end

function endGame(won)
	if (won) then
		humanPlayer.MarkCompletedObjective(missionID)
	else
		humanPlayer.MarkFailedObjective(missionID)
	end
end

function Tick()
	tickCounter = tickCounter + 1
	if (playing == true) then
		if ((not waveEmpty()) and (tickCounter % sendDelay == 0) and (tickCounter >= initialSendDelay)) then
			sendUnits()
		elseif ((not enemiesAlive()) and (waveEmpty())) then
			if (not endless) then
				if (finalWave()) then
					endGame(true)
					return
				end
			end
			exitPlayMode()
			enterBuildMode()
		end
	end
end

function WorldLoaded()
	centraliseCamera()
	missionID = getWinLossConditionID()
	enemySpawns 	= getSpawns()
	initialiseSpawns()
	enemyObjectives = getObjectives()
	initialiseObjectives()
	pathTiles 				= getPathTiles()
	pathBorderTiles 		= getPathBorderTiles()
	setPlayerCash(humanPlayer, startingCash)
	enterBuildMode()
end

--PLAYER VARIABLES--
humanPlayer = Player.GetPlayer("Multi0")
enemyPlayer = Player.GetPlayer("Creeps")
startingCash = 1000				--SETTING: Starting Cash
playerLives = 10				--SETTING: Player Lives
initialPlayerLives = playerLives

--MAP VARIABLES--
mapWidth 			= 32		--SETTING: Map Width
mapHeight 			= 32		--SETTING: Change this to your map's height
enemySpawns 		= {}
spawnAppearance		= "kenn"	--SETTING: Spawn Appearance
enemyObjectives		= {}
objectiveAppearance	= "silo"	--SETTING: Objective Appearance
tickCounter = 0

--WIN LOSS CONDITION VARIABLES--
missionID = nil

--PLAY MODE VARIABLES--
playing = false
aliveEnemies = {}
aliveEnemyObjectives = {}

--WAVE VARIABLES--
wave = {}
waveNumber = 0
initialSendDelay 	= 100	--SETTING: Initial Send Delay
sendDelay 			= 40	--SETTING: Send Delay
parallelUnitSending = true	--SETTING: Parallel Unit Sending
cashPerWave 		= true	--SETTING: Cash Per Wave
waveReward			= nil
playerCash			= nil
endless 			= true	--SETTING: Endless
wavesToSurvive 		= 10	--SETTING: Waves to Survive
customWaves 		= {		--SETTING: Custom Waves
						{Number = 8,	Text = "Ranger Swarm Incoming!",	WaveReward = 1000,		Enemies = {
																												{NumberOf = 8,	Type = "jeep"}
																												}
						},
						{Number = 10,	Text = "Zombie Invasion Incoming!",	Enemies = {
																						{NumberOf = 30, Type = "zombie"}
																						}
						},
						{Number = 20,	Text = "BLITZKRIEG!!",				Enemies = {
																						{NumberOf = 6, Type = "jeep"},
																						{NumberOf = 4, Type = "1tnk"},
																						{NumberOf = 4, Type = "2tnk"},
																						{NumberOf = 2, Type = "3tnk"}
																						}
						}
					  }

--BUILDING MODE VARIABLES--
building 					= false
buildingActor				= nil
pathTiles 					= {}
pathBorderTiles 			= {}

--ENEMY VARIABLES--
enemies = {					--SETTING: Custom Enemies
			{Cost = 1, 		Type = "e1",		Shares = 3},
			{Cost = 1, 		Type = "dog"},
			{Cost = 2, 		Type = "zombie",	MinWave = 10},
			{Cost = 10,		Type = "jeep",		MinWave = 6},
			{Cost = 10, 	Type = "1tnk",		MinWave = 10,	MaxWave = 40},
			{Cost = 20, 	Type = "2tnk",		MinWave = 15},
			{Cost = 25, 	Type = "3tnk",		MinWave = 15},
			{Cost = 40, 	Type = "4tnk",		MinWave = 20},
			{Cost = 40, 	Type = "qtnk",		MinWave = 25}
		  }

--TODO: Add support for killing the objective actor instead
--TODO: Fix disguising spawns and objectives
--TODO: remove space taking for control

--REUPLOAD