--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

if Map.Difficulty == "Easy" then

	NodStartUnits1 = { "e1", "e1", "e1", "e1", "e1" }
	NodStartUnits2 = { "e3", "e3", "e3", "e3", "e3" }
	NodStartUnits3 = { "ltnk", "ltnk", "bggy", "bggy", "bggy", "bike", "bike" }
	NodMCV = { "bggy", "bggy", "mcv" }
	NodSecondaryUnits = { "e5", "e5", "e5", "e5", "e5", "stnk", "stnk" }

	GdiVillageVehicle = { "jeep" }
	GdiVillageVehicle2 = { "apc" }
	Patroler = { "jeep", "jeep" }
	FirstAttackers = { "apc", "apc" }
	AttackWave2 = { "mtnk", "mtnk" }
	RandomWave1 = { "mtnk", "msam", "mtnk" }
	Base1InfAttackers1 = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2" }
	Base1InfAttackers2 = { "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e3", "e2" }
	Base1VehAttackers1 = { "jeep" }
	Base1VehAttackers2 = { "mtnk", "mtnk" }
	Base1VehAttackers3 = { "htnk" }
	Base1DestroyedReinforcements = { "mtnk", "mtnk" }
	AirSneakAttack1 = { "orca", "orca" }
	AirSneakAttack2 = { "orca" }
	AirLoopAttack1 = { "orca" }
	AirLoopAttack2 = { "orca" }
	Base2InfAttack = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e1", "e1", "e1" }
	Base2VehAttack = { "htnk", "mtnk", "mtnk" }
	ReinforcementsLoopInf = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e2", "e2", "e2" }
	ReinforcementsLoopVeh = { "jeep", "mtnk", "mtnk" }
	ReinforcementsLoopAir = { "orca", "orca" }
	Base1Reinforcements = { "mtnk", "e1", "e1", "e3", "e3" }
	
	BuildSecondAttackersDelay = DateTime.Seconds(200)
	StartWavesDelay = DateTime.Seconds(360)
	Attack1Delay = DateTime.Seconds(1)
	
	AirstrikeDelay = DateTime.Seconds(300)
	Base1AttackInf = DateTime.Seconds(230)
	Base1AttackVeh = DateTime.Seconds(120)
	Base1AttackVeh2 = DateTime.Seconds(280)
	Base1AttackVeh3 = DateTime.Seconds(350)
	Base1AttackInf2 = DateTime.Seconds(330)
	StartAirAttackTimer = DateTime.Seconds(300)
	AirAttack2 = DateTime.Seconds(180)
	AirAttack1Interval = DateTime.Seconds(194)
	Base2InfProductionInterval = DateTime.Seconds(240)
	Base2VehProductionInterval = DateTime.Seconds(340)
	EnterAB3 = DateTime.Seconds(600)
	GDIReinforcementsLoopDelayInf = DateTime.Seconds(400)
	GDIReinforcementsLoopDelayVeh = DateTime.Seconds(410)
	GDIReinforcementsLoopDelayAir = DateTime.Seconds(350)
	
elseif Map.Difficulty == "Normal" then

	NodStartUnits1 = { "e1", "e1", "e1", "e1", "e1" }
	NodStartUnits2 = { "e3", "e3", "e3", "e3", "e3" }
	NodStartUnits3 = { "ltnk", "ltnk", "bggy", "bggy", "bggy", "bike", "bike" }
	NodMCV = { "bggy", "bggy", "mcv" }
	NodSecondaryUnits = { "e5", "e5", "e5", "e5", "e5", "stnk", "stnk" }

	GdiVillageVehicle = { "apc" }
	GdiVillageVehicle2 = { "apc" }
	Patroler = { "apc", "apc" }
	FirstAttackers = { "apc", "apc", "jeep" }
	AttackWave2 = { "mtnk", "mtnk", "mtnk", "mtnk" }
	RandomWave1 = { "mtnk", "msam", "mtnk", "jeep" }
	Base1InfAttackers1 = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e1", "e3", "e3" }
	Base1InfAttackers2 = { "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e3", "e2", "e3", "e3", "e3" }
	Base1VehAttackers1 = { "jeep", "jeep" }
	Base1VehAttackers2 = { "mtnk", "mtnk", "msam" }
	Base1VehAttackers3 = { "htnk" }
	Base1DestroyedReinforcements = { "mtnk", "mtnk", "mtnk", "mtnk" }
	AirSneakAttack1 = { "orca", "orca" }
	AirSneakAttack2 = { "orca", "orca" }
	AirLoopAttack1 = { "orca", "orca" }
	AirLoopAttack2 = { "orca", "orca" }
	Base2InfAttack = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2" }
	Base2VehAttack = { "htnk", "mtnk", "mtnk", "apc", "apc", "apc" }
	ReinforcementsLoopInf = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e3" }
	ReinforcementsLoopVeh = { "jeep", "mtnk", "mtnk", "mtnk", "mtnk" }
	ReinforcementsLoopAir = { "orca", "orca", "orca" }
	Base1Reinforcements = { "mtnk", "e1", "e1", "e1", "e3", "e3", "orca" }
	
	BuildSecondAttackersDelay = DateTime.Seconds(180)
	RandomAttackDelay = DateTime.Seconds(150)
	StartWavesDelay = DateTime.Seconds(330)
	Attack1Delay = DateTime.Seconds(1)
	
	AirstrikeDelay = DateTime.Seconds(275)
	Base1AttackInf = DateTime.Seconds(150)
	Base1AttackVeh = DateTime.Seconds(60)
	Base1AttackVeh2 = DateTime.Seconds(240)
	Base1AttackVeh3 = DateTime.Seconds(325)
	Base1AttackInf2 = DateTime.Seconds(250)
	StartAirAttackTimer = DateTime.Seconds(275)
	AirAttack2 = DateTime.Seconds(160)
	AirAttack1Interval = DateTime.Seconds(180)
	Base2InfProductionInterval = DateTime.Seconds(200)
	Base2VehProductionInterval = DateTime.Seconds(250)
	EnterAB3 = DateTime.Seconds(575)
	GDIReinforcementsLoopDelayInf = DateTime.Seconds(300)
	GDIReinforcementsLoopDelayVeh = DateTime.Seconds(310)
	GDIReinforcementsLoopDelayAir = DateTime.Seconds(350)
	
elseif Map.Difficulty == "Hard" then

	NodStartUnits1 = { "e1", "e1", "e1", "e1", "e1" }
	NodStartUnits2 = { "e3", "e3", "e3", "e3", "e3" }
	NodStartUnits3 = { "ltnk", "ltnk", "bggy", "bggy", "bggy", "bike" }
	NodMCV = { "bggy", "bggy", "mcv" }
	NodSecondaryUnits = { "e5", "e5", "e5", "e5", "e5", "stnk", "stnk" }

	GdiVillageVehicle = { "mtnk" }
	GdiVillageVehicle2 = { "mtnk" }
	Patroler = { "mtnk", "mtnk" }
	FirstAttackers = { "mtnk", "mtnk" }
	AttackWave2 = { "mtnk", "mtnk", "msam" }
	RandomWave1 = { "mtnk", "msam", "mtnk", "apc", "apc", "apc" }
	Base1InfAttackers1 = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e1", "e3", "e3", "e2", "e2", "e2" }
	Base1InfAttackers2 = { "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e3", "e2", "e3", "e3", "e3", "e1", "e1", "e1", "e3", "e3" }
	Base1VehAttackers1 = { "apc", "apc" }
	Base1VehAttackers2 = { "mtnk", "mtnk", "msam" }
	Base1VehAttackers3 = { "htnk", "htnk" }
	Base1DestroyedReinforcements = { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" }
	AirSneakAttack1 = { "orca", "orca", "orca" }
	AirSneakAttack2 = { "orca", "orca" }
	AirLoopAttack1 = { "orca", "orca", "orca" }
	AirLoopAttack2 = { "orca", "orca", "orca" }
	Base2InfAttack = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e1", "e1" }
	Base2VehAttack = { "htnk", "mtnk", "mtnk", "apc", "apc", "apc", "msam", "msam" }
	ReinforcementsLoopInf = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e3", "e1", "e2", "e2", "e2", "e3", "e3", "e3" }
	ReinforcementsLoopVeh = { "jeep", "mtnk", "mtnk", "mtnk", "mtnk", "htnk", "htnk" }
	ReinforcementsLoopAir = { "orca", "orca", "orca" }
	Base1Reinforcements = { "mtnk", "mtnk", "e1", "e1", "e1", "e3", "e3", "e3", "orca" }
	
	BuildSecondAttackersDelay = DateTime.Seconds(160)
	StartWavesDelay = DateTime.Seconds(310)
	Attack1Delay = DateTime.Seconds(1)
	
	AirstrikeDelay = DateTime.Seconds(250)
	Base1AttackInf = DateTime.Seconds(125)
	Base1AttackVeh = DateTime.Seconds(50)
	Base1AttackVeh2 = DateTime.Seconds(230)
	Base1AttackVeh3 = DateTime.Seconds(300)
	Base1AttackInf2 = DateTime.Seconds(225)
	StartAirAttackTimer = DateTime.Seconds(250)
	AirAttack2 = DateTime.Seconds(140)
	AirAttack1Interval = DateTime.Seconds(150)
	Base2InfProductionInterval = DateTime.Seconds(200)
	Base2VehProductionInterval = DateTime.Seconds(220)
	EnterAB3 = DateTime.Seconds(565)
	GDIReinforcementsLoopDelayInf = DateTime.Seconds(200)
	GDIReinforcementsLoopDelayVeh = DateTime.Seconds(210)
	GDIReinforcementsLoopDelayAir = DateTime.Seconds(325)
	
else

	NodStartUnits1 = { "e1", "e1", "e1", "e1", "e1" }
	NodStartUnits2 = { "e3", "e3", "e3", "e3", "e3" }
	NodStartUnits3 = { "ltnk", "ltnk", "bggy", "bggy", "bike" }
	NodMCV = { "bggy", "bggy", "mcv" }
	NodSecondaryUnits = { "e5", "e5", "e5", "e5", "e5", "stnk", "stnk" }

	GdiVillageVehicle = { "mtnk" }
	GdiVillageVehicle2 = { "mtnk" }
	Patroler = { "htnk" }
	FirstAttackers = { "mtnk", "mtnk", "mtnk", "mtnk" }
	AttackWave2 = { "mtnk", "mtnk", "mtnk", "mtnk", "msam" }
	RandomWave1 = { "mtnk", "msam", "mtnk", "apc", "apc", "apc", "mtnk", "mtnk" }
	Base1InfAttackers1 = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e1", "e3", "e3", "e2", "e2", "e2", "e1", "e1", "e1", "e1" }
	Base1InfAttackers2 = { "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e3", "e2", "e3", "e3", "e3", "e1", "e1", "e1", "e3", "e3", "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e3" }
	Base1VehAttackers1 = { "mtnk", "mtnk" }
	Base1VehAttackers2 = { "mtnk", "mtnk", "msam", "mtnk" }
	Base1VehAttackers3 = { "htnk", "htnk" }
	Base1DestroyedReinforcements = { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "htnk" }
	AirSneakAttack1 = { "orca", "orca", "orca", "orca" }
	AirSneakAttack2 = { "orca", "orca", "orca" }
	AirLoopAttack1 = { "orca", "orca", "orca", "orca" }
	AirLoopAttack2 = { "orca", "orca", "orca", "orca" }
	Base2InfAttack = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "rmbo" }
	Base2VehAttack = { "htnk", "mtnk", "mtnk", "apc", "apc", "apc", "msam", "msam", "msam", "htnk" }
	ReinforcementsLoopInf = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e2", "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e3", "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" }
	ReinforcementsLoopVeh = { "jeep", "mtnk", "mtnk", "mtnk", "mtnk", "htnk", "htnk", "htnk", "msam" }
	ReinforcementsLoopAir = { "orca", "orca", "orca"}
	Base1Reinforcements = { "e1", "e1", "e1", "e3", "e3", "e3", "orca", "mtnk", "mtnk", "apc" }

	BuildSecondAttackersDelay = DateTime.Seconds(160)
	StartWavesDelay = DateTime.Seconds(285)
	Attack1Delay = DateTime.Seconds(1)
	
	AirstrikeDelay = DateTime.Seconds(200)
	Base1AttackInf = DateTime.Seconds(125)
	Base1AttackVeh = DateTime.Seconds(45)
	Base1AttackVeh2 = DateTime.Seconds(230)
	Base1AttackVeh3 = DateTime.Seconds(275)
	Base1AttackInf2 = DateTime.Seconds(225)
	StartAirAttackTimer = DateTime.Seconds(250)
	AirAttack2 = DateTime.Seconds(120)
	AirAttack1Interval = DateTime.Seconds(120)
	Base2InfProductionInterval = DateTime.Seconds(180)
	Base2VehProductionInterval = DateTime.Seconds(200)
	EnterAB3 = DateTime.Seconds(585)
	GDIReinforcementsLoopDelayInf = DateTime.Seconds(175)
	GDIReinforcementsLoopDelayVeh = DateTime.Seconds(200)
	GDIReinforcementsLoopDelayAir = DateTime.Seconds(300)
	
end

Creep1 = { "pvice" }

GdiUnits_Event = { Actor55, Actor57, Actor56, Actor58, Actor59 }
Trigger1 = { Actor106 }
Silo = { Actor78 }
GTWR1 = { Actor240 }
Base1Tower = { Actor240 }

GameStart = DateTime.Seconds(0.5)

villagepath = { AB1_Vehicle1Rally.Location, AB1_Vehicle1Wp1.Location, AB1_Vehicle1Wp2.Location, AB1_Vehicle1Wp3.Location }
villagepath2 = { AB1_Vehicle2Rally.Location, AB1_Vehicle2Wp1.Location, AB1_Vehicle2Wp2.Location }
GDIPatrolpath = { GDIPatrol_Wp1.Location, GDIPatrol_Wp2.Location, GDIPatrol_Wp3.Location, GDIPatrol_Wp4.Location }

harvester = { "harv", "harv" }

GDIBuildings = { GDIBase1Building1, GDIBase1Building2, GDIBase1Building3, GDIBase1Building4, GDIBase1Building5, GDIBase1Building6, GDIBase1Building7, AB1_GDIBase2_Building1, AB1_GDIBase2_Building2, AB1_GDIBase2_Building3, AB1_GDIBase2_Building4, AB1_GDIBase2_Building5, AB1_GDIBase2_Building6, AB1_GDIBase2_Building7, AB1_GDIBase2_Building8, AB1_GDIBase2_Building9, AB1_GDIBase2_Building10, AB1_GDIBase2_Building11, AB1_GDIBase2_Building12, AB1_GDIBase2_Building13, AB1_GDIBase2_Building14, AB1_GDIBase2_Building15, AB1_GDIBase2_Building16, AB1_GDIBase2_Building17 }
GDILab = { Actor308 }

ActorRemovals =
{
	Easy = { Actor108, Actor156, Actor241, Actor311, Actor312, Actor138 },
	Normal = { Actor241, Actor311, Actor312 },
	Hard = { },
	Brutal = { },
}

CellTriggers1 =
{
	CPos.New(60,42), CPos.New(61,42), CPos.New(62,42), CPos.New(63,42), CPos.New(64,42),
	CPos.New(65,42), CPos.New(66,42), CPos.New(67,42)
}

CellTriggers2 =
{
	CPos.New(43,56), CPos.New(43,57), CPos.New(43,58), CPos.New(43,59), CPos.New(43,60),
	CPos.New(43,61), CPos.New(43,62), CPos.New(43,63)
}

CellTriggers3 =
{
	CPos.New(19,67), CPos.New(18,68), CPos.New(17,69)
}

CellTriggers4 =
{
	CPos.New(12,28), CPos.New(12,27), CPos.New(12,26), CPos.New(12,25), CPos.New(12,24),
	CPos.New(12,23), CPos.New(12,22), CPos.New(12,21), CPos.New(12,20), CPos.New(10,20),
	CPos.New(9,20), CPos.New(8,20), CPos.New(7,20), CPos.New(6,20), CPos.New(5,20),
	CPos.New(4,20), CPos.New(3,20), CPos.New(2,20), CPos.New(1,20)
}

--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

--Globals

NodSecondaryReinforcements = function()
	Trigger.AfterDelay(DateTime.Seconds(3), function()
		Media.PlaySpeechNotification(player, "Reinforce")
		Reinforcements.Reinforce(player, NodSecondaryUnits, { Actor313.Location, Actor314.Location }, 15)
	end)
end

--Globals

--AB1--

WorldLoaded = function()

	Utils.Do(ActorRemovals[Map.Difficulty], function(unit)
		unit.Destroy()
	end)

	Camera.Position = NodSpawnRally1.CenterPosition 
	
	MCVSpawned = 0
	ObjectiveTriggered = 0
	Objective2triggered = 0
	MissionFailure = 0
	MissionSuccess = 0
	ReinforcementsSpawned = 0
	
    player = Player.GetPlayer("Nod")
    enemy = Player.GetPlayer("GDI")
	creeps = Player.GetPlayer("Creeps")
	
	GDIObjective = enemy.AddPrimaryObjective("Kill all enemies.")
	NodObjective1 = player.AddPrimaryObjective("Explore the area.")
	
	Trigger.OnDamaged(Actor55, function()
		if not VehicleSpawned then
			VehicleSpawned = true
			AB1_GdiVillageVehicle()
		end
	end)
	
	Trigger.OnDamaged(Actor59, function()
		if not Vehicle2Spawned then
			Vehicle2Spawned = true
			AB1_GdiVillageVehicle2()
		end
	end)
	
	Trigger.OnEnteredFootprint(CellTriggers1, function(a, id)
		if a.Owner == player and Objective2triggered == 0 then
			Objective2triggered = 1
			Flare = Actor.Create('flare', true, { Owner = player, Location = Actor176.Location })
			Flare.Destroy()
			Flare2 = Actor.Create('flare', true, { Owner = player, Location = Actor208.Location })
			Flare2.Destroy()
			NodObjective3 = player.AddPrimaryObjective("We sent a MCV to the west of your location.")
			player.MarkCompletedObjective(NodObjective2)
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
	
	Trigger.OnEnteredFootprint(CellTriggers2, function(a, id)
		if a.Owner == player and ObjectiveTriggered == 0 then
			ObjectiveTriggered = 1
			NodObjective2 = player.AddPrimaryObjective("Destroy the villages to provoke a GDI reaction.")
			player.MarkCompletedObjective(NodObjective1)
			Trigger.RemoveFootprintTrigger(id)
		end
	end) 
	
	Trigger.OnEnteredFootprint(CellTriggers4, function(a, id)
		if a.Owner == player and MCVSpawned == 0 then
			MCVSpawned = 1
			NodObjective4 = player.AddPrimaryObjective("Eliminate all GDI forces in this area.")
			NodObjective5 = player.AddSecondaryObjective("Capture and hold the GDI laboratory.")
			player.MarkCompletedObjective(NodObjective3)
			Media.PlaySpeechNotification(player, "Reinforce")
			Reinforcements.Reinforce(player, NodMCV, { NodMCVEntry.Location, NodMCVRally.Location }, 15)
			EnterAB2()
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
	
	Trigger.OnAllKilled(Base1Tower, function()
		Reinforcements.Reinforce(enemy, Base1DestroyedReinforcements, { GDIReinforcementsEntry.Location, GDIReinforcementsRally.Location }, 15, function(Reinforcements)
			Reinforcements.AttackMove(Base1RallyInf.Location, 50)
			Reinforcements.Hunt()
		end)
	end)
	
	Trigger.OnAllKilled(Silo, function()
		Reinforcements.Reinforce(creeps, Creep1, { Creep1_WP1.Location, Creep1_WP2.Location }, 15, function(creep)
			creep.AttackMove(AB1_Vehicle2Wp2.Location, 50)
		end)
	end)
	
	Trigger.OnAllKilled(GTWR1, function()
		Reinforcements.Reinforce(enemy, Base1Reinforcements, { Actor298.Location, Actor300.Location }, 15, function(actor)
			Trigger.OnIdle(actor, function()
				actor.AttackMove(Base2AttackPoint.Location, 80)
			end)
		end)
	end)
	
	Trigger.OnAllKilledOrCaptured(GDIBuildings, function()
		MissionSuccess = 1
		Media.PlaySpeechNotification(player, "Win")
		player.MarkCompletedObjective(NodObjective4)
	end)
	
	Trigger.OnAllKilled(GDILab, function()
		player.MarkFailedObjective(NodObjective5)
	end)
	
	Trigger.OnCapture(Actor308, function()
		player.MarkCompletedObjective(NodObjective5)
		NodSecondaryReinforcements()
	end)
	
	Trigger.AfterDelay(GameStart, function()
		SendFirstTroops()
	end)
	
	Trigger.OnObjectiveAdded(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)

	Trigger.OnObjectiveCompleted(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)

	Trigger.OnObjectiveFailed(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)

	Trigger.OnPlayerWon(player, function()
		Media.PlaySpeechNotification(player, "Win")
	end)

	Trigger.OnPlayerLost(player, function()
		Media.PlaySpeechNotification(player, "Lose")
	end)
	
	GDIBase1Building6.RallyPoint = Base1RallyInf.Location
	GDIBase1Building7.RallyPoint = Base1RallyVeh.Location
	AB1_GDIBase2_Building1.RallyPoint = GDIBase2_VehRally.Location
	AB1_GDIBase2_Building10.RallyPoint = GDIBase2_InfRally.Location
	
end

Tick = function()

	if DateTime.GameTime > DateTime.Seconds(5) and player.HasNoRequiredUnits() and MissionFailure == 0 then
		MissionFailure = 1
		Media.PlaySpeechNotification(player, "Lose")
		enemy.MarkCompletedObjective(GDIObjective)
	end
	
	if enemy.HasNoRequiredUnits() and MissionSuccess == 0 then
		MissionSuccess = 1
		Media.PlaySpeechNotification(player, "Win")
		player.MarkCompletedObjective(destroyBaseCenterObjective2)
	end

end

SendFirstTroops = function()
	Media.PlaySpeechNotification(player, "Reinforce")
	Reinforcements.Reinforce(player, NodStartUnits1, { NodSpawnEntry1.Location, NodSpawnRally1.Location }, 15)
	Reinforcements.Reinforce(player, NodStartUnits2, { NodSpawnEntry2.Location, NodSpawnRally1.Location }, 15)
	Trigger.OnEnteredFootprint(CellTriggers3, function(a, id)
		if a.Owner == player and ReinforcementsSpawned == 0 then
			ReinforcementsSpawned = 1
			Media.PlaySpeechNotification(player, "Reinforce")
			Reinforcements.Reinforce(player, NodStartUnits3, { NodVehiclesEntry.Location, NodVehiclesRally.Location }, 15)
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
end
	
AB1_GdiVillageVehicle = function()

	Reinforcements.Reinforce(enemy, GdiVillageVehicle, { AB1_Vehicle1Entry.Location, AB1_Vehicle1Rally.Location }, 15, function(actor)
		actor.Patrol(villagepath, true)
	end)
end

AB1_GdiVillageVehicle2 = function()

	Reinforcements.Reinforce(enemy, GdiVillageVehicle2, { AB1_Vehicle2Entry.Location, AB1_Vehicle2Rally.Location }, 15, function(actor)
		actor.Patrol(villagepath2, false)
	end)
end
	
--AB1--

--AB2--

EnterAB2 = function()

	GDIBase1ProductionLogic()
	GDIBase2ProductionLogic()
	AIRepairsBuildings()
	GDIStartAirAttacks()
	
	Trigger.AfterDelay(DateTime.Seconds(140), function()
		SendGDIAirstrike()
	end)

end

SendGDIAirstrike = function()
	if not AB1_GDIBase2_Building5.IsDead and AB1_GDIBase2_Building5.Owner == enemy then
		local target = getAirstrikeTarget()

		if target then
			AB1_GDIBase2_Building5.SendAirstrike(target, false, Facing.SouthWest + 4)
			Trigger.AfterDelay(AirstrikeDelay, SendGDIAirstrike)
		else
			Trigger.AfterDelay(AirstrikeDelay/4, SendGDIAirstrike)
		end
	end
end

searches = 0
getAirstrikeTarget = function()
	local list = player.GetGroundAttackers()

	if #list == 0 then
		return
	end

	local target = list[DateTime.GameTime % #list + 1].CenterPosition

	local sams = Map.ActorsInCircle(target, WDist.New(8 * 1024), function(actor)
		return actor.Type == "sam" end)

	if #sams == 0 then
		searches = 0
		return target
	elseif searches < 6 then
		searches = searches + 1
		return getAirstrikeTarget()
	else
		searches = 0
		return nil
	end
end

GDIBase1ProductionLogic = function()

Base1BuildAttackersInf()
Base1BuildAttackersVeh()

end

Base1BuildAttackersInf = function()

	if GDIBase1Building6.IsDead or GDIBase1Building6.Owner == player then
		return
	end
	Trigger.AfterDelay(Base1AttackInf, function()
		if not GDIBase1Building6.IsDead or not GDIBase1Building6.Owner == player then
			GDIBase1Building6.Build(Base1InfAttackers1, AttackLogic1)
			Base1BuildAttackersInf2()
		end
	end)

end

Base1BuildAttackersInf2 = function()

	if GDIBase1Building6.IsDead or GDIBase1Building6.Owner == player then
		return
	end
	Trigger.AfterDelay(Base1AttackInf2, function()
		if not GDIBase1Building6.IsDead or not GDIBase1Building6.Owner == player then
			GDIBase1Building6.Build(Base1InfAttackers2, AttackLogic1)
			Base1BuildAttackersInf()
		end
	end)

end

Base1BuildAttackersVeh = function()

	if GDIBase1Building7.IsDead or GDIBase1Building7.Owner == player then
		return
	end
	Trigger.AfterDelay(Base1AttackVeh, function()
		if not GDIBase1Building7.IsDead or not GDIBase1Building7.Owner == player then
			GDIBase1Building7.Build(Base1VehAttackers1, AttackLogic1)
			Base1BuildAttackersVeh2()
		end
	end)
	
end

Base1BuildAttackersVeh2 = function()

	if GDIBase1Building7.IsDead or GDIBase1Building7.Owner == player then
		return
	end
	Trigger.AfterDelay(Base1AttackVeh2, function()
		if not GDIBase1Building7.IsDead or not GDIBase1Building7.Owner == player then
			GDIBase1Building7.Build(Base1VehAttackers2, AttackLogic1)
			Base1BuildAttackersVeh3()
		end
	end)
	
end

Base1BuildAttackersVeh3 = function()

	if GDIBase1Building7.IsDead or GDIBase1Building7.Owner == player then
		return
	end
	Trigger.AfterDelay(Base1AttackVeh3, function()
		if not GDIBase1Building7.IsDead or not GDIBase1Building7.Owner == player then
			GDIBase1Building7.Build(Base1VehAttackers3, AttackLogic1)
			Base1BuildAttackersVeh3()
		end
	end)
	
end

GDIBase2ProductionLogic = function()

RebuildHarvesters()
BuildPatrols()
Base2BuildAttackers()

	Trigger.AfterDelay(EnterAB3, function()
		AB3_LoopReinforcementsInf()
		AB3_LoopReinforcementsVeh()
		AB3_LoopReinforcementsAir()
	end)

end

BuildPatrols = function()
	if AB1_GDIBase2_Building1.IsDead or AB1_GDIBase2_Building1.Owner == player then
		return
	end
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		if not AB1_GDIBase2_Building1.IsDead or not AB1_GDIBase2_Building1.Owner == player then
			AB1_GDIBase2_Building1.Build(Patroler, SendPatrol)
			Trigger.AfterDelay(DateTime.Seconds(60), BuildFirstAttackers)
		end
	end)
end

AttackLogic1 = function(actors)

	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(GDI_AttackPoint.Location, 50)
			actor.Hunt()
		end)
	end)

end

BuildFirstAttackers = function()

	if AB1_GDIBase2_Building1.IsDead or AB1_GDIBase2_Building1.Owner == player then
		return
	end
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		if not AB1_GDIBase2_Building1.IsDead or not AB1_GDIBase2_Building1.Owner == player then
			BuildSecondAttackers()
			AB1_GDIBase2_Building1.Build(FirstAttackers, AttackLogic1)
		end
	end)

end

BuildSecondAttackers = function()

	Trigger.AfterDelay(BuildSecondAttackersDelay, function()
		Reinforcements.Reinforce(enemy, AttackWave2, { GDIReinforcementsEntry.Location, GDIReinforcementsRally.Location }, 15, function(actor)
			Trigger.OnIdle(actor, function()
				actor.AttackMove(GDI_AttackPoint.Location, 50)
				actor.Hunt()
			end)
		end)
	end)

	Trigger.AfterDelay(StartWavesDelay, function()
		BuildAttackers1()
	end)
	
end

BuildAttackers1 = function()

	Trigger.AfterDelay(Attack1Delay, function()
		Reinforcements.Reinforce(enemy, RandomWave1, { GDIReinforcementsEntry.Location, GDIReinforcementsRally.Location }, 15, function(actor)
			Trigger.OnIdle(actor, function()
				actor.AttackMove(GDI_AttackPoint.Location, 50)
				actor.Hunt()
			end)
		end)
	end)
	
end

RebuildHarvesters = function()

	IsBuilding = 0
	AIHarvesterCount = #enemy.GetActorsByType("harv")

	if AB1_GDIBase2_Building1.IsDead or not AB1_GDIBase2_Building1.Owner == player then
		return
		
	elseif AIHarvesterCount == NIL or AIHarvesterCount == 0 and IsBuilding == 0 then
		IsBuilding = 1
		if not AB1_GDIBase2_Building1.IsDead or not AB1_GDIBase2_Building1.Owner == player then
			AB1_GDIBase2_Building1.Build(harvester, function() end)
			Trigger.AfterDelay(DateTime.Seconds(60), RebuildHarvesters)
		end
	else
		Trigger.AfterDelay(DateTime.Seconds(10), RebuildHarvesters)
	end

end

SendPatrol = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.Patrol(GDIPatrolpath, true)
		end)
	end)
	
	Trigger.OnAllKilled(actors, function()
		Trigger.AfterDelay(DateTime.Seconds(120), function()
			Reinforcements.Reinforce(enemy, Patroler, { GDIReinforcementsEntry.Location, GDIReinforcementsRally.Location }, 15, function(actor)
				Trigger.OnIdle(actor, function()
					actor.Patrol(GDIPatrolpath, true)
				end)
			end)
		end)
	end)
end

AIRepairsBuildings = function()
	Utils.Do(Map.NamedActors, function(actor)
		if actor.Owner == enemy and actor.HasProperty("StartBuildingRepairs") then
			Trigger.OnDamaged(actor, function(building)
				if building.Owner == enemy and building.Health < 0.9 * building.MaxHealth then
					building.StartBuildingRepairs()
				end
			end)
		end
	end)
end

Base2BuildAttackers = function()

	Trigger.AfterDelay(DateTime.Seconds(325), function()
		Base2StartInfProduction()
		Base2StartVehProduction()
	end)

end

AttackLogic2 = function(actors)
	Utils.Do(actors, function(actor)
		actor.AttackMove(Base2AttackPoint.Location, 15)
		Trigger.OnIdle(actor, function()
			actor.Hunt()
		end)
	end)
end

Base2StartInfProduction = function()

	if AB1_GDIBase2_Building10.IsDead or AB1_GDIBase2_Building10.Owner == player then
		return
	end
	
	Trigger.AfterDelay(Base2InfProductionInterval, function()
		if not AB1_GDIBase2_Building10.IsDead or not AB1_GDIBase2_Building10.Owner == player then
			AB1_GDIBase2_Building10.Build(Base2InfAttack, AttackLogic2)
			Trigger.AfterDelay(DateTime.Seconds(65), Base2StartInfProduction)
		end
	end)

end

AttackLogic3 = function(actors)
	Utils.Do(actors, function(actor)
		actor.AttackMove(Base2AttackPoint2.Location, 15)
		Trigger.OnIdle(actor, function()
			actor.Hunt()
		end)
	end)
end

Base2StartVehProduction = function()

	if AB1_GDIBase2_Building1.IsDead or AB1_GDIBase2_Building1.Owner == player then
		return
	end
	
	Trigger.AfterDelay(Base2VehProductionInterval, function()
		if not AB1_GDIBase2_Building1.IsDead or not AB1_GDIBase2_Building1.Owner == player then
			AB1_GDIBase2_Building1.Build(Base2VehAttack, AttackLogic3)
			Trigger.AfterDelay(DateTime.Seconds(100), Base2StartVehProduction)
		end
	end)

end

GDIStartAirAttacks = function()

	Trigger.AfterDelay(StartAirAttackTimer, function()
		Reinforcements.Reinforce(enemy, AirSneakAttack1, { GdiSneakAirAttackEntry.Location, GdiSneakAirAttackRally.Location }, 15, function(actor)
			Trigger.OnIdle(actor, function()
			actor.AttackMove(GDI_AttackPoint.Location, 25)
			end)
		end)
		GDIAirAttack2()
	end)
end

GDIAirAttack2 = function()

	Trigger.AfterDelay(AirAttack2, function()
		Reinforcements.Reinforce(enemy, AirSneakAttack2, { AirSneakAttack2Entry.Location, AirSneakAttack2Rally.Location }, 15, function(actor)
			Trigger.OnIdle(actor, function()
				actor.AttackMove(GDI_AttackPoint.Location, 25)
			end)
		end)
		GDIAirAttackLoop1()
		Trigger.AfterDelay(DateTime.Seconds(5), GDIAirAttackLoop2)
	end)

end

GDIAirAttackLoop1 = function()
	
	Trigger.AfterDelay(AirAttack1Interval, function()
		Reinforcements.Reinforce(enemy, AirLoopAttack1, { GdiAirEntry.Location, GdiAirRally.Location }, 15, function(actor1)
			Trigger.OnIdle(actor1, function()
				actor1.AttackMove(AirAttackLoop_AttackPoint1.Location, 5)
				actor1.AttackMove(GDI_AttackPoint.Location, 60)
			end)
		end)
		Trigger.AfterDelay(DateTime.Seconds(150), GDIAirAttackLoop1)
	end)

end

GDIAirAttackLoop2 = function()

	Trigger.AfterDelay(AirAttack1Interval, function()
		Reinforcements.Reinforce(enemy, AirLoopAttack2, { GdiAirEntry.Location, GdiAirRally.Location }, 15, function(actor2)
			Trigger.OnIdle(actor2, function()
				actor2.AttackMove(AirAttackLoop_AttackPoint2.Location, 5)
				actor2.AttackMove(GDI_AttackPoint.Location, 60)
			end)
		end)
		Trigger.AfterDelay(DateTime.Seconds(175), GDIAirAttackLoop2)
	end)
	
end

--AB2--

--AB3--

AB3_LoopReinforcementsInf = function()
	Trigger.AfterDelay(GDIReinforcementsLoopDelayInf, function()
		Reinforcements.Reinforce(enemy, ReinforcementsLoopInf, { GDIReinforcementsEntry.Location, GDIReinforcementsRally.Location }, 15, function(actorinf)
			Trigger.OnIdle(actorinf, function()
				actorinf.AttackMove(GDI_AttackPoint.Location, 25)
				actorinf.Hunt()
			end)
		end)
	end)
end

AB3_LoopReinforcementsVeh = function()
	Trigger.AfterDelay(GDIReinforcementsLoopDelayVeh, function()
		Reinforcements.Reinforce(enemy, ReinforcementsLoopVeh, { GDIReinforcementsEntry.Location, GDIReinforcementsRally.Location }, 15, function(actorveh)
			Trigger.OnIdle(actorveh, function()
				actorveh.AttackMove(GDI_AttackPoint.Location, 25)
				actorveh.Hunt()
			end)
		end)
	end)
end

AB3_LoopReinforcementsAir = function()
	Trigger.AfterDelay(GDIReinforcementsLoopDelayAir, function()
		Reinforcements.Reinforce(enemy, ReinforcementsLoopAir, { GDIReinforcementsEntry.Location, GDIReinforcementsRally.Location }, 15, function(actorair)
			Trigger.OnIdle(actorair, function()
				actorair.AttackMove(GDI_AttackPoint.Location, 80)
			end)
		end)
	end)
end

--AB3--