--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

if Map.Difficulty == "Easy" then
	
	--Timings--
	Base2AttackInterval = DateTime.Seconds(100)
	Base3AttackInterval = DateTime.Seconds(200)
	Base3AttackInterval_hard = DateTime.Seconds(380)
	Base4AttackInterval = DateTime.Seconds(60)
	ScriptedInfAttack1 = DateTime.Seconds(550)
	ScriptedVehicleAttack1 = DateTime.Seconds(570)
	ScriptedSneakAttack1 = DateTime.Seconds(450)
	AB3_StartTimer = DateTime.Seconds(825)

	--GdiReinforcements--
	GdiStartUnits = { "e1", "mtnk", "e1", "e1", "e1", "mtnk", "e3", "e3", "e3", "e3", "mtnk", "e3", "e3" }
	GdiStartUnitsReinforcements = { "apc", "e3", "e3", "e3", "e3" }
	GdiRockets = { "e3", "e3", "e3", "e3" }
	GdiMCV = { "jeep", "mcv", "jeep" }
	
	--NodAttackers--
	AB2_NodBase2Attackers = { "e3", "e1", "e3", "e1", "e3", "e1" }
	AB2_NodBase2Attackers2 = { "e3", "e3", "e3", "e3", "e3", "e1", "e1", "e1" }
	AB2_NodBase3Attackers_INF = { "e1", "e3", "e3" }
	AB2_NodBase3Attackers_VEH = { "bggy", "ltnk", "ltnk" }
	AB2_NodBase3Attackers_VEH_hard = { "ftnk" }
	AB2_NodReinforcementsInf = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3" }
	AB2_NodReinforcementsVeh = { "ltnk", "ltnk", "ltnk", "arty" }
	AB2_NodReinforcementsSneak = { "bike", "bike" }
	
	AB3_NodBase2Attackers = { "e3", "e1", "e3", "e1", "e1", "e3", "e1", "e3", "e4", "e4", "e4", "e3", "e1", "e3", "e3", "e3", "e1", "e1", "e1" }
	AB3_NodBase3Attackers_VEH = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "arty" }
	AB3_NodBase3Attackers_INF = { "e3", "e1", "e3", "e1", "e3", "e1", "e4", "e4", "e4" }
	AB3_NodBase4AttackersVeh = { "ftnk", "ftnk", "arty", "arty", "bggy", "bike", "bike" }
	AB3_NodBase4AttackersVeh_ex = { "bike", "bike" }
	AB3_NodBase4AttackersInf = { "e4", "e4", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e1", "e1", "e3", "e1", "e3" }
	AB3_NodReinforcementsGround = { "ftnk", "ftnk", "ltnk", "mlrs" }
	AB3_NodReinforcementsArty = { "arty", "arty", "ltnk", "mlrs" }
	
elseif Map.Difficulty == "Normal" then

	--Timings--
	Base2AttackInterval = DateTime.Seconds(50)
	Base3AttackInterval = DateTime.Seconds(180)
	Base3AttackInterval_hard = DateTime.Seconds(350)
	Base4AttackInterval = DateTime.Seconds(45)
	ScriptedInfAttack1 = DateTime.Seconds(510)
	ScriptedVehicleAttack1 = DateTime.Seconds(525)
	ScriptedSneakAttack1 = DateTime.Seconds(410)
	AB3_StartTimer = DateTime.Seconds(790)

	--GdiReinforcements--
	GdiStartUnits = { "e1", "mtnk", "e1", "e1", "e1", "mtnk", "e3", "e3", "e3", "e3" }
	GdiStartUnitsReinforcements = { "jeep", "e3", "e3", "e3", "e3" }
	GdiRockets = { "e3", "e3", "e3", "e3" }
	GdiMCV = { "jeep", "mcv", "jeep" }
	
	--NodAttackers--
	AB2_NodBase2Attackers = { "e3", "e1", "e3", "e1", "e1", "e3", "e1", "e3", "e1" }
	AB2_NodBase2Attackers2 = { "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e1", "e1", "e1" }
	AB2_NodBase3Attackers_INF = { "e3", "e1", "e3", "e1", "e3", "e1" }
	AB2_NodBase3Attackers_VEH = { "ltnk", "ltnk", "arty", "bike", "bike", "bike" }
	AB2_NodBase3Attackers_VEH_hard = { "ftnk", "ftnk" }
	AB2_NodReinforcementsInf = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e4", "e4", "e4", "e4" }
	AB2_NodReinforcementsVeh = { "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty" }
	AB2_NodReinforcementsSneak = { "bike", "bike", "bike", "bike" }

	AB3_NodBase2Attackers = { "e3", "e1", "e3", "e1", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e3", "e3", "e1", "e1", "e1" }
	AB3_NodBase3Attackers_VEH = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty", "mlrs" }
	AB3_NodBase3Attackers_INF = { "e3", "e1", "e3", "e1", "e3", "e1", "e1", "e3", "e1", "e4", "e4", "e4" }
	AB3_NodBase4AttackersVeh = { "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "bggy", "bike", "bike" }
	AB3_NodBase4AttackersVeh_ex = { "bike", "bike", "bike", "bike" }
	AB3_NodBase4AttackersInf = { "e3", "e1", "e3", "e1", "e1", "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e4", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e1", "e1", "e3", "e1", "e3" }
	AB3_NodReinforcementsGround = { "ftnk", "ftnk", "ltnk", "ltnk", "mlrs" }
	AB3_NodReinforcementsArty = { "arty", "arty", "ltnk", "ltnk", "ltnk", "mlrs" }
	
elseif Map.Difficulty == "Hard" then

	--Timings--
	Base2AttackInterval = DateTime.Seconds(50)
	Base3AttackInterval = DateTime.Seconds(180)
	Base3AttackInterval_hard = DateTime.Seconds(230)
	Base4AttackInterval = DateTime.Seconds(60)
	ScriptedInfAttack1 = DateTime.Seconds(470)
	ScriptedVehicleAttack1 = DateTime.Seconds(485)
	ScriptedSneakAttack1 = DateTime.Seconds(425)
	AB3_StartTimer = DateTime.Seconds(850)
	
	--GdiReinforcements
	GdiStartUnits = { "e1", "apc", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "apc" }
	GdiStartUnitsReinforcements = { "jeep", "e3", "e3" }
	GdiRockets = { "e3", "e3", "e3", "e3" }
	GdiMCV = { "jeep", "mcv", "jeep" }
	
	--NodAttackers--
	AB2_NodBase2Attackers = { "e3", "e1", "e3", "e1", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1" }
	AB2_NodBase2Attackers2 = { "e3", "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e4", "e1", "e1", "e1", "e1", "e1", "e1" }
	AB2_NodBase3Attackers_INF = { "e3", "e1", "e3", "e1", "e3", "e1" }
	AB2_NodBase3Attackers_VEH = { "ltnk", "ltnk", "arty", "bike", "ltnk", "ltnk", "ltnk" }
	AB2_NodBase3Attackers_VEH_hard = { "ftnk", "ftnk" }
	AB2_NodReinforcementsInf = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e4", "e4" }
	AB2_NodReinforcementsVeh = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty" }
	AB2_NodReinforcementsSneak = { "stnk", "stnk" }
	
	AB3_NodBase2Attackers = { "e3", "e1", "e3", "e1", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e4", "e1", "e1", "e1", "e1", "e1", "e1" }
	AB3_NodBase3Attackers_VEH = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty", "mlrs" }
	AB3_NodBase3Attackers_INF = { "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e4", "e4", "e4" }
	AB3_NodBase4AttackersVeh = { "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "bggy", "bike", "bike", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" }
	AB3_NodBase4AttackersVeh_ex = { "bike", "bike", "bike", "bike", "bike" }
	AB3_NodBase4AttackersInf = { "e3", "e1", "e3", "e1", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e4", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e1", "e1", "e3", "e1", "e3" }
	AB3_NodReinforcementsGround = { "ftnk", "ftnk", "ftnk", "ftnk", "ltnk", "ltnk", "mlrs" }
	AB3_NodReinforcementsArty = { "arty", "arty", "arty", "arty", "ltnk", "ltnk", "ltnk", "mlrs" }
	
else
	
	--Timings--
	Base2AttackInterval = DateTime.Seconds(35)
	Base3AttackInterval = DateTime.Seconds(150)
	Base3AttackInterval_hard = DateTime.Seconds(170)
	Base4AttackInterval = DateTime.Seconds(60)
	ScriptedInfAttack1 = DateTime.Seconds(470)
	ScriptedVehicleAttack1 = DateTime.Seconds(485)
	ScriptedSneakAttack1 = DateTime.Seconds(425)
	AB3_StartTimer = DateTime.Seconds(775)
	
	--GdiReinforcements
	GdiStartUnits = { "e1", "apc", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "apc" }
	GdiStartUnitsReinforcements = { "jeep", "e3", "e3" }
	GdiRockets = { "e3", "e3", "e3", "e3" }
	GdiMCV = { "jeep", "mcv", "jeep" }
	
	--NodAttackers--
	AB2_NodBase2Attackers = { "e3", "e1", "e3", "e1", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1" }
	AB2_NodBase2Attackers2 = { "e3", "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e4", "e1", "e1", "e1", "e1", "e1", "e1" }
	AB2_NodBase3Attackers_INF = { "e3", "e1", "e3", "e1", "e3", "e1" }
	AB2_NodBase3Attackers_VEH = { "ltnk", "ltnk", "arty", "bike", "ltnk", "ltnk", "ltnk" }
	AB2_NodBase3Attackers_VEH_hard = { "ftnk", "ftnk" }
	AB2_NodReinforcementsInf = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e4", "e4" }
	AB2_NodReinforcementsVeh = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty" }
	AB2_NodReinforcementsSneak = { "stnk", "stnk" }
	brutal_vehicles1 = { "bggy", "bggy", "bike" }
	brutal_vehicles2 = { "stnk", "stnk" }
	
	AB3_NodBase2Attackers = { "e3", "e1", "e3", "e1", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e4", "e1", "e1", "e1", "e1", "e1", "e1" }
	AB3_NodBase3Attackers_VEH = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty", "arty", "mlrs" }
	AB3_NodBase3Attackers_INF = { "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e4", "e4", "e4", "e3", "e1" }
	AB3_NodBase4AttackersVeh = { "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "bggy", "bike", "bike", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" }
	AB3_NodBase4AttackersVeh_ex = { "stnk", "stnk", "stnk", "bike", "bike" }
	AB3_NodBase4AttackersInf = { "e3", "e1", "e3", "e1", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e1", "e3", "e3", "e3", "e3", "e3", "e4", "e4", "e4", "e4", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e1", "e1", "e3", "e1", "e3" }
	AB3_NodReinforcementsGround = { "ftnk", "ftnk", "ftnk", "ftnk", "ltnk", "ltnk", "mlrs", "stnk", "stnk" }
	AB3_NodReinforcementsArty = { "arty", "arty", "arty", "arty", "ltnk", "ltnk", "ltnk", "mlrs", "stnk", "stnk" }
	
end

--NodBuildings--
NodBase1 = { AB1_NodBuilding1, AB1_NodBuilding2, AB1_NodBuilding3, AB1_NodBuilding4, AB1_NodBuilding5, AB1_NodBuilding6, AB1_NodBuilding7, AB1_NodBuilding8 }
NodBase1ExceptCYard = { AB1_NodBuilding2, AB1_NodBuilding3, AB1_NodBuilding4, AB1_NodBuilding5, AB1_NodBuilding6, AB1_NodBuilding7, AB1_NodBuilding8 }
NodDefenseFirstLine = { AB1_NodBuilding7, AB1_NodBuilding8 }

AB2_NodBase2 = { AB2_NodBase1_Building1, AB2_NodBase1_Building2, AB2_NodBase1_Building3, AB2_NodBase1_Building4, AB2_NodBase1_Building5, AB2_NodBase1_Building6 }
AB2_NodBase3 = { AB2_NodBase2_Building1, AB2_NodBase2_Building2, AB2_NodBase2_Building3, AB2_NodBase2_Building4, AB2_NodBase2_Building5, AB2_NodBase2_Building6, AB2_NodBase2_Building7, AB2_NodBase2_Building8, AB2_NodBase2_Building9, AB2_NodBase2_Building10, AB2_NodBase2_Building11, AB2_NodBase2_Building12, AB2_NodBase2_Building13, AB2_NodBase2_Building14, AB2_NodBase2_Building15, AB2_NodBase2_Building16, AB2_NodBase2_Building17, AB2_NodBase2_Building18, AB2_NodBase2_Building19, AB2_NodBase2_Building20 }
AB3_NodBase = { AB3_NodBase_Building1, AB3_NodBase_Building2, AB3_NodBase_Building3, AB3_NodBase_Building4, AB3_NodBase_Building5, AB3_NodBase_Building6, AB3_NodBase_Building7, AB3_NodBase_Building8, AB3_NodBase_Building9, AB3_NodBase_Building10, AB3_NodBase_Building11, AB3_NodBase_Building12, AB3_NodBase_Building13, AB3_NodBase_Building14 }

SamSites = { SamSite1, SamSite2, SamSite3, SamSite4, SamSite5, SamSite6, SamSite7, SamSite8, SamSite9, SamSite10}

NodBuildings = { AB2_NodBase1_Building1, AB2_NodBase1_Building2, AB2_NodBase1_Building3, AB2_NodBase1_Building4, AB2_NodBase1_Building5, AB2_NodBase1_Building6, AB2_NodBase1_Building1, AB2_NodBase1_Building2, AB2_NodBase1_Building3, AB2_NodBase1_Building4, AB2_NodBase1_Building5, AB2_NodBase1_Building6, AB2_NodBase2_Building1, AB2_NodBase2_Building2, AB2_NodBase2_Building3, AB2_NodBase2_Building4, AB2_NodBase2_Building5, AB2_NodBase2_Building6, AB2_NodBase2_Building7, AB2_NodBase2_Building8, AB2_NodBase2_Building9, AB2_NodBase2_Building10, AB2_NodBase2_Building11, AB2_NodBase2_Building12, AB2_NodBase2_Building13, AB2_NodBase2_Building14, AB2_NodBase2_Building15, AB2_NodBase2_Building16, AB2_NodBase2_Building17, AB2_NodBase2_Building18, AB2_NodBase2_Building19, AB2_NodBase2_Building20, AB3_NodBase_Building1, AB3_NodBase_Building2, AB3_NodBase_Building3, AB3_NodBase_Building4, AB3_NodBase_Building5, AB3_NodBase_Building6, AB3_NodBase_Building7, AB3_NodBase_Building8, AB3_NodBase_Building9, AB3_NodBase_Building10, AB3_NodBase_Building11, AB3_NodBase_Building12, AB3_NodBase_Building13, AB3_NodBase_Building14 }

--SpecUnits
ScaryTank = AB1_ScaryTank1

--Other--

GameStart = DateTime.Seconds(1)
GameStartT = DateTime.Seconds(4)
AB2EndReached = 0

--Production--

inf1 = { "e1" } --base1
veh1 = { "bggy" } --base1
harvester = { "harv" }

--Waypoints--

BaseInfAttackWpts = { BaseInfAttackWpt1.Location, BaseInfAttackWpt2.Location, BaseInfAttackWpt3.Location, BaseInfAttackWpt4.Location }
Base3_VEHAttackWpts = { AB2_NodBase3Attackers_VEH_WP1.Location, AB2_NodBase3Attackers_VEH_WP2.Location }
Base3_INFAttackWpts = { AB2_NodBase3Attackers_INF_WP1.Location, AB2_NodBase3Attackers_INF_WP2.Location }
brutal_atck1path = { Brutal_Attack1_WP2.Location, Brutal_Attack1_WP3.Location, Brutal_Attack1_WP4. Location }
brutal_patrolpath = { Actor433.Location, Actor434.Location, Actor435. Location, Actor434.Location }

--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

--Globals

Objectives = function()

	MissionFailure = 0
	MissionSuccess = 0
	AirSupportActive = 0
	Base1Destroyed = 0
	Base2Destroyed = 0
	Base3Destroyed = 0
	EnemyHasNoBases = 0

	player = Player.GetPlayer("GDI")
	enemy = Player.GetPlayer("Nod")

	destroyBaseCenterObjective1 = player.AddPrimaryObjective("Destroy the Nod base in this area.")
	nodObjective = enemy.AddPrimaryObjective("Destroy all GDI troops.")
	
	Trigger.OnAllKilledOrCaptured(NodBase1, function()
		destroyBaseCenterObjective2 = player.AddPrimaryObjective("Eliminate all Nod forces in this area.")
		player.MarkCompletedObjective(destroyBaseCenterObjective1)
		EnterAB2()
	end)
	
	Trigger.OnAllKilledOrCaptured(NodBuildings, function()
		MissionSuccess = 1
		Media.PlaySpeechNotification(player, "Win")
		player.MarkCompletedObjective(destroyBaseCenterObjective2)
	end)
	
	Trigger.OnObjectiveAdded(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)
	Trigger.OnObjectiveCompleted(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)
	
	--Trigger.OnAllKilledOrCaptured(SamSites, function()
		--if AirSupportActive == 0 then
			--AirSupportActive = 1
			--AirSupport = Actor.Create("airstrike.proxy", true, { Owner = player })
			--AirSupportEnabled = true
			--player.MarkCompletedObjective(destroySAMsCenterObjective)
		--end
	--end)

end

Tick = function()

	if DateTime.GameTime > DateTime.Seconds(5) and player.HasNoRequiredUnits() and MissionFailure == 0 then
		MissionFailure = 1
		Media.PlaySpeechNotification(player, "Lose")
		enemy.MarkCompletedObjective(nodObjective)
	end
	
	if enemy.HasNoRequiredUnits() and MissionSuccess == 0 then
		MissionSuccess = 1
		Media.PlaySpeechNotification(player, "Win")
		player.MarkCompletedObjective(destroyBaseCenterObjective2)
	end

end

--Globals

--AB1--

WorldLoaded = function()

	AirSupport = Actor.Create("airstrike.proxy", true, { Owner = player })
	AirSupportEnabled = true

	BasicActions()
	Objectives()

    player = Player.GetPlayer("GDI")
    enemy = Player.GetPlayer("Nod")

	Camera.Position = CameraPos.CenterPosition 
	
	Flare = Actor.Create('flare', true, { Owner = player, Location = IRevealSomeShroudForYou.Location })
	Trigger.AfterDelay(GameStart, function()
		SendFirstVehicles()
	end)
	
	
	Trigger.OnAllKilledOrCaptured(NodBase1, function()
		SendPlayerMCV()
	end)
	
	--Trigger.OnAllKilledOrCaptured(NodBase1ExceptCYard, function()
		--IFCYARDLASTBUILDING()
	--end)
	
	Trigger.OnAllKilledOrCaptured(NodDefenseFirstLine, function()
		IF2TOWERSDESTROYED()
	end)
	
end

SendFirstVehicles = function()
	Media.PlaySpeechNotification(player, "Reinforce")
	Reinforcements.Reinforce(player, GdiStartUnits, { AB1_PlayerUnitsEntry.Location, AB1_PlayerUnitsRally.Location }, 15)
end

--IFCYARDLASTBUILDING = function()

	--Add it later maybe--

--end

IF2TOWERSDESTROYED = function()

	FirstBaseInfantryProduction()
	FirstBaseTankProduction()

	if not AB1_ScaryTank1.IsDead then
		AB1_ScaryTank1.AttackMove(AB1_AttackPoint1.Location, 10)
	end
	if not AB1_Bike1.IsDead then
		AB1_Bike1.AttackMove(AB1_AttackPoint1.Location, 10)
	end
	if not AB1_Bike2.IsDead then
		AB1_Bike2.AttackMove(AB1_AttackPoint1.Location, 10)
	end
	
	Trigger.AfterDelay(DateTime.Seconds(6), function()
		Media.PlaySpeechNotification(player, "Reinforce")
		Reinforcements.Reinforce(player, GdiStartUnitsReinforcements, { AB1_PlayerUnitsEntry.Location, AB1_PlayerUnitsRally.Location }, 15)
	end)
	
	Trigger.AfterDelay(DateTime.Seconds(125), function()
		if not NodBase1.IsDead then
			Media.PlaySpeechNotification(player, "Reinforce")
			Reinforcements.Reinforce(player, GdiRockets, { AB1_PlayerUnitsEntry.Location, AB1_PlayerUnitsRally.Location }, 15)
		end
	end)
end

SendPlayerMCV = function()
	Trigger.AfterDelay(DateTime.Seconds(4), function()
		Media.PlaySpeechNotification(player, "Reinforce")
		Reinforcements.Reinforce(player, GdiMCV, { AB1_PlayerUnitsEntry.Location, AB1_PlayerUnitsRally.Location }, 15)
	end)
end

BasicActions = function(ScaryTank)
	Trigger.AfterDelay(DateTime.Seconds(8), function()
		if not AB1_ScaryTank1.IsDead then
			AB1_ScaryTank1.Move(ScaryTankPoint.Location)
		end
	end)
end

FirstBaseInfantryProduction = function()
	if AB1_NodBuilding2.IsDead or AB1_NodBuilding2.Owner == player then
		return
	end
	AB1_NodBuilding2.Build(inf1, SquadHunt)
	Trigger.AfterDelay(DateTime.Seconds(15), FirstBaseInfantryProduction)
end

FirstBaseTankProduction = function()
	if AB1_NodBuilding5.IsDead or AB1_NodBuilding5.Owner == player then
		return
	end
	AB1_NodBuilding5.Build(veh1, SquadHunt)
	Trigger.AfterDelay(DateTime.Seconds(15), FirstBaseTankProduction)
end

SquadHunt = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB1_PlayerUnitsRally.Location, 50)
			actor.Hunt()
		end)
	end)
end

--AB1--

--AB2--

EnterAB2 = function()
	RepairAI()
	AB2_ScriptedAttackTimers()
	Base2Attack()
	Base3Attack_INF()
	Base3Attack_VEH()
	AB2_EndScript()
	if Map.Difficulty == "Hard" or Map.Difficulty == "Brutal" then
		Base3Attack_VEH_hard()
	end
	if Map.Difficulty == "Brutal" then
		Brutal_Attack1()
		Brutal_StnkPatrol()
	end
	--AIRebuildHarvesters()
	--Base3RebuildAI()
end

Brutal_Attack1 = function()

	Trigger.AfterDelay(DateTime.Seconds(50), function()
		Reinforcements.Reinforce(enemy, brutal_vehicles1, { Brutal_Attack1_WP1.Location, Brutal_Attack1_WP2.Location }, 15, function(actor)
			actor.Patrol(brutal_atck1path, false)
		end)
	end)

end

Brutal_StnkPatrol = function()

	Trigger.AfterDelay(DateTime.Seconds(120), function()
		Reinforcements.Reinforce(enemy, brutal_vehicles2, { ScriptedAttacKSneakEntry.Location, ScriptedAttacKSneakRally.Location }, 15, function(StnkPatrolers)
			StnkPatrolers.Patrol(brutal_patrolpath, true)
		end)
	end)

end

RepairAI = function()
	Utils.Do(Map.NamedActors, function(actor)
		if actor.Owner == enemy and actor.HasProperty("StartBuildingRepairs") then
			Trigger.OnDamaged(actor, function(building)
				if building.Owner == enemy then
					building.StartBuildingRepairs()
				end
			end)
		end
	end)
end

AIRebuildHarvesters = function(ai)
	if AIHarvesterCount == NIL or AIHarvesterCount == 0 then
		AIHarvesterCount = #ai.GetActorsByType("harv")
		IsBuildingHarvester = false
	end

	local CurrentHarvesterCount = #ai.GetActorsByType("harv")

	if CurrentHarvesterCount < AIHarvesterCount and AB3_NodBase_Building13.Owner == enemy and not IsBuildingHarvester and not AB3_NodBase_Building13.IsDead then
		IsBuildingHarvester = true
		AB3_NodBase_Building13.Build(harvester, function()
			IsBuildingHarvester = false
		end)
	end
	Trigger.AfterDelay(DateTime.Seconds(5), function() AIRebuildHarvesters(ai) end)
end

--Base3RebuildAI = function()
	--if AB2_NodBase2_Building11.IsDead and not AB2_NodBase2_Building3.IsDead
		--AB2_NodBase2_Building3.Build(AB2_NodBase2_Building11, Base3RebuildAI)
	--elseif AB2_NodBase2_Building9.IsDead and not AB2_NodBase2_Building3.IsDead
		--AB2_NodBase2_Building3.Build(AB2_NodBase2_Building9, Base3RebuildAI)
	--elseif AB2_NodBase2_Building17.IsDead and not AB2_NodBase2_Building3.IsDead
		--AB2_NodBase2_Building3.Build(AB2_NodBase2_Building17, Base3RebuildAI)
	--elseif AB2_NodBase2_Building8.IsDead and not AB2_NodBase2_Building3.IsDead
		--AB2_NodBase2_Building3.Build(AB2_NodBase2_Building8, Base3RebuildAI)
	--elseif AB2_NodBase2_Building12.IsDead and not AB2_NodBase2_Building3.IsDead
		--AB2_NodBase2_Building3.Build(AB2_NodBase2_Building12, Base3RebuildAI)
	--elseif AB2_NodBase2_Building5.IsDead and not AB2_NodBase2_Building3.IsDead
		--AB2_NodBase2_Building3.Build(AB2_NodBase2_Building5, Base3RebuildAI)
	--elseif AB2_NodBase2_Building15.IsDead and not AB2_NodBase2_Building3.IsDead
		--AB2_NodBase2_Building3.Build(AB2_NodBase2_Building15, Base3RebuildAI)
	--end
--end

AB2_EndScript = function()

	Trigger.AfterDelay(AB3_StartTimer, function()
		EnterAB3()
	end)

end

AB2_ScriptedAttackTimers = function()
	Trigger.AfterDelay(ScriptedInfAttack1, function()
		AB2_ScriptedInfAttack()
	end)
	Trigger.AfterDelay(ScriptedVehicleAttack1, function()
		AB2_ScriptedVehicleAttack()
	end)
	Trigger.AfterDelay(ScriptedSneakAttack1, function()
		AB2_ScriptedSneakAttack()
	end)
end

AB2_ScriptedInfAttack = function()

	Reinforcements.Reinforce(enemy, AB2_NodReinforcementsInf, { ScriptedAttackInfEntry.Location, ScriptedAttackInfRally.Location }, 15, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB2_AttackPoint1.Location, 15)
			actor.Hunt()
		end)
	end)
end

AB2_ScriptedVehicleAttack = function()

	Reinforcements.Reinforce(enemy, AB2_NodReinforcementsVeh, { ScriptedAttackVehEntry.Location, ScriptedAttackVehRally.Location }, 15, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB2_AttackPoint1.Location, 15)
			actor.Hunt()
		end)
	end)
end

AB2_ScriptedSneakAttack = function()

	Reinforcements.Reinforce(enemy, AB2_NodReinforcementsSneak, { ScriptedAttacKSneakEntry.Location, ScriptedAttacKSneakRally.Location }, 15, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB2_SneakAttackWaypoint.Location, 3)
			actor.Hunt()
		end)
	end)

end

AB2_AttackLogic1 = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB2_AttackPoint1.Location, 50)
			actor.Hunt()
		end)
	end)
end

--not perfect, but it works
Base2Attack = function()
	if AB2_NodBase1_Building4.IsDead or AB2_NodBase1_Building4.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	end
	Trigger.AfterDelay(Base2AttackInterval, function()
		if not AB2_NodBase1_Building4.IsDead or not AB2_NodBase1_Building4.Owner == player then
			AB2_NodBase1_Building4.Build(AB2_NodBase2Attackers, AB2_AttackLogic1)
			Trigger.AfterDelay(DateTime.Seconds(150), Base2Attack2)
		end
	end)
end

Base2Attack2 = function()
	if AB2_NodBase1_Building4.IsDead or AB2_NodBase1_Building4.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	end
	Trigger.AfterDelay(Base2AttackInterval, function()
		if not AB2_NodBase1_Building4.IsDead or not AB2_NodBase1_Building4.Owner == player then
			AB2_NodBase1_Building4.Build(AB2_NodBase2Attackers2, AB2_AttackLogic1)
			Trigger.AfterDelay(DateTime.Seconds(190), Base2Attack)
		end
	end)
end

AB2_AttackLogic2 = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB2_SneakAttackWaypoint.Location, 3)
			actor.Hunt()
		end)
	end)
end

Base3Attack_INF = function()
	if AB2_NodBase2_Building9.IsDead or AB2_NodBase2_Building9.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	elseif AB2_NodBase2_Building20.IsDead or AB2_NodBase2_Building20.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	end
	Trigger.AfterDelay(Base3AttackInterval, function()
		if not AB2_NodBase2_Building9.IsDead or not AB2_NodBase2_Building9.Owner == player then
			AB2_NodBase2_Building9.Build(AB2_NodBase3Attackers_INF, AB2_AttackLogic2)
			Trigger.AfterDelay(DateTime.Seconds(175), Base3Attack_INF)
		elseif not AB2_NodBase2_Building20.IsDead or not AB2_NodBase2_Building20.Owner == player then
			AB2_NodBase2_Building20.Build(AB2_NodBase3Attackers_INF, AB2_AttackLogic2)
			Trigger.AfterDelay(DateTime.Seconds(175), Base3Attack_INF)
		end
	end)
end

AB2_AttackLogic3 = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB2_AttackPoint1.Location, 25)
			actor.Hunt()
		end)
	end)
end

Base3Attack_VEH = function()
	if AB2_NodBase2_Building8.IsDead or AB2_NodBase2_Building8.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	end
	Trigger.AfterDelay(Base3AttackInterval, function()
		if not AB2_NodBase2_Building8.IsDead or not AB2_NodBase2_Building8.Owner == player then
			AB2_NodBase2_Building8.Build(AB2_NodBase3Attackers_VEH, AB2_AttackLogic3)
			Trigger.AfterDelay(DateTime.Seconds(220), Base3Attack_VEH)
		end
	end)
end

AB2_AttackLogic4 = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB2_SneakAttackWaypoint.Location, 3)
			actor.Hunt()
		end)
	end)
end

Base3Attack_VEH_hard = function()
	if AB2_FtnkAirfield.IsDead or AB2_FtnkAirfield.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	end
	Trigger.AfterDelay(Base3AttackInterval_hard, function()
		if not AB2_FtnkAirfield.IsDead or not AB2_FtnkAirfield.Owner == player then
			AB2_FtnkAirfield.Build(AB2_NodBase3Attackers_VEH_hard, AB2_AttackLogic4)
			Trigger.AfterDelay(DateTime.Seconds(75), Base3Attack_VEH_hard)
		end
	end)
end

--AB2--

--AB3--

EnterAB3 = function()

	AB3_Base2Attack()
	AB3_Base3AttackVeh()
	AB3_Base3AttackInf()
	AB3_FtnkAirfield()
	AB3_AttackLooper()
	
	Trigger.AfterDelay(DateTime.Seconds(85), function()
		AB3_Base4AttackVeh()
		AB3_Base4AttackInf()
		AB3_ReinforcementLoopVehicle1()
		AB3_ReinforcementLoopVehicle2()
	end)
end

AB3_AttackLooper = function()

	Trigger.AfterDelay(DateTime.Seconds(150), AB3_ReinforcementLoopVehicle1)
	Trigger.AfterDelay(DateTime.Seconds(150), AB3_ReinforcementLoopVehicle2)
	Trigger.AfterDelay(DateTime.Seconds(150), AB3_AttackLooper)
	
end

AB3_Base2Attack = function()
	if AB2_NodBase1_Building4.IsDead or AB2_NodBase1_Building4.Owner == player then
		return
	end
	Trigger.AfterDelay(Base2AttackInterval, function()
		if not AB2_NodBase1_Building4.IsDead or not AB2_NodBase1_Building4.Owner == player then
			AB2_NodBase1_Building4.Build(AB3_NodBase2Attackers, AB2_AttackLogic1)
			Trigger.AfterDelay(DateTime.Seconds(95), AB3_Base2Attack)
		end
	end)
end

AB3_Base3AttackVeh = function()
	if AB2_NodBase2_Building8.IsDead or AB2_NodBase2_Building8.Owner == player then
		return
	end
	Trigger.AfterDelay(Base3AttackInterval, function()
		if not AB2_NodBase2_Building8.IsDead or not AB2_NodBase2_Building8.Owner == player then
			AB2_NodBase2_Building8.Build(AB3_NodBase3Attackers_VEH, AB2_AttackLogic3)
			Trigger.AfterDelay(DateTime.Seconds(75), AB3_Base3AttackVeh)
		end
	end)
end

AB3_Base3AttackInf = function()
	if AB2_NodBase2_Building9.IsDead or AB2_NodBase2_Building9.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	elseif AB2_NodBase2_Building20.IsDead or AB2_NodBase2_Building20.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	end
	Trigger.AfterDelay(Base3AttackInterval, function()
		if not AB2_NodBase2_Building9.IsDead or not AB2_NodBase2_Building9.Owner == player then
			AB2_NodBase2_Building9.Build(AB3_NodBase3Attackers_INF, AB2_AttackLogic2)
			Trigger.AfterDelay(DateTime.Seconds(100), AB3_Base3AttackInf)
		elseif not AB2_NodBase2_Building20.IsDead or not AB2_NodBase2_Building20.Owner == player then
			AB2_NodBase2_Building20.Build(AB3_NodBase3Attackers_INF, AB2_AttackLogic2)
			Trigger.AfterDelay(DateTime.Seconds(80), AB3_Base3AttackInf)
		end
	end)
end

AB3_FtnkAirfield = function()
	if AB2_FtnkAirfield.IsDead or AB2_FtnkAirfield.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	end
	Trigger.AfterDelay(Base3AttackInterval_hard, function()
		if not AB2_FtnkAirfield.IsDead or not AB2_FtnkAirfield.Owner == player then
			AB2_FtnkAirfield.Build(AB2_NodBase3Attackers_VEH_hard, AB2_AttackLogic4)
			Trigger.AfterDelay(DateTime.Seconds(5), AB3_FtnkAirfield)
		end
	end)
end

AB3_AttackLogic1 = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB2_AttackPoint1.Location, 100)
			actor.Hunt()
		end)
	end)
end

AB3_Base4AttackVeh = function()
	if AB3_NodBase_Building13.IsDead or AB3_NodBase_Building13.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	end
	Trigger.AfterDelay(Base4AttackInterval, function()
		if not AB3_NodBase_Building13.IsDead or not AB3_NodBase_Building13.Owner == player then
			AB3_NodBase_Building13.Build(AB3_NodBase4AttackersVeh, AB3_AttackLogic1)
			Trigger.AfterDelay(DateTime.Seconds(5), AB3_HuntTeam)
			Trigger.AfterDelay(DateTime.Seconds(110), AB3_Base4AttackVeh)
		end
	end)
end

AB3_AttackLogic2 = function(actors)
	Utils.Do(actors, function(actor)
		Trigger.OnIdle(actor, function()
			actor.Hunt()
		end)
	end)
end

AB3_HuntTeam = function()
	if AB3_NodBase_Building13.IsDead or AB3_NodBase_Building13.Owner == player then
		if AB2EndReached == 1 then
			return
		end
	end
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		if not AB3_NodBase_Building13.IsDead or not AB3_NodBase_Building13.Owner == player then
			AB3_NodBase_Building13.Build(AB3_NodBase4AttackersVeh_ex, AB3_AttackLogic2)
		end
	end)
end

AB3_Base4AttackInf = function()
	if AB3_NodBase_Building8.IsDead or AB3_NodBase_Building8.Owner == player then
		return
	end
	Trigger.AfterDelay(Base4AttackInterval, function()
		if not AB3_NodBase_Building8.IsDead or not AB3_NodBase_Building8.Owner == player then
			AB3_NodBase_Building8.Build(AB3_NodBase4AttackersInf, AB2_AttackLogic1)
			Trigger.AfterDelay(DateTime.Seconds(55), AB3_Base4AttackInf)
		end
	end)
end

AB3_ReinforcementLoopVehicle1 = function()
	Reinforcements.Reinforce(enemy, AB3_NodReinforcementsGround, { ScriptedAttackVehEntry.Location, ScriptedAttackVehRally.Location }, 15, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB3_ReinforcmentGroundPoint.Location, 10)
			actor.Hunt()
		end)
	end)
end

AB3_ReinforcementLoopVehicle2 = function()
	Reinforcements.Reinforce(enemy, AB3_NodReinforcementsArty, { ScriptedAttackVehEntry.Location, ScriptedAttackVehRally.Location }, 15, function(actor)
		Trigger.OnIdle(actor, function()
			actor.AttackMove(AB3_ReinforcmentArtyPoint.Location, 10)
			actor.Hunt()
		end)
	end)
end
--AB3--