bdebug = false -- for debug only
showallyresource = false
startObj2 = false
spiedCY = false

AIHouses = { }
AlliedHouses = { }
SovietHouses = { }

playeralreadydamaged = false
InBase = false

AlliedTechCenter = { ALLIEDTECH }
TanyaATech = false
STNKATech = false

CameraSets = 
{ 
	{ PlayerCamera },
	{ USSRBaseCamera }
}

Tanyas = { }
STNKs = { }

SovNorthGuards = { NorthGuards1, NorthGuards2, NorthGuards3, NorthGuards4, NorthGuards5 }
SovSouthGuards = { SouthGuards1, SouthGuards2, SouthGuards3, SouthGuards4, SouthGuards5, SouthGuards6, SouthGuards7}
SovNorthGuardsPath = { SovNorthGuardA.Location, SovNorthGuardB.Location }
SovSouthGuardsPath = { SovSouthGuardA.Location, SovSouthGuardB.Location }
SovShoreGuard = { ShoreGuard1, ShoreGuard2, ShoreGuard3,ShoreGuard4 }

if Map.Difficulty == "Easy" then
	InitMoney = { 6000, 10000, 2500 }
	TimerTicks = DateTime.Minutes(12)
elseif Map.Difficulty == "Mental" then
	InitMoney = { 3000, 15000, 200000 }
	TimerTicks = DateTime.Minutes(21)
else
	InitMoney = { 4500, 10000, 20000 }
	TimerTicks = DateTime.Minutes(16)
end

Announcements =
{
	{ speech = "TenMinutesRemaining", timeleft = DateTime.Minutes(10) },
	{ speech = "WarningFiveMinutesRemaining", timeleft = DateTime.Minutes(5) },
	{ speech = "WarningFourMinutesRemaining", timeleft = DateTime.Minutes(4) },
	{ speech = "WarningThreeMinutesRemaining", timeleft = DateTime.Minutes(3) },
	{ speech = "WarningTwoMinutesRemaining", timeleft = DateTime.Minutes(2) },
	{ speech = "WarningOneMinuteRemaining", timeleft = DateTime.Minutes(1) },
	{ speech = "AlliedReinforcementsNorth", timeleft = 0 }
}

str_tick_init = 600
str_tick = str_tick_init
str_switch = ""
ticked = TimerTicks
Tick = function()

	Utils.Do(AIHouses, function(h)
		if h.Resources >= h.ResourceCapacity * 0.75 then
			h.Cash = h.Cash + h.Resources - h.ResourceCapacity * 0.25
			h.Resources = h.ResourceCapacity * 0.25
		end
	end)
			
	if not startObj2 then
		ticked = TimerTicks
	else
		ticked = ticked - 1	
	end
	
	if ticked == TimerTicks then
		TickShowInfo(player)
	elseif ticked % 2000 <= 800 and spiedCY then
		TickShowInfo(pl_ussr)
	else
		TickShowInfo(pl_france)
	end

end

TickShowInfo = function(cty)

	local str = "German reinforcements will be arriving in "
	
	if ticked == TimerTicks then
		str = "Objective: Get Tanya and the Phase Tank to the Allied Tech Center. "
	elseif ticked > 0 then
		str = str .. Utils.FormatTime(ticked)
	elseif ticked == 0 then
		player.MarkCompletedObjective(HoldBase)
		PrepareGermanReinforcements()
		str = "German reinforcements has arrived!"
	elseif ticked > -300 then
		str = "German reinforcements has arrived!"
	elseif ticked == -300 then
		RepelEnemy = player.AddPrimaryObjective("Destroy all Soviet production facilities.") 
		Check3rdObj()
		str = "Objective: Destroy the Soviet opposition!"
		
		-- are Germans here already? is it time to talk about them?
		Utils.Do(randommsgcodelist, function(rndc)
			rndc = Utils.Random({0,0,1,1,2,2,2,2})
		end)
	else
		str = "Objective: Destroy the Soviet opposition!"
	end

	-- transfer money between allies
	TransferMoneyManager()
	
	-- wacky messages
	if randommsgallowed then
		if str_tick < 0 or str_switch ~= cty.Name then
		
			local randommsgselect = Utils.RandomInteger(1,#randommsgcodelist)
			MessageCall(cty.Faction, randommsgcodelist[randommsgselect] , 0)
			
			if ticked > -300 then
				randommsgcodelist[randommsgselect] = Utils.Random({0,0,0,0,0,0,0,0,0,1,4,4})
			else
				randommsgcodelist[randommsgselect] = Utils.Random({0,0,0,0,0,0,0,0,1,2,2,4})			
			end
			
			if str_switch ~= cty.Name then
				str_tick = Utils.RandomInteger(1, str_tick_init)
			else
				str_tick = str_tick_init
			end
			str_switch = cty.Name
		else
			str_tick = str_tick - 1
		end
	end
	
	if showallyresource then 
		local gnumproc = 0
		local gharvlist = { }
		-- Check for harvesters
		Utils.Do(ExistingBuildings, function(a)
			if a.Owner == cty and a.Type == "proc" then gnumproc = gnumproc + 1 end
		end)
		if gnumproc > 0 then
			gharvlist = cty.GetActorsByType("harv") --Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor) return actor.Type == "harv" and actor.Owner == cty end)
		end
		
		local str2 = ""
		if cty.Faction == "allies" then str2 = "Allied" else str2 = "Soviet" end
		
		str = "\n\n".. str .."\n_________________________________________________________________________________________________________\n".. str2 .." Base Information" -- for 120 characters max length without shifting the textbox
		str = "\n".. str .."\nResources: ".. (cty.Cash + cty.Resources) .." / ".. gnumproc .." Refinery / ".. #gharvlist .." Ore Truck"
		
		if TransferText[cty.Name] ~= "" then
			str = str .."  (".. TransferText[cty.Name] ..")"
		end
		
		if cty.Faction == "allies" then 
			str = "\n".. str .."\nAllied Standing Army Count: ".. #AlliedHoldingList .."/".. AlliedAttackGroupSize
			str = "\n".. str .."\nAllied Attacking Army Count: ".. #AlliedAttackingList + #AlliedReinfList
		else
			str = "\n".. str .."\nSoviet Standing Army Count: ".. #SovietHoldingList .."/".. SovietAttackGroupSize
			str = "\n".. str .."\nSoviet Attacking Army Count: ".. #SovietAttackingList + #SovietReinfList
		end
		
		local str_factory = ""

		Utils.Do(ProducedUnitTypes, function(t)
			if t.factory.Owner == cty and t.progress > 0 then
				local intprog = (t.progress - t.progress % 1000) / 1000
				if t.factory.Type == "fact" then
					str_factory = " ".. GetName(t.curr_production) .."(".. intprog .."%) ".. str_factory
				else
					str_factory = str_factory .." ".. GetName(t.curr_production) .."(".. intprog .."%) "
				end
			end
		end)
		
		if str_factory ~= "" then
			str = "\n".. str .."\nProducing: \n".. str_factory
		else
			str = "\n".. str .."\nNot producing anything.\n"
		end
		
		str = "\n".. str .."\n\n".. str_message
	end

	UserInterface.SetMissionText(str, cty.Color)
end

Check3rdObj = function()

	if not player.IsObjectiveCompleted(RepelEnemy) then
		local sovietfactory = false
		Utils.Do(ProducedUnitTypes, function(a)
			if not a.factory.IsDead then
				if  a.factory.Owner.Faction == "soviet" then 
					sovietfactory = true
				end
			end
		end)
		if not sovietfactory then 
			player.MarkCompletedObjective(RepelEnemy)
			Check3rdObj()
		end
		
	else
		Trigger.AfterDelay(DateTime.Seconds(1), function() 
			if not player.IsObjectiveFailed(TanyaSurviveObjective) then
				player.MarkCompletedObjective(TanyaSurviveObjective)
			end
			if not player.IsObjectiveFailed(PhaseSurviveObjective) then
				player.MarkCompletedObjective(PhaseSurviveObjective)
			end
			if not player.IsObjectiveFailed(ProtectTechCenter) then
				player.MarkCompletedObjective(ProtectTechCenter)
			end
			if not player.IsObjectiveFailed(DamageBossObjective) then
				player.MarkCompletedObjective(DamageBossObjective)
			end
		end)
	end
	
	Trigger.AfterDelay(25, Check3rdObj)
	
end

Trigger.OnAnyKilled(SovShoreGuard, function()
	Utils.Do(SovShoreGuard, function(a)
		if not a.IsDead then 
			a.Scatter()
			a.AttackMove(PlayerReinfPoint.Location + CVec.New(3, -3), 2)
			a.Wait(50)
			a.AttackMove(USSRAdv1B.Location, 2)
		end
	end)
end)


Trigger.OnAnyKilled(AlliedTechCenter, function()
	player.MarkFailedObjective(ProtectTechCenter)
end)


PlayerDamaged = function()
	if not playeralreadydamaged then
		playeralreadydamaged = true
		Media.PlaySpeechNotification(player, "ObjectiveNotMet")
		player.MarkFailedObjective(DamageBossObjective)
	end
end

Check1stObj = function()
	if TanyaATech and STNKATech and not InBase then
		InBase = true
		Media.PlaySpeechNotification(player, "ObjectiveMet")
		player.MarkCompletedObjective(GetToBase)
		
		Trigger.AfterDelay(DateTime.Seconds(5), function() 
			Utils.Do(Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(a) return a.Owner == pl_base end), function(a)
				a.Owner = player
			end)
			Media.PlaySpeechNotification(player, "NewOptions")
			player.Cash = player.Cash + 5000
		end)

		Trigger.AfterDelay(DateTime.Seconds(8), function() 
			HoldBase = player.AddPrimaryObjective("Hold position until reinforcements arrive.")
			SpyBossObjective = player.AddSecondaryObjective("Infiltrate the enemy Construction Yard to obtain \ndetails about their invasion.")
		end)
		
		Trigger.AfterDelay(DateTime.Seconds(15), function()
			Media.PlaySpeechNotification(player, "MissionTimerInitialised")
			showallyresource = true
			startObj2 = true
			
			Utils.Do(Announcements, function(annc)
				Trigger.AfterDelay(ticked - annc.timeleft, function() Media.PlaySpeechNotification(player, annc.speech) end)
			end)
		end)
		
		delay = 10 -- in seconds
		for i = 1, #AlliedMessageList[3] do
			Trigger.AfterDelay(DateTime.Seconds(12 + i * delay), function()
				randommsgallowed = false
				MessageCall(player.Faction, 3, i)
			end)
		end
		
		Trigger.AfterDelay(DateTime.Seconds(12 + (#AlliedMessageList[3] + 1) * delay), function()
			MessageCall(player.Faction, 0, 0)
		end)
	
		Trigger.AfterDelay(DateTime.Seconds(12 + (#AlliedMessageList[3] + 4) * delay), function()
			randommsgallowed = true
		end)
	
	end
end

ConyardInfiltrated = function()
	spiedCY = true
	player.MarkCompletedObjective(SpyBossObjective)
end

WorldLoaded = function()
	
	player = Player.GetPlayer("Greece")
	pl_base = Player.GetPlayer("GreeceBase")
	pl_france = Player.GetPlayer("France")
	pl_ussr = Player.GetPlayer("USSR")
	pl_ussr2 = Player.GetPlayer("USSR2")
	pl_ukraine = Player.GetPlayer("Ukraine")
	pl_germany = Player.GetPlayer("Germany")
	neutral = Player.GetPlayer("Neutral")
	
	AIHouses = { pl_france, pl_ussr, pl_ussr2, pl_ukraine, pl_germany }
	AlliedHouses = { pl_france, pl_base, pl_germany, player }
	SovietHouses = { pl_ussr, pl_ussr2, pl_ukraine }
	
	Utils.Do(AIHouses, function(h) h.Cash = InitMoney[1] end)
	Utils.Do(SovietHouses, function(h) h.Cash = InitMoney[2] end)
	pl_ussr2.Cash = InitMoney[3]
	
	MessageSort()
	DeclareBaseBuildings()
	PopulateBaseBuildingsExt()
	
	Trigger.OnObjectiveAdded(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)
	Trigger.OnObjectiveCompleted(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)
	Trigger.OnPlayerLost(player, function()
		Media.PlaySpeechNotification(player, "MissionFailed")
	end)
	Trigger.OnPlayerWon(player, function()
		Media.PlaySpeechNotification(player, "MissionAccomplished")
	end)

	-- Trigger.AfterDelay(DateTime.Seconds(1), function() Media.PlaySpeechNotification(allies, "MissionTimerInitialised") end)
	ussrObj = pl_ussr.AddPrimaryObjective("Destroy the Allied Tech Center.")
	ussr2Obj = pl_ussr2.AddPrimaryObjective("Destroy the Allied Tech Center.")
	ussr3Obj = pl_ukraine.AddPrimaryObjective("Destroy the Allied Tech Center.")
	
	SetupMapUnits(0.5)

	Trigger.AfterDelay(DateTime.Seconds(1), PrepareUSSRPatrols)
	Trigger.AfterDelay(DateTime.Seconds(3), PreparePlayerReinforcements)
	Trigger.AfterDelay(DateTime.Seconds(6), function() 
		GetToBase = player.AddPrimaryObjective("Get both Tanya and the Phase Transport to \nthe Allied Tech Center.") 
		ProtectTechCenter = player.AddPrimaryObjective("The Allied Tech Center must survive.")
		TanyaSurviveObjective = player.AddPrimaryObjective("Tanya must survive.")
		PhaseSurviveObjective = player.AddPrimaryObjective("The Phase Transport must survive.")
		
		DamageBossObjective = player.AddSecondaryObjective("Complete the mission without sustaining damage \nto either Tanya or the Phase Transport.")
	end)

	Trigger.AfterDelay(DateTime.Seconds(11), SendUSSRMIGs)

	
	Trigger.AfterDelay(DateTime.Seconds(20), function() 
		ToggleReveal(2, true)
		PrepareSovietReinforcements()
		PrepareFranceReinforcements()
	end)
	Trigger.AfterDelay(DateTime.Minutes(1), function() ToggleReveal(1, false) end)
	Trigger.AfterDelay(DateTime.Minutes(1) + DateTime.Seconds(45), PrepareUSSRReinforcements)
	Trigger.AfterDelay(DateTime.Minutes(2), function() 
		ActivateAI() 
		GroupPatrol(SovNorthGuards, SovNorthGuardsPath, 270, 3)
		GroupPatrol(SovSouthGuards, SovSouthGuardsPath, 270, 3)
	end)	
	Trigger.AfterDelay(DateTime.Minutes(3), function() ToggleReveal(2, false) end)
	
	Trigger.OnEnteredProximityTrigger(ATech.CenterPosition, WDist.New(6 * 1024), function(a, id)
		if a == Tanyas[1] then
			Media.Debug("Tanya is in base.")
			TanyaATech = true
		elseif a == STNKs[1] then
			Media.Debug("Phase Tank is in base.")
			STNKATech = true
		end
		Check1stObj()
	end)

	Trigger.OnExitedProximityTrigger(PlayerReinfPoint.CenterPosition, WDist.New(7 * 1024), function(a, id)
		if a == Tanyas[1] then
			Media.Debug("Tanya out of base.")
			TanyaATech = false
		elseif a == STNKs[1] then
			Media.Debug("Phase Tank out of base.")
			STNKATech = false
		end
	end)
	
	Camera.Position = PlayerCamera.CenterPosition
	
	--Debug stuff here
	
end

ToggleReveal = function(n, bl)
	Utils.Do(CameraSets[n], function(a)
		if bl then
			a.Owner = player
		else
			a.Owner = neutral
		end
	end)
end

ActivateAI = function()

	SetupFactories(0)
	Utils.Do(AIHouses, function(h)
		StructureRepair(h, 0.9)
	end)
	
	SetExistingProductionBuilding(Ukraine_BARR)
	SetExistingProductionBuilding(Ukraine_WEAP)
	
	Utils.Do(ProducedUnitTypes, ProduceUnits)
	
end

