-- Collection of functions for governing AI economy --

GiverThreshold = 2500  -- money above this will be given towards other players
TakerThreshold = 1500  -- the money to fill
TransferTrickle = 2 -- the money to transfer every tick
TransferParties = { }
TransferText = { }


AddMoney = function(cty, money) -- use negative numbers for expenses, returns false if not enough money
	local totalcash = cty.Cash + cty.Resources
	if totalcash + money < 0 then
		return false
	end
	
	-- deduct from Resources first
	if cty.Resources + money < 0 then
		cty.Resources = 0
		cty.Cash = cty.Cash + money + cty.Resources 
	else
		cty.Resources = cty.Resources + money
	end
	return true
end

TransferMoneyManager = function()

	Utils.Do(AIHouses, function(h) TransferText[h.Name] = "" end) -- Refresh text
	TransferText[player.Name] = ""
	
	TransferParties = 
	{
		-- Soviets, pl_ussr2 is a dirty cash bank lol
		{ giver = pl_ussr2, taker = pl_ussr },
		{ giver = pl_ussr2, taker = pl_ukraine },
		{ giver = pl_ukraine, taker = pl_ussr },
		{ giver = pl_ussr, taker = pl_ukraine },
		
		-- Allies
		{ giver = player, taker = pl_france },
		{ giver = pl_france, taker = player },
	}
	
	Utils.Do(TransferParties, function(tp)
	
		-- player wait until he has obtained funds from base
		if (tp.giver == player or tp.taker == player) and not startObj2 then return end
	
		if tp.giver.Cash + tp.giver.Resources > GiverThreshold and tp.taker.Cash + tp.taker.Resources < TakerThreshold then
			TransferMoney(tp.giver, tp.taker, TransferTrickle)
		end
	end)
	
end

TransferMoney = function(giver, taker, money) -- 

	-- take money from giver
	if giver.Resources - money < 0 then
		giver.Resources = 0
		giver.Cash = giver.Cash - money + giver.Resources 
	else
		giver.Resources = giver.Resources - money
	end
	
	-- give money to taker
	if taker.Resources + money < 0 then
		taker.Resources = 0
		taker.Cash = taker.Cash + money + taker.Resources 
	else
		taker.Resources = taker.Resources + money
	end	

	TransferText[giver.Name] = "Transferring money to ".. taker.Name
	TransferText[taker.Name] = "Receiving money from ".. giver.Name
	
end