UserInterface.SetMissionText("Cellular Automaton Forest Generation Version 2")

--FUNCTIONS

function initialiseMap()
	for  x = 0, width - 1 do
		map[x] = {}
		for  y = 0, height - 1 do
			map[x][y] = 1
		end
	end
end

function randomFillMap()
	for x = 0, width - 1 do
		for y = 0, height - 1 do
			if(Utils.RandomInteger(0,100) > randomFillPercent)then
				map[x][y] = 0
        if(Utils.RandomInteger(0,100) < randomFillPercentOre)then
          map[x][y] = -1
        end
			end
		end
	end
  local mcvX = Utils.RandomInteger(1, (width - 1 / 2 ))
  local mcvY = Utils.RandomInteger(1, height)

  createVisual(mcvX, mcvY, "mcv", Player.GetPlayer("Multi0"))
  -- Let lua garbage collector collect this garbage
  -- New coords - New life!
  mcvX = Utils.RandomInteger((width - 1 / 2 ), width - 1)
  mcvY = Utils.RandomInteger(1, height)
  
 createVisual(mcvX, mcvY, "mcv", Player.GetPlayer("Multi1"))
end

function checkForTitle(x, y)
  if(map[x][y] ~= 0)then
    return false
  else
    return true
  end
end


function smoothMap()
	for x = 1, width - 2 do
		for y = 1, height - 2 do
			local areaWeight = parseTileArea(x, y)
			if(areaWeight > 4)then
				map[x][y] = 1
			elseif(areaWeight < 4)then
				map[x][y] = 0
			end
			
			if(map[x][y] == 1)then
				createVisual(x,y,"t")
      elseif(map[x][y] == -1)then
        createVisual(x,y,"o")
			end
		end
	end
  
  
end
	
function parseTileArea(x, y)
	local areaWeight = 0
	for tileX = x - 1, x + 1 do
		for tileY = y - 1, y + 1 do
			if((tileX ~= x) or (tileY ~= y))then
				areaWeight = areaWeight + map[tileX][tileY]
			end
		end
	end
	return areaWeight
end

function createVisual(x, y, tp, mcvowner)
  if(tp=="t")then
    local treeActor = Actor.Create("t" .. tostring(Utils.RandomInteger(10,14)), true, { Location = CPos.New(x ,y), Owner = Neutral })
  elseif(tp=="o")then
    local oreActor = Actor.Create("mine", true, { Location = CPos.New(x ,y), Owner = Neutral})
  else
    local mcvActor = Actor.Create("mpspawn", true, { Location = CPos.New(x ,y), Owner = mcvowner })
  end
end


--DECLARATIONS

Neutral = Player.GetPlayer("Neutral")
width = 130
height = 130
randomFillPercent = 50
randomFillPercentOre = 50
map = {}

--CODE

initialiseMap()
Trigger.AfterDelay(0.1, randomFillMap)
Trigger.AfterDelay(0.2, smoothMap)