tankReinforcements = { "gmtnk" }
artyReinforcements = { "arty" }
superReinforcements = { "turtnk" }
lightReinforcements = { "e1", "e1", "e1", "e1", "e3" }
medReinforcements = { "e1", "e1", "e2", "e2", "e3" }
heavyReinforcements = { "e1", "e3", "e3", "e4", "e4" }
maxiReinforcements = { "e1", "e1", "e3", "e3", "e4", "e4" }
remainingTime = DateTime.Minutes(2) + DateTime.Seconds(0) -- 2:00


mdesc1="Welcome to the Zonecontrole Center, Commander!"
mdesc2="The map contains different zones, marked with flag!"
mdesc3="When you hover over a flag you will be shown what benefets you get if you controle this zone."
mdesc4="To capture a zone, simply move a unit into the flag."
mdesc5="Try to keep your command vehicle alive, it will generate money over time!"

CTFFLagtypes = {"ctrlzone","ctrlzonem","ctrlzonet","ctrlzonea","ctrlzoneh","ctrlzones"}

CTbs = {"handnew","labnew","centnew","padnew","infpad","hinfpad","tinfpad","fixnew","dashq", "artpad"}
aiTicker = DateTime.Seconds(4) -- 0:4
num = 0

function Reinforce (ctrl, bldgn,  reinftyp) -- Reinforcment function
	if ctrl ~= Player.GetPlayer("Neutral") and ctrl ~= Player.GetPlayer("Creeps") then
		if bldgn.Type == "padnew" or bldgn.Type == "infpad" or bldgn.Type == "hinfpad" or bldgn.Type == "tinfpad" or  bldgn.Type == "fixnew" or  bldgn.Type == "artpad" then
			Reinforcements.ReinforceWithTransport(ctrl, 'newtran', reinftyp, {  Map.RandomEdgeCell(), bldgn.Location +CVec.New(1,1) }, { Map.RandomEdgeCell() }, nil, nil)
		end
	end
end

function GetNearFlag (flag) -- function for flag trigger and capture
	--Media.DisplayMessage("Set Up Flag!","")
		local flagactors = Map.ActorsInCircle(flag.CenterPosition , WDist.FromCells(10), function(bld)	
			return  bld.Type == CTbs[1] or  bld.Type == CTbs[2] or  bld.Type == CTbs[3] or  bld.Type == CTbs[4] or  bld.Type == CTbs[5] or  bld.Type == CTbs[6] or  bld.Type == CTbs[7] or  bld.Type == CTbs[8] or  bld.Type == CTbs[9] or  bld.Type == CTbs[10]
		end)
	Trigger.OnEnteredProximityTrigger(flag.CenterPosition, WDist.FromCells(2), function(a, id)
		local mine = flag.Owner
		local yours = a.Owner
		if mine ~= yours and  mine.IsAlliedWith(yours) ~= true and yours ~= Player.GetPlayer("Neutral") and yours ~= Player.GetPlayer("Creeps") and Actor.CruiseAltitude(a.Type) == 0 then
			flag.Owner = yours
			if flagactors ~= nil and flag.Type ~= "ctrlzones" then
				for i,v in ipairs(flagactors) do
					if v ~= nil then
						v.Owner = yours  -- Desync solved?
					end
				end 
			end
		end
	end)	
end

function joinMyTables(t1, t2) -- simple join tables
	for k,v in ipairs(t2) do
		table.insert(t1, v)
		num = num + 1
	end 
	return t1
end

WorldLoaded = function()

	CTFlags = {}
	
	Trigger.AfterDelay(DateTime.Seconds(1), function() -- set up Flags
		local neut = Player.GetPlayer("Neutral")
		for i=1,#CTFFLagtypes do
			local T1 = neut.GetActorsByType(CTFFLagtypes[i])
			if T1 ~= nil then
				joinMyTables(CTFlags, T1)			
			end
		end
	end)
	
	Trigger.AfterDelay(DateTime.Seconds(2), function()	 -- fuse flags
		for k,v in ipairs(CTFlags) do
			GetNearFlag(v)
		end
		return CTFlags
	end)
	
	Trigger.AfterDelay(DateTime.Seconds(3), function() -- player announcements
		timerStarted = true
		Media.DisplayMessage(mdesc1,"")	
	end)
	Trigger.AfterDelay(DateTime.Seconds(8), function()
		Media.DisplayMessage(mdesc2,"")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage(mdesc3,"")
	end)
	Trigger.AfterDelay(DateTime.Seconds(22), function()
		Media.DisplayMessage(mdesc4,"")
	end)	
	Trigger.AfterDelay(DateTime.Seconds(29), function()
		Media.DisplayMessage(mdesc5,"")
	end)	

	Trigger.AfterDelay(DateTime.Seconds(3), function()	
	
	--AI Enter Closed area Trigger	
	
		local aiflaggers = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	
				return  bld.Type == CTFFLagtypes[1] or  bld.Type == CTFFLagtypes[2] or  bld.Type == CTFFLagtypes[3] or  bld.Type == CTFFLagtypes[4] or  bld.Type == CTFFLagtypes[5] or  bld.Type == CTFFLagtypes[6]
			end)
			
		for i = 1, #aiflaggers do
			if aiflaggers[i] ~= nil then
				Trigger.OnEnteredProximityTrigger(aiflaggers[i].CenterPosition, WDist.FromCells(8), function(a, id)
					local mine = aiflaggers[i].Owner
					local yours = a.Owner
					if mine ~= yours and mine.IsAlliedWith(yours) == false and yours.IsBot and (a.Type == "e1" or a.Type == "e2" or a.Type == "e3" or a.Type == "e4" ) and a.IsDead == false then
						a.Stop()
						a.AttackMove(aiflaggers[i].Location)
					end
				end)
				Trigger.OnExitedProximityTrigger(aiflaggers[i].CenterPosition, WDist.FromCells(5), function(a, id)
					local mine = aiflaggers[i].Owner
					local yours = a.Owner
					if mine ~= yours and mine.IsAlliedWith(yours) == false and yours.IsBot and (a.Type == "e1" or a.Type == "e2" or a.Type == "e3" or a.Type == "e4" ) and a.IsDead == false then
						a.Stop()
						a.AttackMove(aiflaggers[i].Location)
					end
				end)
			end
		end
	end)
end


Tick = function() --timer and reinforcments
	
	if remainingTime == 1 and timerStarted then
		local reinf = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	
			return  bld.Type == CTbs[4]
			end)
		if reinf ~= nil then
			for i,v in ipairs(reinf) do
				local owe = v.Owner
				if v ~= nil then
					end
				Reinforce (owe, v,  lightReinforcements)
			end
		end
		local reinf = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	
			return  bld.Type == CTbs[5]
			end)
		if reinf ~= nil then
			for i,v in ipairs(reinf) do
				local owe = v.Owner
				if v ~= nil then
					end
				Reinforce (owe, v,  medReinforcements)
			end
		end
		local reinf = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	
			return  bld.Type == CTbs[6]
			end)
		if reinf ~= nil then
			for i,v in ipairs(reinf) do
				local owe = v.Owner
				if v ~= nil then
					end
				Reinforce (owe, v,  heavyReinforcements)
			end
		end
		local reinf = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	
			return  bld.Type == CTbs[7]
			end)
		if reinf ~= nil then
			for i,v in ipairs(reinf) do
				local owe = v.Owner
				if v ~= nil then
					end
				Reinforce (owe, v,  tankReinforcements)
			end
		end
		local reinf = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	
			return  bld.Type == CTbs[8]
			end)
		if reinf ~= nil then
			for i,v in ipairs(reinf) do
				local owe = v.Owner
				if v ~= nil then
					end
				Reinforce (owe, v,  superReinforcements)
			end
		end
		local reinf = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	
			return  bld.Type == CTbs[10]
			end)
		if reinf ~= nil then
			for i,v in ipairs(reinf) do
				local owe = v.Owner
				if v ~= nil then
					end
				Reinforce (owe, v,  artyReinforcements)
			end
		end
	end
	
	if remainingTime > 0 and timerStarted then
		UserInterface.SetMissionText("Time until Reinforcments: " .. Utils.FormatTime(remainingTime), Player.GetPlayer("Neutral").Color)
		remainingTime = remainingTime - 1
	elseif remainingTime == 0 then
		UserInterface.SetMissionText("Time until Reinforcments: " .. Utils.FormatTime(remainingTime), Player.GetPlayer("Neutral").Color)
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			remainingTime = DateTime.Minutes(1) + DateTime.Seconds(30)  -- 1:30
		end)
		
		
	end
		if aiTicker > 0 and aiTicker then
		aiTicker = aiTicker - 1
	elseif aiTicker == 0 then
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			aiTicker = DateTime.Minutes(0) + DateTime.Seconds(5)  -- 0:5
		end)		
	end
	
	--new AI scripz
	if aiTicker == 1 then
		for i=1,8 do
			local ai = Player.GetPlayer("Multi" .. tostring(i-1))
			if ai ~= nil and ai.IsBot then
				local aiunits = ai.GetGroundAttackers() -- get Atack units
				local attackpoint = nil
				local randomn = Utils.RandomInteger(1,100) -- random Roll
				
				local lowtarget = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	-- getting sight flags
					return  bld.Type == CTFFLagtypes[6] and bld.Owner ~= ai and ai.IsAlliedWith(bld.Owner) == false
				end)
				local medtarget = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	-- getting Infantry flags
					return  (bld.Type == CTFFLagtypes[1] or bld.Type == CTFFLagtypes[2]) and bld.Owner ~= ai and ai.IsAlliedWith(bld.Owner) == false
				end)
				local Hightarget = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	-- getting Tang flags
					return  (bld.Type == CTFFLagtypes[3] or bld.Type == CTFFLagtypes[4]) and bld.Owner ~= ai and ai.IsAlliedWith(bld.Owner) == false
				end)
				local Mosttarget = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(bld)	-- getting Heavy flags
					return  bld.Type == CTFFLagtypes[5] and bld.Owner ~= ai and ai.IsAlliedWith(bld.Owner) == false
				end)
			
				
					if randomn < 11 then  -- decide on priority and random roll
						attackpoint = lowtarget[Utils.RandomInteger(1,#lowtarget)]
					elseif randomn > 10 and randomn < 36 then
						attackpoint = medtarget[Utils.RandomInteger(1,#medtarget)]
					elseif randomn > 35 and randomn < 74 then
						attackpoint = Hightarget[Utils.RandomInteger(1,#Hightarget)]
					else
						attackpoint = Mosttarget[Utils.RandomInteger(1,#Mosttarget)]
					end

				if attackpoint ~= nil then -- check and force to attack choosen point
					local whos = attackpoint.Owner
					if whos ~= ai and whos.IsAlliedWith(ai) == false then
						for v=1, 40 do
							local unit = aiunits[v]
							if unit ~= nil and unit.IsIdle then
								unit.AttackMove(attackpoint.Location)
							end
						end
					end
				end	
			end
		end
	end
end
