USSR3BasePower = { USSR3_BASE_POWER1,  USSR3_BASE_POWER2, USSR3_BASE_POWER3 }
USSR3ShoreDefenses = { ShoreTesla01, ShoreTesla02, ShoreTesla03, ShoreTesla04, ShoreTesla05, ShoreTesla06, ShoreSAM01, ShoreSAM02, ShoreSAM03, ShoreSAM04, ShoreSAM05 }

USSR2BasePower = { USSR2_BASE_POWER1 }
USSR2SAMs = { USSR2_BASE_SAM1, USSR2_BASE_SAM2, USSR2_BASE_SAM3 }

USSRMISSBasePower = { USSR_MISS_POWER1,  USSR_MISS_POWER2 }
USSRMISSBaseDefenses = { USSR_MISS_TESLA, USSR_MISS_POWER1,  USSR_MISS_POWER2 }
USSRMISSSAMs = { USSR_MISS_SAM1, USSR_MISS_SAM2, USSR_MISS_SAM3, USSR_MISS_SAM4, USSR_MISS_SAM5, USSR_MISS_SAM6 }

playeralreadydamaged = false
SAMsTrigger = true
USSR2SAMsOffline = false
USSRMISSSAMsOffline = false

USSR3BaseGuard = { USSR3_INV_4TNK, USSR3_INV_TROOP1, USSR3_INV_TROOP2, USSR3_INV_TROOP3, USSR3_INV_TROOP4, USSR3_INV_TROOP5, USSR3_INV_TROOP6, USSR3_INV_TROOP7 }

if Map.Difficulty == "Mental" then
	USSR3BaseGuardPath = { CPos.New(126, 34), CPos.New(112, 26), CPos.New(115, 14), CPos.New(126, 17) }
else
	USSR3BaseGuardPath = { CPos.New(115, 54), CPos.New(130, 56) }
end
	
USSR2BaseGuard = { USSR2_INV_3TNK, USSR2_INV_TROOP1, USSR2_INV_TROOP2 }
USSR2BaseGuardPath = { CPos.New(78, 25), CPos.New(92, 11) }

USSRMISSGuardA = { USSRMISSGuard1 }
USSRMISSGuardA2 = { USSRMISSGuard2, USSRMISSGuard3, USSRMISSGuard4 }
USSRMISSGuardB = { USSRMISSGuard5, USSRMISSGuard6, USSRMISSGuard7, USSRMISSGuard8, USSRMISSGuard9 }
USSRMISSGuardAPath = { CPos.New(33, 32), CPos.New(33, 15) }
USSRMISSGuardBPath = { CPos.New(31, 19), CPos.New(37, 19) }

ExtractionPath = { ExtractionEntryPoint.Location, ExtractionLZ.Location }
ScientistEvacuate = false
TanyaEvacuate = false
STNKEvacuate = false

CameraSets = 
{ 
	{ CAMERA_USSR3_SHORE1, CAMERA_USSR3_SHORE2, CAMERA_USSR3_SHORE3, CAMERA_USSR3_SHORE4 } , 
	{ CAMERA_USSR3_BASE1, CAMERA_USSR3_BASE2, CAMERA_USSR3_BASE3 } , 
	{ CAMERA_USSR_BASE1, CAMERA_USSR_BASE2, CAMERA_USSR_BASE3, CAMERA_USSR_BASE4, CAMERA_USSR_BASE5, CAMERA_USSR_BASE6, CAMERA_USSR_BASE7 } , 
	{ CAMERA_USSR_MISS1, CAMERA_USSR_BIO1 } , 
	{ CAMERA_USSR2_BASE1 } 
}

Tanyas = { }
STNKs = { }

Tick = function()

	if pl_england.Resources >= pl_england.ResourceCapacity * 0.75 then
		pl_england.Cash = pl_england.Cash + pl_england.Resources - pl_england.ResourceCapacity * 0.25
		pl_england.Resources = pl_england.ResourceCapacity * 0.25
	end
	
	if pl_ussr.Resources >= pl_ussr.ResourceCapacity * 0.75 then
		pl_ussr.Cash = pl_ussr.Cash + pl_ussr.Resources - pl_ussr.ResourceCapacity * 0.25
		pl_ussr.Resources = pl_ussr.ResourceCapacity * 0.25
	end	

	if pl_ussr2.Resources >= pl_ussr2.ResourceCapacity * 0.75 then
		pl_ussr2.Cash = pl_ussr2.Cash + pl_ussr2.Resources - pl_ussr2.ResourceCapacity * 0.25
		pl_ussr2.Resources = pl_ussr2.ResourceCapacity * 0.25
	end	

	if pl_ussr3.Resources >= pl_ussr3.ResourceCapacity * 0.75 then
		pl_ussr3.Cash = pl_ussr3.Cash + pl_ussr3.Resources - pl_ussr3.ResourceCapacity * 0.25
		pl_ussr3.Resources = pl_ussr3.ResourceCapacity * 0.25
	end	
end

-- USSR3 is out of power
Trigger.OnAllKilledOrCaptured(USSR3BasePower, function()
	RescueScientists = player.AddPrimaryObjective("Rescue scientists in the Soviet Technology Center.")

	player.MarkCompletedObjective(ShoreOffline)
	Media.PlaySpeechNotification(player, "ObjectiveMet")
	
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Utils.Do(USSR3BaseGuard, function(unit)
			if not unit.IsDead then
				unit.Patrol(USSR3BaseGuardPath, true, 240)
			end
		end)
	end)

	if Map.Difficulty == "Mental" then
		Utils.Do(USSR3ShoreDefenses, function(u)
			if not u.IsDead then
				u.Owner = pl_ussr4
			end
		end)
	end
	
	Trigger.AfterDelay(DateTime.Seconds(2), PrepareENGLANDReinforcements)
	Trigger.AfterDelay(DateTime.Seconds(10), PreparePlayerReinforcements2)
	Trigger.AfterDelay(DateTime.Seconds(25), PrepareUSSRReinforcements)
	Trigger.AfterDelay(DateTime.Minutes(2), ActivateAI)	

	Trigger.AfterDelay(DateTime.Seconds(5), function() ToggleReveal(3,true) end)
end)

-- USSR Technology Center defenses destroyed
Trigger.OnAnyKilled(USSRMISSBaseDefenses, function()

	local delay = 0
	if Map.Difficulty ~= "Mental" then
		delay = 100
	end
	
	GroupPatrol(USSRMISSGuardA, USSRMISSGuardAPath, 150 + delay)
	GroupPatrol(USSRMISSGuardA2, USSRMISSGuardAPath, 80 + delay)
	GroupPatrol(USSRMISSGuardB, USSRMISSGuardBPath, 90)
	
	DestroySAMsObjective = player.AddPrimaryObjective("Destroy the SAM Sites to allow extraction.")
	ScientistSurviveObjective = player.AddPrimaryObjective("The Scientist must survive.")
	
	player.MarkCompletedObjective(RescueScientists)
	Media.PlaySpeechNotification(player, "ObjectiveMet")

	SendPlayerScientist()
	
	Trigger.AfterDelay(DateTime.Seconds(5), function() ToggleReveal(5,true) end)
end)

-- USSR2 SAMs offline
Trigger.OnAllKilledOrCaptured(USSR2BasePower, function()

	Utils.Do(USSR2SAMs, function(u)
		if not u.IsDead then
			u.Owner = pl_ussr4
		end
	end)
	
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Utils.Do(USSR2BaseGuard, function(unit)
			if not unit.IsDead then
				unit.Patrol(USSR2BaseGuardPath, true, 120)
			end
		end)
	end)
	
	USSR2SAMsOffline = true
	CheckSAMClear()
end)

-- USSR2 SAMs destroyed
Trigger.OnAllKilledOrCaptured(USSR2SAMs, function()
	USSR2SAMsOffline = true
	CheckSAMClear()
end)

-- USSR MISS SAMs offline and Coil offline
Trigger.OnAllKilledOrCaptured(USSRMISSBasePower, function()

	Utils.Do(USSRMISSSAMs, function(u)
		if not u.IsDead then
			u.Owner = pl_ussr4
		end
	end)

	USSRMISSSAMsOffline = true
	CheckSAMClear()
end)

-- USSR MISS SAMs destroyed
Trigger.OnAllKilledOrCaptured(USSRMISSSAMs, function()
	USSRMISSSAMsOffline = true
	CheckSAMClear()
end)

CheckSAMClear = function()
	
	if SAMsTrigger and USSR2SAMsOffline and USSRMISSSAMsOffline then
		-- reinforcement extraction sequence
		SAMsTrigger = false --prevent duplicates
		
		ExtractScientists = player.AddPrimaryObjective("Wait for the helicopter and extract the Scientist.")
		player.MarkCompletedObjective(DestroySAMsObjective)	
		
		Trigger.AfterDelay(DateTime.Seconds(2), function()
			SendHeliEscorts()
		end)

		Trigger.AfterDelay(DateTime.Seconds(3), function()
			SendHeliEscorts()
		end)
		
		Trigger.AfterDelay(DateTime.Seconds(4), function()
			Actor.Create("flare", true, { Owner = pl_england, Location = ExtractionFlarePoint.Location })
			Media.PlaySpeechNotification(player, "SignalFlareEast")
			SendExtractionHelicopter()
		end)
		
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			SendHeliEscorts()
		end)

		Trigger.AfterDelay(DateTime.Seconds(6), function()
			SendHeliEscorts()
		end)
	end
	
end

RescueFailed = function()
	player.MarkFailedObjective(ExtractScientists)
	player.MarkFailedObjective(ScientistSurviveObjective)
end

PlayerDamaged = function()
	if not playeralreadydamaged and Map.Difficulty == "Mental" then
		playeralreadydamaged = true
		Media.PlaySpeechNotification(player, "ObjectiveNotMet")
		player.MarkFailedObjective(DamageBossObjective)
	end
end


SendExtractionHelicopter = function()
	heli = Reinforcements.ReinforceWithTransport(player, "tran", nil, ExtractionPath)[1]
	if not PlScientist.IsDead then
		Trigger.OnRemovedFromWorld(PlScientist, EvacuateHelicopter)
	end
	Trigger.OnKilled(heli, RescueFailed)
	Trigger.OnRemovedFromWorld(heli, HelicopterGone)
end

EvacuateHelicopter = function()
	if heli.HasPassengers then
		RetreatHeliEscorts()
		heli.Move(ExtractionEntryPoint.Location)
		Trigger.OnIdle(heli, heli.Destroy)
	end
end

HelicopterGone = function()
	if not heli.IsDead then
		Media.PlaySpeechNotification(player, "TargetRescued")
		ScientistEvacuate = true
		Trigger.AfterDelay(DateTime.Seconds(1), function()
		
			EvacuateForcesObjective = player.AddPrimaryObjective("Return Tanya and the Phase Tank to the initial\n landing zone for evacuation.")
			player.MarkCompletedObjective(ExtractScientists)
			player.MarkCompletedObjective(ScientistSurviveObjective)
		end)
	end
end

CheckFinal = function()
	if not (ScientistEvacuate and TanyaEvacuate and STNKEvacuate) then
		return
	end
	
	player.MarkCompletedObjective(EvacuateForcesObjective)
	
	Trigger.AfterDelay(DateTime.Seconds(1), function() 
		if not player.IsObjectiveFailed(TanyaSurviveObjective) then
			player.MarkCompletedObjective(TanyaSurviveObjective)
		end
		if not player.IsObjectiveFailed(PhaseSurviveObjective) then
			player.MarkCompletedObjective(PhaseSurviveObjective)
		end
		
		if Map.Difficulty == "Mental" then
			if not player.IsObjectiveFailed(DamageBossObjective) then
				player.MarkCompletedObjective(DamageBossObjective)
			end
		end
	end)
end

WorldLoaded = function()
	player = Player.GetPlayer("Greece")
	pl_england = Player.GetPlayer("England")
	pl_ussr = Player.GetPlayer("USSR")
	pl_ussr2 = Player.GetPlayer("USSR2")
	pl_ussr3 = Player.GetPlayer("USSR3")
	pl_ussr4 = Player.GetPlayer("USSR4")
	neutral = Player.GetPlayer("Neutral")
	
	Trigger.OnObjectiveAdded(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)
	Trigger.OnObjectiveCompleted(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)
	Trigger.OnPlayerLost(player, function()
		Media.PlaySpeechNotification(player, "MissionFailed")
	end)
	Trigger.OnPlayerWon(player, function()
		Media.PlaySpeechNotification(player, "MissionAccomplished")
	end)

	-- Trigger.AfterDelay(DateTime.Seconds(1), function() Media.PlaySpeechNotification(allies, "MissionTimerInitialised") end)
	ussrObj = pl_ussr.AddPrimaryObjective("Stop the Allied rescue.")
	ussr2Obj = pl_ussr2.AddPrimaryObjective("Stop the Allied rescue.")
	ussr3Obj = pl_ussr3.AddPrimaryObjective("Stop the Allied rescue.")
	ussr4Obj = pl_ussr4.AddPrimaryObjective("Stop the Allied rescue.")
	
	SetupMapUnits(0.5)
	Trigger.OnDamaged(PlayerSpy, PlayerDamaged)

	Trigger.AfterDelay(DateTime.Seconds(1), PrepareUSSRPatrols)
	Trigger.AfterDelay(DateTime.Seconds(1), PreparePlayerReinforcements)
	Trigger.AfterDelay(DateTime.Seconds(6), function() 
		ToggleReveal(1, true)
		ShoreOffline = player.AddPrimaryObjective("Cut off power to the shore defences.")
		TanyaSurviveObjective = player.AddPrimaryObjective("Tanya must survive.")
		PhaseSurviveObjective = player.AddPrimaryObjective("The Phase Transport must survive.")
		
		if Map.Difficulty == "Mental" then
			DamageBossObjective = player.AddSecondaryObjective("Complete the mission without sustaining damage \nto any of your units.")
		end

	end)

	Trigger.OnEnteredProximityTrigger(USSRMISSApproach.CenterPosition, WDist.New(2 * 1024), function(a, id)
		if a.Owner == player then
			ToggleReveal(4, true)
		end
	end)

	Trigger.OnEnteredProximityTrigger(PlayerReinfPoint.CenterPosition, WDist.New(4 * 1024), function(a, id)
		if a == Tanyas[1] then
			Media.Debug("Tanya ready to evacuate.")
			TanyaEvacuate = true
		elseif a == STNKs[1] then
			Media.Debug("Phase Tank ready to evacuate.")
			STNKEvacuate = true
		end
		CheckFinal()
	end)

	Trigger.OnExitedProximityTrigger(PlayerReinfPoint.CenterPosition, WDist.New(5 * 1024), function(a, id)
		if a == Tanyas[1] then
			Media.Debug("Tanya out of evacuation zone.")
			TanyaEvacuate = false
		elseif a == STNKs[1] then
			Media.Debug("Phase Tank out of evacuation zone.")
			STNKEvacuate = false
		end
	end)
	
	Trigger.AfterDelay(DateTime.Seconds(15), function() 

		PlayerCamera.Owner = neutral
		if Map.Difficulty ~= "Mental" then
			ToggleReveal(2, true)
		end

	end)
	
	Camera.Position = PlayerCamera.CenterPosition
end

ToggleReveal = function(n, bl)
	Utils.Do(CameraSets[n], function(a)
		if bl then
			a.Owner = player
		else
			a.Owner = neutral
		end
	end)
end

ActivateAI = function()

	SetupFactories(0)
	StructureRepair(pl_ussr, 0.9)
	StructureRepair(pl_ussr2, 0.9)
	StructureRepair(pl_ussr3, 0.9)
	StructureRepair(pl_england, 0.8)
	Utils.Do(ProducedUnitTypes, ProduceUnits)
	
end

