-- Collection of functions for governing unit and AI behaviour --

if Map.Difficulty == "Easy" then
	SovietBuildTimeMultiplier = 4
	AlliedBuildTimeMultiplier = 1.5
	AircraftTimeMultiplier = 10
	DogTimeMultiplier = 5

	SovietInfantryTypes = { "e1", "e1", "e1", "e1", "e2" }
	AdvSovietInfantryTypes = { "e1", "e1", "e1", "e1", "e1", "e2", "e2", "e4", "e4" }
	SovietVehicleTypes = { "3tnk", "3tnk", "3tnk", "3tnk", "3tnk", "v2rl", "v2rl", "v2rl", "apc", "ftrk", "ftrk", "ftrk", "ftrk", "ttnk" }
	SovietAircraftType = { }

	AlliedInfantryTypes = { "e1", "e1", "e1", "e3", "e3", "e3" }
	AlliedVehicleTypes = { "jeep", "jeep", "1tnk", "arty", "arty", "arty", "2tnk", "2tnk", "apc" }

	SovietAttackGroupSize = 6
	AlliedAttackGroupSize = 20
	
elseif Map.Difficulty == "Mental" then
	
	SovietBuildTimeMultiplier = 2.5
	AlliedBuildTimeMultiplier = 2.5
	AircraftTimeMultiplier = 3
	DogTimeMultiplier = 3.5

	SovietInfantryTypes = { "e1", "e1", "e2", "e2", "e2", "e4" }
	AdvSovietInfantryTypes = { "e1", "e1", "e2", "e2", "e2", "e4", "e4", "shok", "shok" }
	SovietVehicleTypes = { "3tnk", "3tnk", "3tnk", "v2rl", "v2rl", "v2rl", "apc", "ftrk", "ftrk", "4tnk", "4tnk", "ttnk", "ttnk", "ttnk" }
	SovietAircraftType = { "yak" }

	AlliedInfantryTypes = { "e1", "e1", "e1", "e1", "e1", "e3" }
	AlliedVehicleTypes = { "jeep", "jeep", "jeep", "1tnk", "1tnk", "1tnk", "arty", "2tnk", "apc" }

	SovietAttackGroupSize = 20
	AlliedAttackGroupSize = 10
else

	SovietBuildTimeMultiplier = 3
	AlliedBuildTimeMultiplier = 2
	AircraftTimeMultiplier = 6
	DogTimeMultiplier = 4

	SovietInfantryTypes = { "e1", "e1", "e1", "e1", "e2", "e2" }
	AdvSovietInfantryTypes = { "e1", "e1", "e1", "e1", "e2", "e2", "e4", "e4", "shok" }
	SovietVehicleTypes = { "3tnk", "3tnk", "3tnk", "3tnk", "3tnk", "v2rl", "v2rl", "v2rl", "apc", "ftrk", "ftrk", "ftrk", "4tnk", "ttnk" }
	SovietAircraftType = { "yak" }

	AlliedInfantryTypes = { "e1", "e1", "e1", "e1", "e3", "e3" }
	AlliedVehicleTypes = { "jeep", "jeep", "1tnk", "1tnk", "1tnk", "arty", "arty", "2tnk", "apc" }

	SovietAttackGroupSize = 15
	AlliedAttackGroupSize = 15	
end 

SovietAirfields = { USSR_AFLD1, USSR_AFLD2 }
SovietMain = { USSR_BARR1, USSR_BARR2, USSR_WEAP1, USSR_WEAP2, USSR_AFLD1, USSR_AFLD2 }
SovietOuter = { USSR2_BASE_BARR, USSR3_BASE_BARR, USSR3_BOTTOM_BARR }
AlliedBase = { }

SovietMainHoldingList = { }
SovietOuterHoldingList = { }
AlliedHoldingList = { }

ProducedUnitTypes =
{
	-- USSR Production
	{ factory = USSR_BARR1, types = AdvSovietInfantryTypes },
	{ factory = USSR_BARR2, types = AdvSovietInfantryTypes },
	{ factory = USSR_WEAP1, types = SovietVehicleTypes },
	{ factory = USSR_WEAP2, types = SovietVehicleTypes },
	{ factory = USSR_AFLD1, types = SovietAircraftType },
	{ factory = USSR_AFLD2, types = SovietAircraftType },
	
	-- USSR2 Production

	{ factory = USSR2_BASE_BARR, types = SovietInfantryTypes },

	-- USSR3 Production
	{ factory = USSR3_BASE_BARR, types = SovietInfantryTypes },
	{ factory = USSR3_BOTTOM_BARR, types = SovietInfantryTypes }
	
	-- ENGLAND Production
}

BaseBuildings = {
	{ type = "powr", pos = CVec.New(2, -2), cost = 300 },
	{ type = "tent", pos = CVec.New(-3, -1), cost = 400 },
	{ type = "pbox", pos = CVec.New(-4, 3), cost = 300 },
	{ type = "proc", pos = CVec.New(4, -2), cost = 1400 },
	{ type = "powr", pos = CVec.New(0, 4), cost = 300 },
	{ type = "pbox", pos = CVec.New(-4, 5), cost = 300 },
	{ type = "gun", pos = CVec.New(-4, 2), cost = 600 },
	{ type = "gun", pos = CVec.New(-4, 6), cost = 600 },
	{ type = "powr", pos = CVec.New(-2, 6), cost = 300 },
	{ type = "tent", pos = CVec.New(-2, 3), cost = 300 },
	{ type = "agun", pos = CVec.New(0, 2), cost = 800 }

}

CheckForCYard = function()
	ConYard = Map.ActorsInBox(AllyReinfPoint3.CenterPosition, EngBase.CenterPosition, function(actor)
		return actor.Type == "fact" and actor.Owner == pl_england
	end)

	return #ConYard >= 1
end

BuildBase = function()
	if not CheckForCYard() then
		return
	end

	for i,v in ipairs(BaseBuildings) do
		if not v.exists then
			BuildBuilding(v)
			return
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(5), BuildBase)
end

BuildBuilding = function(building)
	Trigger.AfterDelay(Actor.BuildTime(building.type)/3, function()
		local actor = Actor.Create(building.type, true, { Owner = pl_england, Location = EngBase.Location + building.pos })
		pl_england.Cash = pl_england.Cash - building.cost
		
		Media.Debug("Allied structure completed: ".. building.type)
		building.exists = true
		
		if building.type == "tent" then
			local newfty = #ProducedUnitTypes + 1
			table.insert(ProducedUnitTypes, {factory = actor, types = AlliedInfantryTypes} )
			SetupFactories(newfty)
			ProduceUnits(ProducedUnitTypes[newfty])
			AlliedBase[#AlliedBase + 1] = actor
		end
		
		Trigger.OnKilled(actor, function() building.exists = false end)
		Trigger.OnDamaged(actor, function(building)
			if building.Owner == pl_england and building.Health < building.MaxHealth * 0.9 then
				building.StartBuildingRepairs()
			end
		end)

		Trigger.AfterDelay(DateTime.Seconds(1), BuildBase)
	end)
end




-- Simple hunt
IdleHunt = function(a) 
	if a.HasProperty("Hunt") then
		if not a.IsDead then 
			Trigger.OnIdle(a, function(a)
				if a.IsInWorld then
					a.Hunt()
				end
			end)
		end
	end
end

-- Closed loop patrol - Not used
GroupPatrol = function(units, waypoints, delay)
	local i = 1
	local stop = false

	Utils.Do(units, function(unit)
		if not unit.IsDead then
			Trigger.OnIdle(unit, function()
				if stop then
					return
				end

				if unit.Location == waypoints[i] then
					local bool = Utils.All(units, function(actor)
						if actor.IsDead then return true end
						return actor.IsIdle 
					end)

					if bool then
						stop = true

						i = i + 1
						if i > #waypoints then
							i = 1
						end

						Trigger.AfterDelay(delay, function() stop = false end)
					end
				else
					unit.AttackMove(waypoints[i], 1)
				end
			end)
		end
	end)
end

-- Initial unit setup
SetupMapUnits = function(n)
	Utils.Do(Map.NamedActors, function(a)
		if a.Type == "dog" then
			a.Stance = "AttackAnything"
		elseif a.Type == "dtrk" then
			if Map.Difficulty == "Mental" then
				Trigger.OnIdle(a, a.Destroy)
			end
		elseif a.Type ~= "camera" then
			a.Stance = "Defend"
			
			-- attack persistent attackers
			if a.HasProperty("Health") then
				Trigger.OnDamaged(a, function(b)
					if b.Health < n * b.MaxHealth then
						b.Stance = "AttackAnything"
					end
				end)
			end
			
			-- convert all walls to neutral
			if (a.Type == "brik" or a.Type == "cycl" or a.Type == "fenc" or a.Type == "sbag") and a.Owner ~= neutral then
				a.Owner = neutral
			end
		end
	end)
end

-- Production of units from factory
ProduceUnits = function(t)
	local factory = t.factory
	if (not factory.IsDead) and #t.types > 0 then
		local unitType = t.types[Utils.RandomInteger(1, #t.types + 1)]
		Media.Debug(factory.Type.. " decided to build: ".. unitType)

		-- too many doge.
		if unitType == "dog" then
			factory.Wait(Actor.BuildTime(unitType) * DogTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02}))
		elseif unitType == "yak" or unitType == "mig" then
			factory.Wait(Actor.BuildTime(unitType) * AircraftTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02}))
		else
			-- Soviet vs Allied adjustment for difficulty
			if factory.Owner == pl_england then
				factory.Wait(Actor.BuildTime(unitType) * AlliedBuildTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02}))
			else
				factory.Wait(Actor.BuildTime(unitType) * SovietBuildTimeMultiplier * Utils.Random({0.98,0.99,1,1.01,1.02}))
			end
		end
		factory.Produce(unitType)
		factory.CallFunc(function() ProduceUnits(t) end)
	end
end

-- Factory setup to produce
SetupFactories = function(i)
	if i == 0 then
		Utils.Do(ProducedUnitTypes, function(production)
			local fty = production.factory
			if not fty.IsDead then
				Trigger.OnProduction(fty, function(_, a) DecisionMaker(fty, a) end)
			end
		end)
	else
		local fty = ProducedUnitTypes[i].factory
		if not fty.IsDead then
			Trigger.OnProduction(fty, function(_, a) DecisionMaker(fty, a) end)		
		end
	end
end

AircraftDecisionMaker = function(a)
	if a.IsDead then return end
	a.Stop()
	a.AttackMove(Utils.Random(USSRAircraftAttackPos).Location, 5)
	
	Trigger.AfterDelay(DateTime.Seconds(7), function() AircraftDecisionMaker(a) end)
end

-- What to do with the units?
DecisionMaker = function(factory, a)

	local isaircraft = false
	for i = 1, #SovietAirfields do
		if SovietAirfields[i] == factory then isaircraft = true end
	end

	if isaircraft then -- Unit is a Soviet aircraft
	
		Media.Debug("Sending Soviet Aircraft to attack.")
		AircraftDecisionMaker(a)
		return
	
	else -- Unit is a ground vehicle, Allied or Soviet
		-- What factory is this?
		for i = 1, #SovietMain do -- Factory belongs to Soviet, on the western front
			if SovietMain[i] == factory then
			
				SovietMainHoldingList[#SovietMainHoldingList + 1] = a
				if #SovietMainHoldingList >= SovietAttackGroupSize then

					local units = { }

					for i = 1, #SovietMainHoldingList do
						units[i] = SovietMainHoldingList[1]
						table.remove(SovietMainHoldingList, 1)
					end
					
					Media.Debug("Sending Soviet West Holding List to attack.")
					Utils.Do(units, function(unit)
						if not unit.IsDead then
							unit.AttackMove(Utils.Random(USSRAdvanceLv1), 1)
							unit.AttackMove(Utils.Random(USSRAdvanceLv2), 1)
							unit.AttackMove(Utils.Random(USSRAdvanceLv3), 1)
							IdleHunt(unit)
						end
					end)
				end
				return
			end
		end
		
		for i = 1, #SovietOuter do -- Factory belongs to Soviet, on the eastern front
			if SovietOuter[i] == factory then
			
				SovietOuterHoldingList[#SovietOuterHoldingList + 1] = a
				if #SovietOuterHoldingList >= SovietAttackGroupSize then

					local units = { }

					for i = 1, #SovietOuterHoldingList do
						units[i] = SovietOuterHoldingList[1]
						table.remove(SovietOuterHoldingList, 1)
					end
					
					Media.Debug("Sending Soviet East Holding List to attack.")
					Utils.Do(units, function(unit)
						if not unit.IsDead then
							unit.AttackMove(Utils.Random(USSRAdvanceLv1), 1)
							unit.AttackMove(Utils.Random(USSRAdvanceLv2), 1)
							unit.AttackMove(Utils.Random(USSRAdvanceLv3), 1)
							IdleHunt(unit)
						end
					end)
				end
				return			
			end
		end

		if #AlliedBase > 0 then
			for i = 1, #AlliedBase do -- Factory belongs to Allies, on the western front
				if AlliedBase[i] == factory then
				
					AlliedHoldingList[#AlliedHoldingList + 1] = a
					if #AlliedHoldingList >= AlliedAttackGroupSize then

						local units = { }

						for i = 1, #AlliedHoldingList do
							units[i] = AlliedHoldingList[1]
							table.remove(AlliedHoldingList, 1)
						end
						
						Media.Debug("Sending Allied West Holding List to attack.")
						Utils.Do(units, function(unit)
							if not unit.IsDead then
								unit.AttackMove(Utils.Random(ENGLANDAdvanceLv1), 1)
								unit.AttackMove(Utils.Random(ENGLANDAdvanceLv2), 1)
								unit.AttackMove(Utils.Random(ENGLANDAdvanceLv3), 1)
								IdleHunt(unit)
							end
						end)
					end
					return
				end
			end
		end
		
		-- IdleHunt(a)
		
	end
end

-- All houses to repair structures
StructureRepair = function(cty,n) -- cty is house, n is the fraction of health to start repairing

	Utils.Do(Map.NamedActors, function(actor)
		if actor.Owner == cty and actor.HasProperty("StartBuildingRepairs") then
			Trigger.OnDamaged(actor, function(building)
				if building.Owner == cty and building.Health < n * building.MaxHealth then
					building.StartBuildingRepairs()
				end
			end)
		end
	end)
end