function getBuildings()
	for i = 1, 22 do
		if (i < 10) then
			actorFilterTypes[i] = "city0" .. i
		else
			actorFilterTypes[i] = "city" .. i
		end
	end
end

function filterActor(actor)
	return Utils.Any(actorFilterTypes, function(a) if (actor.Type == a) then return true end end)
end

function addTriggers()
	for i, x in pairs(actors) do
		if (filterActor(x)) then
			Trigger.OnPassengerEntered(x, function(t, x)
				t.Owner = x.Owner
			end)
			Trigger.OnPassengerExited(x, function(t, x)
				if (not t.HasPassengers) then
					t.Owner = neutral
				end
			end)
		end
	end
end

function WorldLoaded()

	--Edit these to suit your map
	actorFilterTypes = {}
		
		
	--Don't touch these
	actors = Map.NamedActors
	actorCount = 0
	neutral = Player.GetPlayer("Neutral")
	getBuildings()
	addTriggers()
	UserInterface.SetMissionText(tostring(actorCount))
end