Infantry  = { "e4", "e1", "e1", "e2", "e1", "e2" }
AssultInf = { "e4", "e1", "e1", "e2", "e1", "e4", "e1", "e1", "e2", "e1", "e7", "SHOK", "SHOK" }
Vehicles  = { "arty", "ftrk", "ftrk", "apc", "apc" }
Tank      = { "3tnk" }
LongRange = { "v2rl" }
Boss      = { "4tnk" }

SovietEntryPoints = { Entry1, Entry2, Entry3, Entry4, Entry5, Entry6, Entry7 }
OilDerricks       = { Player0OIL, Player1OIL, Player2OIL, Player3OIL, Player4OIL, Player5OIL }
SpawnPoints       = { PlayerSpawn0, PlayerSpawn1, PlayerSpawn2, PlayerSpawn3, PlayerSpawn4, PlayerSpawn5 }
Snipers           = { Sniper1, Sniper2, Sniper3, Sniper4, Sniper5, Sniper6, Sniper7, Sniper8, Sniper9, Sniper10, Sniper11 }

Wave = 0
Waves = {
    -- delay  entry_point, type, spawn_point
    -- wave 1
    { 150, SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 2
    { 500,  SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 3
    { 500,  SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 4
    { 500,  SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 5
    { 500,  SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 6
    { 1000, SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },

    -- wave 7
    { 1000, SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 8
    { 1000, SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },

    -- wave 9
    { 750,  SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 10
    { 1400, SovietEntryPoints, Vehicles, SpawnPoints       },
    { 10,   SovietEntryPoints, Vehicles, SpawnPoints       },
    { 10,   SovietEntryPoints, Vehicles, SpawnPoints       },
    { 10,   SovietEntryPoints, Vehicles, SpawnPoints       },
    { 10,   SovietEntryPoints, Vehicles, SpawnPoints       },


    -- wave 11
    { 2000, SovietEntryPoints, Boss,     SpawnPoints       },

    -- wave 12
    { 2000, SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },


    -- wave 13
    { 1000, SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 14
    { 1500, SovietEntryPoints, Vehicles, SpawnPoints       },
    { 100,  SovietEntryPoints, Vehicles, SpawnPoints       },
    { 100,  SovietEntryPoints, Vehicles, SpawnPoints       },
    { 100,  SovietEntryPoints, Vehicles, SpawnPoints       },
    { 100,  SovietEntryPoints, Vehicles, SpawnPoints       },
    { 100,  SovietEntryPoints, Vehicles, SpawnPoints       },
    { 100,  SovietEntryPoints, Vehicles, SpawnPoints       },


    -- wave 15
    { 1500, SovietEntryPoints, Infantry, SpawnPoints       },
    { 10,   SovietEntryPoints, LongRange, SpawnPoints      },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 10,   SovietEntryPoints, LongRange, SpawnPoints      },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 10,   SovietEntryPoints, LongRange, SpawnPoints      },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 16
    { 1500, SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },

    -- wave 17
    { 50,   SovietEntryPoints, Infantry, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, Infantry, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, Infantry, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, Infantry, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, Infantry, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, Infantry, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, Infantry, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, Infantry, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, Infantry, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, Infantry, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 50,   SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },

    -- wave 18
    { 1500, SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 10,   SovietEntryPoints, LongRange, SpawnPoints      },
    { 10,   SovietEntryPoints, LongRange, SpawnPoints      },
    { 10,   SovietEntryPoints, LongRange, SpawnPoints      },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 19
    { 1500, SovietEntryPoints, LongRange, SpawnPoints       },
    { 15,   SovietEntryPoints, LongRange, SpawnPoints       },
    { 15,   SovietEntryPoints, LongRange, SpawnPoints       },
    { 15,   SovietEntryPoints, LongRange, SpawnPoints       },
    { 15,   SovietEntryPoints, LongRange, SpawnPoints       },
    { 15,   SovietEntryPoints, LongRange, SpawnPoints       },

    -- wave 20
    { 2500, SovietEntryPoints, Boss,     SpawnPoints       },
    { 25,   SovietEntryPoints, Boss,     SpawnPoints       },
    { 25,   SovietEntryPoints, Boss,     SpawnPoints       },
    { 25,   SovietEntryPoints, Boss,     SpawnPoints       },
    { 25,   SovietEntryPoints, Boss,     SpawnPoints       },

    -- wave 21
    { 1500, SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, AssultInf, SpawnPoints       },
    { 1,    SovietEntryPoints, Infantry, SpawnPoints       },

    -- wave 22
    { 1500, SovietEntryPoints, LongRange, SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints       },

    -- wave 23
    { 1500, SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },
    { 1,    SovietEntryPoints, Tank,     SpawnPoints       },

    --wave 24
    { 15,   SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },

    --wave 25
    { 1500, SovietEntryPoints, Infantry, SpawnPoints       },
    { 1,    SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints      },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 20,  SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints      },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 20,  SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints      },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 20,  SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints      },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 20,  SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints      },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       },
    { 20,  SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, Boss,     SpawnPoints       },
    { 1,    SovietEntryPoints, LongRange, SpawnPoints      },
    { 1,    SovietEntryPoints, Vehicles, SpawnPoints       }
}

SendUnits = function(entryCell, unitTypes, interval, targetCell)
    Reinforcements.Reinforce(soviets, unitTypes, { entryCell }, interval, function(a)
        Trigger.OnIdle(a, function(a)
            if a.Location ~= targetCell then
                a.AttackMove(targetCell)
            else
                a.Hunt()
            end
        end)
    end)

    if (Wave < #Waves) then
        SendWave()
    else
        Trigger.AfterDelay(DateTime.Minutes(1), SovietsRetreating)
        Media.DisplayMessage("You survived the onslaught! No more waves incoming.")
    end
end

SendWave = function()
    Wave = Wave + 1
    local wave = Waves[Wave]

    local delay = wave[1]
    local entry = Utils.Random(wave[2]).Location
    local units = wave[3]
    local target = Utils.Random(wave[4]).Location

    Trigger.AfterDelay(delay, function()
        SendUnits(entry, units, 30, target)

        if not played then
            played = true
            Utils.Do(players, function(player)
                Media.PlaySpeechNotification(player, "EnemyUnitsApproaching")
            end)
            Trigger.AfterDelay(DateTime.Seconds(2), function() played = false end)
        end
    end)
end

SovietsRetreating = function()
    Utils.Do(Snipers, function(a)
        if not a.IsDead and a.Owner == soviets then
            a.Destroy()
        end
    end)
end

WorldLoaded = function()
    soviets = Player.GetPlayer("Soviets")
    players = { }
    for i = 0, 6, 1 do
        local player = Player.GetPlayer("Multi" ..i)
        players[i] = player
    end

    Utils.Do(Snipers, function(a)
        if a.Owner == soviets then
            -- a.GrantUpgrade("")
        end
    end)

    Media.DisplayMessage("Defend Fort uTox at all costs!")

    SendWave()
end
