
fighterRatio = 2

builders = {}

Set = function(list)
  local set = {}
  for _, l in ipairs(list) do set[l] = true end
  return set
end

valid = Set( { 
"mig", "yak", "tran", "heli", "hind", 
"c1" , "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "c10", 
"dog", "e1", "e2", "e3", "e4", "e6", "spy", "e7", "medi", "mech", "thf", "hijacker", "shok", "sniper",
"v2rl", "1tnk", "2tnk", "3tnk", "4tnk", "arty", "jeep", "apc", "mgg", "mrj", "ttnk", "ftrk", "dtrk", "ctnk", "qtnk", "stnk", "mnly.ap", "mnly.at",
"ss", "msub", "dd", "ca", "lst", "pt"} )

entersWorld = function(actor)
	if builders[actor.Owner.InternalName] then
		-- Change ownership of builder units to figheters.
		if valid[actor.Info.Name] then
			alliedFighters = OpenRA.GetPlayers(function(player) return player:IsAlliedWith(actor.Owner) and player.Playable and builders[player.InternalName] == false and actor.Owner.InternalName ~= player.InternalName end)
			if table.getn(alliedFighters) > 0 then
				x = OpenRA.GetRandomInteger(0,table.getn(alliedFighters))
				index = 0
				for i, fighter in ipairs(alliedFighters) do
					if index == x then
						actor:ChangeOwner(fighter)
						break
					end
					index = index + 1
				end
			end
		end
	else
		-- Remove any mcvs that fighters get.
		if actor.Info.Name == "mcv" then
			Actor.Create("FIGHTERTNK", { Location = actor.Location , Owner = actor.Owner })
			Actor.RemoveSelf(actor)
		end
	end
end

WorldLoaded = function()

	local allPlayers = OpenRA.GetPlayers(function(player) return player.Playable end)

	-- Setup builders
	for i, player in ipairs(allPlayers) do
		if builders[player.InternalName] == nil then
			builders[player.InternalName] = true

			-- Get all allies with this player
			alliedPlayers = OpenRA.GetPlayers(function(p) return p:IsAlliedWith(player) and p.Playable and  builders[p.InternalName] == nil and p.InternalName ~= player.InternalName end)
			ratio = 0
			for i, allied in ipairs(alliedPlayers) do
				builders[allied.InternalName] = false
				ratio = ratio + 1
				if ratio >= fighterRatio then
					break
				end
			end
		end
	end

	World.ActorAdded:Add(entersWorld)
end