
TargetBuildingDestroyed = function()
	if ( player0 ~= nil ) then
		player0.MarkFailedObjective(PlayerObjective0)
	end

	if ( player1 ~= nil ) then
		player1.MarkCompletedObjective(PlayerObjective1)
	end
	if ( player2 ~= nil ) then
		player2.MarkCompletedObjective(PlayerObjective2)
	end
	if ( player3 ~= nil ) then
		player3.MarkCompletedObjective(PlayerObjective3)
	end
	if ( player4 ~= nil ) then
		player4.MarkCompletedObjective(PlayerObjective4)
	end
end

MissionAccomplished = function(player)
	Media.PlaySpeechNotification(player, "MissionAccomplished")
end

MissionFailed = function(player)
	Media.PlaySpeechNotification(player, "MissionFailed")
end

WorldLoaded = function()
	player0 = Player.GetPlayer("Multi0")
	player1 = Player.GetPlayer("Multi1")
	player2 = Player.GetPlayer("Multi2")
	player3 = Player.GetPlayer("Multi3")
	player4 = Player.GetPlayer("Multi4")

	Media.DisplayMessage("40 minutes left.", "Mission:")

	Trigger.AfterDelay(7500, function() 
		Media.DisplayMessage("35 minutes left.", "Mission:")
	end)

	Trigger.AfterDelay(15000, function() 
		Media.DisplayMessage("30 minutes left.", "Mission:")
	end)

	Trigger.AfterDelay(22500, function() 
		Media.DisplayMessage("25 minutes left.", "Mission:")
	end)

	Trigger.AfterDelay(30000, function() 
		Media.DisplayMessage("20 minutes left.", "Mission:")
	end)

	Trigger.AfterDelay(37500, function() 
		Media.DisplayMessage("15 minutes left.", "Mission:")
	end)

	Trigger.AfterDelay(45000, function() 
		Media.DisplayMessage("10 minutes left.", "Mission:")
	end)

	Trigger.AfterDelay(52500, function() 
		Media.DisplayMessage("5 minutes left.", "Mission:")
	end)

	Media.StopMusic();

	-- Play Hell March on the last 3 minutes.
	Trigger.AfterDelay(55500, function() 
		Media.PlayMusic("hell226m", nil)
	end)

	if ( TargetBuilding ~= nil ) then
		Trigger.OnKilled(TargetBuilding, TargetBuildingDestroyed)
	end

	if ( player0 ~= nil ) then
		Trigger.OnPlayerLost(player0, MissionFailed)
		Trigger.OnPlayerWon(player0, MissionAccomplished)
		PlayerObjective0 = player0.AddPrimaryObjective("Defend target building for 40 minutes.")
	end

	if ( player1 ~= nil ) then
		Trigger.OnPlayerLost(player1, MissionFailed)
		Trigger.OnPlayerWon(player1, MissionAccomplished)
		PlayerObjective1 = player1.AddPrimaryObjective("Destory target building within 40 minutes.")
	end

	if ( player2 ~= nil ) then
		Trigger.OnPlayerLost(player2, MissionFailed)
		Trigger.OnPlayerWon(player2, MissionAccomplished)
		PlayerObjective2 = player2.AddPrimaryObjective("Destory target building within 40 minutes.")
	end

	if ( player3 ~= nil ) then
		Trigger.OnPlayerLost(player3, MissionFailed)
		Trigger.OnPlayerWon(player3, MissionAccomplished)
		PlayerObjective3 = player3.AddPrimaryObjective("Destory target building within 40 minutes.")
	end
	
	if ( player4 ~= nil ) then
		Trigger.OnPlayerLost(player4, MissionFailed)
		Trigger.OnPlayerWon(player4, MissionAccomplished)
		PlayerObjective4 = player4.AddPrimaryObjective("Destory target building within 40 minutes.")
	end
end
