-------------------------------------
-- Created by Umair Azfar Khan 
--
-- Version 1.0
--
-- Ported from crossfire mod to RA mod
--
-- Creation date: 2014 Nov 16
--
-- Final release date: 2014 Dec 5
-------------------------------------
hpadsGone = false
ScoutTeam = {"sniper", "e3", "e3", "e3", "e3"}							--Starting reinforcements
ScoutTeamPath = { EntryPoint.Location, RallyPoint.Location }			--The path taken by the reinforcements as the mission starts

HeliPatrol = {"heli", "heli", "heli", "heli"}							--Helicopters that keep patrolling till you take out their helipads
HeliPath = { HeliPoint1.Location, HeliPoint2.Location, HeliPoint3.Location, HeliPoint4.Location } --The path taken by the helicopters

--The Anti Aircraft guns to destroy in order to call reinforcements
AgunsA = { Agun1a, Agun2a, Agun3a, Agun4a }
AgunsB = { Agun1b, Agun2b, Agun3b }
AgunsC = { Agun1c, Agun2c, Agun3c, Agun4c, Agun5c, Agun6c, Agun7c}
AgunsD = { Agun1d, Agun2d, Agun3d, Agun4d, Agun5d, Agun6d }

InsertionHelicopter = "tran.insertion"									--transport helicopter that is used for the first 2 reinforcements. Cannot be selected
TransReinforcements = { "e1", "e1", "e3", "e3", "e3" }					--Reinforcements carried by the transport helicopter

TransReinforcementsPathA = { PathAEntry.Location, EntryPoint.Location, PathARally.Location}	--Reinforcements path A
TransReinforcementsPathB = { PathAEntry.Location, EntryPoint.Location, PathBRally.Location}	--Reinforcements path B
TransReinforcementsPathC = { PathCEntry.Location, PathCRally.Location}	--Reinforcements path C

AgunsType = 1	--Used to keep track of which AA guns team is destroyed, so that the appropriate transport is called

ParadropPoints = { Paradrop1, Paradrop2, Paradrop3, Paradrop4 }			--Points where troops will be paradropped
ParadropTroops = { "e1", "e1", "e1", "e3", "e3", "e3", "e3"}		--Troop types to be paradropped

Buildings = { Obj1, Obj2, Obj3, Obj4, Obj5, Obj6, Obj7, Obj8, Obj9, Obj10, Obj11, Obj12, Obj13, Obj14, Obj15, Obj16, Obj17, Obj18, Obj20, Obj21, Obj22, Obj23, Obj24, Obj25, Obj26 }

--AirStrikePoints = { Obj1, Obj2, Obj3, Obj4, Obj7, Obj8, Obj9, Obj10, Obj13, Obj16, Obj17, Obj18, Obj19, Obj22, Obj25, Obj26}

Helipads = { Hpad1, Hpad2, Hpad3, Hpad4 }

AgunDefenders = {"e1", "e1", "e3", "e3"}								--Defenders of Aguns
AgunPoints = { AgunPoint1, AgunPoint2, AgunPoint3, AgunPoint4, AgunPoint5, AgunPoint6, AgunPoint7, AgunPoint8, AgunPoint9, AgunPoint10, AgunPoint11, AgunPoint12 }

BaseDefenders = {"e1", "e1", "e1", "e1", "1tnk", "2tnk"}				--Base Defenders
BasePoints = { BasePoint1, BasePoint2, BasePoint3, BasePoint4, BasePoint5, BasePoint6, BasePoint7, BasePoint8, BasePoint9, BasePoint10 }

--------------------------------------
--   Called when the game starts    --
--------------------------------------
SendScoutTeam = function()
	local Scouts = Reinforcements.Reinforce(player, ScoutTeam, ScoutTeamPath, DateTime.Seconds(1))
	Trigger.OnAllKilled(Scouts, MissionFailed)
	Media.PlaySpeechNotification(player, "ReinforcementsArrived")
end

--------------------------------------------------
--   Called when reinforcements are demanded    --
--------------------------------------------------
SendReinforcements = function()
	Media.PlaySpeechNotification(player, "ReinforcementsArrived")
	if AgunsType == 1 then
		Reinforcements.ReinforceWithTransport(player, InsertionHelicopter, TransReinforcements, TransReinforcementsPathA, { EntryPoint.Location })
	elseif AgunsType == 2 then
		Reinforcements.ReinforceWithTransport(player, InsertionHelicopter, TransReinforcements, TransReinforcementsPathB, { EntryPoint.Location })
	elseif AgunsType == 3 then
		Reinforcements.ReinforceWithTransport(player, "tran", TransReinforcements, TransReinforcementsPathC)
	end
	Media.PlaySpeechNotification(player, "ReinforcementsArrived")
end

-------------------------------------------------------
--   Called when all helipads have been destroyed    --
-------------------------------------------------------
HelipadsDestroyed = function()
	player.MarkCompletedObjective(HelipadsDestroyedObjective)
	allies.MarkFailedObjective(HelipadsDefendObjective)
	Trigger.AfterDelay(DateTime.Seconds(2), function() Media.PlaySpeechNotification(player, "ObjectiveMet") end)
	hpadsGone = true
end

------------------------------------------------------------
--   Called when all the buildings have been destroyed    --
------------------------------------------------------------
BuildingsDestroyed = function()
	MissionAccomplished()
end

--------------------------------------------
--   Called when Mission is successful    --
--------------------------------------------
MissionAccomplished = function()
	Trigger.AfterDelay(DateTime.Seconds(2), function() 
		Media.PlaySpeechNotification(player, "Win")
	end)
	Trigger.AfterDelay(DateTime.Seconds(4), function() 
		player.MarkCompletedObjective(SurviveObjective)
		player.MarkCompletedObjective(MissionObjective)
		allies.MarkFailedObjective(AnnihilateObjective)
	end)
end

-------------------------------------------
--   Called when Mission is a failure    --
-------------------------------------------
MissionFailed = function()
	Trigger.AfterDelay(DateTime.Seconds(2), function() 
		Media.PlaySpeechNotification(player, "Lose")
	end)
	Trigger.AfterDelay(DateTime.Seconds(4), function() 
		player.MarkFailedObjective(SurviveObjective)
		player.MarkFailedObjective(MissionObjective)
		allies.MarkCompletedObjective(AnnihilateObjective)
	end)
end

----------------------------------------------------
--   Called when a series of AA guns is killed    --
----------------------------------------------------
AgunsAKilled = function()
	AgunsType = 1
	Actor.Create("flare", true, { Owner = player, Location = PathARally.Location })
	Trigger.AfterDelay(DateTime.Seconds(2), SendReinforcements)
end

AgunsBKilled = function()
	AgunsType = 2
	Actor.Create("flare", true, { Owner = player, Location = PathBRally.Location })
	Trigger.AfterDelay(DateTime.Seconds(2), SendReinforcements)
end

AgunsCKilled = function()
	AgunsType = 3
	Actor.Create("flare", true, { Owner = player, Location = PathCRally.Location })
	Trigger.AfterDelay(DateTime.Seconds(2), SendReinforcements)
end

AgunsDKilled = function()
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		Media.PlaySpeechNotification(player, "ObjectiveMet")
		player.MarkCompletedObjective(AAgunsDestroyedObjective)
		allies.MarkFailedObjective(AAgunsSavedObjective)
	end)
	Trigger.AfterDelay(DateTime.Seconds(4), function() 
		ParadropUnits()
	end)
end

-----------------------------------------------
--   Called when the last AA gun is killed   --
-----------------------------------------------
ParadropUnits = function()
	num = 1
	Media.PlaySpeechNotification(player, "ReinforcementsArrived")
	Utils.Do(ParadropPoints, function(type)
		local lz = ParadropPoints[num].Location
		local start = Map.CenterOfCell(Map.RandomEdgeCell()) + WVec.New(0, 0, Actor.CruiseAltitude("badr"))
		local transport = Actor.Create("badr", true, { CenterPosition = start, Owner = player, Facing = (Map.CenterOfCell(lz) - start).Facing })

		Utils.Do(ParadropTroops, function(type)
			local a = Actor.Create(type, false, { Owner = player })
			transport.LoadPassenger(a)
		end)
		
		Actor.Create("flare", true, { Owner = player, Location = ParadropPoints[num].Location })
		transport.Paradrop(lz)
		num = num + 1
	end)
end

--------------------------------------------------
--   Called when the Radar has been destroyed   --
--------------------------------------------------
RadarDestroyed = function()
	player.MarkCompletedObjective(RadarDestroyedObjective)
	allies.MarkFailedObjective(RadarDefendObjective)
	Trigger.AfterDelay(DateTime.Seconds(1), function()	Media.PlaySpeechNotification(player, "ObjectiveMet") end)
	AirStrike()
end

AirStrike = function()
	num = 1	
	
	local lz = BasePoints[num].Location
	local start = Map.CenterOfCell(Map.RandomEdgeCell()) + WVec.New(0, 0, Actor.CruiseAltitude("badr"))	
	local bomber = Actor.Create("mig", true, { CenterPosition = start, Owner = player, Facing = (Map.CenterOfCell(lz) - start).Facing })
	bomber.AttackMove(BasePoints[num].Location)
	num = num + 1
	if num < 11 then
		Trigger.AfterDelay(DateTime.Seconds(3), AirStrike )
	end
end

------------------------------------------------
--   Called to start the Helicopters patrol   --
------------------------------------------------
SendHelicopters = function()
    local units = Reinforcements.Reinforce(allies, HeliPatrol, HeliPath, 30, function(vehicle) vehicle.Patrol(HeliPath, true, 15) end)
	if hpadsGone == false then
		Trigger.OnAllKilled(units, SendHelicopters)
	end
end

------------------------------------------------------------------
--   Called to initialize Pakistani infantry all over the map   --
------------------------------------------------------------------
InitializeAlliedArmy = function()	
	--Initialize all the Agun Defenders
	num = 1
	Utils.Do(AgunPoints, function(type)
		Utils.Do(AgunDefenders, function(unit)
			local u = Actor.Create(unit, true, { Owner = allies, Location = AgunPoints[num].Location})
			u.Scatter()	
		end)
		num = num + 1
	end)	
	--Initialize all the Base Defenders
	num = 1
	Utils.Do(BasePoints, function(type)
		Utils.Do(BaseDefenders, function(unit)
			local u = Actor.Create(unit, true, { Owner = allies, Location = BasePoints[num].Location})
			u.Scatter()	
		end)
		num = num + 1
	end)	
	
	--Acquire the entire allies army
	alliesArmy = allies.GetGroundAttackers()
	--Set the stance to Hunt
	Utils.Do(alliesArmy, function(a) 
		a.Stance = "AttackAnything"
		--if not a.IsDead and a.HasProperty("Hunt") then
		--Trigger.OnIdle(a, a.Hunt)
		--end
	end)
		
end

---------------------------------------------------------------------
--   Called when the world is loaded at the beginning of the map   --
---------------------------------------------------------------------
WorldLoaded = function()
	player = Player.GetPlayer("USSR")						--Setting USSR as the playable faction
	allies = Player.GetPlayer("Allies")
	
	
	Trigger.OnObjectiveAdded(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. p.GetObjectiveType(id) .. " objective")
	end)
	Trigger.OnObjectiveCompleted(player, function(p, id) Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")	end)
	Trigger.OnObjectiveFailed(player, function(p, id) Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed") end)
	
	
	--Displaying map details
	Media.DisplayMessage(" Infiltration || Version: 0.98 || Created by: Umair Azfar Khan\n" )
	
	--Setting the Primary Objectives
	MissionObjective = player.AddPrimaryObjective("Destroy the all enemy structures.")
	SurviveObjective = player.AddPrimaryObjective("At least one member of the scout team must survive.\n")
	AnnihilateObjective = allies.AddPrimaryObjective("The russian scout team must be annihilated.")
	
	--Setting Secondary Objectives
	AAgunsDestroyedObjective = player.AddSecondaryObjective("Destroy all Anti Aircraft Guns in the area.")
	AAgunsSavedObjective = allies.AddSecondaryObjective("Defend all Anti Aircraft Guns in the area.")
	HelipadsDestroyedObjective = player.AddSecondaryObjective("Destroy the helipads towards North.")
	HelipadsDefendObjective = allies.AddSecondaryObjective("Defend the helipads in the northern base.")
	RadarDestroyedObjective = player.AddSecondaryObjective("Destroy North-east radar to call in Airstrikes.")
	RadarDefendObjective = allies.AddSecondaryObjective("Defend the radar towards North-east.")

	
	--Initializing Camera
	Trigger.AfterDelay(DateTime.Seconds(1), function() Actor.Create("camera", true, { Owner = player, Location = CameraPoint.Location }) end)
	Camera.Position = CameraPoint.CenterPosition			--Centering the map to the Location
	InitializeAlliedArmy()									--Produce the Allies army on map
	Trigger.AfterDelay(DateTime.Seconds(1), SendScoutTeam) 	--Sending the USSR scout team reinforcements	
	Trigger.AfterDelay(DateTime.Seconds(5), SendHelicopters)										--Sending the helicopter patrol
	Trigger.OnAllKilled(AgunsA, AgunsAKilled) 				--This is triggered when the A series of guns is Annihilated
	Trigger.OnAllKilled(AgunsB, AgunsBKilled) 				--This is triggered when the B series of guns is Annihilated
	Trigger.OnAllKilled(AgunsC, AgunsCKilled) 				--This is triggered when the C series of guns is Annihilated
	Trigger.OnAllKilled(AgunsD, AgunsDKilled) 				--This is triggered when the D series of guns is Annihilated
	Trigger.OnAllKilled(Helipads, HelipadsDestroyed) 		--This is triggered when all helipads have been Annihilated
	Trigger.OnKilled(RadarDome, RadarDestroyed) 				--This is triggered when the radar dome towards Northeast has been Annihilated
	Trigger.OnAllKilled(Buildings, BuildingsDestroyed) 		--This is triggered when all Buildings have been Annihilated
end