
num_waves=10
chat = Media.DisplayMessage
choose = Utils.Random
rand = function(inclusive_high) return Utils.RandomInteger(0,inclusive_high+1) end

-- seconds
wave1_delay = 30
waveN_delay = 10

--[[
The 'difficulty' variable behaves as follows:
Techlevel    | difficulty | how it should be
Unrestricted | 1          | easy
No powers    | 2          | moderate
Medium       | 3          | hard
Low          | 4          | nigh impossible
--]]

-- cash modifiers per difficulty level
difficulty_names={"Easy","Moderate","Hard","Maximum"}
cash_modifiers={3.0, 1.0, 0.5, 0.2}

calc_cash_amount = function(wave_num)
	-- how much money to give each player at the end of a wave
	return (100+wave_num*100)*cash_modifiers[difficulty]
end

get_squad_count = function(wave_num)
	local a=1.8+wave_num*1.2
	if difficulty > 3 then a=1.05*a end
	return math.floor(a)
end

able_to_fly = function(thing)
	return Actor.CruiseAltitude(thing.Type) > 0
end

--[[
each squad is a list of {count,type} tuples
the squads should all be about the same combat strength
Organized by difficulty (easiest groups first)
On the first wave there will be mostly squads from group 1,
midgame there will be mostly whatever groups are in the middle of the list,
and at the few last waves the last groups will be used.
More groups and squads can be added as desired
--]]
squad_defs={{
	-- group 1 (the easiest)
	{{3,"imp"}},
	{{8,"poss"}},
	{{2,"pinky"}},
}, {
	-- group 2
	{{4,"spos"}},
	{{3,"pinky"}},
}, {
	-- group 3
	{{2,"spectre"}},
	{{1,"caco"}},
	{{3,"bspi"}},
}, {
	-- group 4
	{{3,"spectre"}},
	{{2,"reve"}},
	{{2,"caco"}},
	{{3,"bspi"}},
}, {
	-- group 5
	{{2,"cpos"},{3,"spos"}},
	{{1,"bspi"}},
	{{1,"manc"}},
	{{6,"imp"}},
}}

get_outline_pos = function(x0,y0,w,h)
	w=w-1
	h=h-1
	local x = x0 + rand(w)
	local y = y0 + rand(h)
	local x1 = x0 + w
	local y1 = y0 + h
	local t = {{x+1,y0},{x,y1},{x0,y},{x1,y+1}}
	local m = choose(t)
	return CPos.New(m[1],m[2])
end

keep_monster_busy = function(a)
	if a.IsInWorld and not a.IsDead then
		if able_to_fly(a) then
			a.AttackMove(get_outline_pos(37,40,4,4),5)
		else
			a.Hunt()
		end
	end
end

-- key=Actor, value=first tick when the actor is allowed to switch target again
retarg = {}
retarg_delay = 40

maintain_retarg = function()
	now=DateTime.GameTime
	for actor,expire in pairs(retarg) do
		if now > expire then
			retarg[actor] = nil
		end
	end
	Trigger.AfterDelay(15,maintain_retarg)
end

do_retaliate = function(a,e)
	if a.IsInWorld and ( not a.IsDead )
	and e.IsInWorld and ( not e.IsDead ) then
		if retarg[a] == nil and e.HasProperty("Location")
		and ( able_to_fly(a) or not able_to_fly(e) ) then
			a.Stop()
			a.AttackMove(e.Location, 5)
			a.Wait(75)
			retarg[a] = DateTime.GameTime + retarg_delay
		end
	end
end

init_monster = function(a)
	Trigger.OnIdle(a,keep_monster_busy)
	Trigger.OnDamaged(a,do_retaliate)
end

cell_inside_map = function(x,y)
	return x >= 16 and y >= 16 and x < 64 and y < 64
end

the_sleep_ticks=0
spawn_squad = function(sq)
	local all_spawns={
		{CPos.New(35,16),CVec.New(1,0)},
		{CPos.New(35,63),CVec.New(1,0)},
		{CPos.New(16,39),CVec.New(0,1)},
		{CPos.New(63,38),CVec.New(0,1)},
		{CPos.New(17,21),CVec.New(1,-1)},
		{CPos.New(57,17),CVec.New(1,1)},
		{CPos.New(18,57),CVec.New(1,1)},
		{CPos.New(56,61),CVec.New(1,-1)}
	}
	local temp=choose(all_spawns)
	local pos=temp[1]
	local pos_inc=temp[2]
	local new_actors={}
	for stuff,stuff in pairs(sq) do
		local num=stuff[1]
		local kind=stuff[2]
		for i=1,num do
			if not cell_inside_map(pos.X,pos.Y) then
				-- prevent spawning things outside the map
				temp=choose(all_spawns)
				pos=temp[1]
				pos_inc=temp[2]
			end
			local a=Actor.Create(kind,true,{Owner=monsters_owner,Location=pos})
			the_sleep_ticks=the_sleep_ticks+1 -- some delay between squad members to ease pathfinder pain
			a.Wait(the_sleep_ticks)
			init_monster(a)
			new_actors[#new_actors+1]=a
			pos = pos + pos_inc
		end
	end
	return new_actors
end

choose_squad = function()
	local t=(curr_wave_id-1)/(num_waves-1)
	local level_randz=0.9
	t=t*#squad_defs
	t=t + ( rand(1024) / 512.0 - 1.0 ) * level_randz
	t=math.ceil(t+0.5)
	t=math.max(t,1)
	t=math.min(t,#squad_defs)
	local d=squad_defs[t]
	assert(d ~= nil)
	assert(#d > 0)
	return choose(d)
end

spawn_some_squads = function(num_squads)
	if num_squads < 1 then num_squads=1 end
	local allm={}
	the_sleep_ticks=0
	for i=1,num_squads do
		local sq=choose_squad()
		for j=1,#players do
			for m,m in pairs(spawn_squad(sq)) do
				allm[#allm+1]=m
			end
		end
	end
	return allm
end

win = function()
	chat("Mission Succesful")
	for i,p in ipairs(players) do
		if mission_objs[p] ~= nil then
			p.MarkCompletedObjective( mission_objs[p] )
			mission_objs[p] = nil
		end
	end
end

lose = function()
	chat("Mission Failure")
	for i,p in ipairs(players) do
		if mission_objs[p] ~= nil then
			p.MarkFailedObjective( mission_objs[p] )
			mission_objs[p] = nil
		end
	end
end

end_wave = function()
 	chat("Area cleared! "..waveN_delay.." seconds until the next wave")
	for p,p in pairs(players) do
		p.Cash=p.Cash+calc_cash_amount(curr_wave_id)
	end
 	Trigger.AfterDelay(waveN_delay*25,next_wave)
end


next_wave = function()
	curr_wave_id=curr_wave_id+1
	chat("Wave "..curr_wave_id.."/"..num_waves)
	local m=spawn_some_squads(get_squad_count(curr_wave_id))
	if curr_wave_id > num_waves-0.5 then
		chat("This is the last wave")
		--[[
		for i=1,#players do
			-- spawn the final boss
			m[#m+1]=spawn_squad({1,"cyber"})[1]
		end
		--]]
		Trigger.OnAllRemovedFromWorld(m,win)
	else
		Trigger.OnAllRemovedFromWorld(m,end_wave)
	end
end

modify_unit = function(producer,unit)
	-- Here we can inspect & modify anything that comes out of a barracks/factory/helipad
	-- unit.Health=unit.Health*(4-difficulty)/4.0
end

is_base_defense = function(a)
	return a.Type == "sam" or a.Type == "obli"
end

init_loss_condition = function()
	local stuff={}
	for a,a in pairs(Map.NamedActors) do
		if a.IsInWorld and not is_base_defense(a) then
			for p,p in pairs(players) do
				if a.Owner == p then
					print("add a named thingy for player " .. p.Name .. ": " .. a.Type)
					stuff[#stuff+1]=a
					Trigger.OnProduction(a,modify_unit)
				end
			end
		end
	end
	Trigger.OnAllRemovedFromWorld(stuff,lose)
end

init_players = function()
	players={}
	monsters_owner=Player.GetPlayer("Creeps")
	neutral_owner=Player.GetPlayer("Neutral")
	mission_objs={}
	for i=0,3 do
		local p=Player.GetPlayer("Multi"..i)
		if p ~= nil then
			players[#players+1]=p
			mission_objs[p]=p.AddPrimaryObjective("Defend your structures")
		end
	end
end

fix_idle = function()
	for i,a in ipairs(monsters_owner.GetGroundAttackers()) do
		-- in case some monster has gotten into "idle" state make it move again
		if a.IsIdle then
			init_monster(a)
		end
	end
	Trigger.AfterDelay(5*25,fix_idle)
end

place_things = function(kind,locations)
	for p,p in pairs(locations) do
		Actor.Create(kind,true,{Owner=neutral_owner,Location=CPos.New(p[1],p[2])})
	end
end

remove_named_n = function(prefix)
	for i=1,4 do
		local a=Map.NamedActor(prefix .. i)
		if a ~= nil then
			a.Stop()
			a.Destroy()
		end
	end
end

realize_difficulty = function()
	chat("Difficulty: "..difficulty_names[difficulty].." (based on techlevel)")
	if difficulty > 3 then
		-- reduce the delay between consecutive waves on the max difficulty
		waveN_delay=math.floor(waveN_delay*0.6+0.5)
	end
	if difficulty > 1 then
		remove_named_n("Defense")
	end
	if difficulty > 2 then
		remove_named_n("Sam")
	end
end

WorldLoaded = function()
	curr_wave_id=0
	difficulty=4
	init_players()
	init_loss_condition()
	maintain_retarg()
	place_things("barrel",({{51,44},{37,26},{55,23},{23,57},{25,45},{26,45},{41,25},{20,29}}))
	for i=1,difficulty-1 do
		local a=Actor.Create("Dif."..i,true,{Owner=neutral_owner})
		Trigger.OnRemovedFromWorld(a,function() difficulty=difficulty-1 end)
	end
	chat("First wave of enemies incoming in "..wave1_delay.." s")
	Trigger.AfterDelay(2,realize_difficulty)
	Trigger.AfterDelay(wave1_delay*25,next_wave)
	fix_idle()
end

