
MAXPLAYERCOUNT = 8
--SpawnPoints = { SPMulti0, SPMulti1, SPMulti2, SPMulti3, SPMulti4, SPMulti5, SPMulti6, SPMulti7 }

Teams =
{
	{ units = { "ant" },																			entryCell = Actor66.Location },
	{ units = { "ant", "ant", "ant" }, 												entryCell = Actor68.Location },
	{ units = { "ant", "ant", "ant", "ant" }, 								entryCell = Actor69.Location },
	{ units = { "ant", "ant" }, 															entryCell = Actor66.Location },
	{ units = { "ant", "ant", "ant", "ant", "ant" }, 					entryCell = Actor68.Location },
	{ units = { "ant", "ant", "ant" }, 												entryCell = Actor69.Location },
	{ units = { "ant", "ant", "ant", "ant", "ant"},						entryCell = Actor66.Location },
	{ units = { "ant", "ant" }, 															entryCell = Actor68.Location },
	{ units = { "ant", "ant", "ant", "ant", "ant" },					entryCell = Actor69.Location },
	{ units = { "ant" }, 																			entryCell = Actor122.Location },
	{ units = { "ant" }, 																			entryCell = Actor123.Location }
}

CreateTeam = function(Team)
	local units = Reinforcements.Reinforce(Ants, Team.units, { Team.entryCell }, 25)
	SendUnits(units)
	Utils.Do(units, function(actor)
		if not actor.IsDead then
			Trigger.OnIdle(actor, actor.Hunt)
		end
	end)
	Trigger.AfterDelay(DateTime.Seconds(delayRepeatTeam), function()
		CreateTeam(Team)
	end)
end

SendUnits = function(units)
	--Get random player spawnpoint
	local player = Utils.Random(players)
	local waypoint = Map.NamedActor("SPMulti"..tostring(player.Spawn - 1))
	Utils.Do(units, function(unit)
		if not unit.IsDead then
			unit.AttackMove(waypoint.Location)
			unit.Hunt()
		end
	end)
end

WorldLoaded = function()
	--get players
	Ants = Player.GetPlayer("Ants")
	players = { }
	for i = 1, MAXPLAYERCOUNT, 1 do
		local player = Player.GetPlayer("Multi" ..i-1)
		if player ~= nil then
			table.insert(players, player)
		end
	end

	--set delays
	if Map.Difficulty == "Easy" then
		delayFirstTeam = 90
		delayNextTeam = 8
		delayRepeatTeam = 80 * (MAXPLAYERCOUNT + 2 - #players)
	elseif Map.Difficulty == "Hard" then
		delayFirstTeam = 30
		delayNextTeam = 6
		delayRepeatTeam = 50 * (MAXPLAYERCOUNT + 2 - #players)
	else
		delayFirstTeam = 60
		delayNextTeam = 7
		delayRepeatTeam = 65 * (MAXPLAYERCOUNT + 2 - #players)
	end

	--start mutant teams
	local delay = delayFirstTeam
	Trigger.AfterDelay(DateTime.Seconds(delay), function()
		CreateTeam(Teams[1])
	end)

	delay = delayFirstTeam + delayFirstTeam
	Trigger.AfterDelay(DateTime.Seconds(delay), function()
		CreateTeam(Teams[2])
	end)

	delay = delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[3])
	end)

	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[4])
	end)

	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[5])
	end)

	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[6])
	end)

	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[7])
	end)

	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[8])
	end)

	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[9])
	end)

	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[10])
	end)

	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[11])
	end)
end
