MAXPLAYERCOUNT = 8
--SpawnPoints = { SPMulti0, SPMulti1, SPMulti2, SPMulti3, SPMulti4, SPMulti5, SPMulti6, SPMulti7 }

Teams =
{
	{ units = { "c1" },							entryCell = waypoint52.Location, building = Actor105 },
	{ units = { "c2", "c6", "c7", "c8" }, 		entryCell = waypoint53.Location, building = Actor97 },
	{ units = { "c5", "c2", "c3", "c4", "c1" }, entryCell = waypoint54.Location, building = Actor101 },
	{ units = { "c3", "c9", "c7", "c8" }, 		entryCell = waypoint55.Location, building = Actor102 },
	{ units = { "c2", "c6", "c7" }, 			entryCell = waypoint56.Location, building = Actor104 },
	{ units = { "c1", "c2" }, 					entryCell = waypoint57.Location, building = Actor107 },
	{ units = { "c5", "c8" },					entryCell = waypoint58.Location, building = Actor106 },
	{ units = { "c2", "c1" }, 					entryCell = waypoint59.Location, building = Actor103 },
	{ units = { "c5", "c6", "c7" },				entryCell = waypoint60.Location, building = Actor100 },
	{ units = { "c5", "c6" }, 					entryCell = waypoint61.Location, building = Actor99 },
	{ units = { "c3", "c2", "c1" }, 			entryCell = waypoint62.Location, building = Actor98 }
}

-- C1	Nukie
-- C2	Vulcan Guy
-- C3	Angry Guy
-- C4	Evil Guy
-- C5	Shaker
-- C6	Fire Breather
-- C7	Zapper
-- C8	Flak Guy

CreateTeam = function(Team)
	if Team.building.IsDead then
		return
	end
	local units = Reinforcements.Reinforce(Mutants, Team.units, { Team.entryCell }, 25)
	SendUnits(units)
	Utils.Do(units, function(actor)
		if not actor.IsDead then
			Trigger.OnIdle(actor, actor.Hunt)
		end
	end)
	Trigger.AfterDelay(DateTime.Seconds(delayRepeatTeam), function()
		CreateTeam(Team)
	end)
end

SendUnits = function(units)
	--Get random player spawnpoint
	local player = Utils.Random(players)
	local waypoint = Map.NamedActor("SPMulti"..tostring(player.Spawn - 1))	
	Utils.Do(units, function(unit)
		if not unit.IsDead then
			unit.AttackMove(waypoint.Location)
			unit.Hunt()
		end
	end)
end

WorldLoaded = function()
	--get players
	Mutants = Player.GetPlayer("Mutants")
	players = { }
	for i = 1, MAXPLAYERCOUNT, 1 do
		local player = Player.GetPlayer("Multi" ..i-1)
		if player ~= nil then
			table.insert(players, player)
		end
	end

	--set delays
	if Map.Difficulty == "Easy" then
		delayFirstTeam = 90
		delayNextTeam = 8
		delayRepeatTeam = 80 * (MAXPLAYERCOUNT + 2 - #players)
	elseif Map.Difficulty == "Hard" then
		delayFirstTeam = 30
		delayNextTeam = 6
		delayRepeatTeam = 50 * (MAXPLAYERCOUNT + 2 - #players)
	else
		delayFirstTeam = 60
		delayNextTeam = 7
		delayRepeatTeam = 65 * (MAXPLAYERCOUNT + 2 - #players)
	end
	
	--start mutant teams
	local delay = delayFirstTeam
	Trigger.AfterDelay(DateTime.Seconds(delay), function()
		CreateTeam(Teams[1])
	end)
	
	delay = delayFirstTeam + delayFirstTeam
	Trigger.AfterDelay(DateTime.Seconds(delay), function()
		CreateTeam(Teams[2])
	end)
	
	delay = delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[3])
	end)
	
	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[4])
	end)
	
	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[5])
	end)
	
	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[6])
	end)
	
	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[7])
	end)
	
	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[8])
	end)
	
	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[9])
	end)
	
	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[10])
	end)
	
	delay = delay + delayNextTeam
	Trigger.AfterDelay(DateTime.Minutes(delay), function()
		CreateTeam(Teams[11])
	end)
end