﻿GasChamberMechanismTrigger = { CPos.New(14,16), CPos.New(14,17), CPos.New(14,18), CPos.New(14,19), CPos.New(14,20) }
KevorkianCameraTrigger = { CPos.New(43,22), CPos.New(43,23), CPos.New(43,24) }
DestroyLabTrigger = { CPos.New(24,13) }
Escape1Trigger = { CPos.New(37,6) }
MissionAccomplishedTrigger = { CPos.New(4,4), CPos.New(4,5), CPos.New(4,6), CPos.New(4,7), CPos.New(4,8), CPos.New(4,9) }

ExplosionWaypoints = { Rally1, Rally2 }

FlameTurrets = { FlameTurret1, FlameTurret2 }

--Actors
Zombie = "zombie"
TanyaType = "e7"
LabFire = "flare"
BioLab = "bio"
Wall = "brik"
Dog = "dog"
C1 = "c1"
C2 = "c2"
C3 = "c3"
C4 = "c4"
C5 = "c5"
C6 = "c6"
C7 = "c7"
C8 = "c8"
C9 = "c9"

ExplosionsTest = function()
	local Spawns = 
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Utils.Do(Spawns.units, function(units)
			local buildinglocations = Utils.Random(ExplosionWaypoints).Location
			BindActorTriggers(buildinglocations, units)
		end)
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), Explosions)
end

BindActorTriggers = function(ExplosionWaypoints)
	Actor.Create(TanyaType, true, { Location = ExplosionWaypoints, Owner = Multi0 })
	if a.IsInWorld then
		a.Kill()
	end	
end

SendPlayer = function()
	local Tanya = Actor.Create(TanyaType, true, { Location = SpawnPoint.Location, Owner = Multi0 })
	Tanya.Move(Rally1.Location)
	Trigger.OnKilled(Tanya, MissionFailed)
end

GasChamber = function()
	KevorkianLab = Actor.Create("Camera.KevorkianLab", true, { Owner = Multi0, Location = LabCam.Location })
	Reinforcements.Reinforce(Civilian, { "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9" }, { CivilianSpawn1.Location, MutationChamber.Location })
	Reinforcements.Reinforce(Civilian, { "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9" }, { CivilianSpawn2.Location, MutationChamber.Location })
	Civilian1 = Actor.Create(C1, true, { Location = CivilianSpawn1.Location, Owner = Civilian })
	Civilian2 = Actor.Create(C2, true, { Location = CivilianSpawn1.Location, Owner = Civilian })
	Civilian3 = Actor.Create(C3, true, { Location = CivilianSpawn1.Location, Owner = Civilian })
	Civilian4 = Actor.Create(C4, true, { Location = CivilianSpawn1.Location, Owner = Civilian })
	Civilian5 = Actor.Create(C5, true, { Location = CivilianSpawn2.Location, Owner = Civilian })
	Civilian6 = Actor.Create(C6, true, { Location = CivilianSpawn2.Location, Owner = Civilian })
	Civilian7 = Actor.Create(C7, true, { Location = CivilianSpawn2.Location, Owner = Civilian })
	Civilian8 = Actor.Create(C8, true, { Location = CivilianSpawn2.Location, Owner = Civilian })
	Civilian9 = Actor.Create(C9, true, { Location = CivilianSpawn2.Location, Owner = Civilian })
	Civilian1.Move(MutationChamber.Location)
	Civilian2.Move(MutationChamber.Location)
	Civilian3.Move(MutationChamber.Location)
	Civilian4.Move(MutationChamber.Location)
	Civilian5.Move(MutationChamber.Location)
	Civilian6.Move(MutationChamber.Location)
	Civilian7.Move(MutationChamber.Location)
	Civilian8.Move(MutationChamber.Location)
	Civilian9.Move(MutationChamber.Location)
	Trigger.AfterDelay(DateTime.Seconds(13), function()
		ConcreteWall1 = Actor.Create(Wall, true, { Location = WallBarrier1.Location, Owner = Neutral })
		ConcreteWall2 = Actor.Create(Wall, true, { Location = WallBarrier2.Location, Owner = Neutral })
		Trigger.AfterDelay(DateTime.Seconds(2), function()
			Utils.Do(FlameTurrets, function(actor)
				actor.Owner = BadGuy
			end)
			Trigger.AfterDelay(DateTime.Seconds(10), function()
				Utils.Do(FlameTurrets, function(actor)
					actor.Owner = Neutral
				end)
				ConcreteWall1.Kill()
				ConcreteWall2.Kill()
				if not FlameTurret1.IsDead then
					GasChamber()
				end
			end)
		end)
	end)
end

Trigger.OnEnteredFootprint(KevorkianCameraTrigger, function(a, id)
	Trigger.RemoveFootprintTrigger(id)
	if	a.Owner == Multi0 and a.Type == "e7" then
		kevorkiancam = Actor.Create("Camera.KevorkianCam", true, { Owner = Multi0, Location = BossCam.Location })
		Reinforcements.Reinforce(BadGuy, { "e4", "e4", "e4" }, { InfantrySpawn2.Location, Rally2.Location })
		Trigger.AfterDelay(DateTime.Seconds(15), function()
			if not Kevorkian.IsDead then
				Kevorkian.AttackMove(InfantrySpawn1.Location)
			end
		end)
	end
end)

MissionAccomplished = function()
	alliedObjective2 = Multi0.AddPrimaryObjective("Destroy The Gas Chamber")
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Multi0.MarkCompletedObjective(alliedObjective1)
		Trigger.AfterDelay(DateTime.Seconds(8), function()
			kevorkiancam.Destroy()
		end)
	end)
end

Escape = function()
	alliedObjective3 = Multi0.AddPrimaryObjective("Escape with Civilians")
	BioDestroy = Actor.Create(BioLab, true, { Location = Explosion2.Location, Owner = Multi0 })
	BioDestroy.Kill()
	BioDestroy1 = Actor.Create(BioLab, true, { Location = Explosion1.Location, Owner = Multi0 })
	BioDestroy1.Kill()
	FlameTurret1.Kill()
	FlameTurret2.Kill()
	KillCivilians()
	KevorkianLab.Destroy()
	Reinforcements.Reinforce(BadGuy, { "e1", "e1", "e1", "e1" }, { InfantrySpawn3.Location, CivilianSpawn2.Location })
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Multi0.MarkCompletedObjective(alliedObjective2)
		BioDestroy = Actor.Create(BioLab, true, { Location = Explosion2.Location, Owner = Multi0 })
		BioDestroy.Kill()
		BioDestroy1 = Actor.Create(BioLab, true, { Location = Explosion1.Location, Owner = Multi0 })
		BioDestroy1.Kill()
		Actor.Create(LabFire, true, { Location = Explosion1.Location, Owner = BadGuy })
		Actor.Create(LabFire, true, { Location = Explosion2.Location, Owner = BadGuy })
		Trigger.AfterDelay(DateTime.Seconds(3), function()
			CivTeam = Reinforcements.Reinforce(Multi0, { "c1", "c2", "c3", "c4", "c5", "c6" }, { KevorkianExit.Location, CivilianSpawn1.Location })
			Trigger.OnAllKilled(CivTeam, MissionFailed)
			Explosions()
			Media.PlaySoundNotification(Multi0, "AlertBuzzer")
			Trigger.AfterDelay(DateTime.Seconds(25), function()
				ChemTeam = Reinforcements.Reinforce(BadGuy, { "e4", "e4", "e4", "e4", "e4" }, { KevorkianExit.Location, MutationChamber.Location })
			end)
		end)
	end)
end

KillCivilians = function()
	if Civilian1.IsDead or Civilian2.IsDead or Civilian3.IsDead or Civilian4.IsDead or Civilian5.IsDead or Civilian6.IsDead or Civilian7.IsDead or Civilian8.IsDead or Civilian9.IsDead then
		Actor.Create(Zombie, true, { Location = Rally1.Location, Owner = BadGuy })
	elseif Civilian1.IsInWorld or Civilian2.IsInWorld or Civilian3.IsInWorld or Civilian4.IsInWorld or Civilian5.IsInWorld or Civilian6.IsInWorld or Civilian7.IsInWorld or Civilian8.IsInWorld or Civilian9.IsInWorld then
			Civilian1.Kill()
			Civilian2.Kill()
			Civilian3.Kill()
			Civilian4.Kill()
			Civilian5.Kill()
			Civilian6.Kill()
			Civilian7.Kill()
			Civilian8.Kill()
			Civilian9.Kill()
	end
end

CivilianRescue = function()
	if DestroyLabTrigger then
		Trigger.OnEnteredFootprint(MissionAccomplishedTrigger, function(a, id)
			Trigger.AfterDelay(10, function()
				if a.Owner == Multi0 and a.Type == "e7" then
					Multi0.MarkCompletedObjective(alliedObjective3)
				end
			end)
		end)
	end
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Reinforcements.Reinforce(BadGuy, { "e4", "e4", "e4" }, { InfantrySpawn2.Location, CivilianSpawn2.Location })
		Reinforcements.Reinforce(BadGuy, { "e1", "e1", "e1", "e1", "e1" }, { InfantrySpawn3.Location, CivilianSpawn2.Location })
		Trigger.AfterDelay(DateTime.Seconds(20), function()
			Reinforcements.Reinforce(BadGuy, { "e1", "e4", "e1", "e4", "e1" }, { SpawnPoint.Location, Rally2.Location })
			Dog1 = Actor.Create(Dog, true, { Location = SpawnPoint.Location, Owner = BadGuy })
			Dog1.AttackMove(CivilianSpawn2.Location)
			CivilianRescue()
		end)
	end)
end

Explosions = function()
	BioDestroy = Actor.Create(BioLab, true, { Location = Explosion1.Location, Owner = BadGuy })
	BioDestroy.Kill()
	BioDestroy = Actor.Create(BioLab, true, { Location = Explosion3.Location, Owner = BadGuy })
	BioDestroy.Kill()
	Actor.Create(LabFire, true, { Location = Explosion3.Location, Owner = BadGuy })
	Actor.Create(LabFire, true, { Location = Explosion4.Location, Owner = BadGuy })
	Actor.Create(LabFire, true, { Location = Explosion9.Location, Owner = BadGuy })
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		BioDestroy = Actor.Create(BioLab, true, { Location = Explosion5.Location, Owner = BadGuy })
		BioDestroy.Kill()
		BioDestroy = Actor.Create(BioLab, true, { Location = Explosion6.Location, Owner = BadGuy })
		BioDestroy.Kill()
		Trigger.AfterDelay(DateTime.Seconds(2), function()
			BioDestroy = Actor.Create(BioLab, true, { Location = Explosion7.Location, Owner = BadGuy })
			BioDestroy.Kill()
			BioDestroy = Actor.Create(BioLab, true, { Location = Explosion8.Location, Owner = BadGuy })
			BioDestroy.Kill()
			Trigger.AfterDelay(DateTime.Seconds(5), function()
				BioDestroy = Actor.Create(BioLab, true, { Location = Explosion9.Location, Owner = BadGuy })
				BioDestroy.Kill()
				Trigger.AfterDelay(DateTime.Seconds(1), function()
					Explosions()
				end)
			end)
		end)
	end)
end

MissionFailed = function()
	Multi0.MarkFailedObjective(alliedObjective1)
	if alliedObjective3 then
		Multi0.MarkFailedObjective(alliedObjective3)
	end
end

PlayTrack = function()
	Trigger.AfterDelay(DateTime.Seconds(0.000001), function()
		Media.PlaySound("Hanger.aud")
		Trigger.AfterDelay(DateTime.Seconds(424), function()
			PlayTrack()
		end)
	end)
end
WorldLoaded = function()
	Civilian = Player.GetPlayer("Civies")
	BadGuy = Player.GetPlayer("BadGuy")
	Neutral = Player.GetPlayer("Neutral")
	Multi0 = Player.GetPlayer("Multi0")
	GasChamber()
	SendPlayer()
	Media.StopMusic()
	PlayTrack()
	Trigger.OnKilled(Kevorkian, MissionAccomplished)

	Trigger.OnObjectiveAdded(Multi0, function(p, id)
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
		end)
	end)

	alliedObjective1 = Multi0.AddPrimaryObjective("Kill Dr. Kevorkian", "Primary Objective:")

	Trigger.OnObjectiveCompleted(Multi0, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(Multi0, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)
	Trigger.OnPlayerLost(Multi0, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Multi0, "MissionFailed")
		end)
	end)
	Trigger.OnPlayerWon(Multi0, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Multi0, "MissionAccomplished")
		end)
	end)
	Trigger.OnEnteredFootprint(GasChamberMechanismTrigger, function(a, id)
		Trigger.RemoveFootprintTrigger(id)
		Trigger.AfterDelay(10, function()
			if a.Owner == Multi0 and a.Type == "e7" then
				Reinforcements.Reinforce(BadGuy, { "e1", "e1", "e1", "e1" }, { InfantrySpawn1.Location, Rally1.Location })
			end
		end)
	end)
	Trigger.OnEnteredFootprint(DestroyLabTrigger, function(a, id)
		Trigger.RemoveFootprintTrigger(id)
		Trigger.AfterDelay(10, function()
			if	a.Owner == Multi0 and a.Type == "e7" then
				Escape()
				CivilianRescue()
			end
		end)
	end)
end