TeamCiv1 = { "c1" }
TeamCiv2 = { "c1" }
TeamCiv3 = { "c4", "c5", "c6" }
TeamCiv4 = { "c9", "c7", "c8" }
TeamCiv5 = { "c6", "c7", "c9" }
TeamCiv6 = { "c1", "c7", "c8" }
TeamCiv7 = { "c9", "c1", "c7" }
TeamCiv8 = { "c1", "c7", "c8" }
TeamCiv9 = { "c9", "c1", "c7" }
TeamCiv10 = { "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "c1" }

Teams =
{
	{ units = TeamCiv1, entryCell = waypoint1.Location, building = house1 },
	{ units = TeamCiv2, entryCell = waypoint6.Location, building = house6 },
	{ units = TeamCiv3, entryCell = waypoint3.Location, building = house3 },
	{ units = TeamCiv4, entryCell = waypoint5.Location, building = house5 },
	{ units = TeamCiv5, entryCell = waypoint2.Location, building = house2 },
	{ units = TeamCiv6, entryCell = waypoint6.Location, building = house6 },
	{ units = TeamCiv7, entryCell = waypoint2.Location, building = house3 },
	{ units = TeamCiv8, entryCell = waypoint4.Location, building = house4 },
	{ units = TeamCiv9, entryCell = waypoint5.Location, building = house5 },
	{ units = TeamCiv10, entryCell = waypoint6.Location, building = house6 }
}

--SpawnPoints = { victim1, victim2 }

CreateTeam = function(Team)
	if Team.building.IsDead then
		return
	end
	local units = Reinforcements.Reinforce(BadGuy, Team.units, { Team.entryCell }, 25)
	SendUnits(units)
	Utils.Do(units, function(actor)
		if not actor.IsDead then
			Trigger.OnIdle(actor, actor.Hunt)
		end
	end)
	Trigger.AfterDelay(DateTime.Seconds(110), function()
		CreateTeam(Team)
	end)
end


SendUnits = function(units)
	--Get random player spawnpoint
	local player = Utils.Random(players)
	local waypoint = Map.NamedActor("victim1"..tostring(player.Spawn - 1))
	Utils.Do(units, function(unit)
	end)
end

WorldLoaded = function()
	BadGuy = Player.GetPlayer("BadGuy")
	players = { }
	for i = 0, 7, 1 do
		local player = Player.GetPlayer("Multi" ..i)
		if player ~= nil then
			table.insert(players, player)
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(30), function()
		CreateTeam(Teams[1])
	end)
	Trigger.AfterDelay(DateTime.Seconds(30), function()
		CreateTeam(Teams[2])
	end)
	Trigger.AfterDelay(DateTime.Seconds(80), function()
		CreateTeam(Teams[3])
	end)
	Trigger.AfterDelay(DateTime.Minutes(2), function()
		CreateTeam(Teams[4])
	end)
	Trigger.AfterDelay(DateTime.Minutes(3), function()
		CreateTeam(Teams[5])
	end)
	Trigger.AfterDelay(DateTime.Minutes(5), function()
		CreateTeam(Teams[6])
	end)
	Trigger.AfterDelay(DateTime.Minutes(7), function()
		CreateTeam(Teams[7])
	end)
	Trigger.AfterDelay(DateTime.Minutes(8), function()
		CreateTeam(Teams[8])
	end)
	Trigger.AfterDelay(DateTime.Minutes(9), function()
		CreateTeam(Teams[9])
	end)
	Trigger.AfterDelay(DateTime.Minutes(20), function()
		CreateTeam(Teams[10])
	end)
end
