
Ant1Path = { downright.Location, upperleft.Location }
Ant2Path = { upperright.Location, downleft.Location }

ActivateAnt1 = function()
	local Ant1 = Actor.Create("ant", true, { Owner = Killerant, Location = upperleft.Location })
	Ant1unit = { Ant1 }
	GroupPatrol(Ant1unit, Ant1Path, DateTime.Seconds(1))
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(30, 120)), function()
		ActivateAnt2()
	end)
end

ActivateAnt2 = function()
	local Ant2 = Actor.Create("ant", true, { Owner = Killerant, Location = downleft.Location })
	Ant2unit = { Ant2 }
	GroupPatrol(Ant2unit, Ant2Path, DateTime.Seconds(1))
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(30, 120)), function()
		ActivateAnt1()
	end)
end

GroupPatrol = function(units, waypoints, delay) 
	local i = 1
	local stop = false
	Utils.Do(units, function(unit)
		Trigger.OnIdle(unit, function()
			if stop then
				return
			end
			if unit.Location == waypoints[i] then
				local bool = Utils.All(units, function(actor) return actor.IsIdle end)
				if bool then
					stop = true
					i = i + 1
					if i > #waypoints then
						i = 1
					end
					Trigger.AfterDelay(delay, function() stop = false end)
				end
			else
				unit.AttackMove(waypoints[i])
			end
		end)
	end)
end

InitPlayers = function()
	Killerant = Player.GetPlayer("Killerant")
end

WorldLoaded = function()
	InitPlayers()
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(0, 180)), function()
		ActivateAnt1()
	end)
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(0, 180)), function()
		ActivateAnt2()
	end)
end