if Map.Difficulty == "with effects" then
	lightingEffects = true
elseif Map.Difficulty == "no effects" then
	lightingEffects = false
end

function round(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

increasing = true

changeLighting = function()
	local ambientChange = 0.0005
	local currentAmbient = Lighting.Ambient

	if currentAmbient + ambientChange > 1.3 then
		increasing = false
	end

	if currentAmbient - ambientChange < 0.5 then
		increasing = true
	end

	if increasing then
		currentAmbient = currentAmbient + ambientChange

		if currentAmbient < 1 then
			Lighting.Red = Lighting.Red - (ambientChange * 1.3)
			Lighting.Green = Lighting.Green - ambientChange
			Lighting.Blue = Lighting.Green - ambientChange
		else
			Lighting.Red = Lighting.Red - (ambientChange * 0.5)
			Lighting.Green = Lighting.Green - (ambientChange * 0.5)
			Lighting.Blue = Lighting.Green - (ambientChange * 0.5)
		end

	else
		currentAmbient = currentAmbient - ambientChange

		if currentAmbient < 1 then
			Lighting.Red = Lighting.Red + (ambientChange * 1.3)
			Lighting.Green = Lighting.Green + ambientChange
			Lighting.Blue = Lighting.Green + ambientChange
		else
			Lighting.Red = Lighting.Red + (ambientChange * 0.5)
			Lighting.Green = Lighting.Green + (ambientChange * 0.5)
			Lighting.Blue = Lighting.Green + (ambientChange * 0.5)
		end

	end

	-- roundedCurrentAmbient = round(currentAmbient, 1)

	Lighting.Ambient = currentAmbient

	-- Media.DisplayMessage(tostring(currentAmbient))
end

Tick = function()
	-- Perf: access to local variables is faster... in theory

	if lightingEffects then
		local Utils = Utils
		local Lighting = Lighting

		if Lighting.Ambient < 0.8 then
			if (Utils.RandomInteger(1, 600) == 10) then
				local delay = Utils.RandomInteger(1, 10)
				Lighting.Flash("LightningStrike", delay)
				Trigger.AfterDelay(delay, function()
					Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
				end)
			end
			if (Utils.RandomInteger(1, 600) == 10) then
				Media.PlaySound("thunder-ambient.aud")
			end
			if (DateTime.GameTime % DateTime.Seconds(12) == 0) then
					Media.PlaySound("rain.aud")
			end
		end

		-- if (DateTime.GameTime % DateTime.Seconds(1) == 0) then
			changeLighting()
		-- end
	end
end