if Map.Difficulty == "50$ per derrick" then
	cderrick = "OILB.50"
elseif Map.Difficulty == "100$ per derrick" then
	cderrick = "OILB.100"
elseif Map.Difficulty == "150$ per derrick" then
	cderrick = "OILB.150"
elseif Map.Difficulty == "200$ per derrick" then
	cderrick = "OILB.200"
elseif Map.Difficulty == "250$ per derrick" then
	cderrick = "OILB.250"
elseif Map.Difficulty == "300$ per derrick" then
	cderrick = "OILB.300"
elseif Map.Difficulty == "350$ per derrick" then
	cderrick = "OILB.350"
elseif Map.Difficulty == "400$ per derrick" then
	cderrick = "OILB.400"
end

function round(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

increasing = true

changeLighting = function()
	local ambientChange = 0.0005
	local currentAmbient = Lighting.Ambient

	if currentAmbient + ambientChange > 1.3 then
		increasing = false
	end

	if currentAmbient - ambientChange < 0.5 then
		increasing = true
	end

	if increasing then
		currentAmbient = currentAmbient + ambientChange

		if currentAmbient < 1 then
			Lighting.Red = Lighting.Red - (ambientChange * 1.4)
			Lighting.Green = Lighting.Green - ambientChange
			Lighting.Blue = Lighting.Green - ambientChange
		else
			Lighting.Red = Lighting.Red - (ambientChange * 0.4)
			Lighting.Green = Lighting.Green - (ambientChange * 0.4)
			Lighting.Blue = Lighting.Green - (ambientChange * 0.4)
		end

	else
		currentAmbient = currentAmbient - ambientChange

		if currentAmbient < 1 then
			Lighting.Red = Lighting.Red + (ambientChange * 1.4)
			Lighting.Green = Lighting.Green + ambientChange
			Lighting.Blue = Lighting.Green + ambientChange
		else
			Lighting.Red = Lighting.Red + (ambientChange * 0.4)
			Lighting.Green = Lighting.Green + (ambientChange * 0.4)
			Lighting.Blue = Lighting.Green + (ambientChange * 0.4)
		end

	end

	-- roundedCurrentAmbient = round(currentAmbient, 1)

	Lighting.Ambient = currentAmbient

	-- Media.DisplayMessage(tostring(currentAmbient))
end

WorldLoaded = function()

	Trigger.AfterDelay(DateTime.Seconds(0), function()
		Utils.Do(Map.NamedActors, function(a)
			if a.Type == "oilb" then
				local newDerrick = Actor.Create(cderrick, true, { Owner = a.Owner, Location = a.Location })
				a.Destroy()
			end
		end)
	end)

	friendlyAI = Player.GetPlayer("FriendlyAI")
	neutralAI = Player.GetPlayer("Neutral")

	Trigger.AfterDelay(DateTime.Seconds(0), function()
		Utils.Do(Map.NamedActors, function(a)
			if a.Type == "brik" then
				a.Owner = friendlyAI
			end
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Utils.Do(Map.NamedActors, function(a)
			if a.Type == "brik" then
				a.Owner = neutralAI
			end
		end)
	end)

	Media.DisplayMessage(Map.Difficulty)
	Media.DisplayMessage("Infantry: 20 per type")
	Media.DisplayMessage("Tanks: 20 per type")
	Media.DisplayMessage("Aircraft: 10 per type")
	Media.DisplayMessage("Defense structures: 10 per type")
end

Tick = function()
	-- Perf: access to local variables is faster... in theory
	local Utils = Utils
	local Lighting = Lighting

	if Lighting.Ambient < 0.8 then
		if (Utils.RandomInteger(1, 600) == 10) then
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Trigger.AfterDelay(delay, function()
				Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
			end)
		end
		if (Utils.RandomInteger(1, 600) == 10) then
			Media.PlaySound("thunder-ambient.aud")
		end
		if (DateTime.GameTime % DateTime.Seconds(12) == 0) then
				Media.PlaySound("rain.aud")
		end
	end

	changeLighting()
end